/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.nio.Address;
import java.io.IOException;

public class NonSmartClientInvocationService
extends AbstractClientInvocationService {
    public NonSmartClientInvocationService(HazelcastClientInstanceImpl client) {
        super(client);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        this.send(invocation, this.getOwnerConnection());
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        assert (connection != null);
        this.send(invocation, connection);
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        invocation.getClientMessage().setPartitionId(partitionId);
        this.send(invocation, this.getOwnerConnection());
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        this.send(invocation, this.getOwnerConnection());
    }

    private ClientConnection getOwnerConnection() throws IOException {
        Address ownerConnectionAddress = this.connectionManager.getOwnerConnectionAddress();
        ClientConnection ownerConnection = (ClientConnection)this.connectionManager.getActiveConnection(ownerConnectionAddress);
        if (ownerConnection == null) {
            throw new IOException("NonSmartClientInvocationService: Owner connection is not available.");
        }
        return ownerConnection;
    }
}

