/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features;

import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesSupport
extends CellarSupport {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(FeaturesSupport.class);
    protected FeaturesService featuresService;

    public void init(BundleContext bundleContext) {
    }

    public void destroy() {
    }

    public Boolean isFeatureInstalledLocally(String name, String version) {
        if (this.featuresService != null) {
            try {
                Feature[] localFeatures = this.featuresService.listInstalledFeatures();
                if (localFeatures != null && localFeatures.length > 0) {
                    for (Feature localFeature : localFeatures) {
                        if (!localFeature.getName().equals(name) || !localFeature.getVersion().equals(version) && version != null) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("CELLAR FEATURES: can't check if the feature {}/{} is installed locally", new Object[]{name, version, e});
            }
        }
        return false;
    }

    public Boolean isRepositoryRegisteredLocally(String uri) {
        try {
            Repository[] localRepositories;
            for (Repository localRepository : localRepositories = this.featuresService.listRepositories()) {
                if (!localRepository.getURI().toString().equals(uri)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("CELLAR FEATURES: can't check if the feature repository {} is registered locally", (Object)uri, (Object)e);
        }
        return false;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }
}

