/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.serde;

import java.nio.ByteBuffer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaHeaderSerializer
implements KafkaHeaderSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaHeaderSerializer.class);

    @Override
    public byte[] serialize(String key, Object value) {
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong((Long)value);
            return buffer.array();
        }
        if (value instanceof Integer) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt((Integer)value);
            return buffer.array();
        }
        if (value instanceof Double) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putDouble((Double)value);
            return buffer.array();
        }
        if (value instanceof Boolean) {
            return value.toString().getBytes();
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        LOG.debug("Cannot propagate header value of type[{}], skipping... Supported types: String, Integer, Long, Double, byte[].", value != null ? value.getClass() : "null");
        return null;
    }
}

