package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.io.Writer;

import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.context.Context;

import org.dom4j.DocumentHelper;
import org.dom4j.Document;
import org.dom4j.XPath;
import org.dom4j.Node;
import org.dom4j.rule.Pattern;
import org.dom4j.rule.Rule;

/**
 *  Currently provides the match rule accumulation
 *  as well as the AST storage and rendering
 *
 *  Rule stuff might be replaced with the dom4j RuleManager
 *
 *  @author <a href="mailto:geirm@apache.org?">Geir Magnusson Jr.</a>
 */
public class TemplateHandler
{
    private Map astmap = new HashMap();
    private List xpathList = new ArrayList();

    public void registerMatch( String xpath, SimpleNode node )
    {
        //System.out.println("registering : " + xpath );

        Pattern pattern = DocumentHelper.createPattern( xpath );
        Rule rule = new Rule( pattern );
        Map foo = new HashMap();

        foo.put("rule", rule );
        foo.put("xpath", xpath );
        foo.put("ast", node );
        xpathList.add( foo );
    }


    boolean render( DVSLNode node, Context context, Writer writer )
        throws Exception
    {
        /*
         *  find if we have an AST where the xpath expression mathes
         *  for this node
         */

        Node dom4jnode = (Node) node.getNodeImpl();
        SimpleNode sn = null;

        for( int i = 0; i < xpathList.size(); i++ )
        {
            Map m = (Map) xpathList.get(i);

            Rule xpathrule = (Rule) m.get("rule");

            if( xpathrule.matches( dom4jnode ) )
            {
                sn = (SimpleNode) m.get( "ast" );
                //System.out.println("using : " + (String) m.get("xpath") );

                break;
            }
        }

        if( sn == null)
            ; //System.out.println("Yikes : failed to find ast for '" + node.getName() );

        /*
         *  if we found something, render
         */

        if( sn != null)
        {
            InternalContextAdapterImpl ica =
                new InternalContextAdapterImpl( context );

            ica.pushCurrentTemplateName( node.name() );

            try
            {
                sn.render( ica, writer );
            }
            finally
            {
                ica.popCurrentTemplateName();
            }

            return true;
        }

        return false;
    }

}
