/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.filter.FilteringHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.XmlTag;

public class HeaderResponseContainer
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final String filterName;

    public HeaderResponseContainer(String id, String filterName) {
        super(id);
        this.filterName = filterName;
        this.setRenderBodyOnly(true);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        FilteringHeaderResponse response = FilteringHeaderResponse.get();
        if (!response.isClosed()) {
            throw new RuntimeException("there was an error processing the header response - you tried to render a bucket of response from FilteringHeaderResponse, but it had not yet run and been closed.  this should occur when the header container that is standard in wicket renders, so perhaps you have done something to keep that from rendering?");
        }
        CharSequence foot = response.getContent(this.filterName);
        this.replaceComponentTagBody(markupStream, openTag, foot);
    }
}

