/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.encoding;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;
import org.apache.wicket.util.lang.Args;

public class UrlEncoder {
    protected BitSet dontNeedEncoding;
    protected static final int caseDiff = 32;
    public static final UrlEncoder QUERY_INSTANCE = new UrlEncoder(Type.QUERY);
    public static final UrlEncoder PATH_INSTANCE = new UrlEncoder(Type.PATH);
    public static final UrlEncoder FULL_PATH_INSTANCE = new UrlEncoder(Type.FULL_PATH);
    private final Type type;

    protected UrlEncoder(Type type) {
        int i;
        this.type = type;
        this.dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            this.dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            this.dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            this.dontNeedEncoding.set(i);
        }
        this.dontNeedEncoding.set(45);
        this.dontNeedEncoding.set(46);
        this.dontNeedEncoding.set(95);
        this.dontNeedEncoding.set(126);
        this.dontNeedEncoding.set(33);
        this.dontNeedEncoding.set(36);
        this.dontNeedEncoding.set(42);
        this.dontNeedEncoding.set(44);
        this.dontNeedEncoding.set(58);
        this.dontNeedEncoding.set(64);
        switch (type) {
            case QUERY: {
                this.dontNeedEncoding.set(32);
                this.dontNeedEncoding.set(47);
                break;
            }
            case PATH: {
                this.dontNeedEncoding.set(38);
                this.dontNeedEncoding.set(61);
                this.dontNeedEncoding.set(43);
                this.dontNeedEncoding.set(59);
                break;
            }
            case FULL_PATH: {
                this.dontNeedEncoding.set(38);
                this.dontNeedEncoding.set(61);
                this.dontNeedEncoding.set(43);
                this.dontNeedEncoding.set(47);
            }
        }
    }

    public String encode(String s, Charset charset) {
        return this.encode(s, charset.name());
    }

    public String encode(String unsafeInput, String charsetName) {
        Charset charset;
        String s = unsafeInput.replace("\u0000", "NULL");
        StringBuilder out = new StringBuilder(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Args.notNull(charsetName, "charsetName");
        try {
            charset = Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            throw new RuntimeException(new UnsupportedEncodingException(charsetName));
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException(new UnsupportedEncodingException(charsetName));
        }
        boolean stopEncoding = false;
        int i = 0;
        while (i < s.length()) {
            byte[] ba;
            char c;
            int c2 = s.charAt(i);
            if (!stopEncoding && c2 == 63 && this.type == Type.FULL_PATH) {
                stopEncoding = true;
            }
            if (stopEncoding || this.dontNeedEncoding.get(c2)) {
                if (c2 == 32) {
                    c2 = 43;
                }
                out.append((char)c2);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c2);
                if (c2 >= 55296 && c2 <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    charArrayWriter.write(d);
                    ++i;
                }
                if (++i >= s.length()) break;
                c = s.charAt(i);
                c2 = c;
            } while (!this.dontNeedEncoding.get(c));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            for (byte b : ba = str.getBytes(charset)) {
                out.append('%');
                char ch = Character.forDigit(b >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(b & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
        }
        return out.toString();
    }

    public static enum Type {
        QUERY,
        PATH,
        FULL_PATH;

    }
}

