NAME
    RISCOS::ROMModule -- routines to enumerate the ROM modules

SYNOPSIS
        use RISCOS::ROMModule;

        @rommods = rommodules;

        foreach $mod (@rommods) {
            print $mod->Line();
        }


DESCRIPTION
    `RISCOS::ROMModule' provides a class to hold details about a
    module in ROM, and a subroutine `rommodules' to enumerate all
    modules in ROM.

  Methods

    new [<number>, [<rom>]]
        Returns a new `RISCOS::ROMModule' object with details of
        module *number* in ROM *rom*. *number* defaults to `0',
        *rom* to `-1'.

        Returns undefined if the specified module does not exist.

    Name
        Returns the name of the module.

    State
        Returns the state of the module - *i.e.* 'Unplugged',
        'Dormant', 'Active', 'Running'

        Currently this is only a text string, but if the proposed
        `DualVar' module becomes available this will return a dual-
        valued scalar with the string and the `OS_Module 20' numeric
        code (-1, 0, 1, 2 respectively).

    Chunk
        Returns the chunk number for an expansion card module.

    Version
        Returns the version number of the module.

    ROM Returns the ROM number of the module. (Not the ROM number + 1 as
        returned by `OS_Module 20'.)

    Number
        Returns the number of the module in its ROM. (Not the ROM
        number + 1 as returned by `OS_Module 20'.)

        By calling new in turn with `ROM' and `Number' + 1 it is
        possible to enumerate all the modules in ROM, which is
        exactly what `rommodules' does.

    Line
        Returns a line of text in the same format as the OS
        `ROMModules' would, except that the formatting of the ROM
        numbers is correct (compare with RISC OS 3.70).


  rommodules

    `rommodules' returns an array of `RISCOS::RomModule' objects
    corresponding to all modules in the System ROMs and any
    expansion cards, in the order returned by `OS_Module 20'.

BUGS
    None known.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

