# EXPORT : functions ending by export are called from xml
# CRON : functions ending by cron are called from timer
# SCHEDULE : functions ending by schedule are called from cron



# ===========
# ENVIRONMENT
# ===========

Environment = {};

Environment.new = func {
   var obj = { parents : [Environment],

               smoke : Smoke.new()
         };

   obj.init();

   return obj;
};

Environment.init = func {
}

Environment.slowschedule = func {
   me.smoke.schedule();
}


# =====
# SMOKE
# =====

Smoke = {};

Smoke.new = func {
   var obj = { parents : [Smoke,System.new("/systems/environment")],

               SMOKEGROUNDSEC : 120.0,
               SMOKEFLIGHTSEC : 12.0,
               
               SMOKEGROUNDFEET : 25.0,
               SMOKEFLIGHTFEET : 20.0
         };

   return obj;
};

Smoke.schedule = func {
   var lifesec = 0.0;
   var sizefeet = 0.0;
   var altitudeft = me.noinstrument["altitude"].getValue();

   lifesec = me.ratio( altitudeft, constantaero.LANDINGFT, me.SMOKEFLIGHTSEC, me.SMOKEGROUNDSEC );
   sizefeet = me.ratio( altitudeft, constantaero.LANDINGFT, me.SMOKEFLIGHTFEET, me.SMOKEGROUNDFEET );

   me.itself["root"].getChild("smoke-sec").setValue(lifesec);
   me.itself["root"].getChild("smoke-feet").setValue(sizefeet);
}

Smoke.ratio = func( altitudeft, maxft, minvalue, maxvalue ) {
   var result = minvalue;

   # spread with wind
   if( altitudeft <= maxft ) {
       result = ( ( maxft - altitudeft ) / maxft ) * ( maxvalue - minvalue ) + minvalue;
   }
   
   return result;
}
