# EXPORT : functions ending by export are called from xml
# CRON : functions ending by cron are called from timer
# SCHEDULE : functions ending by schedule are called from cron

# current nasal version doesn't accept :
# - too many operations on 1 line.
# - variable with hyphen (?).



# =================
# OVERRIDING JSBSIM
# =================

ConcordeJSBsim = {};

ConcordeJSBsim.new = func {
   var obj = { parents : [ConcordeJSBsim,System.new("/systems/flight")],
   
               DISABLETANK : 0
         };

   return obj;
}

ConcordeJSBsim.specific = func {
   # disable JSBSim stand alone mode
   for( var i=0; i < constantaero.NBENGINES; i=i+1 ) {
        me.itself["tank"][i].getChild("priority").setValue( me.DISABLETANK );
   }
}


# ==============
# INITIALIZATION
# ==============

ConcordeMain = {};

ConcordeMain.new = func {
   var obj = { parents : [ConcordeMain],
   
               timer1sec : nil,
               timer3sec : nil,
               timer5sec : nil,
               timer10sec : nil,
               timer15sec : nil,
               timer30sec : nil,
               timer60sec : nil,
               timerstartup : nil
         };

   obj.init();

   return obj;
}

# ----------------------
# The possible relations :
# ----------------------

# - pumpsystem : Pump.new(),
#   inside another system / instrument, to synchronize the objects.

# - me.electricalsystem = electrical;
#   local pointer to the global object, to call its nasal code.

# - <dependency>/systems/electrical</dependency>
#   tag in the instrumentation / system initialization, to read the properties.

# - <static-port>/systems/static</static-port>
#   tag in the instrumentation file, to customize a C++ instrument.

# - <noinstrument>/position/altitude-agl-ft</noinstrument>.
#   no relation to an instrument / system failure.

ConcordeMain.putinrelation = func {
   autopilotsystem.set_relation( autothrottlesystem );
   MWSsystem.set_relation( ADCinstrument, CGinstrument, INSinstrument,
                           airbleedsystem, electricalsystem, enginesystem,
                           flightsystem, fuelsystem, hydraulicsystem, antiicingsystem,
                           pressuresystem, tankpressuresystem );

   wiperinstrument.set_relation( noseinstrument );

   copilotcrew.set_relation( airbleedsystem, autopilotsystem, electricalsystem, flightsystem,
                             hydraulicsystem, lightingsystem, MWSsystem, voicecrew );
   engineercrew.set_relation( airbleedsystem, autopilotsystem, electricalsystem, enginesystem,
                              fuelsystem, hydraulicsystem, lightingsystem, voicecrew );
   voicecrew.set_relation( autopilotsystem );
   crewcrew.set_relation( airbleedsystem, autopilotsystem, autothrottlesystem, electricalsystem, fuelsystem,
                          crewscreen, copilotcrew, engineercrew, voicecrew, copilothuman, engineerhuman );

   engineerhuman.set_relation( seatsystem );
}

ConcordeMain.synchronize = func {
   electricalsystem.set_rate( fuelsystem.PUMPSEC );
   hydraulicsystem.set_rate( fuelsystem.PUMPSEC );
   airbleedsystem.set_rate( fuelsystem.PUMPSEC );
   enginesystem.set_rate( fuelsystem.PUMPSEC );
}

ConcordeMain.startupcron = func {
   crewcrew.startupexport();
}

# 1 seconds cron (only, to spare frame rate)
ConcordeMain.sec1cron = func {
   electricalsystem.schedule();
   hydraulicsystem.schedule();
   fuelsystem.schedule();
   airbleedsystem.schedule();
   enginesystem.schedule();
   GPWSsystem.schedule();
   lightingsystem.schedule();
   ADCinstrument.schedule();
   altimeterinstrument.schedule();
   wiperinstrument.schedule();
   daytimeinstrument.schedule();
}

# 3 seconds cron
ConcordeMain.sec3cron = func {
   autopilotsystem.schedule();
   autothrottlesystem.schedule();
   MWSsystem.schedule();
   flightsystem.schedule();
   fuelsystem.slowschedule();
   antiicingsystem.schedule();
   INSinstrument.schedule();
   Compassinstrument.schedule();
   crewscreen.schedule();
}

# 5 seconds cron
ConcordeMain.sec5cron = func {
   IASinstrument.schedule();
   VSIinstrument.schedule();
   machinstrument.schedule();
   AOAinstrument.schedule();
   CGinstrument.schedule();
   standbyIASinstrument.schedule();
   autopilotsystem.slowschedule();
   autothrottlesystem.slowschedule();
   pressuresystem.schedule();
   enginesystem.slowschedule();
   copilotcrew.fastschedule();
   copilothuman.schedule();
   engineerhuman.schedule();
   tractorexternal.schedule();
}

# 10 seconds cron
ConcordeMain.sec10cron = func {
   MWSsystem.slowschedule();
   airbleedsystem.slowschedule();
   pressuresystem.slowschedule();
}

# 15 seconds cron
ConcordeMain.sec15cron = func {
   TMOinstrument.schedule();
   GPWSsystem.slowschedule();
   engineerhuman.slowschedule();
   environment.slowschedule();
}

# 30 seconds cron
ConcordeMain.sec30cron = func {
   tankpressuresystem.schedule();
}

# 60 seconds cron
ConcordeMain.sec60cron = func {
   electricalsystem.slowschedule();
   hydraulicsystem.slowschedule();
   airbleedsystem.slowschedule();
   antiicingsystem.slowschedule();
   copilotcrew.veryslowschedule();
   engineercrew.veryslowschedule();
}

ConcordeMain.savedata = func {
   var saved_props = [ "/controls/adc/ivsi-in-cruise",
                       "/controls/adc/system[0]/ivsi-emulated",
                       "/controls/adc/system[1]/ivsi-emulated",
                       "/controls/anti-ice/icing-model/duration/few-min",
                       "/controls/anti-ice/icing-model/duration/scattered-min",
                       "/controls/anti-ice/icing-model/duration/broken-min",
                       "/controls/anti-ice/icing-model/duration/overcast-min",
                       "/controls/anti-ice/icing-model/duration/clear-min",
                       "/controls/anti-ice/icing-model/temperature/max-degc",
                       "/controls/anti-ice/icing-model/temperature/min-degc",
                       "/controls/autoflight/fg-waypoint",
                       "/controls/autoflight/real-nav",
                       "/controls/captain/countdown",
                       "/controls/crew/captain-busy",
                       "/controls/crew/checklist",
                       "/controls/crew/clock",
                       "/controls/crew/disable",
                       "/controls/crew/ins-alignment",
                       "/controls/crew/landing-lights/as-required",
                       "/controls/crew/landing-lights/navigation",
                       "/controls/crew/landing-lights/set",
                       "/controls/crew/landing-lights/taxi",
                       "/controls/crew/menu/procedures",
                       "/controls/crew/menu/voice",
                       "/controls/crew/night-lighting",
                       "/controls/crew/presets",
                       "/controls/crew/radio/altitude-ft",
                       "/controls/crew/radio/ignore",
                       "/controls/crew/radio/set",
                       "/controls/crew/startup",
                       "/controls/crew/state/fuel",
                       "/controls/crew/stop-engine23",
                       "/controls/crew/status/allways",
                       "/controls/crew/status/none",
                       "/controls/crew/status/notify",
                       "/controls/crew/status/timeout",
                       "/controls/crew/status/timeout-s",
                       "/controls/engineer/move",
                       "/controls/environment/als/external-lights",
                       "/controls/environment/als/lights",
                       "/controls/environment/contrails",
                       "/controls/environment/rain",
                       "/controls/environment/smoke",
                       "/controls/environment/vortex/visible",
                       "/controls/human/lighting/captain",
                       "/controls/human/lighting/center",
                       "/controls/human/lighting/copilot",
                       "/controls/human/lighting/engineer",
                       "/controls/fuel/reinit",
                       "/controls/tractor/distance-m",
                       "/controls/seat/arm/captain",
                       "/controls/seat/arm/copilot",
                       "/controls/seat/floating/recover",
                       "/controls/seat/yoke",
                       "/controls/voice/disable",
                       "/controls/voice/sound",
                       "/controls/voice/text",
                       "/sim/sound/concorde/external",
                       "/sim/systems/concorde/optimize",
                       "/sim/user/callsign",
                       "/systems/fuel/presets",
                       "/systems/human/serviceable",
                       "/systems/seat/position/gear-front/x-m",
                       "/systems/seat/position/gear-front/y-m",
                       "/systems/seat/position/gear-front/z-m",
                       "/systems/seat/position/gear-main/x-m",
                       "/systems/seat/position/gear-main/y-m",
                       "/systems/seat/position/gear-main/z-m",
                       "/systems/seat/position/gear-main2/x-m",
                       "/systems/seat/position/gear-main2/y-m",
                       "/systems/seat/position/gear-main2/z-m",
                       "/systems/seat/position/observer/x-m",
                       "/systems/seat/position/observer/y-m",
                       "/systems/seat/position/observer/z-m",
                       "/systems/seat/position/observer2/x-m",
                       "/systems/seat/position/observer2/y-m",
                       "/systems/seat/position/observer2/z-m",
                       "/systems/seat/position/steward/x-m",
                       "/systems/seat/position/steward/y-m",
                       "/systems/seat/position/steward/z-m" ];

   for( var i = 0; i < size(saved_props); i = i + 1 ) {
        aircraft.data.add(saved_props[i]);
   }
}

# global variables in Concorde namespace, for call by XML
ConcordeMain.instantiate = func {
   globals.Concorde.constant = Concorde.Constant.new();
   globals.Concorde.constantaero = Concorde.Constantaero.new();
   globals.Concorde.constantISA = Concorde.ConstantISA.new();
   globals.Concorde.FDM = Concorde.ConcordeJSBsim.new();
   globals.Concorde.environment = Concorde.Environment.new();

   globals.Concorde.electricalsystem = Concorde.Electrical.new();
   globals.Concorde.hydraulicsystem = Concorde.Hydraulic.new();
   globals.Concorde.flightsystem = Concorde.Flight.new();
   globals.Concorde.airbleedsystem = Concorde.Airbleed.new();
   globals.Concorde.pressuresystem = Concorde.Pressurization.new();
   globals.Concorde.antiicingsystem = Concorde.Antiicing.new();
   globals.Concorde.fuelsystem = Concorde.Fuel.new();
   globals.Concorde.tankpressuresystem = Concorde.Pressurizetank.new();
   globals.Concorde.autopilotsystem = Concorde.Autopilot.new();
   globals.Concorde.autothrottlesystem = Concorde.Autothrottle.new();
   globals.Concorde.GPWSsystem = Concorde.Gpws.new();
   globals.Concorde.MWSsystem = Concorde.Mws.new();
   globals.Concorde.enginesystem = Concorde.Engine.new();
   globals.Concorde.lightingsystem = Concorde.Lighting.new();
   globals.Concorde.gearsystem = Concorde.Gear.new();

   globals.Concorde.CGinstrument = Concorde.Centergravity.new();
   globals.Concorde.machinstrument = Concorde.Machmeter.new();
   globals.Concorde.TMOinstrument = Concorde.Temperature.new();
   globals.Concorde.ADCinstrument = Concorde.AirDataComputer.new();
   globals.Concorde.altimeterinstrument = Concorde.Altimeter.new();
   globals.Concorde.IASinstrument = Concorde.Airspeed.new();
   globals.Concorde.standbyIASinstrument = Concorde.StandbyAirspeed.new();
   globals.Concorde.VSIinstrument = Concorde.VerticalSpeed.new();
   globals.Concorde.AOAinstrument = Concorde.AccelerometerAOA.new();
   globals.Concorde.INSinstrument = Concorde.Inertial.new();
   globals.Concorde.Compassinstrument = Concorde.Compass.new();
   globals.Concorde.HSIinstrument = Concorde.HSI.new();
   globals.Concorde.transponderinstrument = Concorde.Transponder.new();
   globals.Concorde.wiperinstrument = Concorde.Wiper.new();
   globals.Concorde.noseinstrument = Concorde.NoseVisor.new();
   globals.Concorde.markerinstrument = Concorde.Markerbeacon.new();
   globals.Concorde.daytimeinstrument = Concorde.Daytime.new();
   globals.Concorde.genericinstrument = Concorde.Generic.new();

   globals.Concorde.doorsystem = Concorde.Doors.new();
   globals.Concorde.seatsystem = Concorde.Seats.new();

   globals.Concorde.menuscreen = Menu.new();
   globals.Concorde.crewscreen = Crewbox.new();

   globals.Concorde.copilotcrew = Concorde.Virtualcopilot.new();
   globals.Concorde.engineercrew = Concorde.Virtualengineer.new();
   globals.Concorde.voicecrew = Concorde.Voice.new();
   globals.Concorde.crewcrew = Crew.new();

   globals.Concorde.copilothuman = Concorde.Copilothuman.new();
   globals.Concorde.engineerhuman = Concorde.Engineerhuman.new();

   globals.Concorde.tractorexternal = Concorde.Tractor.new();
}

# general initialization
ConcordeMain.init = func {
   aircraft.livery.init( "Aircraft/Concorde/Models/Liveries",
                         "sim/model/livery/name",
                         "sim/model/livery/index" );

   me.instantiate();
   me.putinrelation();
   me.synchronize();

   # JSBSim specific
   globals.Concorde.FDM.specific();

   # schedule the 1st call
   me.timer1sec = maketimer(fuelsystem.PUMPSEC, me, me.sec1cron);
   me.timer3sec = maketimer(autopilotsystem.AUTOPILOTSEC, me, me.sec3cron);
   me.timer5sec = maketimer(pressuresystem.PRESSURIZESEC, me, me.sec5cron);
   me.timer10sec = maketimer(MWSsystem.AUXILIARYSEC, me, me.sec10cron);
   me.timer15sec = maketimer(15, me, me.sec15cron);
   me.timer30sec = maketimer(tankpressuresystem.TANKSEC, me, me.sec30cron);
   me.timer60sec = maketimer(60, me, me.sec60cron);

   me.timer1sec.simulatedTime = 1;
   me.timer3sec.simulatedTime = 1;
   me.timer5sec.simulatedTime = 1;
   me.timer10sec.simulatedTime = 1;
   me.timer15sec.simulatedTime = 1;
   me.timer30sec.simulatedTime = 1;
   me.timer60sec.simulatedTime = 1;

   me.timer1sec.start();
   me.timer3sec.start();
   me.timer5sec.start();
   me.timer10sec.start();
   me.timer15sec.start();
   me.timer30sec.start();
   me.timer60sec.start();

   # saved on exit, restored at launch
   me.savedata();
   
   # waits that systems are ready
   me.timerstartup = maketimer(2.0, me, me.startupcron);
   me.timerstartup.singleShot = 1;
   me.timerstartup.start();

   # the 3D is soon visible
   print("Concorde systems started, version ", getprop("/sim/aircraft-version"));
}

# state reset
ConcordeMain.reinit = func {
   if( getprop("/controls/fuel/reinit") ) {
       # default is JSBSim state, which loses fuel selection.
       globals.Concorde.fuelsystem.reinitexport();
   }
}

# object creation
concordeL  = setlistener("/sim/signals/fdm-initialized", func { globals.Concorde.main = ConcordeMain.new(); removelistener(concordeL); });

# state reset
concordeL2 = setlistener("/sim/signals/reinit", func { globals.Concorde.main.reinit(); });
