# Multiplayer support for the QSeries
# Copyright (c) 2019 Ludovic Brenta
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# This file is loaded into fgfs whenever the local fgfs sees a remote
# Q400 of any variant.  It aliases generic multiplayer properties into
# the property tree of the remote aircraft (under
# /ai/models/multiplayer[*]) for animations.


var all_props =
[[ "sim/model/blunt-nose",                    "int[0]" ],
 [ "sim/model/display-callsign",              "int[1]" ],
 [ "sim/model/lights/nav-lights/state",       "int[9]" ],
 [ "sim/model/lights/landing-light[0]/state", "int[10]" ],
 [ "sim/model/lights/landing-light[1]/state", "int[11]" ],
 [ "sim/model/lights/taxi-lights/state",      "int[12]" ],
 [ "sim/model/lights/strobe/state",           "int[13]" ],
 [ "sim/model/lights/beacon/state",           "int[14]" ],
 [ "gear/gear[0]/wow", "bool[0]" ],
 [ "gear/gear[1]/wow", "bool[1]" ],
 [ "gear/gear[2]/wow", "bool[2]" ],
 [ "fdm/jsbsim/fcs/yaw-sum-lag",                         "float[0]" ],
 [ "fdm/jsbsim/hydraulics/elevators/final",              "float[1]" ],
 [ "fdm/jsbsim/hydraulics/ailerons/final",               "float[2]" ],
 [ "systems/electrical/outputs/nav-lights",              "float[3]" ],
 [ "systems/electrical/outputs/landing-light[0]",        "float[4]" ],
 [ "systems/electrical/outputs/landing-light[1]",        "float[5]" ],
 [ "systems/electrical/outputs/taxi-lights",             "float[6]" ],
 [ "systems/electrical/outputs/strobe",                  "float[7]" ],
 [ "systems/electrical/outputs/beacon",                  "float[8]" ],
 [ "systems/electrical/volts",                           "float[9]" ],
 [ "gear/gear[0]/rollspeed-ms",                          "float[10]" ],
 [ "gear/gear[1]/rollspeed-ms",                          "float[11]" ],
 [ "gear/gear[2]/rollspeed-ms",                          "float[12]" ],
 [ "sim/model/door-positions/passengerF/position-norm",  "float[18]" ],
 [ "sim/model/door-positions/passengerLH/position-norm", "float[19]" ],
 [ "sim/model/door-positions/passengerRF/position-norm", "float[20]" ],
 [ "sim/model/door-positions/passengerRH/position-norm", "float[21]" ],
 [ "sim/model/door-positions/cargo/position-norm",       "float[22]" ],
 [ "controls/flight/spoiler-inbd-left",                  "float[23]" ],
 [ "controls/flight/spoiler-inbd-right",                 "float[24]" ],
 [ "controls/flight/spoiler-outbd-left",                 "float[25]" ],
 [ "controls/flight/spoiler-outbd-right",                "float[26]" ]];

init_remote_aircraft = func (r) {
  # r is the property node corresponding to the remote QSeries.
  print ("BEGIN Qseries loading for remote pilot " ~ r.getNode ("sim/multiplay/callsign").getValue ());
  var g = r.getNode ("sim/multiplay/generic");
  foreach (var p; all_props) {
    r.initNode (p[0]).alias (g.initNode (p[1]));
  }
  print ("END Qseries loaded for remote pilot " ~ r.getNode ("sim/multiplay/callsign").getValue ());
};

unload_remote_aircraft = func (r) {
  foreach (var p; all_props) {
    r.getNode (p[0]).unalias();
  }
  print ("Qseries unloaded for remote pilot " ~ r.getNode ("sim/multiplay/callsign").getValue ());
}

init_local_aircraft = func () {
  print ("Initializing multiplayer...");
  var g = props.globals.initNode ("sim/multiplay/generic");
  foreach (var p; all_props) {
    g.initNode (p[1]).alias (props.globals.initNode (p[0]));
  }
  print ("done");
}
