// -*- mode: C; -*-
// Licence: GPL v2
// based on
// © Emilian Huminiuc and Vivian Meazza 2011
// addition for wingflex mesh distortion by Thorsten Renk 2015
// re-write to simulate a banner by Bea Wolf 2020

#version 120

varying	vec3	rawpos;
varying	vec3	VNormal;
varying	vec3	VTangent;
varying	vec3	VBinormal;
varying	vec3	vViewVec;
varying vec3 	vertVec;

varying	float	alpha;

varying float flogz;

attribute	vec3	tangent;
attribute	vec3	binormal;

//uniform	float		pitch;
//uniform	float		roll;
//uniform	float		hdg;
uniform float 		attachment_x_m;
uniform float		wind_speed;
//uniform float		beta_deg;
uniform float		time;
uniform float		displacement_factor;
uniform float		time_factor;
uniform	int  		refl_dynamic;
uniform int  		shader_qual;
uniform int		rembrandt_enabled;

//////Fog Include///////////
// uniform	int 	fogType;
// void	fog_Func(int type);
////////////////////////////

void	main(void)
{
		vec4 vertex = gl_Vertex;
		// We want to simulate a banner in the wind, ideas:
		//	1. front edge is fixed (by the attachment), movement of the attachment is done with animations outside of the shader
		//	2. the banner turns into the wind (beta)
		//	3. the banner moves in a sinus-wave-like motion, dependent on airspeed
		//	4. heuristics: 
		//		4.1 behaviour at low airspeeds is not simulated for the moment (way more complicated)
		//		4.2 displacing the y-Coordinate without adjusting x makes the banner larger, but avoiding this would make things unnecessarily complicated, so we hope it's not that noticeable
		if ( vertex.x > attachment_x_m ) {
			float arm  = vertex.x - attachment_x_m;
			float sin_input = time * time_factor + arm * ( 1 + 0.05 * abs(vertex.z) * abs(vertex.z) );
			vertex.y = vertex.y + displacement_factor * wind_speed * sin( sin_input ) * arm;
			//vertex.z = vertex.z + sin_input * 0.1;
			//vertex.y = 0.1 * time;
		}
		
		// logarithmic depth
		flogz = 1.0 + gl_Position.w;
		//gl_Position = ftransform();
		
		
		

		rawpos = vertex.xyz;
		vec4 ecPosition = gl_ModelViewMatrix * vertex;

		VNormal = normalize(gl_NormalMatrix * gl_Normal);

		vec3 n = normalize(gl_Normal);
		vec3 tempTangent = cross(n, vec3(1.0,0.0,0.0));
		vec3 tempBinormal = cross(n, tempTangent);

		VTangent = normalize(gl_NormalMatrix * tempTangent);
		VBinormal = normalize(gl_NormalMatrix * tempBinormal);
		vec3 t = tempTangent;
		vec3 b = tempBinormal;
		// Super hack: if diffuse material alpha is less than 1, assume a
		// transparency animation is at work
		if (gl_FrontMaterial.diffuse.a < 1.0)
			alpha = gl_FrontMaterial.diffuse.a;
		else
			alpha = gl_Color.a;

		// Vertex in eye coordinates
		vertVec = ecPosition.xyz;
		vViewVec.x = dot(t, vertVec);
		vViewVec.y = dot(b, vertVec);
		vViewVec.z = dot(n, vertVec);

		if(rembrandt_enabled < 1){
			gl_FrontColor = gl_FrontMaterial.emission + gl_Color
					  * (gl_LightModel.ambient + gl_LightSource[0].ambient);
		} else {
			gl_FrontColor = gl_Color;
		}
		gl_Position = gl_ModelViewProjectionMatrix * vertex;
		gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
}
