var volt_src = "";
if( getprop("/sim/aero") == "q400-jsb" ){
	volt_src = "/systems/electrical/DC/rmain-bus/volts";
} else {
	volt_src = "/systems/electrical/outputs/APU";
}

var APU = {
	switches: {
		master:	props.globals.getNode("/controls/APU/master", 1),
		power:	props.globals.getNode("/controls/APU/power-btn", 1),
		start:	props.globals.getNode("/controls/APU/start", 1),
		bleed:	props.globals.getNode("/controls/APU/bleedair", 1),
		generator:	props.globals.getNode("/controls/APU/generator", 1),
	},
	selftest: {
		status:	props.globals.getNode("/controls/APU/selftest", 1),
		power:	props.globals.getNode("/controls/APU/power-btn-tst", 1),
		start:	props.globals.getNode("/controls/APU/start-btn-tst", 1),
		generator:	props.globals.getNode("/controls/APU/gen-btn-tst", 1),
		bleed:	props.globals.getNode("/controls/APU/bleedair-tst", 1),
		gen_oht:	props.globals.getNode("/controls/APU/gen-oht-tst", 1),
	},
	rpm:		props.globals.getNode("/engines/APU/rpm", 1),
	running:	props.globals.getNode("/engines/APU/running", 1),
	plugged:	props.globals.getNode("/engines/APU/plugged", 1),
	start_volt:	props.globals.getNode(volt_src, 1),
	state:	0,	# commanded state: 0 = off, 1 = idle (62), 2 = bleed air (98)
	gen_btn:	props.globals.getNode("/controls/APU/gen-btn", 1),
};

setlistener( APU.switches.start, func{
	if( APU.switches.start.getBoolValue() and APU.switches.master.getBoolValue() and APU.start_volt.getDoubleValue() > 20 ){
		interpolate( APU.rpm, 62, 5 );
	}
});

setlistener( APU.rpm, func {
	if( APU.rpm >= 62 ){
		APU.switches.start.setBoolValue( 0 );
		APU.running.setBoolValue( 1 );
		APU.switches.power.setBoolValue( 1 );
	} else {
		APU.running.setBoolValue( 0 );
		APU.switches.power.setBoolValue( 0 );
	}
});

setlistener( APU.switches.master, func{
	if( APU.switches.master.getBoolValue() ){		# Switching the APU on starts the self-test
		APU_selftest();
	}
});

var APU_selftest = func( last_state = 0 ){	
	if( last_state == 0 ){
		APU.selftest.status.setBoolValue( 1 );
		settimer( APU_selftest( 1 ), 0.1 );
	} elsif( last_state == 1 ){
		APU.selftest.power.setIntValue( 1 );
		settimer( APU_selftest( 2 ), 0.2 );
	} elsif( last_state == 2 ){
		APU.selftest.power.setIntValue( 0 );
		settimer( APU_selftest( 3 ), 0.2 );
	} elsif( last_state == 3 ){
		APU.selftest.power.setIntValue( 2 );
		settimer( APU_selftest( 4 ), 0.2 );
	} elsif( last_state == 4 ){
		APU.selftest.power.setIntValue( 0 );
		settimer( APU_selftest( 5 ), 0.2 );
	} elsif( last_state == 5 ){
		APU.selftest.start.setBoolValue( 1 );
		settimer( APU_selftest( 6 ), 0.2 );
	} elsif( last_state == 6 ){
		APU.selftest.start.setBoolValue( 0 );
		settimer( APU_selftest( 7 ), 0.2 );
	} elsif( last_state == 7 ){
		APU.selftest.generator.setIntValue( 1 );
		settimer( APU_selftest( 8 ), 0.2 );
	} elsif( last_state == 8 ){
		APU.selftest.generator.setIntValue( 0 );
		settimer( APU_selftest( 9 ), 0.2 );
	} elsif( last_state == 9 ){
		APU.selftest.generator.setIntValue( 2 );
		settimer( APU_selftest( 10 ), 0.2 );
	} elsif( last_state == 10 ){
		APU.selftest.generator.setIntValue( 0 );
		settimer( APU_selftest( 11 ), 0.2 );
	} elsif( last_state == 11 ){
		APU.selftest.bleed.setBoolValue( 1 );
		settimer( APU_selftest( 12 ), 0.2 );
	} elsif( last_state == 12 ){
		APU.selftest.bleed.setBoolValue( 0 );
		settimer( APU_selftest( 13 ), 0.2 );
	} elsif( last_state == 13 ){
		APU.selftest.gen_oht.setBoolValue( 1 );
		settimer( APU_selftest( 14 ), 0.2 );
	} elsif( last_state == 14 ){
		APU.selftest.gen_oht.setBoolValue( 0 );
		settimer( APU_selftest( 15 ), 0.5 );
	} elsif( last_state == 15 ){
		APU.selftest.status.setBoolValue( 0 );
	}
}
		

var update_APU = func{
	var master = APU.switches.master.getBoolValue();
	var running = APU.running.getBoolValue();
	var start = APU.switches.start.getBoolValue();
	var blair = APU.switches.bleed.getBoolValue();
	var generator = APU.switches.generator.getBoolValue();
	
	if( running ){
		if( !master ){
			if( APU.state != 0 ){
				interpolate( APU.rpm, 0, 5 );		# Spin APU down if master is switched off
				APU.state = 0;
			}
		}elsif( blair and APU.state != 2 ){
			interpolate( APU.rpm, 98, 2 );	# APU spins up to maximum RPM when bleed air is selected
			APU.state = 2;
		}elsif( !blair and !start and APU.state != 1 ){
			interpolate( APU.rpm, 62, 2 );	# APU spins back down to idle RPM when bleed air is un-selected
			APU.state = 1;
		}
		
		APU.plugged.setBoolValue( generator );
		APU.gen_btn.setIntValue( 2 - generator );
	} else {
		APU.plugged.setBoolValue( 0 );
		APU.gen_btn.setIntValue( 0 );
	}
}

var apu_loop = maketimer( 0.1, update_APU );
apu_loop.simulatedTime = 1;

setlistener("/sim/signals/fdm-initialized", func{
	apu_loop.start();
	print("APU System loaded");
});
