############### importand for the fdm-init setlistener at the end of this file ############
var iPad_Vmax = nil;
var iPad_8nm = nil;
var iPad_300on3 = nil;
var iPad_Climb = nil;
var iPad_iMap = nil;
var iPAD_display = nil;
var iMAP_display = nil;
var iWP_display = nil;
var MyWp = nil;
var MyAircraft = nil;
var MyWp_1 = nil;
var MyWp_2 = nil;
var MyWp_3 = nil;
var MyWp_4 = nil;
var MyMap = nil;
var g = nil;

################ some inits  ##############
var instrument_dir = "Aircraft/RR-ACCEL/Models/Cockpit/Instruments/ipad/";
props.globals.initNode("/instrumentation/ipad/show-manual-tt22",0,"BOOL");
props.globals.initNode("/instrumentation/ipad/show-manual-ty92",0,"BOOL");
props.globals.initNode("/instrumentation/ipad/show-manual-xfap",0,"BOOL");
props.globals.initNode("/instrumentation/ipad/page-tt22",0,"INT");
props.globals.initNode("/instrumentation/ipad/page-ty92",0,"INT");
props.globals.initNode("/instrumentation/ipad/page-xfap",0,"INT");

var istart = props.globals.initNode("/instrumentation/ipad/start",0,"BOOL");
var page = props.globals.initNode("/instrumentation/ipad/page","start","STRING");
var calcevent = props.globals.initNode("/electrical-flight-events/calculate-event",0,"BOOL");
var startevent = props.globals.initNode("/electrical-flight-events/start-event",0,"BOOL");
var startaltitude = props.globals.initNode("/electrical-flight-events/start-altitude",0,"DOUBLE");
var starthpa = props.globals.initNode("/electrical-flight-events/start-hpa",0,"DOUBLE");
var startwindfrom = props.globals.initNode("/electrical-flight-events/start-wind-from",0,"DOUBLE");
var startwindspeed = props.globals.initNode("/electrical-flight-events/start-wind-speed-kt",0,"DOUBLE");

var steady_sec = props.globals.getNode("/sim/time/steady-clock-sec",	1);

var vmaxact = props.globals.initNode("/electrical-flight-events/vmax/vmax-actual",0,"DOUBLE");
for(var v=0; v <= 9; v+=1){
	props.globals.initNode("/electrical-flight-events/vmax/vmax["~v~"]",0,"DOUBLE");
	props.globals.initNode("/electrical-flight-events/vmax/vmax-string["~v~"]","","STRING");
	props.globals.initNode("/electrical-flight-events/vmax/vmax-str["~v~"]","","STRING");
}

var threeact = props.globals.initNode("/electrical-flight-events/threehundert/three-actual",0,"DOUBLE");
var threeacttime = props.globals.initNode("/electrical-flight-events/threehundert/three-starttime",0,"DOUBLE");
for(var v=0; v <= 8; v+=1){
	props.globals.initNode("/electrical-flight-events/threehundert/three-string["~v~"]","","STRING");
	props.globals.initNode("/electrical-flight-events/threehundert/three-str["~v~"]","","STRING");
}

 props.globals.initNode("/electrical-flight-events/distance/distance-starttime",0,"DOUBLE");
 props.globals.initNode("/electrical-flight-events/distance/wp",0,"INT");
 props.globals.initNode("/electrical-flight-events/distance/nm",10,"DOUBLE");
 props.globals.initNode("/electrical-flight-events/distance/nmminus",9,"DOUBLE");
 props.globals.initNode("/electrical-flight-events/distance/nmplus",11,"DOUBLE");
 props.globals.initNode("/electrical-flight-events/distance/calc-nm",0,"INT");
 props.globals.initNode("/electrical-flight-events/distance/zoom",10,"INT");
 props.globals.initNode("/electrical-flight-events/distance/wp-zoom",5,"INT");
for(var v=0; v <= 5; v+=1){
	props.globals.initNode("/electrical-flight-events/distance/distance["~v~"]",0,"DOUBLE");
	props.globals.initNode("/electrical-flight-events/distance/dis-sort["~v~"]",0,"INT");
	props.globals.initNode("/electrical-flight-events/distance/dis-str["~v~"]","","STRING");
	props.globals.initNode("/electrical-flight-events/distance/dis-string["~v~"]","","STRING");
}
for(var v=0; v <= 2; v+=1){
	props.globals.initNode("/electrical-flight-events/distance/point["~v~"]/lat",0,"DOUBLE");
	props.globals.initNode("/electrical-flight-events/distance/point["~v~"]/lon",0,"DOUBLE");
}


############# the canvas base class - also switch for the actual shown canvas #################
var canvas_iPAD_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "CaviarDreams.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();

		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)",
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var starter = istart.getBoolValue();

		if ( starter == 1 ) {
			if(page.getValue() == "vmax"){
				iPad_Vmax.page.show();
				iPad_Vmax.update();
				iPad_8nm.page.hide();
				iPad_iMap.page.hide();
				iPad_300on3.page.hide();
				iPad_Climb.page.hide();
			}elsif(page.getValue() == "300on3"){
				iPad_300on3.page.show();
				iPad_300on3.update();
				iPad_8nm.page.hide();
				iPad_iMap.page.hide();
				iPad_Vmax.page.hide();
				iPad_Climb.page.hide();
			}elsif(page.getValue() == "8nm"){
				iPad_8nm.page.show();
				iPad_8nm.update();
				iPad_iMap.page.hide();
				iPad_300on3.page.hide();
				iPad_Vmax.page.hide();
				iPad_Climb.page.hide();
			}elsif(page.getValue() == "iMap"){
				iPad_iMap.page.show();
				iPad_iMap.update();
				iPad_8nm.page.hide();
				iPad_300on3.page.hide();
				iPad_Vmax.page.hide();
				iPad_Climb.page.hide();
			}elsif(page.getValue() == "climb"){
				iPad_Climb.page.show();
				iPad_Climb.update();
				iPad_8nm.page.hide();
				iPad_iMap.page.hide();
				iPad_300on3.page.hide();
				iPad_Vmax.page.hide();
			}else{
				page.setValue("start");
				iPad_Vmax.page.hide();
				iPad_8nm.page.hide();
				iPad_iMap.page.hide();
				iPad_300on3.page.hide();
				iPad_Climb.page.hide();
			}

		} else {
			iPad_Vmax.page.hide();
			iPad_8nm.page.hide();
			iPad_iMap.page.hide();
			iPad_300on3.page.hide();
			iPad_Climb.page.hide();
		}

		var wgpu = getprop("aircraft/settings/weak_gpu") or 0;
		if(wgpu == 0){
			settimer(func me.update(), 0.8);   # canvas need only be updated every 0.8sec.
		}else{
			page.setValue("start");
			iPad_Vmax.page.hide();
			iPad_8nm.page.hide();
			iPad_iMap.page.hide();
			iPad_300on3.page.hide();
			iPad_Climb.page.hide();
		}
	},
};

########## the possible views on screen, with the logic for the flight events ######################

var canvas_iPAD_Vmax = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_iPAD_Vmax , canvas_iPAD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["vmax.digits","test.0","test.1","test.2","test.3","test.4","test.5","test.6","test.7","test.8","test.9",
		"zus.0","zus.1","zus.2","zus.3","zus.4","zus.5","zus.6","zus.7","zus.8","zus.9",
		"info.0","info.1","info.2","info.3","info.4","info.5","info.6","info.7","info.8","info.9",
		"abort.0","abort.1"];
	},
	update: func() {

		var speed = getprop("instrumentation/airspeed-indicator/indicated-speed-kt") or 0;
		var vmax = vmaxact.getValue();
		var start = startevent.getValue();
		var startalt = startaltitude.getValue();
		var actalt = getprop("instrumentation/altimeter/indicated-altitude-ft") or 0;
		var hpa = getprop("instrumentation/altimeter/setting-hpa") or 0;
		var inhg = getprop("environment/pressure-inhg") or 0;
		var windkts = getprop("environment/wind-speed-kt") or 0;
		var windfrom = getprop("environment/wind-from-heading-deg") or 0;
		var pitchdeg = getprop("orientation/pitch-deg") or 0;
		var hdg = getprop("orientation/heading-deg") or 0;
		var temp_c = getprop("environment/temperature-degc") or 0;
		var time_d =  getprop("sim/time/real/day") or 0;
		var time_m =  getprop("sim/time/real/month") or 0;
		var time_year =  getprop("sim/time/real/year") or 0;
		var time_y = time_year - 2000;
		var time_h =  getprop("sim/time/real/hour") or 0;
		var time_min =  getprop("sim/time/real/minute") or 0;
		var timestring = sprintf("%02d", time_d)~"."~sprintf("%02d", time_m)~"."~sprintf("%02d", time_y)~" "~sprintf("%02d", time_h)~":"~sprintf("%02d", time_min);

		if(start == 1){
			if(startalt == 0){
				startaltitude.setValue(actalt);
				starthpa.setValue(hpa);
				startwindfrom.setValue(windfrom);
				startwindspeed.setValue(windkts);
			}

			# show last 10 tests
			var vmaxOther = props.globals.getNode("/electrical-flight-events/vmax").getChildren("vmax");
			var vmaxtrials = size(vmaxOther);
			var speedtest_list = {};

			for(var i=0; i < vmaxtrials; i+=1){
				me["test."~i].setText(sprintf("%.2f", getprop("/electrical-flight-events/vmax/vmax["~i~"]") or 0));
				me["info."~i].setText(sprintf("%s", getprop("/electrical-flight-events/vmax/vmax-string["~i~"]") or "-"));
				me["zus."~i].setText(sprintf("%s", getprop("/electrical-flight-events/vmax/vmax-str["~i~"]") or "-"));
			}

			var notetest = 1;
			# warning messages
			if(pitchdeg < -1.8){
				me["abort.0"].setText(sprintf("%s", "HOLD ALTITUDE!"));
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
			}
			if(actalt <= (startalt-100)){
				me["abort.0"].setText(sprintf("%s", "ALTITUDE MISMATCH!"));
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
			}
			if(windkts > 18){
				me["abort.0"].setText(sprintf("%s", "TOO STRONG WINDS!"));
				vmaxact.setValue(0.0);
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
				startevent.setBoolValue(0);
			}


			# monitor the valid tests
			if(speed > vmax and notetest == 1){
				vmaxact.setValue(speed);
				me["vmax.digits"].setText(sprintf("%.2f", speed));
				me["abort.0"].setText(sprintf("%s", ""));
			}

		}else{

			# test is finished, but the last vamx isn't deleted - that's the right point to save this test.
			if(vmaxact.getValue() != 0){

				# sort the last 10 speedtests
				var vmaxOther = props.globals.getNode("/electrical-flight-events/vmax").getChildren("vmax");
				var vmaxtrials = size(vmaxOther);
				var speedtest_list = {};
				for(var i=0; i < vmaxtrials; i+=1){
					speedtest_list[i] = {s: getprop("/electrical-flight-events/vmax/vmax["~i~"]"),e: getprop("/electrical-flight-events/vmax/vmax-string["~i~"]"),etc: getprop("/electrical-flight-events/vmax/vmax-str["~i~"]")};
				}

				# write the info text for this speedtest
				var infotext = "kts  "~sprintf("%.0f", actalt)~"ft/ "~sprintf("%.2f", inhg)~"/ "~sprintf("%.1f", temp_c)~"°C/ hdg "~sprintf("%.0f", hdg);
				var moretext = "Wind "~sprintf("%.0f", windkts)~"kts from "~sprintf("%.0f",windfrom)~"/ "~timestring;
				speedtest_list[10] = {s: vmaxact.getValue(), e: infotext, etc: moretext}; # fill the hash with the actual test

				var sortedspeedtest_list = sort(keys(speedtest_list), func (a,b) { speedtest_list[b].s - speedtest_list[a].s;});
				pop(sortedspeedtest_list);  #cut the slowest test
				var sortnr = size(sortedspeedtest_list);

				if(sortedspeedtest_list != nil){
					for(var n=0; n < sortnr; n+=1){
						me["test."~n].setText(sprintf("%.2f", speedtest_list[sortedspeedtest_list[n]].s));
						setprop("/electrical-flight-events/vmax/vmax["~n~"]", speedtest_list[sortedspeedtest_list[n]].s);
						setprop("/electrical-flight-events/vmax/vmax-string["~n~"]", speedtest_list[sortedspeedtest_list[n]].e);
						setprop("/electrical-flight-events/vmax/vmax-str["~n~"]", speedtest_list[sortedspeedtest_list[n]].etc);
					}
				}
				me["vmax.digits"].setText(sprintf("%.2f", vmaxact.getValue()));
			}else{

				# show last 10 tests
				var vmaxOther = props.globals.getNode("/electrical-flight-events/vmax").getChildren("vmax");
				var vmaxtrials = size(vmaxOther);
				for(var i=0; i < vmaxtrials; i+=1){
					me["test."~i].setText(sprintf("%.2f", getprop("/electrical-flight-events/vmax/vmax["~i~"]") or 0));
					me["info."~i].setText(sprintf("%s", getprop("/electrical-flight-events/vmax/vmax-string["~i~"]") or "-"));
					me["zus."~i].setText(sprintf("%s", getprop("/electrical-flight-events/vmax/vmax-str["~i~"]") or "-"));
				}

			}

			vmaxact.setValue(0.0);
			startaltitude.setValue(0.0);
			starthpa.setValue(0.0);
			startwindfrom.setValue(0.0);
			startwindspeed.setValue(0.0);
		}

	}

};

var canvas_iPAD_8nm = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_iPAD_8nm , canvas_iPAD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["test.0","test.1","test.2",
		"zus.0","zus.1","zus.2",
		"info.0","info.1","info.2","help",
		"abort.0"];
	},
	update: func() {

		# show last 10 tests
		var disOther = props.globals.getNode("/electrical-flight-events/distance").getChildren("distance");
		var distrials = size(disOther);
		var distest_list = {};

		# only 3 from 5 shown
		for(var i=0; i < 3; i+=1){
			me["test."~i].setText(sprintf("%i", getprop("/electrical-flight-events/distance/distance["~i~"]") or 0));
			me["info."~i].setText(sprintf("%s", getprop("/electrical-flight-events/distance/dis-str["~i~"]") or "-"));
			me["zus."~i].setText(sprintf("%s", getprop("/electrical-flight-events/distance/dis-string["~i~"]") or "-"));
		}

		MyWp.setController("Aircraft position");
		MyWp.setRange(getprop("/electrical-flight-events/distance/wp-zoom") or 2);

		MyWp.setTranslation(iWP_display.get("view[0]")/2, iWP_display.get("view[1]")/2);

		#var r = func(name,vis=1,zindex=nil) return caller(0)[0];
		# APT and VOR are the layer names
		#foreach(var type; [r('APT')] )
		#MyWp.addLayer(factory: canvas.SymbolLayer, type_arg: type.name, visible: type.vis, priority: type.zindex,);

		MyAircraft.setGeoPosition(getprop("/position/latitude-deg"), getprop("/position/longitude-deg"));
		# how many points
		var maxWp = props.globals.getNode("/electrical-flight-events/distance").getChildren("point");
		var allwps = size(maxWp);

		for(var i=0; i < allwps; i+=1){
			var la = getprop("/electrical-flight-events/distance/point["~ i ~"]/lat");
			var lo = getprop("/electrical-flight-events/distance/point["~ i ~"]/lon");
			if(i == 0) MyWp_1.setGeoPosition(la, lo);
			if(i == 1) MyWp_2.setGeoPosition(la, lo);
			if(i == 2) {
				MyWp_3.setGeoPosition(la, lo);
				MyWp_4.setGeoPosition(la, lo);
			}
		}

		if(getprop("/electrical-flight-events/distance/wp") > 0 and getprop("/electrical-flight-events/distance/distance-starttime") > 0){
			MyWp_4.show();
			MyWp_3.hide();
		}else{
			MyWp_3.show();
			MyWp_4.hide();
		}
		# Finish and save data in the autopilot /instruments/xflighttech/xf.nas
	# close the 8nm update loop
	}
};

var canvas_iPAD_iMap = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_iPAD_iMap , canvas_iPAD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {

			var zoom = getprop("/electrical-flight-events/distance/zoom") or 10;
			var type = "intl";
			var tile_size = 256;

			MyMap.setController("Aircraft position");
			MyMap.setRange(25);

			# created childs fill the tree in loop mode :))
			var toomuch = size(g.getChildren());
			if(toomuch > 200) g.removeAllChildren();

			MyMap.setTranslation(iMAP_display.get("view[0]")/2, iMAP_display.get("view[1]")/2);
			var r = func(name,vis=1,zindex=nil) return caller(0)[0];

			var maps_base = getprop("/sim/fg-home") ~ '/cache/maps';

			# (also see http://wiki.openstreetmap.org/wiki/Tile_usage_policy)
			var makeUrl = string.compileTemplate('https://maps.wikimedia.org/osm-{type}/{z}/{x}/{y}.png');
		  #https://maps.wikimedia.org/osm-intl/${z}/${x}/${y}.png
		  var makePath =
		  string.compileTemplate(maps_base ~ '/osm-{type}/{z}/{x}/{y}.png');
		  var num_tiles = [3, 3];
		  var center_tile_offset = [(num_tiles[0] - 1) / 2,(num_tiles[1] - 1) / 2];

			# simple aircraft icon at current position/center of the map
			g.createChild("path")
			.moveTo( tile_size * center_tile_offset[0] - 10,
			  tile_size * center_tile_offset[1] )
			.horiz(20)
			.move(-10,-10)
			.vert(20)
			.set("stroke", "red")
			.set("stroke-width", 3)
			.set("z-index", 2);

			##
			# initialize the map by setting up
			# a grid of raster images

			var tiles = setsize([], num_tiles[0]);
			for(var x = 0; x < num_tiles[0]; x += 1)
			{
			  tiles[x] = setsize([], num_tiles[1]);
			  for(var y = 0; y < num_tiles[1]; y += 1)
			  tiles[x][y] = g.createChild("image", "map-tile");
			}

			var last_tile = [-1,-1];
			var last_type = type;

			##
			# this is the callback that will be regularly called by the timer
			# to update the map
			var updateMapTiles = func()
			{
			  # get current position
			  var lat = getprop('/position/latitude-deg');
			  var lon = getprop('/position/longitude-deg');

			  var n = math.pow(2, zoom);
			  var offset = [
			  n * ((lon + 180) / 360) - center_tile_offset[0],
			  (1 - math.ln(math.tan(lat * math.pi/180) + 1 / math.cos(lat * math.pi/180)) / math.pi) / 2 * n - center_tile_offset[1]
			  ];
			  var tile_index = [int(offset[0]), int(offset[1])];

			  var ox = tile_index[0] - offset[0];
			  var oy = tile_index[1] - offset[1];

			  for(var x = 0; x < num_tiles[0]; x += 1)
			  for(var y = 0; y < num_tiles[1]; y += 1)
			  tiles[x][y].setTranslation(int((ox + x) * tile_size + 0.5), int((oy + y) * tile_size + 0.5));

			  if(tile_index[0] != last_tile[0] or tile_index[1] != last_tile[1] or type != last_type ){
			    for(var x = 0; x < num_tiles[0]; x += 1)
			    for(var y = 0; y < num_tiles[1]; y += 1)
			    {
			      var pos = {
			        z: zoom,
			        x: int(offset[0] + x),
			        y: int(offset[1] + y),
			        type: type
			      };

			      (func {
			        var img_path = makePath(pos);
			        var tile = tiles[x][y];

			        if( io.stat(img_path) == nil )
			        { # image not found, save in $FG_HOME
			          var img_url = makeUrl(pos);
			          #print('requesting ' ~ img_url);
			          http.save(img_url, img_path)
			          .done(func {tile.set("src", img_path);})
			          .fail(func (r) print('Failed to get image ' ~ img_path ~ ' ' ~ r.status ~ ': ' ~ r.reason));
			        }
			        else # cached image found, reusing
			        {
			          #print('loading ' ~ img_path);
			          tile.set("src", img_path)
			        }
			        })();
			      }

			      last_tile = tile_index;
			      last_type = type;
			    }
			  };
				updateMapTiles();

	# close the ipadmap update loop
	}

};

var canvas_iPAD_300on3 = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_iPAD_300on3 , canvas_iPAD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["vmax.digits","time.digits",
		"zus.0","zus.1","zus.2","zus.3","zus.4","zus.5","zus.6","zus.7","zus.8","zus.9",
		"info.0","info.1","info.2","info.3","info.4","info.5","info.6","info.7","info.8","info.9",
		"abort.0","abort.1"];
	},
	update: func() {

		var speed = getprop("instrumentation/airspeed-indicator/indicated-speed-kt") or 0;
		var start = startevent.getValue();
		var startalt = startaltitude.getValue();
		var actalt = getprop("instrumentation/altimeter/indicated-altitude-ft") or 0;
		var hpa = getprop("instrumentation/altimeter/setting-hpa") or 0;
		var inhg = getprop("environment/pressure-inhg") or 0;
		var windkts = getprop("environment/wind-speed-kt") or 0;
		var windfrom = getprop("environment/wind-from-heading-deg") or 0;
		var pitchdeg = getprop("orientation/pitch-deg") or 0;
		var hdg = getprop("orientation/heading-deg") or 0;
		var temp_c = getprop("environment/temperature-degc") or 0;
		var time = steady_sec.getDoubleValue();
		var time_d =  getprop("sim/time/real/day") or 0;
		var time_m =  getprop("sim/time/real/month") or 0;
		var time_year =  getprop("sim/time/real/year") or 0;
		var time_y = time_year - 2000;
		var time_h =  getprop("sim/time/real/hour") or 0;
		var time_min =  getprop("sim/time/real/minute") or 0;
		var timestring = sprintf("%02d", time_d)~"."~sprintf("%02d", time_m)~"."~sprintf("%02d", time_y)~" "~sprintf("%02d", time_h)~":"~sprintf("%02d", time_min);

		if(start == 1){
			if(startalt == 0){
				startaltitude.setValue(actalt);
				starthpa.setValue(hpa);
				startwindfrom.setValue(windfrom);
				startwindspeed.setValue(windkts);
			}
			if(threeacttime.getValue() == 0){
				threeacttime.setValue(time);
			}

			var notetest = 1;

			# warning messages
			if(pitchdeg < -3.5){
				me["abort.0"].setText(sprintf("%s", "HOLD ALTITUDE!"));
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
			}
			if(actalt <= (startalt-150)){
				me["abort.0"].setText(sprintf("%s", "ALTITUDE MISMATCH!"));
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
			}
			if(windkts > 18){
				me["abort.0"].setText(sprintf("%s", "TOO STRONG WINDS!"));
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
				startevent.setBoolValue(0);
			}

			var lt = threeacttime.getValue();
			var diff = time - lt;
			if(diff > 180){
				startevent.setValue(0);
				me["abort.0"].setText(sprintf("%s", "FINISHED"));

				# save the last flightdatas here

				var threeOther = props.globals.getNode("/electrical-flight-events/threehundert").getChildren("three-string");
				var threetrials = size(threeOther);

				# write the info text for this speedtest
				var infotext = timestring;
				var moretext = " Wind "~sprintf("%.0f", windkts)~"kts from "~sprintf("%.0f",windfrom)~"/"~sprintf("%.0f", actalt)~"ft/"~sprintf("%.2f", inhg)~"/"~sprintf("%.1f", temp_c)~"°C/hdg "~sprintf("%.0f", hdg);

				setprop("/electrical-flight-events/threehundert/three-string[8]", getprop("/electrical-flight-events/threehundert/three-string[7]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[8]", getprop("/electrical-flight-events/threehundert/three-str[7]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[7]", getprop("/electrical-flight-events/threehundert/three-string[6]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[7]", getprop("/electrical-flight-events/threehundert/three-str[6]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[6]", getprop("/electrical-flight-events/threehundert/three-string[5]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[6]", getprop("/electrical-flight-events/threehundert/three-str[5]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[5]", getprop("/electrical-flight-events/threehundert/three-string[4]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[5]", getprop("/electrical-flight-events/threehundert/three-str[4]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[4]", getprop("/electrical-flight-events/threehundert/three-string[3]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[4]", getprop("/electrical-flight-events/threehundert/three-str[3]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[3]", getprop("/electrical-flight-events/threehundert/three-string[2]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[3]", getprop("/electrical-flight-events/threehundert/three-str[2]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[2]", getprop("/electrical-flight-events/threehundert/three-string[1]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[2]", getprop("/electrical-flight-events/threehundert/three-str[1]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[1]", getprop("/electrical-flight-events/threehundert/three-string[0]") or '');
				setprop("/electrical-flight-events/threehundert/three-str[1]", getprop("/electrical-flight-events/threehundert/three-str[0]") or '');
				setprop("/electrical-flight-events/threehundert/three-string[0]", infotext);
				setprop("/electrical-flight-events/threehundert/three-str[0]", moretext);

			}else{
			  var resttime = 180-diff;
				me["time.digits"].setText(sprintf("%.0f", resttime));
			}

			# monitor the valid tests
			if(speed > 299.9 and notetest == 1){
				me["vmax.digits"].setText(sprintf("%.0f", speed));
				me["abort.0"].setText(sprintf("%s", ""));
			}else{
				me["abort.0"].setText(sprintf("%s", "TOO SLOW!"));
				startaltitude.setValue(0.0);
				starthpa.setValue(0.0);
				startwindfrom.setValue(0.0);
				startwindspeed.setValue(0.0);
				notetest = 0;
				startevent.setBoolValue(0);
			}

		}else{

			threeacttime.setValue(0.0);
			startaltitude.setValue(0.0);
			starthpa.setValue(0.0);
			startwindfrom.setValue(0.0);
			startwindspeed.setValue(0.0);
		}

		# show last 9 tests
		var threeOther = props.globals.getNode("/electrical-flight-events/threehundert").getChildren("three-string");
		var threetrials = size(threeOther);

		for(var i=0; i < threetrials; i+=1){
			me["info."~i].setText(sprintf("%s", getprop("/electrical-flight-events/threehundert/three-string["~i~"]") or "-"));
			me["zus."~i].setText(sprintf("%s", getprop("/electrical-flight-events/threehundert/three-str["~i~"]") or "-"));
		}

	}

};

var canvas_iPAD_Climb = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_iPAD_Climb , canvas_iPAD_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {



	}

};

############ the init setlistener #################

setlistener("sim/signals/fdm-initialized", func {
	iMAP_display = canvas.new({
		"name": "iMap",
		"size": [456, 606],    #in mm
		"view": [456, 606],		 #in mm
		"mipmapping": 1
	});
	iMAP_display.addPlacement({"node": "ipad.map.display"});
	var groupMap = iMAP_display.createGroup();
	MyMap = groupMap.createChild("map");
	g = iMAP_display.createGroup();

	#debug.dump(iMAP_display.createGroup());

	iWP_display = canvas.new({
		"name": "iWp",
		"size": [456, 303],    #in mm
		"view": [456, 303],		 #in mm
		"mipmapping": 1
	});
	iWP_display.addPlacement({"node": "ipad.wp.display"});
	var groupWP = iWP_display.createGroup();
	MyWp = groupWP.createChild("map");
	MyAircraft = MyWp.createChild("image").setFile("./Models/Cockpit/Instruments/ipad/aircraft.png").set("z-index", 4);
	MyWp_1 = MyWp.createChild("image").setFile("./Models/Cockpit/Instruments/ipad/wp.png").set("z-index", 3);
	MyWp_2 = MyWp.createChild("image").setFile("./Models/Cockpit/Instruments/ipad/wp.png").set("z-index", 3);
	MyWp_3 = MyWp.createChild("image").setFile("./Models/Cockpit/Instruments/ipad/wp-start.png").set("z-index", 3);
	MyWp_4 = MyWp.createChild("image").setFile("./Models/Cockpit/Instruments/ipad/wp-finish.png").set("z-index", 3);

	iPAD_display = canvas.new({
		"name": "iPad",
		"size": [456, 606],    #in mm
		"view": [456, 606],		 #in mm
		"mipmapping": 1
	});
	iPAD_display.addPlacement({"node": "ipad.display"});
	var groupVmax = iPAD_display.createGroup();
	var group8nm = iPAD_display.createGroup();
	var group300on3 = iPAD_display.createGroup();
	var groupClimb = iPAD_display.createGroup();

	iPad_Vmax = canvas_iPAD_Vmax.new(groupVmax, instrument_dir~"vmax.svg");
	iPad_8nm = canvas_iPAD_8nm.new(group8nm, instrument_dir~"8nm.svg");
	iPad_300on3 = canvas_iPAD_300on3.new(group300on3, instrument_dir~"300on3.svg");
	iPad_Climb = canvas_iPAD_Climb.new(groupClimb, instrument_dir~"climb.svg");
	iPad_iMap = canvas_iPAD_iMap.new(groupMap, instrument_dir~"iMap.svg");

	canvas_iPAD_base.update();
});

# if we go back from the weak gpu state
setlistener("aircraft/settings/weak_gpu", func(state) {
	var value = state.getValue();
	if(!value){
		iPad_Vmax.update();
		iPad_8nm.update();
		iPad_iMap.update();
		iPad_300on3.update();
		iPad_Climb.update();
		canvas_iPAD_base.update();
	}
});


#########  stuff for the click action on the ipad ###########

var startipad = func {
 	var ipw = getprop("/instrumentation/ipad/start") or 0;
	var ipage = getprop("/instrumentation/ipad/page") or "";
	var man1 = getprop("instrumentation/ipad/show-manual-tt22");
	var man2 = getprop("instrumentation/ipad/show-manual-ty92");
	var man3 = getprop("instrumentation/ipad/show-manual-xfap");

	if(ipw == 0){
		if(ipage == ""){
			setprop("instrumentation/ipad/page", "start");
		}
		setprop("instrumentation/ipad/start", 1);
	}elsif(ipw == 1 and ipage != "start"){
		setprop("instrumentation/ipad/page", "start");
	}elsif(man1 == 1 or man2 == 1 or man3 == 1){
		setprop("instrumentation/ipad/show-manual-tt22", 0);
		setprop("instrumentation/ipad/show-manual-ty92", 0);
		setprop("instrumentation/ipad/show-manual-xfap", 0);
	}else{
		setprop("instrumentation/ipad/start", 0);
		setprop("instrumentation/ipad/show-manual-tt22", 0);
		setprop("instrumentation/ipad/show-manual-ty92", 0);
		setprop("instrumentation/ipad/show-manual-xfap", 0);
	}
}

################ functions ##############
var sort_rules = func(a, b){
    if(a < b){
        return -1; # a should before b in the returned vector
    }elsif(a == b){
        return 0; # a is equivalent to b
    }else{
        return 1; # a should after b in the returned vector
    }
}

var calc_triangle = func (){
	var hdg = getprop("orientation/heading-deg");
	var nm = getprop("/electrical-flight-events/distance/nm");

	var site = nm*1852/3;  # 1nm = 1852m
	var startposin = site + 2000;
	var pos_start = geo.aircraft_position().apply_course_distance(hdg, startposin);
	setprop("/electrical-flight-events/distance/point[0]/lat",pos_start.lat());
	setprop("/electrical-flight-events/distance/point[0]/lon",pos_start.lon());

	#print(hdg);
	#print(pos_start.lat());
	#print(pos_start.lon());


	hdg = geo.normdeg(hdg+120);
	var to = geo.Coord.new().set_latlon(pos_start.lat(), pos_start.lon());
	var pos_1 = to.apply_course_distance(hdg, site);
	setprop("/electrical-flight-events/distance/point[1]/lat",pos_1.lat());
	setprop("/electrical-flight-events/distance/point[1]/lon",pos_1.lon());

	#print(hdg);
	#print(pos_1.lat());
	#print(pos_1.lon());

	hdg = geo.normdeg(hdg+120);
	to = geo.Coord.new().set_latlon(pos_1.lat(), pos_1.lon());
	var pos_2 = to.apply_course_distance(hdg, site);
	setprop("/electrical-flight-events/distance/point[2]/lat",pos_2.lat());
	setprop("/electrical-flight-events/distance/point[2]/lon",pos_2.lon());

	#print(hdg);
	#print(pos_2.lat());
	#print(pos_2.lon());

	# ok, points fixed
	setprop("/electrical-flight-events/distance/wp",2);
	setprop("/electrical-flight-events/calculate-event",1);
	setprop("/electrical-flight-events/distance/calc-nm",nm);
}

var del_triangle = func (){
	setprop("/electrical-flight-events/distance/point[0]/lat",0);
	setprop("/electrical-flight-events/distance/point[0]/lon",0);
	setprop("/electrical-flight-events/distance/point[1]/lat",0);
	setprop("/electrical-flight-events/distance/point[1]/lon",0);
	setprop("/electrical-flight-events/distance/point[2]/lat",0);
	setprop("/electrical-flight-events/distance/point[2]/lon",0);
	setprop("/electrical-flight-events/calculate-event",0);
	setprop("/electrical-flight-events/distance/calc-nm",0);
}

var scroll_dis_numbers = func (v){
    var n = getprop("electrical-flight-events/distance/nm") or 0;
		var nplus = 0;
		var nminus = 0;

		n = n+v;
    if(n > 999){
      n = 0;
			nplus = 1;
			nminus = 999;
    }elsif(n < 0){
      n = 999;
			nplus = 0;
			nminus = 998;
    }else{
			nplus = n+1;
			nminus = n-1;
    }
    setprop("electrical-flight-events/distance/nmplus", nplus);
	setprop("electrical-flight-events/distance/nm", n);
	setprop("electrical-flight-events/distance/nmminus", nminus);
}
