# LX Navigation LX9050 simulation

var LX9050_main = nil;
var LX9050_start = nil;
var LX9050_display = nil;
var LX9050_map = nil;

var lx9050_p = props.globals.initNode("/instrumentation/lx9050");

var instrument_path = "Aircraft/Silent2Electro/Models/Instruments/LX9050/";

var volts = props.globals.getNode("/systems/electrical/outputs/lx[0]", 1);
var start = lx9050_p.initNode("start", 0.0, "DOUBLE");

var time_hr	=	props.globals.getNode("/sim/time/utc/hour", 1);
var time_min	=	props.globals.getNode("/sim/time/utc/minute", 1);

var wind_deg	=	props.globals.getNode("/environment/wind-from-heading-deg", 1);
var wind_kt	=	props.globals.getNode("/environment/wind-speed-kt",	1);

var vario_te	=	props.globals.getNode("/instrumentation/ilec-sc7/te-reading-mps", 1);
var vario_av	=	props.globals.getNode("/instrumentation/lx9050/average-reading-mps", 1);

var alt_agl	=	props.globals.getNode("/position/altitude-agl-ft", 	1);
var alt_gps	=	props.globals.getNode("/position/altitude-ft", 		1);

var gs_kt	=	props.globals.getNode("/velocities/groundspeed-kt", 	1);

var hdg_trk	=	props.globals.getNode("/orientation/track-deg",		1);
var hdg_true	=	props.globals.getNode("/orientation/heading-deg",	1);

var canvas_LX9050_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = volts.getValue();
		var start_v = start.getValue();
		if ( start_v == 1 and volt > 9 ) {
			LX9050_start.page.hide();
			LX9050_main.show();
			LX9050_main.update();
		} else if ( start_v > 0 and start_v < 1 and volt > 9){
			LX9050_main.hide();
			LX9050_start.page.show();
		} else {
			LX9050_main.hide();;
			LX9050_start.page.hide();
		}
	},
};


var canvas_LX9050_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_LX9050_start , canvas_LX9050_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	
};


var ls = setlistener("sim/signals/fdm-initialized", func {
	LX9050_display = canvas.new({
		"name": "LX9050",
		"size": [480, 800],
		"view": [480, 800],
		"mipmapping": 1
	});
	LX9050_display.addPlacement({"node": "lx9050.screen.main"});
	var groupMain = LX9050_display.createGroup();
	var groupStart = LX9050_display.createGroup();
	
	LX9050_main = canvas_nd.new(groupMain);
	
	LX9050_map = canvas.new({
		"name": "LX9050_map",
		"size": [480, 800],
		"view": [480, 800],
		"mipmapping": 1
	});
	
	LX9050_start = canvas_LX9050_start.new(groupStart, instrument_path~"LX9050_start.svg");
	
	var base_update = maketimer(0.2, func() {
				canvas_LX9050_base.update();
			});
	base_update.start();
	removelistener(ls);
});

var showLX9050 = func {
	var dlg = canvas.Window.new([480, 800], "dialog").set("resize", 1);
	dlg.setCanvas(LX9050_display);
}

setlistener(volts, func{
	if(volts.getValue() >= 10 and start.getValue() == 0){
		interpolate("/instrumentation/lx9050/start", 1, 3.5 );
	}else if( volts.getValue() < 10 and start.getValue() != 0){
		start.setValue(0.0);
	}
});
