# $Id$
#
# Nasal script to print errors to the screen when aircraft exceed design limits:
#  - extending spoiler above maximum spoiler extension speed(s) (not used as limit is Vne)
#  - exceeding Vne 
#  - exceeding Va (->Caution)
#  - exceeding MTOW
#  - exceeding structural G limits (not used as limits are not published)
# Taken from Aircraft/Generic and adapted for LS1-c

# If we have a message, display it, but don't bother checking for
# any other errors for 5 seconds. Otherwise we're likely to get
# repeated messages.
var i = [ 5, 5 ]; # number of iterations skipped when message was printed

var limits = {
    vne: props.globals.getNode("/limits/vne", 1),
    va: props.globals.getNode("/limits/va", 1),
    mtow: props.globals.getNode("/limits/mtow-lbs"),
};

var airspeed_p = props.globals.getNode("/velocities/airspeed-kt", 1);
var gross_weight = props.globals.getNode("/fdm/jsbsim/inertia/weight-lbs", 1);
var replay_freeze = props.globals.getNode("/sim/freeze/replay-state", 1);

var checkLimits = func {
    if( replay_freeze.getBoolValue() ) return;

    var airspeed	= airspeed_p.getDoubleValue();
    var vne		= limits.vne.getDoubleValue();
    var va		= limits.va.getDoubleValue();
    var msg = "";

    if( i[0] < 5 ){
	  i[0] += 1;
    } elsif ((airspeed != nil) and (vne != nil) and (airspeed > vne))	{
	  screen.log.write("Airspeed exceeds Never Exceed Speed (Vne)!");
	  i[0] = 0;
    } else if ((airspeed != nil) and (va != nil) and (airspeed > va))	{
	  screen.log.write("Caution: Airspeed exceeds Manoeuvring Speed (Va)!");
	  i[0] = 0;
    }

    if( i[1] < 5 ){
	  i[1] += 1;
    } elsif ( gross_weight.getDoubleValue() > limits.mtow.getDoubleValue() ){
	  screen.log.write( "Maximum Takeoff Weight exceeded!" );
	  i[1] = 0;
    }
}

var check_limits_timer = maketimer( 1.0, checkLimits );
check_limits_timer.simulatedTime = 1;
check_limits_timer.start();
