##########################################
##	DG/R.-S. LS8(-sc/-e) neo	##
##########################################

##	Liveries	##
if( getprop("/sim/aero") == "ls8-e" ){
	aircraft.livery.init("Aircraft/LS8/Models/Liveries-e");
} else {
	aircraft.livery.init("Aircraft/LS8/Models/Liveries");
}

##	Instruments	##
# Load vario instrument for the mechanical vario-5stv5
# (the following code is based on the ILEC SC7 e-vario)
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_needle = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/variometer/te-reading-mps"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_needle],
	enable: 1);

# Vibrating yaw string
var yawstring = YawString.new(
	on_update: update_prop("instrumentation/yawstring"));

var string_instrument = Instrument.new(
	components: [yawstring],
	enable: 1);

##	Water Ballast	##
var wing_outflow_rate = [
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[0]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[1]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[2]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[3]"),
];
var tail_outflow_rate = props.globals.getNode("fdm/jsbsim/systems/water-ballast/tail-outflow-rate-pps");
var tank_level_p = [
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[5]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[6]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[7]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[8]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[9]"),
];
var tank_level_lbs = [ 0.0, 0.0, 0.0, 0.0, 0.0 ];
var delta_time = props.globals.getNode("/sim/time/delta-sec");

var update_waterballast = func () {
	var t_outflow_rate = tail_outflow_rate.getDoubleValue();
	var dt = delta_time.getDoubleValue();
	for( var i=0; i<=3; i=i+1 ){
		tank_level_lbs[ i ] = tank_level_p[ i ].getDoubleValue();
		tank_level_p[ i ].setDoubleValue( math.max( tank_level_lbs[ i ] - wing_outflow_rate[ i ].getDoubleValue()  * dt, 0.0 ) );
	}
	tank_level_lbs[ 4 ] = tank_level_p[ 4 ].getDoubleValue();
	if( tank_level_lbs[ 4 ] > 0.0 ) {
		tank_level_p[ 4 ].setDoubleValue( tank_level_lbs[ 4 ] - t_outflow_rate  * dt );
	}
}
var waterballast_timer = maketimer( 0.0, update_waterballast );
waterballast_timer.simulatedTime = 1;


##	Start updates when FDM is initialized	##
var ls = setlistener("/sim/signals/fdm-initialized", func() {
	waterballast_timer.start();
	removelistener( ls );
});
