# Dornier DO228(-212 NG) Engine System
# Bea Wolf (D-ECHO) 2020
# Reference(s): see do228-212.xml

# Automatic startup (see ref. [1] p.7-58ff.)

var current_start = -1;	# -1 = off, 0 = left engine, 1 = right engine
var starter_set = 0;

var n1 = [
		props.globals.getNode("engines/engine[0]/n1", 1),
		props.globals.getNode("engines/engine[1]/n1", 1),
	];
var running_flag = [
		props.globals.getNode("engines/engine[0]/running"),
		props.globals.getNode("engines/engine[1]/running"),
	];
var starter = [
		props.globals.getNode("controls/engines/engine[0]/starter-int", 1),
		props.globals.getNode("controls/engines/engine[1]/starter-int", 1),
	];
var generator = [
		props.globals.getNode("controls/electric/generator[0]"),
		props.globals.getNode("controls/electric/generator[1]"),
	];
var gen_int = [
		props.globals.getNode("/controls/electric/engine[0]/generator"),
		props.globals.getNode("/controls/electric/engine[1]/generator"),
	];
var throttle_cmd = [
		props.globals.getNode("/controls/engines/engine[0]/throttle", 1),
		props.globals.getNode("/controls/engines/engine[1]/throttle", 1),
	];
var reverse_cmd = [
		props.globals.getNode("/controls/engines/engine[0]/reverser", 1),
		props.globals.getNode("/controls/engines/engine[1]/reverser", 1),
	];
var engine_speed_cmd = [
		props.globals.getNode("/controls/engines/engine[0]/engine-speed", 1),
		props.globals.getNode("/controls/engines/engine[1]/engine-speed", 1),
	];
var cutoff_cmd = [
		props.globals.getNode("/controls/engines/engine[0]/cutoff", 1),
		props.globals.getNode("/controls/engines/engine[1]/cutoff", 1),
	];

setlistener( engine_speed_cmd[0], func () {
	if ( engine_speed_cmd[0].getDoubleValue() >= 0.2 and cutoff_cmd[0].getBoolValue() != 0 ){
		cutoff_cmd[0].setBoolValue( 0 );
	} else if ( engine_speed_cmd[0].getDoubleValue() < 0.2 and cutoff_cmd[0].getBoolValue() != 1 ){
		cutoff_cmd[0].setBoolValue( 1 );
	}
});
setlistener( engine_speed_cmd[1], func () {
	if ( engine_speed_cmd[1].getDoubleValue() >= 0.2 and cutoff_cmd[1].getBoolValue() != 0 ){
		cutoff_cmd[1].setBoolValue( 0 );
	} else if ( engine_speed_cmd[1].getDoubleValue() < 0.2 and cutoff_cmd[1].getBoolValue() != 1 ){
		cutoff_cmd[1].setBoolValue( 1 );
	}
});

start_engine = func {
	if( current_start == -1 ){
		starter_set = 0;
		starter[ 0 ].setBoolValue( 0 );
		starter[ 1 ].setBoolValue( 0 );
		start_engine_updater.stop();
		return;
	}
	if( n1[ current_start ].getDoubleValue() > 55.0 ){
		current_start = -1;
	} else if ( starter_set == 0 ){
		starter[ current_start ].setBoolValue( 1 );
		starter_set = 1;
	}
}

var start_engine_updater = maketimer( 0.1, start_engine );
start_engine_updater.simulatedTime = 1;

# Called from keybinding or 3d model
var start = func ( i ){
	if ( !running_flag[ i ].getBoolValue() and current_start == -1 ) {
		current_start = i;
		start_engine_updater.restart( 0.1 );
	}
}
var stop = func ( i ){
	if( current_start != -1 ) {
		current_start = -1;
	}
}

var toggleReverse = func ( i ){
	if( !reverse_cmd[ i ].getBoolValue() and throttle_cmd[ i ].getDoubleValue() < 0.05 ){
		throttle_cmd[ i ].setDoubleValue( 0.0 );
		reverse_cmd[ i ].setBoolValue( 1 );
	} else {
		reverse_cmd[ i ].setBoolValue( 0 );
	}
}

# Generator control unit
var gcu = func () {
	for( var i=0; i <= 1; i += 1 ){
		if( generator[i].getBoolValue() or starter[i].getBoolValue() ){
			gen_int[i].setBoolValue( 1 );
		} else {
			gen_int[i].setBoolValue( 0 );
		}
	}
}
var gcu_updater = maketimer( 0.02, gcu );
gcu_updater.simulatedTime = 1;
gcu_updater.start();

#	TODO simulate fuel pressure
var fp_low = [
	props.globals.initNode("instrumentation/eicas/fuel-pressure-low[0]", 0, "BOOL"),
	props.globals.initNode("instrumentation/eicas/fuel-pressure-low[1]", 0, "BOOL"),
	];
var fp = [
	props.globals.initNode("engines/engine[0]/fuel-pressure-bar", 0, "DOUBLE"),
	props.globals.initNode("engines/engine[1]/fuel-pressure-bar", 0, "DOUBLE"),
	];

for( var i=0; i<=1; i += 1 ){
	setlistener( fp[ i ], func() {
		if( fp_low[ i ].getBoolValue() and fp[ i ].getDoubleValue() > 1 ){
			fp_low[ i ].setBoolValue( 1 );
		} else if ( !fp_low[ i ].getBoolValue() and fp[ i ].getDoubleValue() < 0.6 ){
			fp_low[ i ].setBoolValue( 0 );
		}
	});
}
	
