#		AHRS.nas
#
#		basic simulation of an Attitude and Heading Reference System
#		started 01/2024 Bea Wolf (D-ECHO)
#		ref. PIM, p. 7-30 ff.

var system_state = 0;	# 0 = OFF, 1 = SELFTEST, 2 = ALIGN, 3 = ACTIVE

var ahrs = props.globals.initNode("/instrumentation/ahrs[0]");

var status = ahrs.initNode("status", 0, "INT");

var att_valid = ahrs.initNode("attitude/valid", 0, "BOOL");
var hdg_valid = ahrs.initNode("heading/valid", 0, "BOOL");

var volts = [
	props.globals.getNode("/systems/electrical/outputs/ahrs[0]", 1),
	props.globals.getNode("/systems/electrical/outputs/ahrs[1]", 1),
];

# This function gets called on every system state change
var update_system_state = func( new_state ){
	if( new_state == 2 ){
		# ALIGN
		settimer( func{ update_system_state( 3 )}, 15.0 ); # TODO only when aircraft is stationary, else longer
	}
	
	if( new_state == 3 ){
		att_valid.setBoolValue( 1 );
		hdg_valid.setBoolValue( 1 );
	} else {
		att_valid.setBoolValue( 0 );
		hdg_valid.setBoolValue( 0 );
	}
	
	status.setIntValue( new_state );
	system_state = new_state;
}

var ahrs_slow_loop = func{
	if( ( volts[0].getDoubleValue() > 24.0 or volts[1].getDoubleValue() > 24.0 ) and system_state == 0 ){
		update_system_state( 1 );
		settimer( func{ update_system_state( 2 ) }, 15.0 );
	} elsif( ( volts[0].getDoubleValue() <= 24.0 and volts[1].getDoubleValue() <= 24.0 ) and system_state != 0 ){
		update_system_state( 0 );
	}
}

var ahrs_slow_loop_timer = maketimer( 0.5, ahrs_slow_loop );
ahrs_slow_loop_timer.simulatedTime = 1;
ahrs_slow_loop_timer.start();
