# Bombardier CRJ700 series
# Nasal effects
##########################

## Livery select
aircraft.livery.init("Aircraft/CRJ700-family/Models/Liveries/" ~ getprop("sim/aircraft"));

## Switch sounds
var switch_sound =
 {
 sounds: [],
 new: func(sound_prop, time)
  {
  var m =
   {
   node: props.globals.getNode(sound_prop, 1),
   time: time
   };
  append(switch_sound.sounds, m);
  var id = size(switch_sound.sounds) - 1;
  for (var i = 0; i < size(arg); i += 1)
   {
   setlistener(arg[i], func
    {
    switch_sound.sound(id);
    }, 0, 0);
   }
  },
 sound: func(id)
  {
  var sound = switch_sound.sounds[id];
  if (sound.node.getBoolValue())
   {
   return;
   }
  sound.node.setBoolValue(1);
  settimer(func
   {
   sound.node.setBoolValue(0);
   }, sound.time);
  }
 };
switch_sound.new("sim/sound/passenger-sign", 2,
 "controls/switches/no-smoking-sign",
 "controls/switches/seatbelt-sign"
 );
switch_sound.new("sim/sound/click", 0.5,
 "instrumentation/mfd[0]/page",
 "instrumentation/mfd[0]/tcas",
 "instrumentation/mfd[0]/wx",
 "instrumentation/mfd[1]/page",
 "instrumentation/mfd[1]/tcas",
 "instrumentation/mfd[1]/wx",
 "instrumentation/eicas[0]/page",
 "instrumentation/eicas[1]/page",
 "instrumentation/mk-viii/inputs/discretes/gpws-inhibit",
 "instrumentation/mk-viii/inputs/discretes/momentary-flap-override",
 "instrumentation/use-metric-altitude",
 "controls/autoflight/yaw-damper[0]/engage",
 "controls/autoflight/yaw-damper[1]/engage",
 "controls/electric/external-power",
 "controls/electric/battery-switch",
 "controls/electric/engine[0]/generator",
 "controls/electric/APU-generator",
 "controls/electric/engine[1]/generator",
 "controls/lighting/nav-lights",
 "controls/lighting/beacon",
 "controls/lighting/strobe",
 "controls/lighting/logo-lights",
 "controls/lighting/wing-lights",
 "controls/lighting/landing-lights[0]",
 "controls/lighting/landing-lights[1]",
 "controls/lighting/landing-lights[2]",
 "controls/lighting/taxi-lights",
 "controls/flight/ground-lift-dump",
 "consumables/fuel/tank[0]/selected",
 "controls/fuel/gravity-xflow",
 "consumables/fuel/tank[1]/selected",
 "controls/pneumatic/bleed-source",
 "controls/pneumatic/ram-air-turbine",
 "controls/APU/fuel-pump",
 "controls/APU/off-on",
 "controls/engines/engine[0]/reverser-armed",
 "controls/engines/engine[1]/reverser-armed",
 "controls/engines/engine[0]/starter",
 "controls/engines/engine[1]/starter",
 "controls/anti-ice/wiper[0]",
 "controls/anti-ice/wiper[1]",
 "controls/anti-ice/wing-heat",
 "controls/anti-ice/engine[0]/inlet-heat",
 "controls/anti-ice/engine[1]/inlet-heat",
 "controls/lighting/dome"
 );

## Tire smoke
var tiresmoke_system = aircraft.tyresmoke_system.new(0, 1, 2);

## Lights
var beacon_light = aircraft.light.new("sim/model/lights/beacon", [0.05, 6], "controls/lighting/beacon");
var strobe_light = aircraft.light.new("sim/model/lights/strobe", [0.05, 2], "controls/lighting/strobe");
