# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=glib
VER=2.16.5
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

TARGET=c:/devel/target/$HEX
DEPS=''

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev
usemsvs6

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS='-I/opt/proxy-libintl/include' LDFLAGS='-L/opt/proxy-libintl/lib -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --disable-gtk-doc --prefix=$TARGET
libtoolcacheize
make glibconfig.h.win32 &&
make glibconfig.h &&
mv glibconfig.h glibconfig.h.autogened &&
cp glibconfig.h.win32 glibconfig.h &&
PATH=$TARGET/bin:.libs:$PATH make -j3 install &&

./glib-zip &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
