# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=gtk+
VER=2.14.4
REV=2
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev
usemsvs6

(

set -x

DEPS=`latest --arch=${ARCH} glib atk cairo pango libpng zlib libtiff jpeg`
PROXY_LIBINTL=`latest --arch=${ARCH} proxy-libintl`


PKG_CONFIG_PATH=
for D in $DEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
    [ -d /devel/dist/${ARCH}/$D/lib/pkgconfig ] && PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

LIBPNG=`latest --arch=${ARCH} libpng`
ZLIB=`latest --arch=${ARCH} zlib`
LIBTIFF=`latest --arch=${ARCH} libtiff`
JPEG=`latest --arch=${ARCH} jpeg`

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

# "Backported" fixes from SVN

patch -p0 <<'EOF'
diff -pru ../gtk+-2.14.4.orig/ChangeLog ./ChangeLog
--- ../gtk+-2.14.4.orig/ChangeLog	2008-10-17 07:36:30.000000000 +0300
+++ ./ChangeLog	2008-11-07 17:28:25.921875000 +0200
@@ -1,3 +1,49 @@
+2008-11-04  Tor Lillqvist  <tml@novell.com>
+
+	Bug 557212 - Problem with which window gains focus and is visible
+
+	* gdk/win32/gdkevents-win32.c (ensure_stacking_on_activate_app):
+	Only do the restacking for the active window of the
+	application. Seems to fix the problem.
+
+	(gdk_event_translate): Only call ensure_stacking_on_activate_app()
+	when the application is being activated, not deactivated.
+
+2008-11-01  Tor Lillqvist  <tml@novell.com>
+
+	Bug 558278 - Crash when calling a callback set by
+	gdk_add_client_message_filter()
+
+	* gdk/win32/gdkevents-win32.c (apply_event_filters): Rename from
+	apply_filters() so that it is clear that this function is for
+	GdkEventFilters only.
+
+	(print_event): Print more information for GDK_CLIENT_EVENT events.
+
+	(gdk_event_translate): When handling client filters, don't use
+	apply_event_filters(). Use similar code as in the X11 backend,
+	although not exactly, as the parameter list and return value
+	semantics of gdk_event_translate() is different.
+
+2008-10-18  Tor Lillqvist  <tml@novell.com>
+
+	* gdk/win32/gdkevents-win32.c (gdk_event_translate): On
+	WM_WINDOWPOSCHANGING, don't dereference windowpos in the debugging
+	output without setting it first.
+
+2008-10-18  Tor Lillqvist  <tml@novell.com>
+
+	Bug 556578 - GIMP windows stay on top of other windows
+
+	* gdk/win32/gdkevents-win32.c (ensure_stacking_on_unminimize)
+	(ensure_stacking_on_window_pos_changing)
+	(ensure_stacking_on_activate_app): Ignore unmapped windows in the
+	loops where we look for the lowest "transient-type" window.
+
+	(gdk_event_translate): Don't call
+	ensure_stacking_on_window_pos_changing() or
+	ensure_stacking_on_activate_app() for unmapped windows.
+
 2008-10-16  Matthias Clasen  <mclasen@redhat.com>
 
 	* === Released 2.14.4 ====
Only in .: ChangeLog~
diff -pru ../gtk+-2.14.4.orig/gdk/win32/gdkevents-win32.c ./gdk/win32/gdkevents-win32.c
--- ../gtk+-2.14.4.orig/gdk/win32/gdkevents-win32.c	2008-10-17 07:06:36.000000000 +0300
+++ ./gdk/win32/gdkevents-win32.c	2008-11-07 17:25:37.562500000 +0200
@@ -1070,6 +1070,16 @@ print_event (GdkEvent *event)
 	       event->configure.x, event->configure.y,
 	       event->configure.width, event->configure.height);
       break;
+    case GDK_CLIENT_EVENT:
+      g_print ("%s %d %ld %ld %ld %ld %ld",
+	       gdk_atom_name (event->client.message_type),
+	       event->client.data_format,
+	       event->client.data.l[0],
+	       event->client.data.l[1],
+	       event->client.data.l[2],
+	       event->client.data.l[3],
+	       event->client.data.l[4]);
+      break;
     case GDK_SCROLL:
       g_print ("(%.4g,%.4g) (%.4g,%.4g) %s ",
 	       event->scroll.x, event->scroll.y,
@@ -1213,9 +1223,9 @@ fill_key_event_string (GdkEvent *event)
 }
 
 static GdkFilterReturn
-apply_filters (GdkWindow  *window,
-	       MSG        *msg,
-	       GList      *filters)
+apply_event_filters (GdkWindow  *window,
+		     MSG        *msg,
+		     GList      *filters)
 {
   GdkFilterReturn result = GDK_FILTER_CONTINUE;
   GdkEvent *event;
@@ -2116,9 +2126,10 @@ ensure_stacking_on_unminimize (MSG *msg)
 	  GdkWindowImplWin32 *rover_impl =
 	    (GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
 
-	  if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
-	      rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
-	      rover_impl->transient_owner != NULL)
+	  if (GDK_WINDOW_IS_MAPPED (rover_gdkw) &&
+	      (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+	       rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+	       rover_impl->transient_owner != NULL))
 	    {
 	      lowest_transient = rover;
 	    }
@@ -2166,9 +2177,10 @@ ensure_stacking_on_window_pos_changing (
 	      GdkWindowImplWin32 *rover_impl =
 		(GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
 
-	      if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
-		  rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
-		  rover_impl->transient_owner != NULL)
+	      if (GDK_WINDOW_IS_MAPPED (rover_gdkw) &&
+		  (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+		   rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+		   rover_impl->transient_owner != NULL))
 		{
 		  restacking = TRUE;
 		  windowpos->hwndInsertAfter = rover;
@@ -2202,12 +2214,12 @@ ensure_stacking_on_activate_app (MSG    
     }
 
   if (IsWindowVisible (msg->hwnd) &&
-      gdk_win32_handle_table_lookup (GetActiveWindow ()))
+      msg->hwnd == GetActiveWindow ())
     {
-      /* This window is not a transient-type window and this or some
-       * other window in this app is the active window. Make sure this
-       * window is as visible as possible, just below the lowest
-       * transient-type window of this app.
+      /* This window is not a transient-type window and it is the
+       * activated window. Make sure this window is as visible as
+       * possible, just below the lowest transient-type window of this
+       * app.
        */
       HWND rover;
 
@@ -2222,9 +2234,10 @@ ensure_stacking_on_activate_app (MSG    
 	      GdkWindowImplWin32 *rover_impl =
 		(GdkWindowImplWin32 *)((GdkWindowObject *)rover_gdkw)->impl;
 
-	      if (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
-		  rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
-		  rover_impl->transient_owner != NULL)
+	      if (GDK_WINDOW_IS_MAPPED (rover_gdkw) &&
+		  (rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_UTILITY ||
+		   rover_impl->type_hint == GDK_WINDOW_TYPE_HINT_DIALOG ||
+		   rover_impl->transient_owner != NULL))
 		{
 		  GDK_NOTE (EVENTS, g_print (" restacking: %p", rover));
 		  SetWindowPos (msg->hwnd, rover, 0, 0, 0, 0,
@@ -2273,7 +2286,7 @@ gdk_event_translate (MSG  *msg,
     {
       /* Apply global filters */
 
-      GdkFilterReturn result = apply_filters (NULL, msg, _gdk_default_filters);
+      GdkFilterReturn result = apply_event_filters (NULL, msg, _gdk_default_filters);
       
       /* If result is GDK_FILTER_CONTINUE, we continue as if nothing
        * happened. If it is GDK_FILTER_REMOVE or GDK_FILTER_TRANSLATE,
@@ -2332,7 +2345,7 @@ gdk_event_translate (MSG  *msg,
     {
       /* Apply per-window filters */
 
-      GdkFilterReturn result = apply_filters (window, msg, ((GdkWindowObject *) window)->filters);
+      GdkFilterReturn result = apply_event_filters (window, msg, ((GdkWindowObject *) window)->filters);
 
       if (result == GDK_FILTER_REMOVE || result == GDK_FILTER_TRANSLATE)
 	{
@@ -2345,9 +2358,15 @@ gdk_event_translate (MSG  *msg,
     {
       GList *tmp_list;
       GdkFilterReturn result = GDK_FILTER_CONTINUE;
+      GList *node;
 
       GDK_NOTE (EVENTS, g_print (" client_message"));
 
+      event = gdk_event_new (GDK_NOTHING);
+      ((GdkEventPrivate *)event)->flags |= GDK_EVENT_PENDING;
+
+      node = _gdk_event_queue_append (_gdk_display, event);
+
       tmp_list = client_filters;
       while (tmp_list)
 	{
@@ -2357,38 +2376,41 @@ gdk_event_translate (MSG  *msg,
 
 	  if (filter->type == GDK_POINTER_TO_ATOM (msg->wParam))
 	    {
-	      GList *filter_list = g_list_append (NULL, filter);
-	      
 	      GDK_NOTE (EVENTS, g_print (" (match)"));
 
-	      result = apply_filters (window, msg, filter_list);
-
-	      g_list_free (filter_list);
+	      result = (*filter->function) (msg, event, filter->data);
 
 	      if (result != GDK_FILTER_CONTINUE)
 		break;
 	    }
 	}
 
-      if (result == GDK_FILTER_REMOVE || result == GDK_FILTER_TRANSLATE)
+      switch (result)
 	{
+	case GDK_FILTER_REMOVE:
+	  _gdk_event_queue_remove_link (_gdk_display, node);
+	  g_list_free_1 (node);
+	  gdk_event_free (event);
 	  return_val = TRUE;
 	  goto done;
-	}
-      else
-	{
+
+	case GDK_FILTER_TRANSLATE:
+	  ((GdkEventPrivate *)event)->flags &= ~GDK_EVENT_PENDING;
+	  GDK_NOTE (EVENTS, print_event (event));
+	  return_val = TRUE;
+	  goto done;
+
+	case GDK_FILTER_CONTINUE:
 	  /* Send unknown client messages on to Gtk for it to use */
 
-	  event = gdk_event_new (GDK_CLIENT_EVENT);
+	  event->client.type = GDK_CLIENT_EVENT;
 	  event->client.window = window;
 	  event->client.message_type = GDK_POINTER_TO_ATOM (msg->wParam);
 	  event->client.data_format = 32;
 	  event->client.data.l[0] = msg->lParam;
 	  for (i = 1; i < 5; i++)
 	    event->client.data.l[i] = 0;
-	  
-	  append_event (event);
-	  
+	  GDK_NOTE (EVENTS, print_event (event));
 	  return_val = TRUE;
 	  goto done;
 	}
@@ -3164,18 +3186,20 @@ gdk_event_translate (MSG  *msg,
       break;
 
     case WM_WINDOWPOSCHANGING:
-      GDK_NOTE (EVENTS, g_print (" %s %s %dx%d@%+d%+d now below %p",
-				 _gdk_win32_window_pos_bits_to_string (windowpos->flags),
-				 (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
-				  (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
-				   (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
-				    (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
-				     (sprintf (buf, "%p", windowpos->hwndInsertAfter),
-				      buf))))),
-				 windowpos->cx, windowpos->cy, windowpos->x, windowpos->y,
-				 GetNextWindow (msg->hwnd, GW_HWNDPREV)));
+      GDK_NOTE (EVENTS, (windowpos = (WINDOWPOS *) msg->lParam,
+			 g_print (" %s %s %dx%d@%+d%+d now below %p",
+				  _gdk_win32_window_pos_bits_to_string (windowpos->flags),
+				  (windowpos->hwndInsertAfter == HWND_BOTTOM ? "BOTTOM" :
+				   (windowpos->hwndInsertAfter == HWND_NOTOPMOST ? "NOTOPMOST" :
+				    (windowpos->hwndInsertAfter == HWND_TOP ? "TOP" :
+				     (windowpos->hwndInsertAfter == HWND_TOPMOST ? "TOPMOST" :
+				      (sprintf (buf, "%p", windowpos->hwndInsertAfter),
+				       buf))))),
+				  windowpos->cx, windowpos->cy, windowpos->x, windowpos->y,
+				  GetNextWindow (msg->hwnd, GW_HWNDPREV))));
 
-      return_val = ensure_stacking_on_window_pos_changing (msg, window);
+      if (GDK_WINDOW_IS_MAPPED (window))
+	return_val = ensure_stacking_on_window_pos_changing (msg, window);
       break;
 
     case WM_WINDOWPOSCHANGED:
@@ -3655,8 +3679,8 @@ gdk_event_translate (MSG  *msg,
       GDK_NOTE (EVENTS, g_print (" %s thread: %I64d",
 				 msg->wParam ? "YES" : "NO",
 				 (gint64) msg->lParam));
-
-      ensure_stacking_on_activate_app (msg, window);
+      if (msg->wParam && GDK_WINDOW_IS_MAPPED (window))
+	ensure_stacking_on_activate_app (msg, window);
       break;
 
       /* Handle WINTAB events here, as we know that gdkinput.c will
Only in ./gdk/win32: gdkevents-win32.c~
EOF

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I/devel/dist/${ARCH}/${LIBPNG}/include -I/devel/dist/${ARCH}/${ZLIB}/include -I/devel/dist/${ARCH}/${LIBTIFF}/include -I/devel/dist/${ARCH}/${JPEG}/include -I/devel/dist/${ARCH}/${PROXY_LIBINTL}/include" LDFLAGS="-L/devel/dist/${ARCH}/${LIBPNG}/lib -L/devel/dist/${ARCH}/${ZLIB}/lib -L/devel/dist/${ARCH}/${LIBTIFF}/lib -L/devel/dist/${ARCH}/${JPEG}/lib -L/devel/dist/${ARCH}/${PROXY_LIBINTL}/lib -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base" LIBS=-lintl CFLAGS=-O2 ./configure --with-gdktarget=win32 --disable-gdiplus --with-included-loaders --with-included-immodules --without-libjasper --enable-debug=yes --enable-explicit-deps=no --disable-gtk-doc --disable-static --prefix=$TARGET &&
libtoolcacheize &&
rm gtk/gtk.def &&
(PATH="/devel/target/$HEX/bin:$PATH" make -j3 install || (rm .libtool-cache* && PATH="/devel/target/$HEX/bin:$PATH" make -j3 install)) &&

grep -v -E 'Automatically generated|Created by|LoaderDir =' <$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders >$TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp &&
    mv $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders.temp $TARGET/etc/gtk-2.0/gdk-pixbuf.loaders &&
grep -v -E 'Automatically generated|Created by|ModulesPath =' <$TARGET/etc/gtk-2.0/gtk.immodules >$TARGET/etc/gtk-2.0/gtk.immodules.temp &&
    mv $TARGET/etc/gtk-2.0/gtk.immodules.temp $TARGET/etc/gtk-2.0/gtk.immodules &&

./gtk-zip.sh &&

mv /tmp/${MOD}-${VER}.zip /tmp/$RUNZIP &&
mv /tmp/${MOD}-dev-${VER}.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
