/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class Network {
    private Netlist netlist;
    private int netIndex;
    private ArrayList exportedNames = new ArrayList();
    private ArrayList unexportedNames = new ArrayList();

    public Network(Netlist netlist, int netIndex) {
        this.netlist = netlist;
        this.netIndex = netIndex;
    }

    public void addName(String nm, boolean exported) {
        if (nm != null) {
            if (exported) {
                this.exportedNames.add(nm);
                if (this.unexportedNames.contains(nm)) {
                    this.unexportedNames.remove(nm);
                }
            } else if (!this.exportedNames.contains(nm)) {
                this.unexportedNames.add(nm);
            }
        }
    }

    public Netlist getNetlist() {
        return this.netlist;
    }

    public Cell getParent() {
        return this.netlist.netCell.cell;
    }

    public int getNetIndex() {
        return this.netIndex;
    }

    public Iterator getNames() {
        NameComparator nc = new NameComparator();
        Collections.sort(this.exportedNames, nc);
        Collections.sort(this.unexportedNames, nc);
        ArrayList allNames = new ArrayList(this.exportedNames);
        allNames.addAll(this.unexportedNames);
        return allNames.iterator();
    }

    public Iterator getExportedNames() {
        Collections.sort(this.exportedNames, new NameComparator());
        return this.exportedNames.iterator();
    }

    public boolean hasNames() {
        return this.exportedNames.size() > 0 || this.unexportedNames.size() > 0;
    }

    public boolean hasName(String nm) {
        return this.exportedNames.contains(nm) || this.unexportedNames.contains(nm);
    }

    public Iterator getPorts() {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator it = this.getParent().getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pit = ni.getPortInsts();
            while (pit.hasNext()) {
                PortInst pi = (PortInst)pit.next();
                if (this.netlist.getNetwork(pi) != this) continue;
                ports.add(pi);
            }
        }
        return ports.iterator();
    }

    public Iterator getExports() {
        ArrayList<Export> exports = new ArrayList<Export>();
        Iterator it = this.getParent().getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            int busWidth = this.netlist.getBusWidth(e);
            for (int i = 0; i < busWidth; ++i) {
                if (this.netlist.getNetwork(e, i) != this) continue;
                exports.add(e);
            }
        }
        return exports.iterator();
    }

    public Iterator getArcs() {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator it = this.getParent().getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (this.netlist.getNetwork(ai, 0) != this) continue;
            arcs.add(ai);
        }
        return arcs.iterator();
    }

    public boolean isExported() {
        return this.exportedNames.size() > 0;
    }

    public String describe(boolean withQuotes) {
        if (this.hasNames()) {
            Iterator it = this.getNames();
            String name = (String)it.next();
            while (it.hasNext()) {
                name = name + "/" + (String)it.next();
            }
            if (withQuotes) {
                name = "'" + name + "'";
            }
            return name;
        }
        Iterator it = this.getParent().getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (this.netlist.getNetwork(ai, 0) != this) continue;
            return withQuotes ? "'" + ai.getName() + "'" : ai.getName();
        }
        return "";
    }

    public String toString() {
        return "network " + this.describe(true);
    }

    private static class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return TextUtils.nameSameNumeric(s1, s2);
        }
    }
}

