/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.Main;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class Job
implements ActionListener,
Runnable {
    private static final boolean DEBUG = false;
    private static final int MIN_NUM_SECONDS = 60000;
    public static final DatabaseChangesThread databaseChangesThread;
    private static Job changingJob;
    private DefaultMutableTreeNode myNode;
    private boolean deleteWhenDone;
    private boolean display;
    protected long startTime;
    protected long endTime;
    private boolean started;
    private boolean finished;
    private boolean aborted;
    private boolean scheduledToAbort;
    private boolean reportExecution = false;
    private String jobName;
    private Tool tool;
    private Type jobType;
    private Cell upCell;
    private String progress = null;
    private List savedHighlights;
    private Point2D savedHighlightsOffset;
    private Thread thread;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Job(String jobName, Tool tool, Type jobType, Cell upCell, Cell downCell, Priority priority) {
        if (downCell != null) {
            upCell = null;
        }
        this.jobName = jobName;
        this.tool = tool;
        this.jobType = jobType;
        this.upCell = upCell;
        this.display = true;
        this.deleteWhenDone = true;
        this.endTime = 0L;
        this.startTime = 0L;
        this.scheduledToAbort = false;
        this.aborted = false;
        this.finished = false;
        this.started = false;
        this.myNode = null;
        this.thread = null;
        this.savedHighlights = new ArrayList();
        if (jobType == Type.CHANGE || jobType == Type.UNDO) {
            this.saveHighlights();
        }
    }

    public void startJob() {
        this.startJob(true, true);
    }

    public void startJob(boolean display, boolean deleteWhenDone) {
        this.display = display;
        this.deleteWhenDone = deleteWhenDone;
        if (display) {
            this.myNode = new DefaultMutableTreeNode(this);
        }
        if (Main.NOTHREADING) {
            TopLevel.setBusyCursor(true);
            this.run();
            TopLevel.setBusyCursor(false);
        } else {
            Job.databaseChangesThread.addJob(this);
        }
    }

    public abstract boolean doIt();

    protected void setReportExecutionFlag(boolean flag) {
        this.reportExecution = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.startTime = System.currentTimeMillis();
        ActivityLogger.logJobStarted(this.jobName, this.jobType, this.upCell, this.savedHighlights, this.savedHighlightsOffset);
        try {
            if (this.jobType != Type.EXAMINE) {
                changingJob = this;
            }
            if (this.jobType == Type.CHANGE) {
                Undo.startChanges(this.tool, this.jobName, this.upCell, this.savedHighlights, this.savedHighlightsOffset);
            }
            this.doIt();
            if (this.jobType == Type.CHANGE) {
                Undo.endChanges();
            }
        }
        catch (Throwable e) {
            this.endTime = System.currentTimeMillis();
            e.printStackTrace(System.err);
            ActivityLogger.logException(e);
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
        finally {
            if (this.jobType == Type.EXAMINE) {
                Job.databaseChangesThread.endExamine(this);
            } else {
                changingJob = null;
            }
            this.endTime = System.currentTimeMillis();
        }
        this.finished = true;
        if (this.reportExecution || this.endTime - this.startTime >= 60000L) {
            if (User.isBeepAfterLongJobs()) {
                Toolkit.getDefaultToolkit().beep();
            }
            System.out.println(this.getInfo());
        }
        if (this.deleteWhenDone) {
            Job.databaseChangesThread.removeJob(this);
        }
    }

    protected void flushBatch() {
        if (this.jobType != Type.CHANGE) {
            return;
        }
        Undo.endChanges();
        Undo.startChanges(this.tool, this.jobName, this.upCell, this.savedHighlights, this.savedHighlightsOffset);
    }

    protected synchronized void setProgress(String progress) {
        this.progress = progress;
        WindowFrame.wantToRedoJobTree();
    }

    private synchronized String getProgress() {
        return this.progress;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void abort() {
        if (this.aborted) {
            System.out.println("Job already aborted: " + this.getStatus());
            return;
        }
        this.scheduledToAbort = true;
        WindowFrame.wantToRedoJobTree();
    }

    private void saveHighlights() {
        this.savedHighlights.clear();
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Iterator it = highlighter.getHighlights().iterator();
        while (it.hasNext()) {
            this.savedHighlights.add(it.next());
        }
        this.savedHighlightsOffset = highlighter.getHighlightOffset();
    }

    protected synchronized void setAborted() {
        this.aborted = true;
        WindowFrame.wantToRedoJobTree();
    }

    protected synchronized boolean getScheduledToAbort() {
        return this.scheduledToAbort;
    }

    public synchronized boolean getAborted() {
        return this.aborted;
    }

    public boolean getDisplay() {
        return this.display;
    }

    public boolean getDeleteWhenDone() {
        return this.deleteWhenDone;
    }

    public boolean checkAbort() {
        if (this.getAborted()) {
            return true;
        }
        boolean scheduledAbort = this.getScheduledToAbort();
        if (scheduledAbort) {
            System.out.println(this + ": aborted");
            this.setReportExecutionFlag(true);
            this.setAborted();
        }
        return scheduledAbort;
    }

    public static Iterator getAllJobs() {
        return databaseChangesThread.getAllJobs();
    }

    public String getStatus() {
        if (!this.started) {
            return "waiting";
        }
        if (this.aborted) {
            return "aborted";
        }
        if (this.finished) {
            return "done";
        }
        if (this.scheduledToAbort) {
            return "scheduled to abort";
        }
        if (this.getProgress() == null) {
            return "running";
        }
        return this.getProgress();
    }

    public void remove() {
        if (!this.finished && !this.aborted) {
            return;
        }
        Job.databaseChangesThread.removeJob(this);
    }

    public static synchronized boolean acquireExamineLock(boolean block) {
        return true;
    }

    public static synchronized void releaseExamineLock() {
    }

    public static synchronized boolean hasExamineLock() {
        Thread thread = Thread.currentThread();
        if (thread == databaseChangesThread) {
            return true;
        }
        Job job = Job.databaseChangesThread.getJob(thread);
        return job != null;
    }

    public static void invokeExamineLater(Runnable task, Object singularKey) {
        SwingExamineJob priorJob;
        if (singularKey != null && (priorJob = SwingExamineJob.getWaitingJobFor(singularKey)) != null) {
            priorJob.abort();
        }
        SwingExamineJob job = new SwingExamineJob(task, singularKey);
        job.startJob(false, true);
    }

    public static void checkExamine() {
        if (!Main.getDebug()) {
            return;
        }
        if (Main.NOTHREADING) {
            return;
        }
    }

    public static Thread getChangingThread() {
        return changingJob != null ? databaseChangesThread : null;
    }

    public static Job getChangingJob() {
        return changingJob;
    }

    public static Cell getChangingCell() {
        return changingJob != null ? Job.changingJob.upCell : null;
    }

    public static void checkChanging() {
        if (Thread.currentThread() != databaseChangesThread) {
            if (Main.NOTHREADING) {
                return;
            }
            String msg = "Database is being changed by another thread";
            System.out.println(msg);
            throw new IllegalStateException(msg);
        }
        if (changingJob == null) {
            if (Main.NOTHREADING) {
                return;
            }
            String msg = "Database is changing but no change job is running";
            System.out.println(msg);
            throw new IllegalStateException(msg);
        }
    }

    public static void checkSwingThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Exception e = new Exception("Job.checkSwingThread is not in the AWT Event Thread, it is in Thread " + Thread.currentThread());
            ActivityLogger.logException(e);
        }
    }

    public String toString() {
        return this.jobName + " (" + this.getStatus() + ")";
    }

    public static DefaultMutableTreeNode getExplorerTree() {
        return databaseChangesThread.getExplorerTree();
    }

    public JPopupMenu getPopupStatus() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem m = new JMenuItem("Get Info");
        m.addActionListener(this);
        popup.add(m);
        m = new JMenuItem("Abort");
        m.addActionListener(this);
        popup.add(m);
        m = new JMenuItem("Delete");
        m.addActionListener(this);
        popup.add(m);
        return popup;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals("Get Info")) {
            System.out.println(this.getInfo());
        }
        if (source.getText().equals("Abort")) {
            this.abort();
        }
        if (source.getText().equals("Delete")) {
            if (!this.finished && !this.aborted) {
                System.out.println("Cannot delete running jobs.  Wait till it is finished, or abort it");
                return;
            }
            Job.databaseChangesThread.removeJob(this);
        }
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Job " + this.toString());
        Date start = new Date(this.startTime);
        if (this.finished) {
            long time = this.endTime - this.startTime;
            buf.append(" took: " + TextUtils.getElapsedTime(time));
            buf.append(" (started at " + start + ")");
        } else if (this.getProgress() == null) {
            long time = System.currentTimeMillis() - this.startTime;
            buf.append(" has not finished. Current running time: " + TextUtils.getElapsedTime(time));
        } else {
            buf.append(" did not successfully finish.");
        }
        return buf.toString();
    }

    static {
        $assertionsDisabled = !Job.class.desiredAssertionStatus();
        databaseChangesThread = new DatabaseChangesThread();
    }

    private static class SwingExamineJob
    extends Job {
        private static final Map waitingJobs = new HashMap();
        private Runnable task;
        private Object singularKey;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SwingExamineJob(Runnable task, Object singularKey) {
            super("ReserveExamineSlot", User.getUserTool(), Type.EXAMINE, null, null, Priority.USER);
            this.task = task;
            this.singularKey = singularKey;
            Map map = waitingJobs;
            synchronized (map) {
                if (singularKey != null) {
                    waitingJobs.put(singularKey, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doIt() {
            Map map = waitingJobs;
            synchronized (map) {
                if (this.singularKey != null) {
                    waitingJobs.remove(this.singularKey);
                }
            }
            try {
                SwingUtilities.invokeAndWait(this.task);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SwingExamineJob getWaitingJobFor(Object singularKey) {
            if (singularKey == null) {
                return null;
            }
            Map map = waitingJobs;
            synchronized (map) {
                return (SwingExamineJob)waitingJobs.get(singularKey);
            }
        }
    }

    private static class InthreadExamineJob
    extends Job {
        private boolean waiting = false;
        private int lockCount = 0;
        protected final Object mutex = new Object();
        static final /* synthetic */ boolean $assertionsDisabled;

        private InthreadExamineJob() {
            super("Inthread Examine", User.getUserTool(), Type.EXAMINE, null, null, Priority.USER);
        }

        public boolean doIt() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return true;
        }

        private void incrementLockCount() {
            ++this.lockCount;
        }

        private void decrementLockCount() {
            --this.lockCount;
        }

        private int getLockCount() {
            return this.lockCount;
        }

        static /* synthetic */ void access$1600(InthreadExamineJob x0) {
            x0.decrementLockCount();
        }

        static /* synthetic */ int access$1700(InthreadExamineJob x0) {
            return x0.getLockCount();
        }

        static {
            $assertionsDisabled = !(class$com$sun$electric$tool$Job == null ? (class$com$sun$electric$tool$Job = Job.class$("com.sun.electric.tool.Job")) : class$com$sun$electric$tool$Job).desiredAssertionStatus();
        }
    }

    private static class DatabaseChangesThread
    extends Thread {
        private static ArrayList allJobs;
        private static int numStarted;
        private static int numExamine;
        private static String jobNode;
        static final /* synthetic */ boolean $assertionsDisabled;

        DatabaseChangesThread() {
            super("Database");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Job job = this.waitChangeJob();
                job.run();
                DatabaseChangesThread databaseChangesThread = this;
                synchronized (databaseChangesThread) {
                    if (!this.isChangeJobQueuedOrRunning()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                TopLevel.setBusyCursor(false);
                            }
                        });
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Job waitChangeJob() {
            while (true) {
                if (numStarted < allJobs.size()) {
                    Job job = (Job)allJobs.get(numStarted);
                    if (job.scheduledToAbort || job.aborted) {
                        this.removeJob(job);
                        continue;
                    }
                    if (job.jobType == Type.EXAMINE) {
                        job.started = true;
                        if (job instanceof InthreadExamineJob) {
                            InthreadExamineJob ijob = (InthreadExamineJob)job;
                            boolean started = false;
                            Object object = ijob.mutex;
                            synchronized (object) {
                                if (ijob.waiting) {
                                    ijob.waiting = false;
                                    ijob.mutex.notify();
                                    started = true;
                                }
                            }
                            if (!started) continue;
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            ++numStarted;
                            ++numExamine;
                            continue;
                        }
                        ++numStarted;
                        ++numExamine;
                        Thread t = new Thread((Runnable)job, job.jobName);
                        job.thread = t;
                        t.start();
                        continue;
                    }
                    if (numExamine == 0) {
                        job.started = true;
                        ++numStarted;
                        return job;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private synchronized void addJob(Job j) {
            if (numStarted == allJobs.size()) {
                this.notify();
            }
            allJobs.add(j);
            if (j.jobType == Type.CHANGE) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TopLevel.setBusyCursor(true);
                    }
                });
            }
            if (j.getDisplay()) {
                WindowFrame.wantToRedoJobTree();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addInthreadExamineJob(InthreadExamineJob j, boolean wait) {
            Object object = this;
            synchronized (object) {
                if (this.isChangeJobQueuedOrRunning()) {
                    if (!wait) {
                        return false;
                    }
                    this.addJob(j);
                    Object object2 = j.mutex;
                    synchronized (object2) {
                        j.waiting = true;
                    }
                } else {
                    allJobs.add(j);
                    ++numExamine;
                    ++numStarted;
                    j.incrementLockCount();
                    return true;
                }
            }
            object = j.mutex;
            synchronized (object) {
                if (j.waiting) {
                    try {
                        j.mutex.wait();
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted in databaseChangesThread");
                    }
                }
            }
            j.incrementLockCount();
            return true;
        }

        private synchronized void removeJob(Job j) {
            int index = allJobs.indexOf(j);
            if (index != -1) {
                allJobs.remove(index);
                if (index == numStarted) {
                    this.notify();
                }
                if (index < numStarted) {
                    --numStarted;
                }
            }
            if (j.getDisplay()) {
                WindowFrame.wantToRedoJobTree();
            }
        }

        public synchronized DefaultMutableTreeNode getExplorerTree() {
            DefaultMutableTreeNode explorerTree = new DefaultMutableTreeNode(jobNode);
            Iterator it = allJobs.iterator();
            while (it.hasNext()) {
                Job j = (Job)it.next();
                if (!j.getDisplay()) continue;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(j);
                j.myNode.setUserObject(null);
                j.myNode = node;
                explorerTree.add(node);
            }
            return explorerTree;
        }

        private synchronized void endExamine(Job j) {
            if (--numExamine == 0) {
                this.notify();
            }
        }

        private synchronized Job getJob(Thread t) {
            Iterator it = allJobs.iterator();
            while (it.hasNext()) {
                Job j = (Job)it.next();
                if (j.thread != t) continue;
                return j;
            }
            return null;
        }

        public synchronized Iterator getAllJobs() {
            ArrayList jobsList = new ArrayList();
            Iterator it = allJobs.iterator();
            while (it.hasNext()) {
                jobsList.add(it.next());
            }
            return jobsList.iterator();
        }

        private synchronized boolean isChangeJobQueuedOrRunning() {
            Iterator it = allJobs.iterator();
            while (it.hasNext()) {
                Job j = (Job)it.next();
                if (j.finished || j.jobType != Type.CHANGE) continue;
                return true;
            }
            return false;
        }

        static /* synthetic */ boolean access$1500(DatabaseChangesThread x0, InthreadExamineJob x1, boolean x2) {
            return x0.addInthreadExamineJob(x1, x2);
        }

        static {
            $assertionsDisabled = !(class$com$sun$electric$tool$Job == null ? (class$com$sun$electric$tool$Job = Job.class$("com.sun.electric.tool.Job")) : class$com$sun$electric$tool$Job).desiredAssertionStatus();
            allJobs = new ArrayList();
            numStarted = 0;
            numExamine = 0;
            jobNode = "JOBS";
        }
    }

    public static class Priority {
        private final String name;
        private final int level;
        public static final Priority USER = new Priority("user", 1);
        public static final Priority VISCHANGES = new Priority("visible-changes", 2);
        public static final Priority INVISCHANGES = new Priority("invisble-changes", 3);
        public static final Priority ANALYSIS = new Priority("analysis", 4);

        private Priority(String name, int level) {
            this.name = name;
            this.level = level;
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static class Type {
        private final String name;
        public static final Type CHANGE = new Type("change");
        public static final Type UNDO = new Type("undo");
        public static final Type EXAMINE = new Type("examine");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

