/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Project
extends Listener {
    public static final int NOTMANAGED = 0;
    public static final int CHECKEDIN = 1;
    public static final int CHECKEDOUTTOYOU = 2;
    public static final int CHECKEDOUTTOOTHERS = 3;
    public static final int OLDVERSION = 4;
    private static final Variable.Key PROJLOCKEDKEY = ElectricObject.newKey("PROJ_locked");
    private static final Variable.Key PROJPATHKEY = ElectricObject.newKey("PROJ_path");
    private static final Variable.Key PROJLIBRARYKEY = ElectricObject.newKey("PROJ_library");
    private static final String PUSERFILE = "projectusers";
    private static final String PROJECTFILE = "project.proj";
    private static Project tool = new Project();
    private static HashMap usersMap;
    private static HashMap libraryProjectInfo;
    private static boolean pmActive;
    private static boolean ignoreChanges;
    private static List fCheckList;
    private static final int ROTORSZ = 256;
    private static final int MASK = 255;
    private static Pref cacheCurrentUserName;
    private static Pref cacheRepositoryLocation;
    private static Pref cacheAuthorizationPassword;

    private Project() {
        super("project");
    }

    public void init() {
        this.setOn();
        pmActive = false;
        ignoreChanges = false;
    }

    public static Project getProjectTool() {
        return tool;
    }

    public static boolean isLibraryManaged(Library lib) {
        ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
        return pl.allCells.size() != 0;
    }

    public static int getCellStatus(Cell cell) {
        Cell newestVersion = cell.getNewestVersion();
        ProjectCell pc = ProjectCell.findProjectCell(newestVersion);
        if (pc == null) {
            return 0;
        }
        if (newestVersion != cell) {
            return 4;
        }
        if (pc.owner.length() == 0) {
            return 1;
        }
        if (pc.owner.equals(Project.getCurrentUserName())) {
            return 2;
        }
        return 3;
    }

    public static String getCellOwner(Cell cell) {
        ProjectCell pc = ProjectCell.findProjectCell(cell);
        if (pc == null) {
            return "";
        }
        return pc.owner;
    }

    public static void updateProject() {
        new UpdateJob();
        pmActive = true;
    }

    public static void checkInThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Project.checkIn(cell);
    }

    public static void checkIn(Cell cell) {
        pmActive = true;
        HashMap cellsMarked = Project.markRelatedCells(cell);
        new CheckInJob(cell.getLibrary(), cellsMarked);
    }

    public static void checkOutThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Project.checkOut(cell);
    }

    public static void checkOut(Cell oldVers) {
        pmActive = true;
        new CheckOutJob(oldVers);
    }

    public static void cancelCheckOutThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Project.cancelCheckOut(cell);
    }

    public static void cancelCheckOut(Cell oldVers) {
        pmActive = true;
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Cancel all changes to the checked-out " + oldVers + " and revert to the checked-in version?");
        if (response != 0) {
            return;
        }
        new CancelCheckOutJob(oldVers);
    }

    public static void addThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Project.addCell(cell);
    }

    public static void addCell(Cell cell) {
        pmActive = true;
        new AddCellJob(cell);
    }

    public static void removeThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Project.removeCell(cell);
    }

    public static void removeCell(Cell cell) {
        pmActive = true;
        new DeleteCellJob(cell);
    }

    public static void examineThisHistory() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Project.examineHistory(cell);
    }

    public static void examineHistory(Cell oldVers) {
        pmActive = true;
        new ShowHistory(oldVers);
    }

    public static void getALibrary() {
        pmActive = true;
        new ShowLibsInRepository();
    }

    public static void addThisLibrary() {
        Project.addALibrary(Library.getCurrent());
    }

    public static void addALibrary(Library lib) {
        new AddLibraryJob(lib);
        pmActive = true;
    }

    public static int getNumUsers() {
        Project.ensureUserList();
        return usersMap.size();
    }

    public static Iterator getUsers() {
        Project.ensureUserList();
        return usersMap.keySet().iterator();
    }

    public static boolean isExistingUser(String user) {
        Project.ensureUserList();
        return usersMap.get(user) != null;
    }

    public static void deleteUser(String user) {
        usersMap.remove(user);
        Project.saveUserList();
    }

    public static void addUser(String user, String encryptedPassword) {
        usersMap.put(user, encryptedPassword);
        Project.saveUserList();
    }

    public static String getEncryptedPassword(String user) {
        return (String)usersMap.get(user);
    }

    public static void changeEncryptedPassword(String user, String newEncryptedPassword) {
        usersMap.put(user, newEncryptedPassword);
        Project.saveUserList();
    }

    public void startBatch(Tool tool, boolean undoRedo) {
    }

    public void endBatch() {
        Project.detectIllegalChanges();
        ignoreChanges = false;
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        if (ignoreChanges) {
            return;
        }
        Project.queueCheck(ni.getParent());
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        if (ignoreChanges) {
            return;
        }
        for (int i = 0; i < nis.length; ++i) {
            Project.queueCheck(nis[i].getParent());
        }
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        if (ignoreChanges) {
            return;
        }
        Project.queueCheck(ai.getParent());
    }

    public void modifyExport(Export pp, PortInst oldPi) {
        if (ignoreChanges) {
            return;
        }
        Project.queueCheck((Cell)pp.getParent());
    }

    public void modifyCell(Cell cell, double oLX, double oHX, double oLY, double oHY) {
        if (ignoreChanges) {
            return;
        }
        Project.queueCheck(cell);
    }

    public void modifyCellGroup(Cell cell, Cell.CellGroup oCellGroup) {
        if (ignoreChanges) {
            return;
        }
        Project.queueCheck(cell);
    }

    public void modifyTextDescript(ElectricObject obj, String varName, ImmutableTextDescriptor oldDescriptor) {
        this.checkObject(obj);
    }

    public void newObject(ElectricObject obj) {
        this.checkObject(obj);
    }

    public void killObject(ElectricObject obj) {
        this.checkObject(obj);
    }

    public void killExport(Export pp, Collection oldPortInsts) {
        if (ignoreChanges) {
            return;
        }
        Project.queueCheck((Cell)pp.getParent());
    }

    public void renameObject(ElectricObject obj, Object oldName) {
        this.checkObject(obj);
    }

    public void newVariable(ElectricObject obj, Variable var) {
        this.checkVariable(obj, var);
    }

    public void killVariable(ElectricObject obj, Variable var) {
        this.checkVariable(obj, var);
    }

    public void modifyVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        this.checkVariable(obj, var);
    }

    public void insertVariable(ElectricObject obj, Variable var, int index) {
        this.checkVariable(obj, var);
    }

    public void deleteVariable(ElectricObject obj, Variable var, int index, Object oldValue) {
        this.checkVariable(obj, var);
    }

    public void readLibrary(Library lib) {
        if (ignoreChanges) {
            return;
        }
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (cell.getVar(PROJLOCKEDKEY) == null) continue;
            pmActive = true;
            ProjectLibrary pl = (ProjectLibrary)libraryProjectInfo.get(lib);
            if (pl != null) continue;
            pl = ProjectLibrary.createProject(lib);
            libraryProjectInfo.put(lib, pl);
        }
    }

    public void eraseLibrary(Library lib) {
    }

    public void writeLibrary(Library lib) {
    }

    private static void detectIllegalChanges() {
        if (!pmActive) {
            return;
        }
        if (fCheckList.size() == 0) {
            return;
        }
        int undoneCells = 0;
        int lowBatch = Integer.MAX_VALUE;
        String errorMsg = "";
        Iterator it = fCheckList.iterator();
        while (it.hasNext()) {
            FCheck f = (FCheck)it.next();
            Cell cell = f.entry;
            if (cell == null || cell.getVar(PROJLOCKEDKEY) == null) continue;
            if (undoneCells != 0) {
                errorMsg = errorMsg + ", ";
            }
            errorMsg = errorMsg + cell.describe(true);
            ++undoneCells;
            if (f.batchNumber >= lowBatch) continue;
            lowBatch = f.batchNumber;
        }
        fCheckList.clear();
        if (undoneCells > 0) {
            new UndoBatchesJob(lowBatch, errorMsg);
        }
    }

    private void checkObject(ElectricObject obj) {
        if (ignoreChanges) {
            return;
        }
        if (obj instanceof NodeInst) {
            Project.queueCheck(((NodeInst)obj).getParent());
            return;
        }
        if (obj instanceof ArcInst) {
            Project.queueCheck(((ArcInst)obj).getParent());
            return;
        }
        if (obj instanceof Export) {
            Project.queueCheck((Cell)((Export)obj).getParent());
            return;
        }
        if (obj instanceof Cell) {
            Project.queueCheck((Cell)obj);
            return;
        }
    }

    private void checkVariable(ElectricObject obj, Variable var) {
        if (ignoreChanges) {
            return;
        }
        if (obj instanceof NodeInst) {
            Project.queueCheck(((NodeInst)obj).getParent());
            return;
        }
        if (obj instanceof ArcInst) {
            Project.queueCheck(((ArcInst)obj).getParent());
            return;
        }
        if (obj instanceof Export) {
            Project.queueCheck((Cell)((Export)obj).getParent());
            return;
        }
        if (obj instanceof Cell && var.getKey() != PROJLOCKEDKEY) {
            Project.queueCheck((Cell)obj);
        }
    }

    private static void queueCheck(Cell cell) {
        Undo.ChangeBatch batch = Undo.getCurrentBatch();
        if (batch == null) {
            return;
        }
        int batchNumber = batch.getBatchNumber();
        Iterator it = fCheckList.iterator();
        while (it.hasNext()) {
            FCheck f = (FCheck)it.next();
            if (f.entry != cell || f.batchNumber != batchNumber) continue;
            return;
        }
        FCheck f = new FCheck();
        f.entry = cell;
        f.batchNumber = batchNumber;
        fCheckList.add(f);
    }

    private static void setChangeStatus(boolean quiet) {
        if (quiet) {
            ignoreChanges = quiet;
        }
    }

    private static void ensureUserList() {
        if (usersMap == null) {
            usersMap = new HashMap();
            String userFile = Project.getRepositoryLocation() + File.separator + PUSERFILE;
            URL url = TextUtils.makeURLToFile(userFile);
            try {
                String userLine;
                URLConnection urlCon = url.openConnection();
                InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
                LineNumberReader lnr = new LineNumberReader(is);
                while ((userLine = lnr.readLine()) != null) {
                    int colonPos = userLine.indexOf(58);
                    if (colonPos < 0) {
                        System.out.println("Missing ':' in user file: " + userLine);
                        break;
                    }
                    String userName = userLine.substring(0, colonPos);
                    String encryptedPassword = userLine.substring(colonPos + 1);
                    usersMap.put(userName, encryptedPassword);
                }
                lnr.close();
            }
            catch (IOException e) {
                System.out.println("Creating new user database");
            }
        }
    }

    private static void saveUserList() {
        String userFile = Project.getRepositoryLocation() + File.separator + PUSERFILE;
        URL url = TextUtils.makeURLToFile(userFile);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(userFile)));
            Iterator it = usersMap.keySet().iterator();
            while (it.hasNext()) {
                String userName = (String)it.next();
                String encryptedPassword = (String)usersMap.get(userName);
                printWriter.println(userName + ":" + encryptedPassword);
            }
            printWriter.close();
            System.out.println("Wrote " + userFile);
        }
        catch (IOException e) {
            System.out.println("Error writing " + userFile);
            return;
        }
    }

    private static void validateLocks(Library lib) {
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            ProjectCell pc = ProjectCell.findProjectCell(cell);
            if (pc == null) {
                Project.markLocked(cell, false);
                continue;
            }
            if (cell.getVersion() < pc.cellVersion) {
                Project.markLocked(cell, false);
                continue;
            }
            if (pc.owner.equals(Project.getCurrentUserName())) {
                Project.markLocked(cell, false);
                continue;
            }
            Project.markLocked(cell, true);
        }
    }

    private static void markLocked(Cell cell, boolean locked) {
        if (!locked) {
            Iterator it = cell.getCellGroup().getCells();
            while (it.hasNext()) {
                Cell oCell = (Cell)it.next();
                if (oCell.getView() != cell.getView() || oCell.getVar(PROJLOCKEDKEY) == null) continue;
                oCell.delVar(PROJLOCKEDKEY);
            }
        } else {
            Iterator it = cell.getCellGroup().getCells();
            while (it.hasNext()) {
                Cell oCell = (Cell)it.next();
                if (oCell.getView() != cell.getView()) continue;
                if (oCell.getNewestVersion() == oCell) {
                    if (oCell.getVar(PROJLOCKEDKEY) != null) continue;
                    oCell.newVar(PROJLOCKEDKEY, (Object)new Integer(1));
                    continue;
                }
                if (oCell.getVar(PROJLOCKEDKEY) == null) continue;
                oCell.delVar(PROJLOCKEDKEY);
            }
        }
    }

    private static HashMap markRelatedCells(Cell cell) {
        String owner;
        Cell oCell;
        Iterator cIt;
        Library oLib;
        HashMap<Cell, GenMath.MutableInteger> cellsMarked1 = new HashMap<Cell, GenMath.MutableInteger>();
        HashMap<Cell, GenMath.MutableInteger> cellsMarked2 = new HashMap<Cell, GenMath.MutableInteger>();
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library oLib2 = (Library)it.next();
            Iterator cIt2 = oLib2.getCells();
            while (cIt2.hasNext()) {
                Cell oCell2 = (Cell)cIt2.next();
                cellsMarked1.put(oCell2, new GenMath.MutableInteger(0));
                cellsMarked2.put(oCell2, new GenMath.MutableInteger(0));
            }
        }
        GenMath.MutableInteger mi = (GenMath.MutableInteger)cellsMarked1.get(cell);
        mi.setValue(1);
        mi = (GenMath.MutableInteger)cellsMarked2.get(cell);
        mi.setValue(1);
        boolean propagated = true;
        while (propagated) {
            propagated = false;
            Iterator it2 = Library.getLibraries();
            while (it2.hasNext()) {
                Library oLib3 = (Library)it2.next();
                Iterator cIt3 = oLib3.getCells();
                while (cIt3.hasNext()) {
                    Cell oCell3 = (Cell)cIt3.next();
                    mi = (GenMath.MutableInteger)cellsMarked2.get(oCell3);
                    if (mi.intValue() != 1) continue;
                    propagated = true;
                    mi.setValue(2);
                    Iterator nIt = oCell3.getInstancesOf();
                    while (nIt.hasNext()) {
                        NodeInst ni = (NodeInst)nIt.next();
                        mi = (GenMath.MutableInteger)cellsMarked2.get(ni.getParent());
                        if (mi.intValue() != 0) continue;
                        mi.setValue(1);
                    }
                }
            }
        }
        mi = (GenMath.MutableInteger)cellsMarked2.get(cell);
        mi.setValue(0);
        int total = 0;
        Iterator it3 = Library.getLibraries();
        while (it3.hasNext()) {
            oLib = (Library)it3.next();
            cIt = oLib.getCells();
            while (cIt.hasNext()) {
                oCell = (Cell)cIt.next();
                mi = (GenMath.MutableInteger)cellsMarked2.get(oCell);
                if (mi.intValue() == 0 || (owner = Project.getCellOwner(oCell)).length() == 0 || !owner.equals(Project.getCurrentUserName())) continue;
                mi = (GenMath.MutableInteger)cellsMarked1.get(oCell);
                mi.setValue(1);
                ++total;
            }
        }
        it3 = Library.getLibraries();
        while (it3.hasNext()) {
            oLib = (Library)it3.next();
            cIt = oLib.getCells();
            while (cIt.hasNext()) {
                oCell = (Cell)cIt.next();
                mi = (GenMath.MutableInteger)cellsMarked2.get(oCell);
                mi.setValue(0);
            }
        }
        mi = (GenMath.MutableInteger)cellsMarked2.get(cell);
        mi.setValue(1);
        propagated = true;
        while (propagated) {
            propagated = false;
            it3 = Library.getLibraries();
            while (it3.hasNext()) {
                oLib = (Library)it3.next();
                cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    oCell = (Cell)cIt.next();
                    mi = (GenMath.MutableInteger)cellsMarked2.get(oCell);
                    if (mi.intValue() != 1) continue;
                    propagated = true;
                    mi.setValue(2);
                    Iterator nIt = oCell.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell) || (mi = (GenMath.MutableInteger)cellsMarked2.get(ni.getProto())).intValue() != 0) continue;
                        mi.setValue(1);
                    }
                }
            }
        }
        mi = (GenMath.MutableInteger)cellsMarked2.get(cell);
        mi.setValue(0);
        it3 = Library.getLibraries();
        while (it3.hasNext()) {
            oLib = (Library)it3.next();
            cIt = oLib.getCells();
            while (cIt.hasNext()) {
                oCell = (Cell)cIt.next();
                mi = (GenMath.MutableInteger)cellsMarked2.get(oCell);
                if (mi.intValue() == 0 || (owner = Project.getCellOwner(oCell)).length() == 0 || !owner.equals(Project.getCurrentUserName())) continue;
                mi = (GenMath.MutableInteger)cellsMarked1.get(oCell);
                mi.setValue(1);
                ++total;
            }
        }
        if (total > 0) {
            total = 0;
            StringBuffer infstr = new StringBuffer();
            Iterator it4 = Library.getLibraries();
            while (it4.hasNext()) {
                Library oLib4 = (Library)it4.next();
                Iterator cIt4 = oLib4.getCells();
                while (cIt4.hasNext()) {
                    Cell oCell4 = (Cell)cIt4.next();
                    mi = (GenMath.MutableInteger)cellsMarked1.get(oCell4);
                    if (oCell4 == cell || mi.intValue() == 0) continue;
                    if (total > 0) {
                        infstr.append(", ");
                    }
                    infstr.append(oCell4.describe(true));
                    ++total;
                }
            }
            System.out.println("Also checking in related cell(s): " + infstr.toString());
        }
        return cellsMarked1;
    }

    private static void getCellFromRepository(ProjectCell pc, Library lib, boolean recursively) {
        ProjectLibrary pl = pc.projLib;
        String libName = pl.projDirectory + File.separator + pc.cellName + File.separator + pc.cellVersion + "-" + pc.cellView.getFullName() + "." + pc.libType.getExtensions()[0];
        Cell newCell = null;
        String tempLibName = Project.getTempLibraryName();
        Library fLib = Input.readLibrary(TextUtils.makeURLToFile(libName), tempLibName, pc.libType, true);
        if (fLib == null) {
            System.out.println("Cannot read library " + libName);
        } else {
            String cellNameInRepository = pc.describe();
            Cell cur = fLib.findNodeProto(cellNameInRepository);
            if (cur == null) {
                System.out.println("Cannot find cell " + cellNameInRepository + " in library " + libName);
            } else {
                HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
                Iterator it = cur.getNodes();
                while (it.hasNext()) {
                    ProjectLibrary subPL;
                    ProjectCell subPC;
                    NodeInst ni = (NodeInst)it.next();
                    nodePrototypes.put(ni, ni.getProto());
                    if (!(ni.getProto() instanceof Cell)) continue;
                    Cell subCell = (Cell)ni.getProto();
                    Library subLib = lib;
                    String cellName = subCell.noLibDescribe();
                    Variable var = subCell.getVar(PROJLIBRARYKEY);
                    if (var != null) {
                        String subLibName = (String)var.getObject();
                        subLib = Library.findLibrary(subLibName);
                        if (cellName.startsWith(subLibName + "__")) {
                            cellName = cellName.substring(subLibName.length() + 2);
                        }
                        if (subLib == null && recursively) {
                            subLib = Library.newInstance(subLibName, null);
                            String projFile = Project.getRepositoryLocation() + File.separator + subLibName + File.separator + PROJECTFILE;
                            File pf = new File(projFile);
                            if (!pf.exists()) {
                                System.out.println("Cannot find project file '" + projFile + "'...retrieve aborted.");
                            } else {
                                subLib.newVar(PROJPATHKEY, (Object)projFile);
                                ProjectLibrary subPL2 = ProjectLibrary.findProjectLibrary(subLib);
                                String userName = Project.getCurrentUserName();
                                Iterator sIt = subPL2.allCells.iterator();
                                while (sIt.hasNext()) {
                                    ProjectCell recPC = (ProjectCell)sIt.next();
                                    if (!recPC.latestVersion) continue;
                                    if (recPC.cell == null) {
                                        Project.getCellFromRepository(recPC, subLib, true);
                                        if (recPC.cell == null) {
                                            System.out.println("Error retrieving cell from repository");
                                        }
                                    }
                                    if (recPC.cell == null) continue;
                                    boolean youOwn = userName.length() > 0 && recPC.owner.equals(userName);
                                    Project.markLocked(recPC.cell, !youOwn);
                                }
                            }
                        }
                    }
                    Cell realSubCell = null;
                    if (subLib != null) {
                        realSubCell = subLib.findNodeProto(cellName);
                    }
                    if (realSubCell == null && recursively && (subPC = (subPL = ProjectLibrary.findProjectLibrary(subLib)).findProjectCellByNameViewVersion(subCell.getName(), subCell.getView(), subCell.getVersion())) != null) {
                        if (subPC.cell != null) {
                            System.out.println("ERROR: cell " + cellName + " does not exist, but it appears as " + subPC.cell);
                        }
                        Project.getCellFromRepository(subPC, subLib, recursively);
                        realSubCell = subPC.cell;
                    }
                    if (realSubCell == null) {
                        System.out.println("Cannot find subcell " + cellName + " referenced by cell " + cellNameInRepository);
                        continue;
                    }
                    nodePrototypes.put(ni, realSubCell);
                }
                String cellName = Project.describeFullCellName(cur);
                newCell = Cell.copyNodeProtoUsingMapping(cur, lib, cellName, nodePrototypes);
                if (newCell == null) {
                    System.out.println("Cannot copy " + cur + " from new library");
                }
            }
            fLib.kill("delete");
        }
        pc.cell = newCell;
        if (newCell != null) {
            pl.byCell.put(newCell, pc);
        }
    }

    private static void addNewProjectCells(ProjectLibrary pl, List updatedProjectCells) {
        Cell oldCell;
        HashMap<String, ProjectCell> versionToGet = new HashMap<String, ProjectCell>();
        Iterator<Object> it = pl.allCells.iterator();
        while (it.hasNext()) {
            ProjectCell pc = (ProjectCell)it.next();
            String cellName = pc.cellName + "{" + pc.cellView.getAbbreviation() + "}";
            ProjectCell pcToGet = (ProjectCell)versionToGet.get(cellName);
            if (pcToGet != null) {
                if (pc.cellVersion <= pcToGet.cellVersion) continue;
                if (pc.owner.length() > 0) {
                    oldCell = pl.lib.findNodeProto(pc.describeWithVersion());
                    if (oldCell != null) {
                        if (pc.owner.equals(Project.getCurrentUserName())) {
                            versionToGet.remove(cellName);
                            continue;
                        }
                        System.out.println("WARNING: " + oldCell + " is checked-out to " + pc.owner);
                        continue;
                    }
                    if (!pc.owner.equals(Project.getCurrentUserName())) continue;
                    System.out.println("WARNING: Cell " + pl.lib.getName() + ":" + pc.describe() + " is checked-out to you but is missing from this library.  Do another check-out to edit it.");
                    continue;
                }
            }
            versionToGet.put(cellName, pc);
        }
        it = versionToGet.keySet().iterator();
        while (it.hasNext()) {
            String cellName = (String)it.next();
            ProjectCell pc = (ProjectCell)versionToGet.get(cellName);
            Cell oldCellAny = pl.lib.findNodeProto(pc.describe());
            oldCell = pl.lib.findNodeProto(pc.describeWithVersion());
            if (oldCellAny != null && oldCellAny.getVersion() > pc.cellVersion) {
                System.out.println("WARNING: " + oldCellAny + " is newer than what is in the repository.  Updating it from the repository version");
            }
            if (oldCell != null) continue;
            updatedProjectCells.add(pc);
        }
    }

    private static int updateCellFromRepository(ProjectCell pc, List updatedProjectCells) {
        ProjectLibrary pl = pc.projLib;
        Library lib = pl.lib;
        Cell oldCell = lib.findNodeProto(pc.describe());
        Cell newCell = null;
        int total = 0;
        String libName = pl.projDirectory + File.separator + pc.cellName + File.separator + pc.cellVersion + "-" + pc.cellView.getFullName() + "." + pc.libType.getExtensions()[0];
        String tempLibName = Project.getTempLibraryName();
        Library fLib = Input.readLibrary(TextUtils.makeURLToFile(libName), tempLibName, pc.libType, true);
        if (fLib == null) {
            System.out.println("Cannot read library " + libName);
        } else {
            String cellNameInRepository = pc.describe();
            Cell cur = fLib.findNodeProto(cellNameInRepository);
            if (cur == null) {
                System.out.println("Cannot find cell " + cellNameInRepository + " in library " + libName);
            } else {
                HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
                Iterator it = cur.getNodes();
                while (it.hasNext()) {
                    ProjectLibrary subPL;
                    ProjectCell subCellPC;
                    Cell foundSubCell;
                    Cell subCell;
                    NodeInst ni = (NodeInst)it.next();
                    NodeProto np = ni.getProto();
                    nodePrototypes.put(ni, np);
                    if (!(np instanceof Cell) || (subCell = (Cell)np).getView().isTextView()) continue;
                    Library subLib = lib;
                    String subCellName = Project.describeFullCellName(subCell);
                    Variable var = subCell.getVar(PROJLIBRARYKEY);
                    if (var != null) {
                        String subLibName = (String)var.getObject();
                        subLib = Library.findLibrary(subLibName);
                        if (subCellName.startsWith(subLibName + "__")) {
                            subCellName = subCellName.substring(subLibName.length() + 2);
                        }
                        if (subLib == null) {
                            subLib = Library.newInstance(subLibName, null);
                            String projFile = Project.getRepositoryLocation() + File.separator + subLibName + File.separator + PROJECTFILE;
                            File pf = new File(projFile);
                            if (!pf.exists()) {
                                System.out.println("Cannot find project file '" + projFile + "'...retrieve aborted.");
                            } else {
                                subLib.newVar(PROJPATHKEY, (Object)projFile);
                                ProjectLibrary subPL2 = ProjectLibrary.findProjectLibrary(subLib);
                                Project.addNewProjectCells(subPL2, updatedProjectCells);
                            }
                        }
                    }
                    if ((foundSubCell = subLib.findNodeProto(subCellName)) == null && (subCellPC = (subPL = ProjectLibrary.findProjectLibrary(subLib)).findProjectCellByNameViewVersion(subCell.getName(), subCell.getView(), subCell.getVersion())) != null) {
                        if (subCellPC.cell != null) {
                            System.out.println("ERROR: cell " + subCellName + " does not exist, but it appears as " + subCellPC.cell);
                        }
                        if (!updatedProjectCells.contains(subCellPC)) {
                            System.out.println("ERROR: cell " + subCellName + " needs to be updated but isn't in the list");
                        }
                        total += Project.updateCellFromRepository(subCellPC, updatedProjectCells);
                        foundSubCell = subCellPC.cell;
                    }
                    nodePrototypes.put(ni, foundSubCell);
                }
                String cellName = Project.describeFullCellName(cur);
                newCell = Cell.copyNodeProtoUsingMapping(cur, lib, cellName, nodePrototypes);
                if (newCell == null) {
                    System.out.println("Cannot copy " + cur + " from new library");
                }
            }
            fLib.kill("delete");
        }
        if (newCell != null) {
            pc.cell = newCell;
            pl.byCell.put(newCell, pc);
            if (oldCell != null) {
                if (Project.useNewestVersion(oldCell, newCell)) {
                    System.out.println("Error replacing instances of new " + oldCell);
                } else {
                    System.out.println("Updated " + newCell);
                }
                pl.byCell.remove(oldCell);
            } else {
                System.out.println("Added new " + newCell);
            }
            ++total;
        }
        updatedProjectCells.remove(pc);
        return total;
    }

    private static boolean useNewestVersion(Cell oldCell, Cell newCell) {
        ArrayList instances = new ArrayList();
        Iterator it = oldCell.getInstancesOf();
        while (it.hasNext()) {
            instances.add(it.next());
        }
        it = instances.iterator();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            NodeInst newNi = ni.replace(newCell, false, false);
            if (newNi != null) continue;
            System.out.println("Failed to update instance of " + newCell + " in " + ni.getParent());
            return true;
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            if (wf.getContent().getCell() != oldCell) continue;
            wf.getContent().setCell(newCell, VarContext.globalContext);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowFrame.wantToRedoLibraryTree();
            }
        });
        it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib.getCurCell() != oldCell) continue;
            lib.setCurCell(newCell);
        }
        oldCell.kill();
        return false;
    }

    private static boolean writeCell(Cell cell, ProjectCell pc) {
        String dirName = pc.projLib.projDirectory + File.separator + cell.getName();
        File dir = new File(dirName);
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("Unable to create directory " + dirName);
            return true;
        }
        String libName = dirName + File.separator + cell.getVersion() + "-" + cell.getView().getFullName() + ".elib";
        String tempLibName = Project.getTempLibraryName();
        Library fLib = Library.newInstance(tempLibName, TextUtils.makeURLToFile(libName));
        if (fLib == null) {
            System.out.println("Cannot create library " + libName);
            return true;
        }
        Cell cellCopy = Project.copyrecursively(cell, fLib);
        if (cellCopy == null) {
            System.out.println("Could not place " + cell + " in a library");
            fLib.kill("delete");
            return true;
        }
        fLib.setCurCell(cellCopy);
        fLib.setFromDisk();
        boolean error = Output.writeLibrary(fLib, pc.libType, false);
        if (error) {
            System.out.println("Could not save library with " + cell + " in it");
            fLib.kill("delete");
            return true;
        }
        fLib.kill("delete");
        return false;
    }

    private static String getTempLibraryName() {
        int i = 1;
        String libName;
        while (Library.findLibrary(libName = "projecttemp" + i) != null) {
            ++i;
        }
        return libName;
    }

    private static Cell copyrecursively(Cell fromCell, Library toLib) {
        Cell newFromCell = toLib.findNodeProto(fromCell.noLibDescribe());
        if (newFromCell != null) {
            return newFromCell;
        }
        HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
        Iterator it = fromCell.getNodes();
        while (it.hasNext()) {
            Cell oCell;
            Cell cell;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            nodePrototypes.put(ni, np);
            if (!(np instanceof Cell) || (cell = (Cell)np).getView().isTextView()) continue;
            String subCellName = cell.noLibDescribe();
            if (cell.getLibrary() != fromCell.getLibrary()) {
                subCellName = cell.getLibrary().getName() + "__" + subCellName;
            }
            if ((oCell = toLib.findNodeProto(subCellName)) == null) {
                oCell = Cell.makeInstance(toLib, subCellName);
                if (oCell == null) {
                    System.out.println("Could not create subcell " + subCellName);
                    continue;
                }
                if (cell.getLibrary() != fromCell.getLibrary()) {
                    oCell.newVar(PROJLIBRARYKEY, (Object)cell.getLibrary().getName());
                }
                if (ViewChanges.skeletonizeCell(cell, oCell)) {
                    System.out.println("Copy of sub" + cell + " failed");
                    return null;
                }
            }
            nodePrototypes.put(ni, oCell);
        }
        newFromCell = Cell.copyNodeProtoUsingMapping(fromCell, toLib, Project.describeFullCellName(fromCell), nodePrototypes);
        return newFromCell;
    }

    private static String describeFullCellName(Cell cell) {
        String cellName = cell.getName() + ";" + cell.getVersion();
        if (cell.getView() != View.UNKNOWN) {
            cellName = cellName + "{" + cell.getView().getAbbreviation() + "}";
        }
        return cellName;
    }

    public static String encryptPassword(String text) {
        int i;
        String key = "BicIsSchediwy";
        String readable = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-";
        int seed = 123;
        int keyLen = key.length();
        for (int i2 = 0; i2 < keyLen; ++i2) {
            seed = seed * key.charAt(i2) + i2;
        }
        char[] t1 = new char[256];
        char[] t2 = new char[256];
        char[] t3 = new char[256];
        char[] deck = new char[256];
        for (i = 0; i < 256; ++i) {
            t1[i] = (char)i;
            t3[i] = '\u0000';
            deck[i] = (char)i;
        }
        for (i = 0; i < 256; ++i) {
            seed = 5 * seed + key.charAt(i % keyLen);
            int random = seed % 65521;
            int k = 255 - i;
            int ic = (random & 0xFF) % (k + 1);
            random >>= 8;
            char temp = t1[k];
            t1[k] = t1[ic];
            t1[ic] = temp;
            if (t3[k] != '\u0000') continue;
            ic = (random & 0xFF) % k;
            while (t3[ic] != '\u0000') {
                ic = (ic + 1) % k;
            }
            t3[k] = (char)ic;
            t3[ic] = (char)k;
        }
        for (i = 0; i < 256; ++i) {
            t2[t1[i] & 0xFF] = (char)i;
        }
        int n1 = 0;
        int n2 = 0;
        int nr2 = 0;
        StringBuffer result = new StringBuffer();
        for (int pt = 0; pt < text.length(); ++pt) {
            int nr1 = deck[n1] & 0xFF;
            nr2 = deck[nr1] & 0xFF;
            int i3 = t2[t3[t1[text.charAt(pt) + nr1 & 0xFF] + nr2 & 0xFF] - nr2 & 0xFF] - nr1;
            result.append(readable.charAt(i3 & 0x3F));
            if (++n1 != 256) continue;
            n1 = 0;
            if (++n2 == 256) {
                n2 = 0;
            }
            Project.shuffle(deck, key);
        }
        String res = result.toString();
        return res;
    }

    private static void shuffle(char[] deck, String key) {
        int seed = 123;
        int keyLen = key.length();
        for (int i = 0; i < 256; ++i) {
            seed = 5 * seed + key.charAt(i % keyLen);
            int random = seed % 65521;
            int k = 255 - i;
            int ic = (random & 0xFF) % (k + 1);
            char temp = deck[k];
            deck[k] = deck[ic];
            deck[ic] = temp;
        }
    }

    private static boolean needUserName() {
        if (Project.getCurrentUserName().length() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "You must select a user first (in the 'Project Management' panel of the Preferences dialog)", "No Valid User", 0);
            return true;
        }
        return false;
    }

    public static String getCurrentUserName() {
        return cacheCurrentUserName.getString();
    }

    public static void setCurrentUserName(String u) {
        cacheCurrentUserName.setString(u);
    }

    public static String getRepositoryLocation() {
        return cacheRepositoryLocation.getString();
    }

    public static void setRepositoryLocation(String r) {
        boolean alter = Project.getRepositoryLocation().length() > 0;
        cacheRepositoryLocation.setString(r);
        usersMap = null;
        if (alter) {
            libraryProjectInfo.clear();
        }
    }

    public static String getAuthorizationPassword() {
        return cacheAuthorizationPassword.getString();
    }

    public static void setAuthorizationPassword(String a) {
        cacheAuthorizationPassword.setString(a);
    }

    static {
        libraryProjectInfo = new HashMap();
        fCheckList = new ArrayList();
        cacheCurrentUserName = Pref.makeStringPref("CurrentUserName", Project.tool.prefs, "");
        cacheRepositoryLocation = Pref.makeStringPref("RepositoryLocation", Project.tool.prefs, "");
        cacheAuthorizationPassword = Pref.makeStringPref("e", Project.tool.prefs, "e");
    }

    private static class ProjectCellByVersion
    implements Comparator {
        private ProjectCellByVersion() {
        }

        public int compare(Object o1, Object o2) {
            ProjectCell pc1 = (ProjectCell)o1;
            ProjectCell pc2 = (ProjectCell)o2;
            return pc2.cellVersion - pc1.cellVersion;
        }
    }

    private static class OrderedProjectCells
    implements Comparator {
        private OrderedProjectCells() {
        }

        public int compare(Object o1, Object o2) {
            ProjectCell pc1 = (ProjectCell)o1;
            ProjectCell pc2 = (ProjectCell)o2;
            int diff = pc1.cellName.compareTo(pc2.cellName);
            if (diff != 0) {
                return diff;
            }
            diff = pc1.cellView.getFullName().compareTo(pc2.cellView.getFullName());
            if (diff != 0) {
                return diff;
            }
            return pc1.cellVersion - pc2.cellVersion;
        }
    }

    private static class DeleteCellJob
    extends Job {
        private Cell cell;

        protected DeleteCellJob(Cell cell) {
            super("Delete cell", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it;
            Library lib = this.cell.getLibrary();
            HashSet<Cell> markedCells = new HashSet<Cell>();
            Iterator it2 = this.cell.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                markedCells.add(ni.getParent());
            }
            StringBuffer err = new StringBuffer();
            Iterator it3 = Library.getLibraries();
            while (it3.hasNext()) {
                Library oLib = (Library)it3.next();
                Iterator cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    Cell oCell = (Cell)cIt.next();
                    if (!markedCells.contains(oCell)) continue;
                    if (err.length() > 0) {
                        err.append(", ");
                    }
                    err.append(oCell.describe(true));
                }
            }
            if (markedCells.size() > 0) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot delete " + this.cell + " because it is still being used by: " + err.toString(), "Error Deleting Cell", 0);
                return false;
            }
            if (Project.needUserName()) {
                return false;
            }
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
            if (pl.lockProjectFile()) {
                return false;
            }
            boolean youOwn = false;
            Iterator it4 = pl.allCells.iterator();
            while (it4.hasNext()) {
                ProjectCell pc = (ProjectCell)it4.next();
                if (!pc.owner.equals(Project.getCurrentUserName())) continue;
                youOwn = true;
                break;
            }
            if (youOwn) {
                StringBuffer infstr = new StringBuffer();
                it = pl.allCells.iterator();
                while (it.hasNext()) {
                    ProjectCell pc = (ProjectCell)it.next();
                    if (!pc.owner.equals(Project.getCurrentUserName())) continue;
                    if (infstr.length() > 0) {
                        infstr.append(", ");
                    }
                    infstr.append(pc.describe());
                }
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Before deleting a cell from the repository, you must check-in all of your work. This is because the deletion may be dependent upon changes recently made. These cells are checked out to you: " + infstr.toString(), "Error Deleting Cell", 0);
            } else {
                ArrayList copyList = new ArrayList();
                it = pl.allCells.iterator();
                while (it.hasNext()) {
                    copyList.add(it.next());
                }
                boolean found = false;
                Iterator it5 = copyList.iterator();
                while (it5.hasNext()) {
                    ProjectCell pc = (ProjectCell)it5.next();
                    if (!pc.cellName.equals(this.cell.getName()) || pc.cellView != this.cell.getView()) continue;
                    pl.removeProjectCell(pc);
                    if (pc.cell != null) {
                        pl.byCell.remove(pc.cell);
                    }
                    Project.setChangeStatus(true);
                    Project.markLocked(this.cell, false);
                    Project.setChangeStatus(false);
                    found = true;
                }
                if (found) {
                    System.out.println("Cell " + this.cell.describe(true) + " deleted from the repository");
                } else {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is not in the repository", "Error Deleting Cell", 0);
                }
            }
            pl.releaseProjectFileLock(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.wantToRedoLibraryTree();
                }
            });
            return true;
        }
    }

    private static class AddCellJob
    extends Job {
        private Cell cell;

        protected AddCellJob(Cell cell) {
            super("Add " + cell, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            if (this.cell.getNewestVersion() != this.cell) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot add an old version of the cell", "Error Adding Cell", 0);
                return false;
            }
            if (Project.needUserName()) {
                return false;
            }
            Library lib = this.cell.getLibrary();
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
            if (pl.lockProjectFile()) {
                return false;
            }
            Project.setChangeStatus(true);
            ProjectCell foundPC = pl.findProjectCellByNameView(this.cell.getName(), this.cell.getView());
            if (foundPC != null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is already in the repository", "Error Adding Cell", 0);
            } else {
                ProjectCell pc = new ProjectCell();
                pc.cellName = this.cell.getName();
                pc.cellView = this.cell.getView();
                pc.cellVersion = this.cell.getVersion();
                pc.owner = "";
                pc.lastOwner = Project.getCurrentUserName();
                pc.comment = "Initial checkin";
                pc.latestVersion = true;
                pc.projLib = pl;
                pc.libType = FileType.JELIB;
                pc.cell = this.cell;
                if (Project.writeCell(this.cell, pc)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error writing the cell to the repository", "Error Adding Cell", 0);
                } else {
                    pl.addProjectCell(pc);
                    pl.byCell.put(this.cell, pc);
                    Project.markLocked(this.cell, true);
                    System.out.println("Cell " + this.cell.describe(true) + " added to the project");
                }
            }
            Project.setChangeStatus(false);
            pl.releaseProjectFileLock(true);
            return true;
        }
    }

    private static class AddLibraryJob
    extends Job {
        private Library lib;

        protected AddLibraryJob(Library lib) {
            super("Add Library", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.startJob();
        }

        public boolean doIt() {
            if (Project.getRepositoryLocation().length() == 0) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Before entering a library, set a repository location in the 'Project Management' tab under General Preferences", "Must Setup Project Management", 1);
                return false;
            }
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(this.lib);
            if (pl.allCells.size() != 0) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This library is already in the repository", "Error Adding Library", 0);
                return false;
            }
            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to enter this library into the repository?");
            if (response != 0) {
                return false;
            }
            String libraryname = this.lib.getName();
            pl.projDirectory = Project.getRepositoryLocation() + File.separator + libraryname;
            File dir = new File(pl.projDirectory);
            if (dir.exists()) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Repository directory '" + pl.projDirectory + "' already exists", "Error Adding Library", 0);
                return false;
            }
            if (!dir.mkdir()) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Could not create repository directory '" + pl.projDirectory + "'", "Error Adding Library", 0);
                return false;
            }
            System.out.println("Making repository directory '" + pl.projDirectory + "'...");
            Project.setChangeStatus(true);
            Iterator it = this.lib.getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                ProjectCell pc = new ProjectCell();
                pc.cellName = cell.getName();
                pc.cellView = cell.getView();
                pc.cellVersion = cell.getVersion();
                pc.owner = "";
                pc.lastOwner = Project.getCurrentUserName();
                pc.comment = "Initial checkin";
                pc.libType = FileType.JELIB;
                pc.cell = cell;
                pc.latestVersion = true;
                pc.projLib = pl;
                if (cell.getNewestVersion() != cell) {
                    if (cell.getNumUsagesIn() == 0) continue;
                    System.out.println("Warning: including old version of " + cell);
                    pc.latestVersion = false;
                }
                pl.addProjectCell(pc);
                pl.byCell.put(cell, pc);
                if (Project.writeCell(cell, pc)) {
                    System.out.println("Error writing cell file");
                    continue;
                }
                System.out.println("Entering " + cell);
                Project.markLocked(cell, true);
            }
            String projfile = pl.projDirectory + File.separator + Project.PROJECTFILE;
            this.lib.newVar(PROJPATHKEY, (Object)projfile);
            try {
                PrintStream buffWriter = new PrintStream(new FileOutputStream(projfile));
                Iterator it2 = pl.allCells.iterator();
                while (it2.hasNext()) {
                    ProjectCell pc = (ProjectCell)it2.next();
                    buffWriter.println("::" + pc.cellName + ":" + pc.cellVersion + "-" + pc.cellView.getFullName() + "." + pc.libType.getExtensions()[0] + ":" + pc.owner + ":" + pc.lastOwner + ":" + pc.comment);
                }
                buffWriter.close();
            }
            catch (IOException e) {
                System.out.println("Error creating " + projfile);
            }
            Project.setChangeStatus(false);
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "The current library has been checked-into the repository and marked appropriately.", "Library Added", 1);
            return true;
        }
    }

    private static class UpdateJob
    extends Job {
        protected UpdateJob() {
            super("Update all Cells from Repository", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            Iterator it;
            ProjectLibrary pl;
            if (Project.needUserName()) {
                return false;
            }
            ArrayList updatedProjectCells = new ArrayList();
            Iterator lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library lib = (Library)lIt.next();
                if (lib.isHidden()) continue;
                ProjectLibrary pl2 = ProjectLibrary.findProjectLibrary(lib);
                if (!pl2.lockProjectFile()) {
                    pl2.releaseProjectFileLock(false);
                }
                Project.addNewProjectCells(pl2, updatedProjectCells);
            }
            HashSet<ProjectLibrary> libsLocked = new HashSet<ProjectLibrary>();
            boolean allLocked = true;
            Iterator it2 = updatedProjectCells.iterator();
            while (it2.hasNext()) {
                ProjectCell pc = (ProjectCell)it2.next();
                pl = pc.projLib;
                if (libsLocked.contains(pl)) continue;
                if (pl.lockProjectFile()) {
                    allLocked = false;
                    break;
                }
                libsLocked.add(pl);
            }
            int total = 0;
            if (allLocked) {
                Project.setChangeStatus(true);
                while ((it = updatedProjectCells.iterator()).hasNext()) {
                    ProjectCell pc = (ProjectCell)it.next();
                    total += Project.updateCellFromRepository(pc, updatedProjectCells);
                }
                Project.setChangeStatus(false);
            }
            it = libsLocked.iterator();
            while (it.hasNext()) {
                pl = (ProjectLibrary)it.next();
                pl.releaseProjectFileLock(false);
                Project.validateLocks(pl.lib);
            }
            if (total == 0) {
                System.out.println("Project is up-to-date");
            } else {
                System.out.println("Updated " + total + " cells");
            }
            return true;
        }
    }

    private static class RetrieveLibraryFromRepositoryJob
    extends Job {
        private String libName;

        protected RetrieveLibraryFromRepositoryJob(String libName) {
            super("Retrieve Library from Repository", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.libName = libName;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = Library.findLibrary(this.libName);
            if (lib != null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Library '" + lib.getName() + "' already exists", "Cannot Retrieve Library", 0);
                return false;
            }
            lib = Library.newInstance(this.libName, null);
            String projFile = Project.getRepositoryLocation() + File.separator + this.libName + File.separator + Project.PROJECTFILE;
            File pf = new File(projFile);
            if (!pf.exists()) {
                System.out.println("Cannot find project file '" + projFile + "'...retrieve aborted.");
                return false;
            }
            lib.newVar(PROJPATHKEY, (Object)projFile);
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
            Project.setChangeStatus(true);
            String userName = Project.getCurrentUserName();
            Iterator it = pl.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                if (!pc.latestVersion) continue;
                if (pc.cell == null) {
                    Project.getCellFromRepository(pc, lib, true);
                    if (pc.cell == null) {
                        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error retrieving old version of cell", "Error Getting Old Versions", 0);
                    }
                }
                if (pc.cell == null) continue;
                boolean youOwn = userName.length() > 0 && pc.owner.equals(userName);
                Project.markLocked(pc.cell, !youOwn);
            }
            Project.setChangeStatus(false);
            System.out.println("Library " + lib.getName() + " has been retrieved from the repository");
            return true;
        }
    }

    private static class GetOldVersionJob
    extends Job {
        private Cell cell;
        private int version;

        protected GetOldVersionJob(Cell cell, int version) {
            super("Update " + cell, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.version = version;
            this.startJob();
        }

        public boolean doIt() {
            Cell exists;
            Library lib = this.cell.getLibrary();
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
            String cellName = this.cell.getName() + ";" + this.version;
            if (this.cell.getView() != View.UNKNOWN) {
                cellName = cellName + "{" + this.cell.getView().getAbbreviation() + "}";
            }
            if ((exists = this.cell.getLibrary().findNodeProto(cellName)) != null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Version " + this.version + " of cell " + this.cell.getName() + " is already in your library", "Cannot Retrieve Version", 0);
                return false;
            }
            ProjectCell foundPC = pl.findProjectCellByNameViewVersion(this.cell.getName(), this.cell.getView(), this.version);
            if (foundPC == null) {
                System.out.println("Can't find that version in the repository!");
                return false;
            }
            Project.setChangeStatus(true);
            Project.getCellFromRepository(foundPC, lib, false);
            if (foundPC.cell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error retrieving old version of cell", "Error Getting Old Versions", 0);
            }
            Project.markLocked(foundPC.cell, false);
            Project.setChangeStatus(false);
            System.out.println("Cell " + foundPC.cell.describe(true) + " is now in this library");
            return true;
        }
    }

    private static class ShowLibsInRepository
    extends EDialog {
        private JList libList;
        private DefaultListModel libModel;

        private ShowLibsInRepository() {
            super((Frame)null, true);
            this.initComponents();
            this.setVisible(true);
        }

        protected void escapePressed() {
            this.doButton(false);
        }

        private void doButton(boolean retrieve) {
            if (retrieve) {
                int index = this.libList.getSelectedIndex();
                String libName = (String)this.libModel.getElementAt(index);
                new RetrieveLibraryFromRepositoryJob(libName);
            }
            this.dispose();
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Retrieve a Library from the Repository");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ShowLibsInRepository.this.doButton(false);
                }
            });
            JScrollPane libPane = new JScrollPane();
            this.libModel = new DefaultListModel();
            this.libList = new JList(this.libModel);
            this.libList.setSelectionMode(0);
            libPane.setViewportView(this.libList);
            this.libList.clearSelection();
            this.libList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ShowLibsInRepository.this.doButton(true);
                    }
                }
            });
            String dirName = Project.getRepositoryLocation();
            File dir = new File(dirName);
            File[] filesInDir = dir.listFiles();
            for (int i = 0; i < filesInDir.length; ++i) {
                File subFile = filesInDir[i];
                if (!subFile.isDirectory()) continue;
                this.libModel.addElement(subFile.getName());
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)libPane, gbc);
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowLibsInRepository.this.doButton(true);
                }
            });
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowLibsInRepository.this.doButton(false);
                }
            });
            this.pack();
        }
    }

    private static class ShowHistory
    extends EDialog {
        private Cell cell;
        private TableModel dataModel;
        private JTable table;

        private ShowHistory(Cell cell) {
            super((Frame)null, true);
            this.cell = cell;
            this.initComponents();
            this.setVisible(true);
        }

        protected void escapePressed() {
            this.doButton(false);
        }

        private void doButton(boolean retrieve) {
            if (retrieve) {
                int index = this.table.getSelectedRow();
                int version = TextUtils.atoi((String)this.dataModel.getValueAt(index, 0));
                new GetOldVersionJob(this.cell, version);
            } else {
                this.dispose();
            }
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Examine the History of " + this.cell);
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ShowHistory.this.doButton(false);
                }
            });
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(this.cell.getLibrary());
            ArrayList<ProjectCell> versions = new ArrayList<ProjectCell>();
            Iterator it = pl.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                if (!pc.cellName.equals(this.cell.getName()) || pc.cellView != this.cell.getView()) continue;
                pc.checkInDate = "Not In Repository Yet";
                versions.add(pc);
            }
            String dirName = pl.projDirectory + File.separator + this.cell.getName();
            File dir = new File(dirName);
            File[] filesInDir = dir.listFiles();
            for (int i = 0; i < filesInDir.length; ++i) {
                File subFile = filesInDir[i];
                Date modDate = new Date(subFile.lastModified());
                int version = TextUtils.atoi(subFile.getName());
                boolean found = false;
                Iterator it2 = versions.iterator();
                while (it2.hasNext()) {
                    ProjectCell pc = (ProjectCell)it2.next();
                    if (pc.cellVersion != version) continue;
                    pc.checkInDate = TextUtils.formatDate(modDate);
                    found = true;
                    break;
                }
                if (found) continue;
                ProjectCell pc = new ProjectCell();
                pc.cellName = this.cell.getName();
                pc.cellVersion = version;
                pc.checkInDate = TextUtils.formatDate(modDate);
                pc.projLib = pl;
                versions.add(pc);
            }
            Collections.sort(versions, new ProjectCellByVersion());
            int numVersions = versions.size();
            Object[][] data = new Object[numVersions][4];
            int index = 0;
            Iterator it3 = versions.iterator();
            while (it3.hasNext()) {
                ProjectCell pc = (ProjectCell)it3.next();
                data[index][0] = Integer.toString(pc.cellVersion);
                data[index][1] = pc.checkInDate;
                data[index][2] = pc.lastOwner;
                if (pc.owner.length() > 0) {
                    data[index][2] = pc.owner;
                }
                data[index][3] = pc.comment;
                ++index;
            }
            this.dataModel = new HistoryTableModel(data);
            this.table = new JTable(this.dataModel);
            TableColumn versCol = this.table.getColumnModel().getColumn(0);
            TableColumn dateCol = this.table.getColumnModel().getColumn(1);
            TableColumn userCol = this.table.getColumnModel().getColumn(2);
            TableColumn commentCol = this.table.getColumnModel().getColumn(3);
            versCol.setPreferredWidth(10);
            dateCol.setPreferredWidth(30);
            userCol.setPreferredWidth(20);
            commentCol.setPreferredWidth(40);
            JScrollPane tableScrollPane = new JScrollPane(this.table);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)tableScrollPane, gbc);
            JButton ok = new JButton("Retrieve");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowHistory.this.doButton(true);
                }
            });
            JButton cancel = new JButton("Done");
            this.getRootPane().setDefaultButton(cancel);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowHistory.this.doButton(false);
                }
            });
            this.pack();
        }

        class HistoryTableModel
        extends AbstractTableModel {
            private String[] columnNames;
            private Object[][] data;

            HistoryTableModel(Object[][] data) {
                this.data = data;
                this.columnNames = new String[]{"Version", "Date", "Who", "Comments"};
            }

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                return this.data.length;
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                return this.data[row][col];
            }

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }
        }
    }

    private static class CheckInJob
    extends Job {
        private Library lib;
        private HashMap cellsMarked;

        protected CheckInJob(Library lib, HashMap cellsMarked) {
            super("Check in cells", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.cellsMarked = cellsMarked;
            this.startJob();
        }

        public boolean doIt() {
            if (Project.needUserName()) {
                return false;
            }
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(this.lib);
            if (pl.lockProjectFile()) {
                return false;
            }
            Project.setChangeStatus(true);
            String cellNames = "";
            Iterator it = this.cellsMarked.keySet().iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                GenMath.MutableInteger mi = (GenMath.MutableInteger)this.cellsMarked.get(cell);
                if (mi.intValue() == 0) continue;
                if (cellNames.length() > 0) {
                    cellNames = cellNames + ", ";
                }
                cellNames = cellNames + cell.describe(false);
            }
            String comment = null;
            Iterator it2 = this.cellsMarked.keySet().iterator();
            while (it2.hasNext()) {
                Cell cell = (Cell)it2.next();
                GenMath.MutableInteger mi = (GenMath.MutableInteger)this.cellsMarked.get(cell);
                if (mi.intValue() == 0) continue;
                ProjectCell pc = ProjectCell.findProjectCell(cell);
                if (pc == null) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cell " + cell.describe(true) + " is not in the project.  Add it before checking it in or out.", "Check In Error", 0);
                    continue;
                }
                if (!pc.owner.equals(Project.getCurrentUserName())) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "You cannot check-in " + cell + " because it is checked out to '" + pc.owner + "', not you.", "Check In Error", 0);
                    continue;
                }
                if (comment == null) {
                    comment = JOptionPane.showInputDialog("Reason for checking-in " + cellNames, (Object)"");
                }
                if (comment == null) break;
                if (Project.writeCell(cell, pc)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error writing " + cell, "Check In Error", 0);
                    continue;
                }
                pc.owner = "";
                pc.lastOwner = Project.getCurrentUserName();
                pc.cellVersion = cell.getVersion();
                pc.comment = comment;
                Project.markLocked(cell, true);
                System.out.println("Cell " + cell.describe(true) + " checked in");
            }
            Project.setChangeStatus(false);
            pl.releaseProjectFileLock(true);
            return true;
        }
    }

    private static class CancelCheckOutJob
    extends Job {
        private Cell cell;

        protected CancelCheckOutJob(Cell cell) {
            super("Cancel Check-out " + cell, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            if (Project.needUserName()) {
                return false;
            }
            Library lib = this.cell.getLibrary();
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
            if (pl.lockProjectFile()) {
                return false;
            }
            Project.setChangeStatus(true);
            ProjectCell cancelled = null;
            ProjectCell former = null;
            Iterator it = pl.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                if (!pc.cellName.equals(this.cell.getName()) || pc.cellView != this.cell.getView()) continue;
                if (pc.cellVersion >= this.cell.getVersion()) {
                    if (pc.owner.length() <= 0) continue;
                    if (pc.owner.equals(Project.getCurrentUserName())) {
                        cancelled = pc;
                        continue;
                    }
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is not checked out to you.  Only user '" + pc.owner + "' can cancel the check-out.", "Error Cancelling Check-out", 0);
                    Project.setChangeStatus(false);
                    pl.releaseProjectFileLock(true);
                    return false;
                }
                if (former != null && former.cellVersion < pc.cellVersion) {
                    former = null;
                }
                if (former != null) continue;
                former = pc;
            }
            if (cancelled == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is not checked out.", "Error Cancelling Check-out", 0);
                Project.setChangeStatus(false);
                pl.releaseProjectFileLock(true);
                return false;
            }
            if (former == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot find former version to restore.", "Error Cancelling Check-out", 0);
                Project.setChangeStatus(false);
                pl.releaseProjectFileLock(true);
                return false;
            }
            Project.getCellFromRepository(former, lib, false);
            if (former.cell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error bringing in former version (" + former.cellVersion + ")", "Error Cancelling Check-out", 0);
                Project.setChangeStatus(false);
                pl.releaseProjectFileLock(true);
                return false;
            }
            if (Project.useNewestVersion(this.cell, former.cell)) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error replacing instances of former " + this.cell, "Error Cancelling Check-out", 0);
                Project.setChangeStatus(false);
                pl.releaseProjectFileLock(true);
                return false;
            }
            pl.removeProjectCell(cancelled);
            if (cancelled.cell != null) {
                Project.markLocked(cancelled.cell, true);
                pl.byCell.remove(cancelled.cell);
            }
            former.latestVersion = true;
            Project.setChangeStatus(false);
            pl.releaseProjectFileLock(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.wantToRedoLibraryTree();
                }
            });
            return true;
        }
    }

    private static class CheckOutJob
    extends Job {
        private Cell oldVers;

        protected CheckOutJob(Cell oldVers) {
            super("Check out " + oldVers, tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oldVers = oldVers;
            this.startJob();
        }

        public boolean doIt() {
            ProjectCell pc;
            Library lib = this.oldVers.getLibrary();
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(lib);
            if (Project.needUserName()) {
                return false;
            }
            if (pl.lockProjectFile()) {
                return false;
            }
            ArrayList<ProjectCell> newerProjectCells = new ArrayList<ProjectCell>();
            Iterator it = pl.allCells.iterator();
            while (it.hasNext()) {
                pc = (ProjectCell)it.next();
                if (!pc.cellName.equals(this.oldVers.getName()) || pc.cellView != this.oldVers.getView() || pc.cellVersion <= this.oldVers.getVersion()) continue;
                newerProjectCells.add(pc);
            }
            it = newerProjectCells.iterator();
            while (it.hasNext()) {
                pc = (ProjectCell)it.next();
                if (pc.owner.length() != 0) continue;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "A more recent version of this cell is in the repository.  Do an update first.", "Check-Out Error", 0);
                pl.releaseProjectFileLock(true);
                return false;
            }
            it = newerProjectCells.iterator();
            while (it.hasNext()) {
                pc = (ProjectCell)it.next();
                if (pc.owner.equals(Project.getCurrentUserName())) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "You already checked-out this cell, but the changes are not in the current library.  Checking it out again.", "Check-Out Warning", 2);
                    pl.removeProjectCell(pc);
                    if (pc.cell == null) continue;
                    pl.byCell.remove(pc.cell);
                    continue;
                }
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot check-out cell.  It is checked-out to '" + pc.owner + "'", "Check-Out Error", 0);
                pl.releaseProjectFileLock(true);
                return false;
            }
            Cell newVers = null;
            boolean worked = false;
            ProjectCell pc2 = (ProjectCell)pl.byCell.get(this.oldVers);
            if (pc2 == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is not in the project.  You must add it to the project before being able to check it out and in.", "Check Out Error", 0);
            } else if (pc2.owner.length() != 0) {
                if (pc2.owner.equals(Project.getCurrentUserName())) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is already checked out to you.", "Check Out Error", 0);
                    Project.markLocked(this.oldVers, false);
                } else {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot check this cell out because it is already checked out to '" + pc2.owner + "'", "Check Out Error", 0);
                }
            } else if (pc2.cellVersion > this.oldVers.getVersion()) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot check out " + this.oldVers + " because you don't have the latest version (yours is " + this.oldVers.getVersion() + ", project has " + pc2.cellVersion + ").  Do an 'update' first", "Check Out Error", 0);
            } else {
                Project.setChangeStatus(true);
                newVers = Cell.copyNodeProto(this.oldVers, lib, this.oldVers.getName(), true);
                if (newVers == null) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error making new version of cell", "Check Out Error", 0);
                } else if (Project.useNewestVersion(this.oldVers, newVers)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error replacing instances of new " + this.oldVers, "Check Out Error", 0);
                } else {
                    ProjectCell newPC = new ProjectCell();
                    newPC.cell = newVers;
                    newPC.latestVersion = true;
                    newPC.cellName = pc2.cellName;
                    newPC.cellVersion = newVers.getVersion();
                    newPC.cellView = pc2.cellView;
                    newPC.comment = "CHECKED OUT";
                    newPC.lastOwner = "";
                    newPC.libType = pc2.libType;
                    newPC.owner = Project.getCurrentUserName();
                    newPC.projLib = pl;
                    pc2.latestVersion = false;
                    pc2.cell = null;
                    pl.byCell.remove(this.oldVers);
                    pl.byCell.put(newVers, newPC);
                    pl.addProjectCell(newPC);
                    Project.markLocked(newVers, false);
                    worked = true;
                }
                lib.setChangedMajor();
                lib.setChangedMinor();
                Project.setChangeStatus(false);
            }
            pl.releaseProjectFileLock(true);
            if (worked) {
                String owner;
                GenMath.MutableInteger val;
                Cell cell;
                Iterator cIt;
                Library oLib;
                System.out.println("Cell " + newVers.describe(true) + " checked out for your use");
                HashMap<Cell, GenMath.MutableInteger> cellsMarked = new HashMap<Cell, GenMath.MutableInteger>();
                Iterator it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library oLib2 = (Library)it2.next();
                    Iterator cIt2 = oLib2.getCells();
                    while (cIt2.hasNext()) {
                        Cell cell2 = (Cell)cIt2.next();
                        cellsMarked.put(cell2, new GenMath.MutableInteger(0));
                    }
                }
                GenMath.MutableInteger miNewVers = (GenMath.MutableInteger)cellsMarked.get(newVers);
                miNewVers.setValue(1);
                boolean propagated = true;
                while (propagated) {
                    propagated = false;
                    Iterator it3 = Library.getLibraries();
                    while (it3.hasNext()) {
                        Library oLib3 = (Library)it3.next();
                        Iterator cIt3 = oLib3.getCells();
                        while (cIt3.hasNext()) {
                            Cell cell3 = (Cell)cIt3.next();
                            GenMath.MutableInteger val2 = (GenMath.MutableInteger)cellsMarked.get(cell3);
                            if (val2.intValue() != 1) continue;
                            propagated = true;
                            val2.setValue(2);
                            Iterator nIt = cell3.getInstancesOf();
                            while (nIt.hasNext()) {
                                NodeInst ni = (NodeInst)nIt.next();
                                GenMath.MutableInteger pVal = (GenMath.MutableInteger)cellsMarked.get(ni.getParent());
                                if (pVal.intValue() != 0) continue;
                                pVal.setValue(1);
                            }
                        }
                    }
                }
                miNewVers.setValue(0);
                int total = 0;
                Iterator it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    oLib = (Library)it4.next();
                    cIt = oLib.getCells();
                    while (cIt.hasNext()) {
                        cell = (Cell)cIt.next();
                        val = (GenMath.MutableInteger)cellsMarked.get(cell);
                        if (val.intValue() == 0 || Project.getCellStatus(cell) != 3) continue;
                        val.setValue(3);
                        ++total;
                    }
                }
                if (total != 0) {
                    System.out.println("*** Warning: the following cells are above this in the hierarchy");
                    System.out.println("*** and are checked out to others.  This may cause problems");
                    it4 = Library.getLibraries();
                    while (it4.hasNext()) {
                        oLib = (Library)it4.next();
                        cIt = oLib.getCells();
                        while (cIt.hasNext()) {
                            cell = (Cell)cIt.next();
                            val = (GenMath.MutableInteger)cellsMarked.get(cell);
                            if (val.intValue() != 3) continue;
                            System.out.println("    " + cell + " is checked out to " + Project.getCellOwner(cell));
                        }
                    }
                }
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    oLib = (Library)it4.next();
                    cIt = oLib.getCells();
                    while (cIt.hasNext()) {
                        cell = (Cell)cIt.next();
                        val = (GenMath.MutableInteger)cellsMarked.get(cell);
                        val.setValue(0);
                    }
                }
                miNewVers.setValue(1);
                propagated = true;
                while (propagated) {
                    propagated = false;
                    it4 = Library.getLibraries();
                    while (it4.hasNext()) {
                        oLib = (Library)it4.next();
                        cIt = oLib.getCells();
                        while (cIt.hasNext()) {
                            cell = (Cell)cIt.next();
                            val = (GenMath.MutableInteger)cellsMarked.get(cell);
                            if (val.intValue() != 1) continue;
                            propagated = true;
                            val.setValue(2);
                            Iterator nIt = cell.getNodes();
                            while (nIt.hasNext()) {
                                GenMath.MutableInteger subVal;
                                NodeInst ni = (NodeInst)nIt.next();
                                if (!(ni.getProto() instanceof Cell) || (subVal = (GenMath.MutableInteger)cellsMarked.get(ni.getProto())).intValue() != 0) continue;
                                subVal.setValue(1);
                            }
                        }
                    }
                }
                miNewVers.setValue(0);
                total = 0;
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    oLib = (Library)it4.next();
                    cIt = oLib.getCells();
                    while (cIt.hasNext()) {
                        cell = (Cell)cIt.next();
                        val = (GenMath.MutableInteger)cellsMarked.get(cell);
                        if (val.intValue() == 0 || (owner = Project.getCellOwner(cell)).length() == 0 || owner.equals(Project.getCurrentUserName())) continue;
                        val.setValue(3);
                        ++total;
                    }
                }
                if (total != 0) {
                    System.out.println("*** Warning: the following cells are below this in the hierarchy");
                    System.out.println("*** and are checked out to others.  This may cause problems");
                    it4 = Library.getLibraries();
                    while (it4.hasNext()) {
                        oLib = (Library)it4.next();
                        cIt = oLib.getCells();
                        while (cIt.hasNext()) {
                            cell = (Cell)cIt.next();
                            val = (GenMath.MutableInteger)cellsMarked.get(cell);
                            if (val.intValue() != 3) continue;
                            owner = Project.getCellOwner(cell);
                            System.out.println("    " + cell + " is checked out to " + owner);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static class UndoBatchesJob
    extends Job {
        private int lowestBatch;
        private String errorMsg;

        protected UndoBatchesJob(int lowestBatch, String errorMsg) {
            super("Undo changes to locked cells", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lowestBatch = lowestBatch;
            this.errorMsg = errorMsg;
            this.startJob();
        }

        public boolean doIt() {
            Undo.ChangeBatch batch;
            System.out.println("Cannot change unchecked-out cells: " + this.errorMsg);
            ignoreChanges = true;
            while ((batch = Undo.undoABatch()) != null && batch.getBatchNumber() != this.lowestBatch) {
            }
            Undo.noRedoAllowed();
            ignoreChanges = false;
            return true;
        }
    }

    private static class ProjectLibrary {
        String projDirectory;
        Library lib;
        List allCells = new ArrayList();
        HashMap byCell = new HashMap();
        RandomAccessFile raf;
        FileLock lock;

        private ProjectLibrary() {
        }

        private void addProjectCell(ProjectCell pc) {
            this.allCells.add(pc);
            Collections.sort(this.allCells, new OrderedProjectCells());
        }

        private void removeProjectCell(ProjectCell pc) {
            this.allCells.remove(pc);
            Collections.sort(this.allCells, new OrderedProjectCells());
        }

        private static ProjectLibrary findProjectLibrary(Library lib) {
            ProjectLibrary pl = (ProjectLibrary)libraryProjectInfo.get(lib);
            if (pl != null) {
                return pl;
            }
            pl = ProjectLibrary.createProject(lib);
            libraryProjectInfo.put(lib, pl);
            return pl;
        }

        private ProjectCell findProjectCellByNameView(String name, View view) {
            Iterator it = this.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                if (!pc.cellName.equals(name) || pc.cellView != view) continue;
                return pc;
            }
            return null;
        }

        private ProjectCell findProjectCellByNameViewVersion(String name, View view, int version) {
            Iterator it = this.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                if (!pc.cellName.equals(name) || pc.cellView != view || pc.cellVersion != version) continue;
                return pc;
            }
            return null;
        }

        private static ProjectLibrary createProject(Library lib) {
            ProjectLibrary pl = new ProjectLibrary();
            pl.lib = lib;
            Variable var = lib.getVar(PROJPATHKEY);
            if (var == null) {
                return pl;
            }
            URL url = TextUtils.makeURLToFile((String)var.getObject());
            if (!TextUtils.URLExists(url)) {
                url = null;
                if (Project.getRepositoryLocation().length() > 0 && !TextUtils.URLExists(url = TextUtils.makeURLToFile(Project.getRepositoryLocation() + File.separator + lib.getName() + File.separator + Project.PROJECTFILE))) {
                    url = null;
                }
                if (url == null) {
                    String userFile = OpenFile.chooseInputFile(FileType.PROJECT, "Find Project File for " + lib);
                    if (userFile == null) {
                        return pl;
                    }
                    url = TextUtils.makeURLToFile(userFile);
                }
            }
            String projectFile = url.getFile();
            String projDir = "";
            int sepPos = projectFile.lastIndexOf(47);
            if (sepPos >= 0) {
                projDir = projectFile.substring(0, sepPos);
            }
            try {
                pl.raf = new RandomAccessFile(projectFile, "r");
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot read file: " + projectFile);
                return pl;
            }
            if (Project.getRepositoryLocation().length() == 0) {
                int nextSepPos;
                String repositoryLocation = null;
                if (sepPos > 1 && (nextSepPos = projectFile.lastIndexOf(47, sepPos - 1)) >= 0) {
                    repositoryLocation = projectFile.substring(0, nextSepPos);
                }
                if (repositoryLocation == null) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "You should setup Project Management by choosing a Repository location.  Use the 'Project Management' tab under General Preferences", "Setup Project Management", 1);
                } else {
                    Project.setRepositoryLocation(repositoryLocation);
                }
            }
            pl.projDirectory = projDir;
            pl.loadProjectFile();
            try {
                pl.raf.close();
            }
            catch (IOException e) {
                System.out.println("Error closing project file");
            }
            pl.raf = null;
            return pl;
        }

        private boolean lockProjectFile() {
            if (this.tryLockProjectFile()) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot lock the project file.  It may be in use by another user, or it may be damaged.", "Internal Error", 0);
                return true;
            }
            return false;
        }

        private boolean tryLockProjectFile() {
            String projectFile = this.projDirectory + File.separator + Project.PROJECTFILE;
            try {
                this.raf = new RandomAccessFile(projectFile, "rw");
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot read file " + projectFile);
                return true;
            }
            FileChannel fc = this.raf.getChannel();
            try {
                this.lock = fc.lock();
            }
            catch (IOException e1) {
                System.out.println("Unable to lock project file");
                try {
                    this.raf.close();
                }
                catch (IOException e2) {
                    System.out.println("Unable to close project file");
                }
                this.raf = null;
                return true;
            }
            if (this.loadProjectFile()) {
                try {
                    this.lock.release();
                    this.raf.close();
                }
                catch (IOException e) {
                    System.out.println("Unable to release project file lock");
                }
                this.raf = null;
                return true;
            }
            return false;
        }

        private void releaseProjectFileLock(boolean save) {
            if (save) {
                FileChannel fc = this.raf.getChannel();
                try {
                    fc.position(0L);
                    fc.truncate(0L);
                    Iterator it = this.allCells.iterator();
                    while (it.hasNext()) {
                        ProjectCell pc = (ProjectCell)it.next();
                        String line = "::" + pc.cellName + ":" + pc.cellVersion + "-" + pc.cellView.getFullName() + "." + pc.libType.getExtensions()[0] + ":" + pc.owner + ":" + pc.lastOwner + ":" + pc.comment + "\n";
                        ByteBuffer bb = ByteBuffer.wrap(line.getBytes());
                        fc.write(bb);
                    }
                }
                catch (IOException e) {
                    System.out.println("Error saving project file");
                }
            }
            try {
                this.lock.release();
                this.raf.close();
            }
            catch (IOException e) {
                System.out.println("Unable to unlock and close project file");
                this.lock = null;
            }
        }

        private boolean loadProjectFile() {
            String cellEntry;
            this.allCells.clear();
            this.byCell.clear();
            int[] colonPos = new int[6];
            while (true) {
                String userLine = null;
                try {
                    userLine = this.raf.readLine();
                }
                catch (IOException e) {
                    userLine = null;
                }
                if (userLine == null) break;
                ProjectCell pc = new ProjectCell();
                pc.projLib = this;
                int prevPos = 0;
                for (int i = 0; i < 6; ++i) {
                    colonPos[i] = userLine.indexOf(58, prevPos);
                    prevPos = colonPos[i] + 1;
                    if (prevPos > 0) continue;
                    System.out.println("Too few keywords in project file: " + userLine);
                    return true;
                }
                if (colonPos[0] != 0) {
                    System.out.println("Missing initial ':' in project file: " + userLine);
                    return true;
                }
                pc.cellName = userLine.substring(colonPos[1] + 1, colonPos[2]);
                String section = userLine.substring(colonPos[2] + 1, colonPos[3]);
                int dashPos = section.indexOf(45);
                if (dashPos < 0) {
                    System.out.println("Missing '-' after version number in project file: " + userLine);
                    return true;
                }
                int dotPos = section.indexOf(46);
                if (dotPos < 0) {
                    System.out.println("Missing '.' after view type in project file: " + userLine);
                    return true;
                }
                pc.cellVersion = TextUtils.atoi(section.substring(0, dashPos));
                String viewPart = section.substring(dashPos + 1, dotPos);
                pc.cellView = View.findView(viewPart);
                String fileType = section.substring(dotPos + 1);
                if (fileType.equals("elib")) {
                    pc.libType = FileType.ELIB;
                } else if (fileType.equals("jelib")) {
                    pc.libType = FileType.JELIB;
                } else if (fileType.equals("txt")) {
                    pc.libType = FileType.READABLEDUMP;
                } else {
                    System.out.println("Unknown library type in project file: " + userLine);
                    return true;
                }
                pc.owner = userLine.substring(colonPos[3] + 1, colonPos[4]);
                pc.lastOwner = userLine.substring(colonPos[4] + 1, colonPos[5]);
                pc.comment = userLine.substring(colonPos[5] + 1);
                Iterator it = this.allCells.iterator();
                while (it.hasNext()) {
                    ProjectCell opc = (ProjectCell)it.next();
                    if (!opc.cellName.equalsIgnoreCase(pc.cellName) || opc.cellView != pc.cellView || opc.cellVersion != pc.cellVersion) continue;
                    System.out.println("Error in project file: version " + pc.cellVersion + ", view '" + pc.cellView.getFullName() + "' of cell '" + pc.cellName + "' exists twice");
                }
                pc.latestVersion = false;
                String cellName = pc.describeWithVersion();
                pc.cell = this.lib.findNodeProto(cellName);
                if (pc.cell != null) {
                    if (pc.cell.getVersion() > pc.cellVersion && !pc.owner.equals(Project.getCurrentUserName())) {
                        if (pc.owner.length() == 0) {
                            System.out.println("WARNING: " + pc.cell + " is being edited, but it is not checked-out");
                        } else {
                            System.out.println("WARNING: " + pc.cell + " is being edited, but it is checked-out to " + pc.owner);
                        }
                    }
                    this.byCell.put(pc.cell, pc);
                }
                this.allCells.add(pc);
            }
            HashMap<String, ProjectCell> mostRecent = new HashMap<String, ProjectCell>();
            Iterator it = this.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                cellEntry = pc.describe();
                ProjectCell recent = (ProjectCell)mostRecent.get(cellEntry);
                if (recent != null && recent.cellVersion > pc.cellVersion) continue;
                mostRecent.put(cellEntry, pc);
            }
            it = this.allCells.iterator();
            while (it.hasNext()) {
                ProjectCell pc = (ProjectCell)it.next();
                cellEntry = pc.describe();
                ProjectCell recent = (ProjectCell)mostRecent.get(cellEntry);
                pc.latestVersion = recent == pc;
            }
            return false;
        }
    }

    private static class ProjectCell {
        String cellName;
        View cellView;
        int cellVersion;
        FileType libType;
        Cell cell;
        boolean latestVersion;
        String checkInDate;
        String owner;
        String lastOwner;
        String comment;
        ProjectLibrary projLib;

        private ProjectCell() {
        }

        private static ProjectCell findProjectCell(Cell cell) {
            ProjectLibrary pl = ProjectLibrary.findProjectLibrary(cell.getLibrary());
            ProjectCell pc = (ProjectCell)pl.byCell.get(cell);
            return pc;
        }

        private String describe() {
            String cn = this.cellName;
            if (this.cellView != View.UNKNOWN) {
                cn = cn + "{" + this.cellView.getAbbreviation() + "}";
            }
            return cn;
        }

        private String describeWithVersion() {
            String cn = this.cellName + ";" + this.cellVersion;
            if (this.cellView != View.UNKNOWN) {
                cn = cn + "{" + this.cellView.getAbbreviation() + "}";
            }
            return cn;
        }
    }

    private static class FCheck {
        Cell entry;
        int batchNumber;

        private FCheck() {
        }
    }
}

