/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.LayerTab;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WindowFrame
extends Observable {
    private WindowContent content;
    private JSplitPane js;
    private JInternalFrame jif = null;
    private TopLevel jf = null;
    private InternalWindowsEvents internalWindowsEvents;
    private WindowsEvents windowsEvents;
    private JTabbedPane sideBar;
    private boolean sideBarOnLeft;
    private ExplorerTree explorerTab;
    private PaletteFrame paletteTab;
    private LayerTab layersTab;
    public DefaultMutableTreeNode rootNode;
    public DefaultMutableTreeNode libraryExplorerNode;
    public DefaultMutableTreeNode jobExplorerNode;
    public DefaultMutableTreeNode errorExplorerNode;
    public DefaultMutableTreeNode signalExplorerNode;
    public DefaultMutableTreeNode sweepExplorerNode;
    private DefaultTreeModel treeModel;
    private boolean finished = false;
    private static int windowOffset = 0;
    private static List windowList = new ArrayList();
    private static WindowFrame curWindowFrame = null;
    public static MouseListener curMouseListener = ClickZoomWireListener.theOne;
    public static MouseMotionListener curMouseMotionListener = ClickZoomWireListener.theOne;
    public static MouseWheelListener curMouseWheelListener = ClickZoomWireListener.theOne;
    public static KeyListener curKeyListener = ClickZoomWireListener.theOne;
    private static LibraryTreeUpdater libTreeUpdater = new LibraryTreeUpdater();
    private static final int WINDOW_OFFSET = 0;
    private boolean wantToRedoLibraryTree = false;
    private boolean wantToRedoJobTree = false;
    private boolean wantToRedoErrorTree = false;
    private boolean wantToRedoSignalTree = false;

    public static WindowFrame createEditWindow(final Cell cell) {
        final WindowFrame frame = new WindowFrame();
        if (cell != null && cell.getView().isTextView()) {
            TextWindow tWnd = new TextWindow(cell, frame);
            frame.finishWindowFrameInformation(tWnd, cell);
            tWnd.fillScreen();
        } else {
            EditWindow eWnd = EditWindow.CreateElectricDoc(cell, frame);
            Dimension sz = frame.finishWindowFrameInformation(eWnd, cell);
            eWnd.setScreenSize(sz);
            eWnd.repaintContents(null);
            eWnd.fillScreen();
        }
        WindowFrame.removeUIBinding(frame.js, KeyStroke.getKeyStroke(117, 0));
        WindowFrame.removeUIBinding(frame.js, KeyStroke.getKeyStroke(119, 0));
        if (cell != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    frame.openLibraryInExplorerTree(cell.getLibrary(), new TreePath(frame.rootNode), true);
                }
            });
        }
        return frame;
    }

    public Dimension finishWindowFrameInformation(WindowContent wnd, Cell cell) {
        Dimension sz = this.buildWindowStructure(wnd, cell, null);
        WindowFrame.setCurrentWindowFrame(this);
        this.populateJFrame();
        return sz;
    }

    public static void show3DHighlight() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.setChanged();
            wf.notifyObservers(wf.getContent());
            wf.clearChanged();
        }
    }

    public static WindowFrame createWaveformWindow(Stimuli sd) {
        WindowFrame frame = new WindowFrame();
        WaveformWindow wWnd = new WaveformWindow(sd, frame);
        frame.finishWindowFrameInformation(wWnd, sd.getCell());
        wWnd.fillScreen();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowFrame.wantToOpenCurrentLibrary(false);
            }
        });
        return frame;
    }

    public static void updateTechnologyLists() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.paletteTab.loadTechnologies(false);
            wf.layersTab.loadTechnologies(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension buildWindowStructure(WindowContent content, Cell cell, GraphicsConfiguration gc) {
        this.content = content;
        this.rootNode = new DefaultMutableTreeNode("Explorer");
        content.loadExplorerTree(this.rootNode);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.explorerTab = ExplorerTree.CreateExplorerTree(this.rootNode, this.treeModel);
        JScrollPane scrolledTree = new JScrollPane(this.explorerTab);
        this.sideBar = new JTabbedPane();
        if (TopLevel.getOperatingSystem() == TopLevel.OS.MACINTOSH) {
            this.sideBar.setTabPlacement(2);
        }
        this.paletteTab = PaletteFrame.newInstance(this);
        this.layersTab = new LayerTab(this);
        this.loadComponentMenuForTechnology();
        this.sideBar.add("Components", this.paletteTab.getTechPalette());
        this.sideBar.add("Explorer", scrolledTree);
        this.sideBar.add("Layers", this.layersTab.getContentPane());
        this.sideBar.setSelectedIndex(User.getDefaultWindowTab());
        this.sideBar.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JTabbedPane tp = (JTabbedPane)evt.getSource();
                User.setDefaultWindowTab(tp.getSelectedIndex());
            }
        });
        String cellDescription = cell == null ? "no cell" : cell.describe(false);
        Dimension sz = this.createJFrame(cellDescription, gc);
        if ((windowOffset += 70) > 300) {
            windowOffset = 0;
        }
        this.js = new JSplitPane(1);
        boolean bl = this.sideBarOnLeft = !User.isSideBarOnRight();
        if (this.sideBarOnLeft) {
            this.js.setLeftComponent(this.sideBar);
            this.js.setRightComponent(content.getPanel());
            this.js.setDividerLocation(200);
        } else {
            this.js.setLeftComponent(content.getPanel());
            this.js.setRightComponent(this.sideBar);
            this.js.setDividerLocation(sz.width - 200);
        }
        List list = windowList;
        synchronized (list) {
            windowList.add(this);
        }
        return sz;
    }

    private Dimension createJFrame(String title, GraphicsConfiguration gc) {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension frameSize = new Dimension(scrnSize.width * 4 / 5, scrnSize.height * 6 / 8);
        if (TopLevel.isMDIMode()) {
            this.jif = new JInternalFrame(title, true, true, true, true);
            this.jif.setSize(frameSize);
            this.jif.setLocation(windowOffset + 0, windowOffset);
            this.jif.setAutoscrolls(true);
            this.jif.setFrameIcon(TopLevel.getFrameIcon());
        } else {
            this.jf = new TopLevel("Electric - " + title, new Rectangle(frameSize), this, gc);
            this.jf.setSize(frameSize);
            this.jf.setLocation(windowOffset + 0, windowOffset);
        }
        return frameSize;
    }

    public void loadComponentMenuForTechnology() {
        Technology tech = Technology.getCurrent();
        if (this.content.getCell() != null) {
            tech = this.content.getCell().getTechnology();
        }
        this.paletteTab.loadForTechnology(tech, this);
        this.layersTab.showLayersForTechnology(tech);
    }

    private void populateJFrame() {
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().add(this.js);
            this.internalWindowsEvents = new InternalWindowsEvents(this);
            this.jif.addInternalFrameListener(this.internalWindowsEvents);
            this.jif.addInternalFrameListener(TopLevel.getCurrentJFrame().getToolBar());
            this.content.getPanel().addPropertyChangeListener("GoBackEnabled", TopLevel.getCurrentJFrame().getToolBar());
            this.content.getPanel().addPropertyChangeListener("GoForwardEnabled", TopLevel.getCurrentJFrame().getToolBar());
            TopLevel.addToDesktop(this.jif);
        } else {
            this.jf.getContentPane().add(this.js);
            this.windowsEvents = new WindowsEvents(this);
            this.jf.addWindowListener(this.windowsEvents);
            this.jf.addWindowFocusListener(this.windowsEvents);
            this.jf.setWindowFrame(this);
            this.content.getPanel().addPropertyChangeListener("GoBackEnabled", this.jf.getToolBar());
            this.content.getPanel().addPropertyChangeListener("GoForwardEnabled", this.jf.getToolBar());
            if (!Main.BATCHMODE) {
                this.jf.setVisible(true);
            }
        }
    }

    private void depopulateJFrame() {
        Job.checkSwingThread();
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().remove(this.js);
            this.jif.removeInternalFrameListener(this.internalWindowsEvents);
            this.jif.removeInternalFrameListener(TopLevel.getCurrentJFrame().getToolBar());
            this.content.getPanel().removePropertyChangeListener(TopLevel.getCurrentJFrame().getToolBar());
        } else {
            this.jf.getContentPane().remove(this.js);
            this.jf.removeWindowListener(this.windowsEvents);
            this.jf.removeWindowFocusListener(this.windowsEvents);
            this.jf.setWindowFrame(null);
            this.content.getPanel().removePropertyChangeListener("GoBackEnabled", this.jf.getToolBar());
            this.content.getPanel().removePropertyChangeListener("GoForwardEnabled", this.jf.getToolBar());
        }
    }

    public void setCellWindow(Cell cell) {
        if (cell != null && cell.getView().isTextView()) {
            if (!(this.getContent() instanceof TextWindow)) {
                this.getContent().finished();
                this.content = new TextWindow(cell, this);
                int i = this.js.getDividerLocation();
                if (this.sideBarOnLeft) {
                    this.js.setRightComponent(this.content.getPanel());
                } else {
                    this.js.setLeftComponent(this.content.getPanel());
                }
                this.js.setDividerLocation(i);
                this.content.fillScreen();
                return;
            }
        } else if (!(this.getContent() instanceof EditWindow)) {
            this.getContent().finished();
            this.content = EditWindow.CreateElectricDoc(cell, this);
            int i = this.js.getDividerLocation();
            if (this.sideBarOnLeft) {
                this.js.setRightComponent(this.content.getPanel());
            } else {
                this.js.setLeftComponent(this.content.getPanel());
            }
            this.js.setDividerLocation(i);
            this.content.fillScreen();
            return;
        }
        this.content.setCell(cell, VarContext.globalContext);
        this.currentCellChanged();
    }

    public void moveEditWindow(GraphicsConfiguration gc) {
        if (TopLevel.isMDIMode()) {
            return;
        }
        this.jf.setVisible(false);
        this.depopulateJFrame();
        TopLevel oldFrame = this.jf;
        oldFrame.finished();
        Cell cell = this.content.getCell();
        String cellDescription = cell == null ? "no cell" : cell.describe(false);
        this.createJFrame(cellDescription, gc);
        this.populateJFrame();
        this.content.fireCellHistoryStatus();
    }

    public static void wantToOpenCurrentLibrary(boolean openLib) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.openLibraryInExplorerTree(Library.getCurrent(), new TreePath(wf.rootNode), openLib);
        }
    }

    public void openLibraryInExplorerTree(Library library, TreePath path, boolean openLib) {
        String msg;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        int numChildren = node.getChildCount();
        if (numChildren == 0) {
            return;
        }
        if (openLib && obj instanceof Library) {
            Library lib = (Library)obj;
            if (lib == library) {
                this.explorerTab.expandPath(path);
            }
        } else if (obj instanceof String && ((msg = (String)obj).equalsIgnoreCase("libraries") && openLib || msg.equalsIgnoreCase("signals") && !openLib)) {
            this.explorerTab.expandPath(path);
        }
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            TreePath descentPath = path.pathByAddingChild(child);
            if (descentPath == null) continue;
            this.openLibraryInExplorerTree(library, descentPath, openLib);
        }
    }

    public static void wantToRedoLibraryTree() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.wantToRedoLibraryTree = true;
            wf.redoExplorerTreeIfRequested();
        }
    }

    public static void wantToRedoJobTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.wantToRedoJobTree();
                }
            });
            return;
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.wantToRedoJobTree = true;
            wf.redoExplorerTreeIfRequested();
        }
    }

    public static void wantToRedoErrorTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.wantToRedoErrorTree();
                }
            });
            return;
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.wantToRedoErrorTree = true;
            wf.redoExplorerTreeIfRequested();
        }
    }

    public void wantToRedoSignalTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.this.wantToRedoSignalTree();
                }
            });
            return;
        }
        this.wantToRedoSignalTree = true;
        this.content.loadExplorerTree(this.rootNode);
        this.redoExplorerTreeIfRequested();
    }

    private void redoExplorerTreeIfRequested() {
        Job.checkSwingThread();
        if (!(this.wantToRedoLibraryTree || this.wantToRedoJobTree || this.wantToRedoErrorTree || this.wantToRedoSignalTree)) {
            return;
        }
        HashSet expanded = new HashSet();
        this.recursivelyCache(expanded, new TreePath(this.rootNode), true);
        if (this.wantToRedoLibraryTree) {
            this.libraryExplorerNode = ExplorerTree.makeLibraryTree();
        }
        if (this.wantToRedoJobTree) {
            this.jobExplorerNode = Job.getExplorerTree();
        }
        if (this.wantToRedoErrorTree) {
            this.errorExplorerNode = ErrorLogger.getExplorerTree();
        }
        this.wantToRedoSignalTree = false;
        this.wantToRedoErrorTree = false;
        this.wantToRedoJobTree = false;
        this.wantToRedoLibraryTree = false;
        this.rootNode.removeAllChildren();
        if (this.libraryExplorerNode != null) {
            this.rootNode.add(this.libraryExplorerNode);
        }
        if (this.signalExplorerNode != null) {
            this.rootNode.add(this.signalExplorerNode);
        }
        if (this.sweepExplorerNode != null) {
            this.rootNode.add(this.sweepExplorerNode);
        }
        this.rootNode.add(this.jobExplorerNode);
        this.rootNode.add(this.errorExplorerNode);
        this.explorerTab.treeDidChange();
        this.treeModel.reload();
        this.recursivelyCache(expanded, new TreePath(this.rootNode), false);
    }

    private void recursivelyCache(HashSet expanded, TreePath path, boolean cache) {
        Object obj;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        int numChildren = node.getChildCount();
        if (numChildren == 0) {
            return;
        }
        if (cache) {
            if (this.explorerTab.isExpanded(path)) {
                obj = this.getProperTreeObject(node);
                expanded.add(obj);
            } else {
                numChildren = 0;
            }
        } else {
            obj = this.getProperTreeObject(node);
            if (expanded.contains(obj)) {
                this.explorerTab.expandPath(path);
            } else {
                numChildren = 0;
            }
        }
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            TreePath descentPath = path.pathByAddingChild(child);
            if (descentPath == null) continue;
            this.recursivelyCache(expanded, descentPath, cache);
        }
    }

    private Object getProperTreeObject(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof String) {
            Object parentObj;
            DefaultMutableTreeNode climb = node;
            while ((climb = (DefaultMutableTreeNode)climb.getParent()) != null && (parentObj = climb.getUserObject()) instanceof String) {
                obj = (String)parentObj + "." + (String)obj;
            }
        }
        return obj;
    }

    public static void setSideBarLocation(boolean onLeft) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf.sideBarOnLeft == onLeft) {
            return;
        }
        wf.sideBarOnLeft = onLeft;
        wf.js.setLeftComponent(null);
        wf.js.setRightComponent(null);
        Dimension sz = wf.js.getSize();
        int loc = sz.width - wf.js.getDividerLocation();
        wf.js.setDividerLocation(loc);
        if (onLeft) {
            wf.js.setLeftComponent(wf.sideBar);
            wf.js.setRightComponent(wf.content.getPanel());
        } else {
            wf.js.setLeftComponent(wf.content.getPanel());
            wf.js.setRightComponent(wf.sideBar);
        }
    }

    public WindowContent getContent() {
        return this.content;
    }

    public static WindowFrame getCurrentWindowFrame() {
        return WindowFrame.getCurrentWindowFrame(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowFrame getCurrentWindowFrame(boolean makeNewFrame) {
        List list = windowList;
        synchronized (list) {
            if (curWindowFrame == null && makeNewFrame) {
                Iterator it = windowList.iterator();
                while (it.hasNext()) {
                    curWindowFrame = (WindowFrame)it.next();
                }
                if (curWindowFrame == null) {
                    curWindowFrame = WindowFrame.createEditWindow(null);
                }
            }
            return curWindowFrame;
        }
    }

    public static void setListener(EventListener listener) {
        curMouseListener = (MouseListener)listener;
        curMouseMotionListener = (MouseMotionListener)listener;
        curMouseWheelListener = (MouseWheelListener)listener;
        curKeyListener = (KeyListener)listener;
    }

    public static EventListener getListener() {
        return curMouseListener;
    }

    public static Cell getCurrentCell() {
        if (Main.BATCHMODE) {
            Library lib = Library.getCurrent();
            if (lib == null) {
                return null;
            }
            return lib.getCurCell();
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf == null) {
            return null;
        }
        return wf.getContent().getCell();
    }

    public static Cell needCurCell() {
        Cell curCell = WindowFrame.getCurrentCell();
        if (curCell == null) {
            System.out.println("There is no current cell for this operation.  To create one, use the 'New Cell' command from the 'Cell' menu.");
        }
        return curCell;
    }

    public void setCursor(Cursor cursor) {
        if (!TopLevel.isMDIMode()) {
            this.jf.setCursor(cursor);
        }
        this.js.setCursor(cursor);
        this.content.getPanel().setCursor(cursor);
    }

    public static void removeLibraryReferences(Library lib) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            Cell cell = content.getCell();
            if (cell != null && cell.getLibrary() == lib) {
                content.setCell(null, null);
            }
            content.fullRepaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCurrentWindowFrame(WindowFrame wf) {
        List list = windowList;
        synchronized (list) {
            if (wf.finished) {
                return;
            }
            curWindowFrame = wf;
            windowList.remove(wf);
            windowList.add(wf);
        }
        if (wf != null) {
            Highlighter highlighter;
            wf.currentCellChanged();
            if (wf.getContent() != null && (highlighter = wf.getContent().getHighlighter()) != null) {
                highlighter.gainedFocus();
            }
        }
        WindowFrame.wantToRedoTitleNames();
    }

    private void currentCellChanged() {
        if (this != WindowFrame.getCurrentWindowFrame(false)) {
            return;
        }
        Cell cell = this.getContent().getCell();
        if (cell != null) {
            cell.getLibrary().setCurCell(cell);
            WindowFrame.autoTechnologySwitch(cell, this);
        }
    }

    public static void wantToRedoTitleNames() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame w = (WindowFrame)it.next();
            WindowContent content = w.getContent();
            if (content == null) continue;
            content.setWindowTitle();
        }
    }

    public void setWindowSize(Rectangle frameRect) {
        Dimension frameSize = new Dimension(frameRect.width, frameRect.height);
        if (TopLevel.isMDIMode()) {
            this.jif.setSize(frameSize);
            this.jif.setLocation(frameRect.x, frameRect.y);
        } else {
            this.jf.setSize(frameSize);
            this.jf.setLocation(frameRect.x, frameRect.y);
            this.jf.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (TopLevel.isMDIMode()) {
            this.jif.setVisible(false);
        }
        List list = windowList;
        synchronized (list) {
            if (windowList.size() <= 1 && !TopLevel.isMDIMode() && TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
                FileMenu.quitCommand();
                return;
            }
            windowList.remove(this);
            this.finished = true;
            if (curWindowFrame == this) {
                curWindowFrame = null;
            }
        }
        this.content.finished();
        if (!TopLevel.isMDIMode()) {
            this.jf.finished();
        }
    }

    public WaveformWindow getWaveformWindow() {
        return (WaveformWindow)this.content;
    }

    public PaletteFrame getPaletteTab() {
        return this.paletteTab;
    }

    public LayerTab getLayersTab() {
        return this.layersTab;
    }

    public TopLevel getFrame() {
        if (TopLevel.isMDIMode()) {
            return TopLevel.getCurrentJFrame();
        }
        return this.jf;
    }

    public boolean generatedEvent(AWTEvent e) {
        if (e instanceof InternalFrameEvent) {
            JInternalFrame source = ((InternalFrameEvent)e).getInternalFrame();
            return source == this.jif;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumWindows() {
        List list = windowList;
        synchronized (list) {
            return windowList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getWindows() {
        ArrayList listCopy = new ArrayList();
        List list = windowList;
        synchronized (list) {
            listCopy.addAll(windowList);
        }
        return listCopy.iterator();
    }

    public String composeTitle(Cell cell, String prefix, int pageNo) {
        StringBuffer title = new StringBuffer();
        if (cell != null) {
            title.append(prefix + cell.libDescribe());
            if (cell.isMultiPage()) {
                title.append(" - Page " + (pageNo + 1));
            }
            if (cell.getLibrary() != Library.getCurrent()) {
                title.append(" - Current library: " + Library.getCurrent().getName());
            }
        } else {
            title.append("***NONE***");
        }
        return title.toString();
    }

    public void setTitle(String title) {
        String curTitle = this.getTitle();
        if (title.equals(curTitle)) {
            return;
        }
        if (TopLevel.isMDIMode()) {
            if (this.jif != null) {
                this.jif.setTitle(title);
            }
        } else if (this.jf != null) {
            this.jf.setTitle(title);
        }
    }

    public String getTitle() {
        if (TopLevel.isMDIMode()) {
            if (this.jif != null) {
                return this.jif.getTitle();
            }
        } else if (this.jf != null) {
            return this.jf.getTitle();
        }
        return "";
    }

    private static void removeUIBinding(JComponent comp, KeyStroke key) {
        WindowFrame.removeUIBinding(comp.getInputMap(1), key);
        WindowFrame.removeUIBinding(comp.getInputMap(0), key);
        WindowFrame.removeUIBinding(comp.getInputMap(2), key);
    }

    private static void removeUIBinding(InputMap map, KeyStroke key) {
        if (map == null) {
            return;
        }
        map.remove(key);
        WindowFrame.removeUIBinding(map.getParent(), key);
    }

    public static void autoTechnologySwitch(Cell cell, WindowFrame wf) {
        if (cell.getView().isTextView()) {
            return;
        }
        Technology tech = cell.getTechnology();
        if (tech != null && tech != Technology.getCurrent() && User.isAutoTechnologySwitch()) {
            tech.setCurrent();
            wf.getPaletteTab().setSelectedItem(tech.getTechName());
            wf.getLayersTab().setSelectedItem(tech.getTechName());
        }
    }

    private static class LibraryTreeUpdater
    implements DatabaseChangeListener {
        private LibraryTreeUpdater() {
            Undo.addDatabaseChangeListener(this);
        }

        private void updateLibraryTrees() {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame frame = (WindowFrame)it.next();
                frame.wantToRedoLibraryTree = true;
                frame.redoExplorerTreeIfRequested();
            }
        }

        public void databaseChanged(DatabaseChangeEvent e) {
            if (e.cellTreeChanged()) {
                this.updateLibraryTrees();
            }
        }
    }

    static class InternalWindowsEvents
    extends InternalFrameAdapter {
        WeakReference wf;

        InternalWindowsEvents(WindowFrame wf) {
            this.wf = new WeakReference<WindowFrame>(wf);
        }

        public void internalFrameClosing(InternalFrameEvent evt) {
            ((WindowFrame)this.wf.get()).finished();
        }

        public void internalFrameActivated(InternalFrameEvent evt) {
            WindowFrame.setCurrentWindowFrame((WindowFrame)this.wf.get());
        }
    }

    static class WindowsEvents
    extends WindowAdapter {
        WeakReference wf;

        WindowsEvents(WindowFrame wf) {
            this.wf = new WeakReference<WindowFrame>(wf);
        }

        public void windowActivated(WindowEvent evt) {
            WindowFrame.setCurrentWindowFrame((WindowFrame)this.wf.get());
        }

        public void windowClosing(WindowEvent evt) {
            ((WindowFrame)this.wf.get()).finished();
        }
    }

    public static class CurTechControlListener
    implements ActionListener {
        private WindowFrame wf;

        CurTechControlListener(WindowFrame wf) {
            this.wf = wf;
        }

        public void actionPerformed(ActionEvent evt) {
            JComboBox source = (JComboBox)evt.getSource();
            String techName = (String)source.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech != null) {
                tech.setCurrent();
                this.wf.getPaletteTab().loadForTechnology(tech, this.wf);
                this.wf.getLayersTab().showLayersForTechnology(tech);
            }
        }
    }
}

