/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.CellUsage;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareList
implements Iterable<CellContext> {
    private final List<CellContext> cellContexts = new ArrayList<CellContext>();
    private boolean safeToCheckSizes;

    private boolean hasSkipAnnotation(List<CellContext> cellCtxts) {
        for (CellContext cc : cellCtxts) {
            String reason;
            Cell c = cc.cell;
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
            if (ann == null || (reason = ann.getSkipReason()) == null) continue;
            System.out.println("Not checking: " + NccUtils.fullName(c) + " because it has a \"skipNCC\" annotation " + "with the comment: " + reason);
            return true;
        }
        return false;
    }

    private void purgeUnnecessaryDuplicateCells(List<CellContext> compareList) {
        HashSet<Cell> cells = new HashSet<Cell>();
        Iterator<CellContext> it = compareList.iterator();
        while (it.hasNext() && compareList.size() > 2) {
            Cell c = it.next().cell;
            if (cells.contains(c)) {
                it.remove();
                continue;
            }
            cells.add(c);
        }
    }

    private boolean safeToCompareSizes(List<CellContext> cellContexts, CellUsage use1, CellUsage use2) {
        for (CellContext cc : cellContexts) {
            Cell c = cc.cell;
            if (!c.isSchematic()) continue;
            if (use1.cellIsUsed(c) && !use1.cellHasOnlyOneSize(c)) {
                return false;
            }
            if (!use2.cellIsUsed(c) || use2.cellHasOnlyOneSize(c)) continue;
            return false;
        }
        return true;
    }

    public CompareList(Cell cell, CellUsage use1, CellUsage use2, Set<Cell.CellGroup> visitedGroups) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        Cell.CellGroup group = cell.getCellGroup();
        if (ann != null && ann.getGroupToJoin() != null) {
            group = ann.getGroupToJoin();
        }
        if (visitedGroups.contains(group)) {
            return;
        }
        visitedGroups.add(group);
        boolean used1 = false;
        boolean used2 = false;
        HashSet<CellContext> compareSet = new HashSet<CellContext>();
        Set<CellContext> additions = use1.getGroupAdditions(group);
        if (!additions.isEmpty()) {
            used1 = true;
            compareSet.addAll(additions);
        }
        if (!(additions = use2.getGroupAdditions(group)).isEmpty()) {
            used2 = true;
            compareSet.addAll(additions);
        }
        Iterator<Cell> gi = group.getCells();
        while (gi.hasNext()) {
            Cell c = gi.next();
            NccCellAnnotations a = NccCellAnnotations.getAnnotations(c);
            if (a != null && a.getGroupToJoin() != null && a.getGroupToJoin() != group) continue;
            if (use1.cellIsUsed(c)) {
                used1 = true;
                compareSet.add(use1.getCellContext(c));
            }
            if (use2.cellIsUsed(c)) {
                used2 = true;
                compareSet.add(use2.getCellContext(c));
            }
            if (c == use1.getRoot()) {
                compareSet.add(use2.getCellContext(use2.getRoot()));
                used2 = true;
                used1 = true;
            }
            if (c != use2.getRoot()) continue;
            compareSet.add(use1.getCellContext(use1.getRoot()));
            used2 = true;
            used1 = true;
        }
        Job.error(compareSet.size() == 0, "Cell not in its own group?");
        if (!used1 || !used2) {
            return;
        }
        this.cellContexts.addAll(compareSet);
        this.purgeUnnecessaryDuplicateCells(this.cellContexts);
        if (this.hasSkipAnnotation(this.cellContexts)) {
            this.cellContexts.clear();
        }
        this.safeToCheckSizes = this.safeToCompareSizes(this.cellContexts, use1, use2);
        Job.error(compareSet.size() < 2, "nothing to compare?");
    }

    public void printCells() {
        System.out.print("Compare List contains:=");
        for (CellContext cc : this) {
            System.out.print(" " + cc.cell.getName());
        }
        System.out.println();
    }

    @Override
    public Iterator<CellContext> iterator() {
        return this.cellContexts.iterator();
    }

    public boolean empty() {
        return this.cellContexts.size() == 0;
    }

    public boolean isSafeToCheckSizes() {
        return this.safeToCheckSizes;
    }
}

