/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class GDSLayers {
    public static final GDSLayers EMPTY = new GDSLayers(null);
    private Map<GDSLayerType, Integer> values = new HashMap<GDSLayerType, Integer>();

    public GDSLayers(int normalLayer, int normalType, int pinLayer, int pinType, int textLayer, int textType) {
        this.setLayerType(normalLayer, normalType, GDSLayerType.DRAWING);
        this.setLayerType(pinLayer, pinType, GDSLayerType.PIN);
        this.setLayerType(textLayer, textType, GDSLayerType.TEXT);
    }

    public GDSLayers(int[] vals) {
        if (vals == null) {
            return;
        }
        GDSLayerType[] list2 = GDSLayerType.values();
        int maxNumTypes = list2.length;
        assert (vals.length == maxNumTypes);
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == -1) continue;
            this.values.put(list2[i], vals[i]);
        }
    }

    public void setLayerType(int layerNum, int layerType, GDSLayerType type) {
        if (layerType != -1) {
            layerNum |= layerType << 16;
        }
        this.values.put(type, layerNum);
    }

    public boolean hasLayerType(GDSLayerType type) {
        return this.values.get((Object)type) != null;
    }

    public int getLayerNumber(GDSLayerType type) {
        Integer val = this.values.get((Object)type);
        assert (val != null);
        return val & 0xFFFF;
    }

    public int getLayerType(GDSLayerType type) {
        Integer val = this.values.get((Object)type);
        assert (val != null);
        return val >> 16 & 0xFFFF;
    }

    public int getLayer(GDSLayerType type) {
        return this.values.get((Object)type);
    }

    public String getString(GDSLayerType type) {
        return this.getString(type, false, false);
    }

    public String getString(GDSLayerType type, boolean preFix, boolean extension) {
        String s = "";
        Integer val = this.values.get((Object)type);
        if (val == null || val == -1) {
            return s;
        }
        if (preFix && type != GDSLayerType.DRAWING) {
            s = s + ",";
        }
        s = s + "" + this.getLayerNumber(type);
        int normalType = this.getLayerType(type);
        if (normalType != 0) {
            s = s + "/" + normalType;
        }
        if (extension && type != GDSLayerType.DRAWING) {
            s = s + type.getExtension();
        }
        return s;
    }

    public boolean equals(GDSLayers other) {
        if (other == null) {
            return false;
        }
        for (GDSLayerType t : GDSLayerType.values()) {
            if (this.values.get((Object)t) == other.values.get((Object)t)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (GDSLayerType t : GDSLayerType.values()) {
            if (this.values.get((Object)t) == null) continue;
            str.append(this.getString(t, true, true));
        }
        String s = str.toString();
        int index = s.indexOf(",");
        if (index == 0) {
            s = s.substring(1);
            System.out.println("Warning: No drawing value found for '" + s + "'");
        }
        return s;
    }

    public static GDSLayers parseLayerString(String string2) {
        if (string2.isEmpty()) {
            return null;
        }
        StringTokenizer parser = new StringTokenizer(string2, ",.[]", false);
        ArrayList<String> list2 = new ArrayList<String>();
        while (parser.hasMoreTokens()) {
            list2.add(parser.nextToken());
        }
        int maxNumTypes = GDSLayerType.values().length;
        assert (list2.size() > 0 && list2.size() <= maxNumTypes);
        int[] vals = new int[maxNumTypes];
        Arrays.fill(vals, 0, maxNumTypes, -1);
        int pos = -1;
        for (String s : list2) {
            int gdsVal = -1;
            int gdsType = -1;
            String trimmed = s.trim();
            char lastCh = trimmed.charAt(trimmed.length() - 1);
            pos = lastCh == 't' ? 2 : (lastCh == 'p' ? 1 : (lastCh == 'h' ? 3 : (lastCh == 'd' ? 4 : 0)));
            if (vals[pos] != -1) {
                System.out.println("Multiple definition of a gds type in '" + string2 + "'. Ignoring definition for character '" + lastCh + "'");
                return null;
            }
            if (pos != 0) {
                s = s.substring(0, s.length() - 1);
            }
            StringTokenizer p = new StringTokenizer(s, "/", false);
            while (p.hasMoreTokens()) {
                String item = p.nextToken();
                item = item.trim();
                int val = -1;
                try {
                    val = Integer.parseInt(item);
                }
                catch (NumberFormatException e) {
                    System.out.println("'" + item + "' is not a valid gds number/type. Ignoring defintion");
                    return null;
                }
                if (gdsVal == -1) {
                    gdsVal = val;
                    continue;
                }
                if (gdsType == -1) {
                    gdsType = val;
                    continue;
                }
                System.out.println("Error: '" + string2 + "' is not a valid gds description.");
                return null;
            }
            if (gdsVal == -1) {
                return EMPTY;
            }
            vals[pos] = gdsType != -1 ? gdsVal | gdsType << 16 : gdsVal;
        }
        return new GDSLayers(vals);
    }

    public static GDSLayers getGDSValues(Layer l) {
        EDatabase database = EDatabase.clientDatabase();
        Map<Setting, Object> context = database.getSettings();
        Foundry t1 = l.getTechnology().getSelectedFoundry();
        Setting s1 = t1.getGDSLayerSetting(l);
        return GDSLayers.parseLayerString(context.get(s1).toString());
    }

    public static enum GDSLayerType {
        DRAWING(""),
        PIN("p"),
        TEXT("t"),
        HIGHVOLTAGE("h"),
        DUMMY("d");

        String extension;

        private GDSLayerType(String s) {
            this.extension = s;
        }

        public String getExtension() {
            return this.extension;
        }

        public static GDSLayerType findType(String name) {
            try {
                GDSLayerType t = GDSLayerType.valueOf(name.toUpperCase());
                return t;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

