/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PrimitiveNameToFunction {
    private static PrimitiveNameToFunction nmToF = null;
    private static Set<Technology> techList = new HashSet<Technology>();
    private Map<String, PrimitiveNode.Function> nameToEnum = new HashMap<String, PrimitiveNode.Function>();

    private void add(PrimitiveNode.Function f, String nm) {
        this.nameToEnum.put(nm, f);
    }

    private PrimitiveNameToFunction(Technology tech) {
        this.addFunctions(tech);
        for (PrimitiveNode.Function f : PrimitiveNode.Function.getFunctions()) {
            if (!f.isTransistor() && !f.isResistor()) continue;
            this.nameToEnum.put(f.getName(), f);
        }
    }

    private void addFunctions(Technology tech) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            PrimitiveNode.Function f = pn.getFunction();
            if (!f.isTransistor() && !f.isResistor()) continue;
            this.add(f, pn.getName());
        }
    }

    private PrimitiveNode.Function nameToFunc(String nm) {
        return this.nameToEnum.get(nm);
    }

    public static void prepareToFunctionData(Technology tech) {
        if (techList.contains(tech)) {
            return;
        }
        if (nmToF == null) {
            nmToF = new PrimitiveNameToFunction(tech);
        } else if (tech.isLayout()) {
            nmToF.addFunctions(tech);
        }
    }

    public static PrimitiveNode.Function nameToFunction(String nm) {
        return nmToF.nameToFunc(nm);
    }
}

