/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Tool;
import java.awt.Component;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;

public class EObjectOutputStream
extends ObjectOutputStream {
    private final EDatabase database;

    public EObjectOutputStream(OutputStream out, EDatabase database) throws IOException {
        super(out);
        this.enableReplaceObject(true);
        this.database = database;
    }

    public EDatabase getDatabase() {
        return this.database;
    }

    public IdManager getIdManager() {
        return this.database.getIdManager();
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (obj instanceof ElectricObject && ((ElectricObject)obj).getDatabase() != this.database) {
            throw new NotSerializableException("other database");
        }
        if (obj instanceof View) {
            return new EView((View)obj);
        }
        if (obj instanceof Tool) {
            return new ETool((Tool)obj);
        }
        if (obj instanceof Variable.Key) {
            return new EVariableKey((Variable.Key)obj);
        }
        if (obj instanceof TextDescriptor) {
            return new ETextDescriptor((TextDescriptor)obj);
        }
        if (obj instanceof Network) {
            return new ENetwork((Network)obj, this.database);
        }
        if (obj instanceof Nodable && !(obj instanceof NodeInst)) {
            return new ENodable((Nodable)obj, this.database);
        }
        if (obj instanceof Component) {
            throw new Error("Found AWT class " + obj.getClass() + " in serialized object");
        }
        return obj;
    }

    private static class EView
    implements Serializable {
        String abbreviation;

        private EView(View view) {
            this.abbreviation = view.getAbbreviation();
        }

        private Object readResolve() throws ObjectStreamException {
            View view = View.findView(this.abbreviation);
            if (view == null) {
                throw new InvalidObjectException("View");
            }
            return view;
        }
    }

    private static class ETool
    implements Serializable {
        String toolName;

        private ETool(Tool tool) {
            this.toolName = tool.getName();
        }

        private Object readResolve() throws ObjectStreamException {
            Tool tool = Tool.findTool(this.toolName);
            if (tool == null) {
                throw new InvalidObjectException("Tool");
            }
            return tool;
        }
    }

    private static class EVariableKey
    implements Serializable {
        String varName;

        private EVariableKey(Variable.Key varKey) {
            this.varName = varKey.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            return Variable.newKey(this.varName);
        }
    }

    private static class ETextDescriptor
    implements Serializable {
        private boolean display;
        private long bits;
        private int colorIndex;
        private String fontName;

        private ETextDescriptor(TextDescriptor td) {
            this.display = td.isDisplay();
            this.bits = td.lowLevelGet();
            this.colorIndex = td.getColorIndex();
            int face = td.getFace();
            if (face != 0) {
                this.fontName = AbstractTextDescriptor.ActiveFont.findActiveFont(face).toString();
            }
        }

        private Object readResolve() throws ObjectStreamException {
            MutableTextDescriptor mtd = new MutableTextDescriptor(this.bits, this.colorIndex, this.display);
            int face = 0;
            if (this.fontName != null) {
                face = AbstractTextDescriptor.ActiveFont.findActiveFont(this.fontName).getIndex();
            }
            mtd.setFace(face);
            TextDescriptor td = TextDescriptor.newTextDescriptor(mtd);
            if (td == null) {
                throw new InvalidObjectException("TextDescriptor");
            }
            return td;
        }
    }

    private static class ENetwork
    implements Serializable {
        Cell cell;
        int netIndex;
        Netlist.ShortResistors shortResistors;

        private ENetwork(Network net, EDatabase database) throws NotSerializableException {
            this.cell = net.getParent();
            if (this.cell.getDatabase() != database || !this.cell.isLinked()) {
                throw new NotSerializableException(this.cell + " not linked");
            }
            this.netIndex = net.getNetIndex();
            this.shortResistors = net.getNetlist().getShortResistors();
            if (this.cell.getNetlist(this.shortResistors).getNetwork(this.netIndex) != net) {
                throw new NotSerializableException(net + " not linked");
            }
        }

        private Object readResolve() throws ObjectStreamException {
            Netlist netlist = this.cell.getNetlist(this.shortResistors);
            Network net = netlist.getNetwork(this.netIndex);
            if (net == null) {
                throw new InvalidObjectException("Network");
            }
            return net;
        }
    }

    private static class ENodable
    implements Serializable {
        Cell cell;
        String nodableName;

        private ENodable(Nodable no, EDatabase database) throws NotSerializableException {
            this.cell = no.getParent();
            if (this.cell.getDatabase() != database || !this.cell.isLinked()) {
                throw new NotSerializableException(this.cell + " not linked");
            }
            this.nodableName = no.getName();
        }

        private Object readResolve() throws ObjectStreamException {
            Netlist netlist = this.cell.getNetlist();
            Nodable nodable = null;
            Iterator<Nodable> it = netlist.getNodables();
            while (it.hasNext()) {
                Nodable no = it.next();
                if (!no.getName().equals(this.nodableName)) continue;
                nodable = no;
                break;
            }
            if (nodable == null) {
                throw new InvalidObjectException("Nodable");
            }
            return nodable;
        }
    }
}

