/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.DERWriter;
import gnu.crypto.der.OID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;

public abstract class RSA
extends SignatureSpi
implements Cloneable {
    protected static final OID DIGEST_ALGORITHM = new OID("1.2.840.113549.2");
    protected final OID digestAlgorithm;
    protected final MessageDigest md;
    protected RSAPrivateKey signerKey;
    protected RSAPublicKey verifierKey;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("deprecated");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("deprecated");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.verifierKey = null;
        this.signerKey = (RSAPrivateKey)privateKey;
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.signerKey = null;
        this.verifierKey = (RSAPublicKey)publicKey;
    }

    protected void engineUpdate(byte b) throws SignatureException {
        if (this.signerKey == null && this.verifierKey == null) {
            throw new SignatureException("not initialized");
        }
        this.md.update(b);
    }

    protected void engineUpdate(byte[] buf, int off, int len) throws SignatureException {
        if (this.signerKey == null && this.verifierKey == null) {
            throw new SignatureException("not initialized");
        }
        this.md.update(buf, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.signerKey == null) {
            throw new SignatureException("not initialized for signing");
        }
        ArrayList<DERValue> digestAlg = new ArrayList<DERValue>(2);
        digestAlg.add(new DERValue(6, this.digestAlgorithm));
        digestAlg.add(new DERValue(5, null));
        ArrayList<DERValue> digestInfo = new ArrayList<DERValue>(2);
        digestInfo.add(new DERValue(16, digestAlg));
        digestInfo.add(new DERValue(4, this.md.digest()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DERWriter.write(out, new DERValue(16, digestInfo));
        }
        catch (IOException ioe) {
            throw new SignatureException(ioe.toString());
        }
        byte[] buf = out.toByteArray();
        this.md.reset();
        int k = this.signerKey.getModulus().bitLength();
        int n = 0;
        if ((k & 7) == 0) {
            n = 1;
        }
        if (buf.length < (k = (k >>> 3) + (1 - n)) - 3) {
            throw new SignatureException("RSA modulus too small");
        }
        byte[] d = new byte[k];
        d[1] = 1;
        int i = 2;
        while (i < k - buf.length - 1) {
            d[i] = -1;
            ++i;
        }
        System.arraycopy(buf, 0, d, k - buf.length, buf.length);
        BigInteger eb = new BigInteger(d);
        byte[] ed = eb.modPow(this.signerKey.getPrivateExponent(), this.signerKey.getModulus()).toByteArray();
        if (ed.length < k) {
            byte[] b = new byte[k];
            System.arraycopy(eb, 0, b, k - ed.length, ed.length);
            ed = b;
        } else if (ed.length > k) {
            if (ed.length != k + 1) {
                throw new SignatureException("modPow result is larger than the modulus");
            }
            byte[] b = new byte[k];
            System.arraycopy(ed, 1, b, 0, k);
            ed = b;
        }
        return ed;
    }

    protected int engineSign(byte[] out, int off, int len) throws SignatureException {
        if (out == null || off < 0 || len < 0 || off + len > out.length) {
            throw new SignatureException("illegal output argument");
        }
        byte[] result = this.engineSign();
        if (result.length > len) {
            throw new SignatureException("not enough space for signature");
        }
        System.arraycopy(result, 0, out, off, result.length);
        return result.length;
    }

    protected boolean engineVerify(byte[] sig) throws SignatureException {
        if (this.verifierKey == null) {
            throw new SignatureException("not initialized for verifying");
        }
        if (sig == null) {
            throw new SignatureException("no signature specified");
        }
        int k = this.verifierKey.getModulus().bitLength();
        int n = 0;
        if ((k & 7) == 0) {
            n = 1;
        }
        if (sig.length != (k = (k >>> 3) + (1 - n))) {
            throw new SignatureException("signature is the wrong size (expecting " + k + " bytes, got " + sig.length + ')');
        }
        BigInteger ed = new BigInteger(1, sig);
        byte[] eb = ed.modPow(this.verifierKey.getPublicExponent(), this.verifierKey.getModulus()).toByteArray();
        int i = 0;
        if (eb[0] == 0) {
            i = 1;
            while (i < eb.length && eb[i] == 0) {
                ++i;
            }
            if (i == 1) {
                throw new SignatureException("wrong RSA padding");
            }
            --i;
        } else if (eb[0] == 1) {
            i = 1;
            while (i < eb.length && eb[i] != 0) {
                if (eb[i] != -1) {
                    throw new IllegalArgumentException("wrong RSA padding");
                }
                ++i;
            }
        } else {
            throw new SignatureException("wrong RSA padding type");
        }
        byte[] d = new byte[eb.length - i - 1];
        System.arraycopy(eb, i + 1, d, 0, eb.length - i - 1);
        DERReader der = new DERReader(d);
        try {
            boolean sequenceIsBer;
            DERValue val = der.read();
            if (val.getTag() != 16) {
                throw new SignatureException("failed to parse DigestInfo");
            }
            val = der.read();
            if (val.getTag() != 16) {
                throw new SignatureException("failed to parse DigestAlgorithmIdentifier");
            }
            boolean bl = false;
            if (val.getLength() == 0) {
                bl = sequenceIsBer = true;
            }
            if ((val = der.read()).getTag() != 6) {
                throw new SignatureException("failed to parse object identifier");
            }
            if (!val.getValue().equals(this.digestAlgorithm)) {
                throw new SignatureException("digest algorithms do not match");
            }
            val = der.read();
            if (val.getTag() != 5) {
                throw new SignatureException("cannot handle digest parameters");
            }
            if (sequenceIsBer) {
                der.skip(1);
            }
            if ((val = der.read()).getTag() != 4) {
                throw new SignatureException("failed to parse Digest");
            }
            return MessageDigest.isEqual(this.md.digest(), (byte[])val.getValue());
        }
        catch (IOException ioe) {
            throw new SignatureException(ioe.toString());
        }
    }

    protected boolean engineVerify(byte[] sig, int off, int len) throws SignatureException {
        if (sig == null || off < 0 || len < 0 || off + len > sig.length) {
            throw new SignatureException("illegal parameter");
        }
        byte[] buf = new byte[len];
        System.arraycopy(sig, off, buf, 0, len);
        return this.engineVerify(buf);
    }

    protected RSA(MessageDigest md, OID digestAlgorithm) {
        this.md = md;
        this.digestAlgorithm = digestAlgorithm;
    }
}

