/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.HasNamedParts;
import gnu.mapping.Symbol;
import gnu.mapping.SymbolRef;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class Namespace
implements Externalizable,
HasNamedParts {
    protected static final Hashtable nsTable = new Hashtable(50);
    public static final Namespace EmptyNamespace = Namespace.getInstance("");
    String name;
    protected String prefix = "";
    protected SymbolRef[] table;
    int log2Size = 4;
    private int mask;
    int num_bindings;

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public Namespace() {
        this(64);
    }

    public Namespace(int capacity) {
        while (capacity > 1 << this.log2Size) {
            ++this.log2Size;
        }
        capacity = 1 << this.log2Size;
        this.table = new SymbolRef[capacity];
        this.mask = capacity - 1;
    }

    public static Namespace getDefault() {
        return EmptyNamespace;
    }

    public static Symbol getDefaultSymbol(String name) {
        return EmptyNamespace.getSymbol(name);
    }

    public static Namespace make(String name) {
        return Namespace.getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace getInstance(String name) {
        if (name == null) {
            name = "";
        }
        Hashtable hashtable = nsTable;
        synchronized (hashtable) {
            Namespace ns = (Namespace)nsTable.get(name);
            if (ns != null) {
                return ns;
            }
            ns = new Namespace();
            ns.setName(name.intern());
            nsTable.put(name, ns);
            return ns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Namespace make(String uri, String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return Namespace.getInstance(uri);
        }
        String xname = prefix + " -> " + uri;
        Hashtable hashtable = nsTable;
        synchronized (hashtable) {
            Object old = nsTable.get(xname);
            if (old instanceof Namespace) {
                return (Namespace)old;
            }
            Namespace ns = new Namespace();
            ns.setName(uri);
            ns.prefix = prefix;
            nsTable.put(xname, ns);
            return ns;
        }
    }

    public static Namespace makeUnknownNamespace(String prefix) {
        String uri = prefix == null || prefix == "" ? "" : "http://kawa.gnu.org/unknown-namespace/" + prefix;
        return Namespace.make(uri, prefix);
    }

    public Object get(String name) {
        return Environment.getCurrent().get(this.getSymbol(this.getName()));
    }

    public boolean isConstant(String key) {
        return false;
    }

    public Symbol getSymbol(String key) {
        return this.lookup(key, key.hashCode(), true);
    }

    public Symbol lookup(String key) {
        return this.lookup(key, key.hashCode(), false);
    }

    protected final Symbol lookupInternal(String key, int hash) {
        int index = hash & this.mask;
        SymbolRef prev = null;
        SymbolRef ref = this.table[index];
        while (ref != null) {
            SymbolRef next = ref.next;
            Symbol sym = ref.getSymbol();
            if (sym == null) {
                if (prev == null) {
                    this.table[index] = next;
                } else {
                    prev.next = next;
                }
                --this.num_bindings;
            } else {
                if (sym.getLocalPart().equals(key)) {
                    return sym;
                }
                prev = ref;
            }
            ref = next;
        }
        return null;
    }

    public Symbol add(Symbol sym, int hash) {
        int index = hash & this.mask;
        SymbolRef ref = new SymbolRef(sym, this);
        sym.namespace = this;
        ref.next = this.table[index];
        this.table[index] = ref;
        ++this.num_bindings;
        if (this.num_bindings >= this.table.length) {
            this.rehash();
        }
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol lookup(String key, int hash, boolean create) {
        Namespace namespace = this;
        synchronized (namespace) {
            Symbol sym = this.lookupInternal(key, hash);
            if (sym != null) {
                return sym;
            }
            if (create) {
                return this.add(new Symbol(this, key), hash);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Symbol symbol) {
        Namespace namespace = this;
        synchronized (namespace) {
            String name = symbol.getLocalPart();
            int hash = name.hashCode();
            int index = hash & this.mask;
            SymbolRef prev = null;
            SymbolRef ref = this.table[index];
            while (ref != null) {
                SymbolRef next = ref.next;
                Symbol refsym = ref.getSymbol();
                if (refsym == null || refsym == symbol) {
                    if (prev == null) {
                        this.table[index] = next;
                    } else {
                        prev.next = next;
                    }
                    --this.num_bindings;
                    if (refsym != null) {
                        return true;
                    }
                } else {
                    prev = ref;
                }
                ref = next;
            }
            return false;
        }
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        int newCapacity = 2 * oldCapacity;
        int newMask = newCapacity - 1;
        int countInserted = 0;
        SymbolRef[] oldTable = this.table;
        SymbolRef[] newTable = new SymbolRef[newCapacity];
        int i = oldCapacity;
        while (--i >= 0) {
            SymbolRef ref = oldTable[i];
            while (ref != null) {
                SymbolRef next = ref.next;
                Symbol sym = ref.getSymbol();
                if (sym != null) {
                    String key = sym.getName();
                    int hash = key.hashCode();
                    int index = hash & newMask;
                    ++countInserted;
                    ref.next = newTable[index];
                    newTable[index] = ref;
                }
                ref = next;
            }
        }
        this.table = newTable;
        ++this.log2Size;
        this.mask = newMask;
        this.num_bindings = countInserted;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getName());
        out.writeObject(this.prefix);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = ((String)in.readObject()).intern();
        this.prefix = (String)in.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        String name = this.getName();
        if (name != null) {
            String xname = this.prefix == null || this.prefix.length() == 0 ? name : this.prefix + " -> " + name;
            Namespace ns = (Namespace)nsTable.get(xname);
            if (ns != null) {
                return ns;
            }
            nsTable.put(xname, this);
        }
        return this;
    }

    public String toString() {
        return "#,(namespace \"" + this.name + "\")";
    }
}

