/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;

public class TypeSwitch
extends MethodProc
implements CanInline,
Inlineable {
    public static final TypeSwitch typeSwitch = new TypeSwitch("typeswitch");

    public TypeSwitch(String string) {
        this.setName(string);
    }

    public int numArgs() {
        return -4094;
    }

    public void apply(CallContext callContext) throws Throwable {
        Object[] objectArray = callContext.getArgs();
        Object object2 = objectArray[0];
        int n = objectArray.length - 1;
        for (int i = 1; i < n; ++i) {
            MethodProc methodProc = (MethodProc)objectArray[i];
            int n2 = methodProc.match1(object2, callContext);
            if (n2 < 0) continue;
            return;
        }
        Procedure procedure = (Procedure)objectArray[n];
        procedure.check1(object2, callContext);
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        Expression[] expressionArray = applyExp.getArgs();
        for (int i = 1; i < expressionArray.length; ++i) {
            if (!(expressionArray[i] instanceof LambdaExp)) continue;
            LambdaExp lambdaExp = (LambdaExp)expressionArray[i];
            lambdaExp.setInlineOnly(true);
            lambdaExp.returnContinuation = applyExp;
            lambdaExp.inlineHome = inlineCalls.getCurrentLambda();
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.pushScope();
        Variable variable = codeAttr.addLocal(Type.pointer_type);
        expressionArray[0].compile(compilation, Target.pushObject);
        codeAttr.emitStore(variable);
        int n = 1;
        while (n < expressionArray.length) {
            Expression expression;
            if (n > 1) {
                codeAttr.emitElse();
            }
            if ((expression = expressionArray[n++]) instanceof LambdaExp) {
                LambdaExp lambdaExp = (LambdaExp)expression;
                Declaration declaration = lambdaExp.firstDecl();
                Type type = declaration.getType();
                if (!declaration.getCanRead()) {
                    declaration = null;
                } else {
                    declaration.allocateVariable(codeAttr);
                }
                if (type instanceof TypeValue) {
                    ((TypeValue)((Object)type)).emitTestIf(variable, declaration, compilation);
                } else {
                    if (n < expressionArray.length) {
                        codeAttr.emitLoad(variable);
                        type.emitIsInstance(codeAttr);
                        codeAttr.emitIfIntNotZero();
                    }
                    if (declaration != null) {
                        codeAttr.emitLoad(variable);
                        declaration.compileStore(compilation);
                    }
                }
                lambdaExp.allocChildClasses(compilation);
                lambdaExp.body.compileWithPosition(compilation, target);
                continue;
            }
            throw new Error("not implemented: typeswitch arg not LambdaExp");
        }
        n = expressionArray.length - 2;
        while (--n >= 0) {
            codeAttr.emitFi();
        }
        codeAttr.popScope();
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.pointer_type;
    }
}

