/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final byte[] EMPTY_BUFFER = new byte[0];

    private FileUtil() {
    }

    public static void symlink$5b019334(File file2, File file3) {
        try {
            if (file3.exists() && !file3.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + file3);
            }
            if (file3.getParentFile() != null) {
                file3.getParentFile().mkdirs();
            }
            Runtime runtime = Runtime.getRuntime();
            Message.verbose("executing 'ln -s -f " + file2.getAbsolutePath() + " " + file3.getPath() + "'");
            Process process2 = runtime.exec(new String[]{"ln", "-s", "-f", file2.getAbsolutePath(), file3.getPath()});
            if (process2.waitFor() != 0) {
                String string;
                InputStream inputStream = process2.getErrorStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                    stringBuffer.append('\n');
                }
                throw new IOException("error symlinking " + file2 + " to " + file3 + ":\n" + stringBuffer);
            }
            if (!file3.exists()) {
                throw new IOException("error symlinking: " + file3 + " doesn't exists");
            }
            if (file3.getAbsolutePath().equals(file3.getCanonicalPath())) {
                file3.delete();
                throw new IOException("error symlinking: " + file3 + " isn't a symlink");
            }
            return;
        }
        catch (IOException iOException) {
            Message.verbose("symlink failed; falling back to copy");
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            Message.debug(stringWriter.toString());
            FileUtil.copy(file2, file3, null, true);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public static boolean copy(File file2, File file3, CopyProgressListener copyProgressListener, boolean bl) {
        if (file3.exists()) {
            if (!file3.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + file3);
            }
            if (!file3.canWrite()) {
                file3.delete();
            }
        }
        FileUtil.copy(new FileInputStream(file2), file3, copyProgressListener);
        long l = file2.length();
        long l2 = file3.length();
        if (l != l2) {
            file3.delete();
            throw new IOException("size of source file " + file2.toString() + "(" + l + ") differs from size of dest file " + file3.toString() + "(" + l2 + ") - please retry");
        }
        file3.setLastModified(file2.lastModified());
        return true;
    }

    public static void copy(URL uRL, File file2, CopyProgressListener copyProgressListener) {
        URLHandlerRegistry.getDefault().download(uRL, file2, copyProgressListener);
    }

    public static void copy(InputStream inputStream, File file2, CopyProgressListener copyProgressListener) {
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        CopyProgressListener copyProgressListener2 = copyProgressListener;
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileUtil.copy$2dc1f19f(inputStream, fileOutputStream, copyProgressListener2);
    }

    private static void copy$2dc1f19f(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener) {
        CopyProgressEvent copyProgressEvent = null;
        if (copyProgressListener != null) {
            copyProgressEvent = new CopyProgressEvent();
        }
        try {
            int n;
            byte[] byArray = new byte[65536];
            if (copyProgressListener != null) {
                copyProgressListener.start$15cf7218();
            }
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                outputStream.write(byArray, 0, n);
                if (copyProgressListener == null) continue;
                copyProgressListener.progress(copyProgressEvent.update$565320f6(n));
            }
            if (copyProgressListener != null) {
                copyProgressEvent.update$565320f6(0);
            }
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
            inputStream.close();
            outputStream.close();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
        if (copyProgressListener != null) {
            copyProgressListener.end(copyProgressEvent);
        }
    }

    public static String readEntirely(BufferedReader bufferedReader) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static boolean forceDelete(File file2) {
        File[] fileArray;
        if (!file2.exists()) {
            return true;
        }
        if (file2.isDirectory() && (fileArray = file2.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (FileUtil.forceDelete(fileArray[i])) continue;
                return false;
            }
        }
        return file2.delete();
    }

    public static List getPathFiles(File file2, File file3) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file3 != null && !file3.getAbsolutePath().equals(file2.getAbsolutePath())) {
            arrayList.add(file3);
            file3 = file3.getParentFile();
        }
        if (file2 != null) {
            arrayList.add(file2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static Collection listAll(File file2, Collection collection) {
        return FileUtil.listAll(file2, new ArrayList(), collection);
    }

    private static Collection listAll(File file2, Collection collection, Collection collection2) {
        if (collection2.contains(file2.getName())) {
            return collection;
        }
        if (file2.exists()) {
            collection.add(file2);
        }
        if (file2.isDirectory()) {
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.listAll(fileArray[i], collection, collection2);
            }
        }
        return collection;
    }

    public static File resolveFile(File file2, String string) {
        File file3 = new File(string);
        if (!file3.isAbsolute()) {
            file3 = new File(file2, string);
        }
        return FileUtil.normalize(file3.getPath());
    }

    public static File normalize(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        String[] stringArray = FileUtil.dissect(string);
        stack.push(stringArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[1], File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() < 2) {
                    return new File(string);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            if (i > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(stack.elementAt(i));
        }
        return new File(((StringBuffer)charSequence).toString());
    }

    private static String[] dissect(String string) {
        String string2;
        char c = File.separatorChar;
        int n = (string = string.replace('/', c).replace('\\', c)).indexOf(58);
        if (n > 0) {
            int n2 = n + 1;
            string2 = string.substring(0, n2);
            char[] cArray = string.toCharArray();
            string2 = string2 + c;
            n2 = cArray[n2] == c ? n2 + 1 : n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < cArray.length; ++i) {
                if (cArray[i] == c && cArray[i - 1] == c) continue;
                stringBuffer.append(cArray[i]);
            }
            string = stringBuffer.toString();
        } else if (string.length() > 1 && string.charAt(1) == c) {
            int n3 = string.indexOf(c, 2);
            string2 = (n3 = string.indexOf(c, n3 + 1)) > 2 ? string.substring(0, n3 + 1) : string;
            string = string.substring(string2.length());
        } else {
            string2 = File.separator;
            string = string.substring(1);
        }
        return new String[]{string2, string};
    }
}

