import{ObjectWrapper as e,Color as t,ColorUtils as s,Linkifier as i}from"../common/common.js";import{SDKModel as n,CSSModel as o,DOMModel as a}from"../sdk/sdk.js";import{i18n as r}from"../i18n/i18n.js";import{ContrastInfo as l}from"../color_picker/color_picker.js";import{Runtime as d}from"../root/root.js";import{Widget as c,UIUtils as h,Fragment as u,Toolbar as v,Panel as m,SplitWidget as p,TabbedPane as g,Icon as _,Tooltip as b}from"../ui/ui.js";import{Linkifier as S}from"../components/components.js";import{SortableDataGrid as f,DataGrid as C}from"../data_grid/data_grid.js";import{NumberUtilities as w}from"../platform/platform.js";import{TextRange as y}from"../text_utils/text_utils.js";import{userMetrics as I,UserMetrics as k}from"../host/host.js";class $ extends e.ObjectWrapper{constructor(){super(),this.currentUrl=n.TargetManager.instance().inspectedURL(),n.TargetManager.instance().addEventListener(n.Events.InspectedURLChanged,this._checkUrlAndResetIfChanged,this)}_checkUrlAndResetIfChanged(){this.currentUrl!==n.TargetManager.instance().inspectedURL()&&(this.currentUrl=n.TargetManager.instance().inspectedURL(),this.dispatchEventToListeners(A.Reset))}}const A={RequestOverviewStart:Symbol("RequestOverviewStart"),RequestNodeHighlight:Symbol("RequestNodeHighlight"),PopulateNodes:Symbol("PopulateNodes"),RequestOverviewCancel:Symbol("RequestOverviewCancel"),OverviewCompleted:Symbol("OverviewCompleted"),Reset:Symbol("Reset")};var E=Object.freeze({__proto__:null,OverviewController:$,Events:A});const T={topAppliedToAStatically:"Top applied to a statically positioned element",leftAppliedToAStatically:"Left applied to a statically positioned element",rightAppliedToAStatically:"Right applied to a statically positioned element",bottomAppliedToAStatically:"Bottom applied to a statically positioned element",widthAppliedToAnInlineElement:"Width applied to an inline element",heightAppliedToAnInlineElement:"Height applied to an inline element",verticalAlignmentAppliedTo:"Vertical alignment applied to element which is neither inline nor table-cell"},x=r.registerUIStrings("css_overview/CSSOverviewUnusedDeclarations.js",T),M=r.getLocalizedString.bind(void 0,x);class O{static _add(e,t,s){const i=e.get(t)||[];i.push(s),e.set(t,i)}static checkForUnusedPositionValues(e,t,s,i,n,o,a,r){if("static"===s[i]){if("auto"!==s[n]){const i=M(T.topAppliedToAStatically);this._add(e,i,{declaration:"top: "+s[n],nodeId:t})}if("auto"!==s[o]){const i=M(T.leftAppliedToAStatically);this._add(e,i,{declaration:"left: "+s[o],nodeId:t})}if("auto"!==s[a]){const i=M(T.rightAppliedToAStatically);this._add(e,i,{declaration:"right: "+s[a],nodeId:t})}if("auto"!==s[r]){const i=M(T.bottomAppliedToAStatically);this._add(e,i,{declaration:"bottom: "+s[r],nodeId:t})}}}static checkForUnusedWidthAndHeightValues(e,t,s,i,n,o){if("inline"===s[i]){if("auto"!==s[n]){const i=M(T.widthAppliedToAnInlineElement);this._add(e,i,{declaration:"width: "+s[n],nodeId:t})}if("auto"!==s[o]){const i=M(T.heightAppliedToAnInlineElement);this._add(e,i,{declaration:"height: "+s[o],nodeId:t})}}}static checkForInvalidVerticalAlignment(e,t,s,i,n){if(s[i]&&"inline"!==s[i]&&!s[i].startsWith("table")&&"baseline"!==s[n]){const i=M(T.verticalAlignmentAppliedTo);this._add(e,i,{declaration:"vertical-align: "+s[n],nodeId:t})}}}var L=Object.freeze({__proto__:null,UIStrings:T,UnusedDeclaration:undefined,CSSOverviewUnusedDeclarations:O});class R extends n.SDKModel{constructor(e){super(e),this._runtimeAgent=e.runtimeAgent(),this._cssAgent=e.cssAgent(),this._domAgent=e.domAgent(),this._domSnapshotAgent=e.domsnapshotAgent(),this._overlayAgent=e.overlayAgent()}highlightNode(e){const s={contentColor:t.PageHighlight.Content.toProtocolRGBA(),showInfo:!0,contrastAlgorithm:d.experiments.isEnabled("APCA")?Protocol.Overlay.ContrastAlgorithm.Apca:Protocol.Overlay.ContrastAlgorithm.Aa};this._overlayAgent.invoke_hideHighlight(),this._overlayAgent.invoke_highlightNode({backendNodeId:e,highlightConfig:s})}async getNodeStyleStats(){const e=new Map,s=new Map,i=new Map,n=new Map,o=new Map,a=new Map,r=new Map,c=e=>e.hasAlpha()?e.asString(t.Format.HEXA):e.asString(t.Format.HEX),h=(e,s,i)=>{if(-1===e)return;const n=_[e];if(!n)return;const o=t.Color.parse(n);if(!o||0===o.rgba()[3])return;const a=c(o);if(!a)return;const r=i.get(a)||new Set;return r.add(s),i.set(a,r),o},u=e=>new Set(["altglyph","circle","ellipse","path","polygon","polyline","rect","svg","text","textpath","tref","tspan"]).has(e.toLowerCase()),v=e=>new Set(["iframe","video","embed","img"]).has(e.toLowerCase()),m=(e,t)=>new Set(["tr","td","thead","tbody"]).has(e.toLowerCase())&&t.startsWith("table");let p=0;const{documents:g,strings:_}=await this._domSnapshotAgent.invoke_captureSnapshot({computedStyles:["background-color","color","fill","border-top-width","border-top-color","border-bottom-width","border-bottom-color","border-left-width","border-left-color","border-right-width","border-right-color","font-family","font-size","font-weight","line-height","position","top","right","bottom","left","display","width","height","vertical-align"]});for(const{nodes:b,layout:S}of g){p+=S.nodeIndex.length;for(let p=0;p<S.styles.length;p++){const g=S.styles[p],f=S.nodeIndex[p];if(!b.backendNodeId||!b.nodeName)continue;const C=b.backendNodeId[f],w=b.nodeName[f],[y,I,k,$,A,E,T,x,M,L,R,P,F,N,V,D,H,B,W,U,q,z,j,G]=g,Q=h(y,C,e),X=h(I,C,s);if(u(_[w])&&h(k,C,n),"0px"!==_[$]&&h(A,C,o),"0px"!==_[E]&&h(T,C,o),"0px"!==_[x]&&h(M,C,o),"0px"!==_[L]&&h(R,C,o),P&&-1!==P){const e=_[P],t=a.get(e)||new Map,s="font-size",i="font-weight",n="line-height",o=t.get(s)||new Map,r=t.get(i)||new Map,l=t.get(n)||new Map;if(-1!==F){const e=_[F],t=o.get(e)||[];t.push(C),o.set(e,t)}if(-1!==N){const e=_[N],t=r.get(e)||[];t.push(C),r.set(e,t)}if(-1!==V){const e=_[V],t=l.get(e)||[];t.push(C),l.set(e,t)}t.set(s,o),t.set(i,r),t.set(n,l),a.set(e,t)}if(Q&&X&&"#text"===_[w]){const e=new l.ContrastInfo({backgroundColors:[Q.asString(t.Format.HEXA)],computedFontSize:-1!==F?_[F]:"",computedFontWeight:-1!==N?_[N]:""});e.setColor(X);const s=`${c(X)}_${c(Q)}`;if(d.experiments.isEnabled("APCA")){const t=e.contrastRatioAPCA(),n=e.contrastRatioAPCAThreshold();if(!(!(!t||!n)&&Math.abs(t)>=n)){const e={nodeId:C,contrastRatio:t,textColor:X,backgroundColor:Q,thresholdsViolated:{aa:!1,aaa:!1,apca:!0}};i.has(s)?i.get(s).push(e):i.set(s,[e])}}else{const t=e.contrastRatioThreshold("aa")||0,n=e.contrastRatioThreshold("aaa")||0,o=e.contrastRatio()||0;if(t>o||n>o){const e={nodeId:C,contrastRatio:o,textColor:X,backgroundColor:Q,thresholdsViolated:{aa:t>o,aaa:n>o,apca:!1}};i.has(s)?i.get(s).push(e):i.set(s,[e])}}}O.checkForUnusedPositionValues(r,C,_,D,H,U,B,W),u(_[w])||v(_[w])||O.checkForUnusedWidthAndHeightValues(r,C,_,q,z,j),-1===G||m(_[w],_[q])||O.checkForInvalidVerticalAlignment(r,C,_,q,G)}}return{backgroundColors:e,textColors:s,textColorContrastIssues:i,fillColors:n,borderColors:o,fontInfo:a,unusedDeclarations:r,elementCount:p}}getComputedStyleForNode(e){return this._cssAgent.invoke_getComputedStyleForNode({nodeId:e})}async getMediaQueries(){const e=await this._cssAgent.invoke_getMediaQueries(),t=new Map;if(!e)return t;for(const s of e.medias){if("linkedSheet"===s.source)continue;const e=t.get(s.text)||[];e.push(s),t.set(s.text,e)}return t}async getGlobalStylesheetStats(){const{result:e}=await this._runtimeAgent.invoke_evaluate({expression:"(function() {\n      let styleRules = 0;\n      let inlineStyles = 0;\n      let externalSheets = 0;\n      const stats = {\n        // Simple.\n        type: new Set(),\n        class: new Set(),\n        id: new Set(),\n        universal: new Set(),\n        attribute: new Set(),\n\n        // Non-simple.\n        nonSimple: new Set()\n      };\n\n      for (const styleSheet of document.styleSheets) {\n        if (styleSheet.href) {\n          externalSheets++;\n        } else {\n          inlineStyles++;\n        }\n\n        // Attempting to grab rules can trigger a DOMException.\n        // Try it and if it fails skip to the next stylesheet.\n        let rules;\n        try {\n          rules = styleSheet.rules;\n        } catch (err) {\n          continue;\n        }\n\n        for (const rule of rules) {\n          if ('selectorText' in rule) {\n            styleRules++;\n\n            // Each group that was used.\n            for (const selectorGroup of rule.selectorText.split(',')) {\n              // Each selector in the group.\n              for (const selector of selectorGroup.split(/[\\t\\n\\f\\r ]+/g)) {\n                if (selector.startsWith('.')) {\n                  // Class.\n                  stats.class.add(selector);\n                } else if (selector.startsWith('#')) {\n                  // Id.\n                  stats.id.add(selector);\n                } else if (selector.startsWith('*')) {\n                  // Universal.\n                  stats.universal.add(selector);\n                } else if (selector.startsWith('[')) {\n                  // Attribute.\n                  stats.attribute.add(selector);\n                } else {\n                  // Type or non-simple selector.\n                  const specialChars = /[#.:\\[\\]|\\+>~]/;\n                  if (specialChars.test(selector)) {\n                    stats.nonSimple.add(selector);\n                  } else {\n                    stats.type.add(selector);\n                  }\n                }\n              }\n            }\n          }\n        }\n      }\n\n      return {\n        styleRules,\n        inlineStyles,\n        externalSheets,\n        stats: {\n          // Simple.\n          type: stats.type.size,\n          class: stats.class.size,\n          id: stats.id.size,\n          universal: stats.universal.size,\n          attribute: stats.attribute.size,\n\n          // Non-simple.\n          nonSimple: stats.nonSimple.size\n        }\n      }\n    })()",returnByValue:!0});if("object"===e.type)return e.value}}n.SDKModel.register(R,n.Capability.DOM,!1);var P=Object.freeze({__proto__:null,CSSOverviewModel:R});const F={captureOverview:"Capture overview",cssOverview:"CSS Overview"},N=r.registerUIStrings("css_overview/CSSOverviewStartView.js",F),V=r.getLocalizedString.bind(void 0,N);class D extends c.Widget{constructor(e){super(),this.registerRequiredCSS("css_overview/cssOverviewStartView.css",{enableLegacyPatching:!1}),this._controller=e,this._render()}_render(){const e=h.createTextButton(V(F.captureOverview),(()=>this._controller.dispatchEventToListeners(A.RequestOverviewStart)),"",!0);this.setDefaultFocusedElement(e);const t=u.Fragment.build`
      <div class="vbox overview-start-view">
        <h1>${V(F.cssOverview)}</h1>
        <div>${e}</div>
      </div>
    `;this.contentElement.appendChild(t.element()),this.contentElement.style.overflow="auto"}}var H=Object.freeze({__proto__:null,UIStrings:F,CSSOverviewStartView:D});const B={cancel:"Cancel"},W=r.registerUIStrings("css_overview/CSSOverviewProcessingView.js",B),U=r.getLocalizedString.bind(void 0,W);class q extends c.Widget{constructor(e){super(),this.registerRequiredCSS("css_overview/cssOverviewProcessingView.css",{enableLegacyPatching:!1}),this._formatter=new Intl.NumberFormat("en-US"),this._controller=e,this._render()}_render(){const e=h.createTextButton(U(B.cancel),(()=>this._controller.dispatchEventToListeners(A.RequestOverviewCancel)),"",!0);this.setDefaultFocusedElement(e),this.fragment=u.Fragment.build`
      <div class="vbox overview-processing-view">
        <h1>Processing page</h1>
        <div>${e}</div>
      </div>
    `,this.contentElement.appendChild(this.fragment.element()),this.contentElement.style.overflow="auto"}}var z=Object.freeze({__proto__:null,UIStrings:B,CSSOverviewProcessingView:q});const j={clearOverview:"Clear overview"},G=r.registerUIStrings("css_overview/CSSOverviewSidebarPanel.js",j),Q=r.getLocalizedString.bind(void 0,G);class X extends c.VBox{static get ITEM_CLASS_NAME(){return"overview-sidebar-panel-item"}static get SELECTED(){return"selected"}constructor(){super(!0),this.registerRequiredCSS("css_overview/cssOverviewSidebarPanel.css",{enableLegacyPatching:!1}),this.contentElement.classList.add("overview-sidebar-panel"),this.contentElement.addEventListener("click",this._onItemClick.bind(this));const e=new v.ToolbarButton(Q(j.clearOverview),"largeicon-clear");e.addEventListener(v.ToolbarButton.Events.Click,this._reset,this);const t=this.contentElement.createChild("div","overview-toolbar");new v.Toolbar("",t).appendToolbarItem(e)}addItem(e,t){const s=this.contentElement.createChild("div",X.ITEM_CLASS_NAME);s.textContent=e,s.dataset.id=t}_reset(){this.dispatchEventToListeners(K.Reset)}_deselectAllItems(){this.contentElement.querySelectorAll("."+X.ITEM_CLASS_NAME).forEach((e=>{e.classList.remove(X.SELECTED)}))}_onItemClick(e){const t=e.composedPath()[0];if(!t.classList.contains(X.ITEM_CLASS_NAME))return;const{id:s}=t.dataset;s&&(this.select(s),this.dispatchEventToListeners(K.ItemSelected,s))}select(e){const t=this.contentElement.querySelector(`[data-id=${CSS.escape(e)}]`);t&&(t.classList.contains(X.SELECTED)||(this._deselectAllItems(),t.classList.add(X.SELECTED)))}}const K={ItemSelected:Symbol("ItemSelected"),Reset:Symbol("Reset")};var J=Object.freeze({__proto__:null,UIStrings:j,CSSOverviewSidebarPanel:X,SidebarEvents:K});const Y={overviewSummary:"Overview summary",colors:"Colors",fontInfo:"Font info",unusedDeclarations:"Unused declarations",mediaQueries:"Media queries",elements:"Elements",externalStylesheets:"External stylesheets",inlineStyleElements:"Inline style elements",styleRules:"Style rules",typeSelectors:"Type selectors",idSelectors:"ID selectors",classSelectors:"Class selectors",universalSelectors:"Universal selectors",attributeSelectors:"Attribute selectors",nonsimpleSelectors:"Non-simple selectors",backgroundColorsS:"Background colors: {PH1}",textColorsS:"Text colors: {PH1}",fillColorsS:"Fill colors: {PH1}",borderColorsS:"Border colors: {PH1}",thereAreNoFonts:"There are no fonts.",thereAreNoUnusedDeclarations:"There are no unused declarations.",thereAreNoMediaQueries:"There are no media queries.",contrastIssues:"Contrast issues",occurrence:"occurrence",occurrences:"occurrences",sS:"{PH1} {PH2}",contrastIssuesS:"Contrast issues: {PH1}",textColorSOverSBackgroundResults:"Text color {PH1} over {PH2} background results in low contrast for {PH3} elements",aa:"AA",aaa:"AAA",apca:"APCA",element:"Element",declaration:"Declaration",source:"Source",contrastRatio:"Contrast ratio",cssOverviewElements:"CSS Overview Elements",showElement:"Show element"},Z=r.registerUIStrings("css_overview/CSSOverviewCompletedView.js",Y),ee=r.getLocalizedString.bind(void 0,Z);function te(e){let[t,s,i]=e.hsla();return t=Math.round(360*t),s=Math.round(100*s),i=Math.round(100*i),i=Math.max(0,i-15),`1px solid hsl(${t}deg ${s}% ${i}%)`}class se extends m.PanelWithSidebar{constructor(e,t){super("css_overview_completed_view"),this.registerRequiredCSS("css_overview/cssOverviewCompletedView.css",{enableLegacyPatching:!1}),this._controller=e,this._formatter=new Intl.NumberFormat("en-US"),this._mainContainer=new p.SplitWidget(!0,!0),this._resultsContainer=new c.VBox,this._elementContainer=new ie,this._elementContainer.addEventListener(g.Events.TabClosed,(e=>{0===e.data&&this._mainContainer.setSidebarMinimized(!0)})),this._mainContainer.registerRequiredCSS("css_overview/cssOverviewCompletedView.css",{enableLegacyPatching:!0}),this._mainContainer.setMainWidget(this._resultsContainer),this._mainContainer.setSidebarWidget(this._elementContainer),this._mainContainer.setVertical(!1),this._mainContainer.setSecondIsSidebar(!0),this._mainContainer.setSidebarMinimized(!0),this._sideBar=new X,this.splitWidget().setSidebarWidget(this._sideBar),this.splitWidget().setMainWidget(this._mainContainer);const s=t.model(o.CSSModel),i=t.model(a.DOMModel);if(!s||!i)throw new Error("Target must provide CSS and DOM models");this._cssModel=s,this._domModel=i,this._domAgent=t.domAgent(),this._linkifier=new S.Linkifier(20,!0),this._viewMap=new Map,this._sideBar.addItem(ee(Y.overviewSummary),"summary"),this._sideBar.addItem(ee(Y.colors),"colors"),this._sideBar.addItem(ee(Y.fontInfo),"font-info"),this._sideBar.addItem(ee(Y.unusedDeclarations),"unused-declarations"),this._sideBar.addItem(ee(Y.mediaQueries),"media-queries"),this._sideBar.select("summary"),this._sideBar.addEventListener(K.ItemSelected,this._sideBarItemSelected,this),this._sideBar.addEventListener(K.Reset,this._sideBarReset,this),this._controller.addEventListener(A.Reset,this._reset,this),this._controller.addEventListener(A.PopulateNodes,this._createElementsView,this),this._resultsContainer.element.addEventListener("click",this._onClick.bind(this)),this._data=null}wasShown(){super.wasShown()}_sideBarItemSelected(e){const t=e.data,s=this._fragment.$(t);s&&s.scrollIntoView()}_sideBarReset(){this._controller.dispatchEventToListeners(A.Reset)}_reset(){this._resultsContainer.element.removeChildren(),this._mainContainer.setSidebarMinimized(!0),this._elementContainer.closeTabs(),this._viewMap=new Map,se.pushedNodes.clear(),this._sideBar.select("summary")}_onClick(e){if(!e.target)return;const t=e.target.dataset,s=t.type;if(!s||!this._data)return;let i;switch(s){case"contrast":{const e=t.section,n=t.key;if(!n)return;i={type:s,key:n,nodes:this._data.textColorContrastIssues.get(n)||[],section:e};break}case"color":{const e=t.color,n=t.section;if(!e)return;let o;switch(n){case"text":o=this._data.textColors.get(e);break;case"background":o=this._data.backgroundColors.get(e);break;case"fill":o=this._data.fillColors.get(e);break;case"border":o=this._data.borderColors.get(e)}if(!o)return;o=Array.from(o).map((e=>({nodeId:e}))),i={type:s,color:e,nodes:o,section:n};break}case"unused-declarations":{const e=t.declaration;if(!e)return;const n=this._data.unusedDeclarations.get(e);if(!n)return;i={type:s,declaration:e,nodes:n};break}case"media-queries":{const e=t.text;if(!e)return;const n=this._data.mediaQueries.get(e);if(!n)return;i={type:s,text:e,nodes:n};break}case"font-info":{const e=t.value;if(!t.path)return;const[n,o]=t.path.split("/");if(!e)return;const a=this._data.fontInfo.get(n);if(!a)return;const r=a.get(o);if(!r)return;const l=r.get(e);if(!l)return;i={type:s,name:`${e} (${n}, ${o})`,nodes:l.map((e=>({nodeId:e})))};break}default:return}e.consume(),this._controller.dispatchEventToListeners(A.PopulateNodes,i),this._mainContainer.setSidebarMinimized(!1)}_onMouseOver(e){const t=e.composedPath().find((e=>e.dataset&&e.dataset.backendNodeId));if(!t)return;const s=Number(t.dataset.backendNodeId);this._controller.dispatchEventToListeners(A.RequestNodeHighlight,s)}async _render(e){if(!e||!("backgroundColors"in e)||!("textColors"in e))return;this._data=e;const{elementCount:t,backgroundColors:s,textColors:i,textColorContrastIssues:n,fillColors:o,borderColors:a,globalStyleStats:r,mediaQueries:l,unusedDeclarations:d,fontInfo:c}=this._data,h=this._sortColorsByLuminance(s),v=this._sortColorsByLuminance(i),m=this._sortColorsByLuminance(o),p=this._sortColorsByLuminance(a);this._fragment=u.Fragment.build`
    <div class="vbox overview-completed-view">
      <div $="summary" class="results-section horizontally-padded summary">
        <h1>${ee(Y.overviewSummary)}</h1>

        <ul>
          <li>
            <div class="label">${ee(Y.elements)}</div>
            <div class="value">${this._formatter.format(t)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.externalStylesheets)}</div>
            <div class="value">${this._formatter.format(r.externalSheets)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.inlineStyleElements)}</div>
            <div class="value">${this._formatter.format(r.inlineStyles)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.styleRules)}</div>
            <div class="value">${this._formatter.format(r.styleRules)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.mediaQueries)}</div>
            <div class="value">${this._formatter.format(l.size)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.typeSelectors)}</div>
            <div class="value">${this._formatter.format(r.stats.type)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.idSelectors)}</div>
            <div class="value">${this._formatter.format(r.stats.id)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.classSelectors)}</div>
            <div class="value">${this._formatter.format(r.stats.class)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.universalSelectors)}</div>
            <div class="value">${this._formatter.format(r.stats.universal)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.attributeSelectors)}</div>
            <div class="value">${this._formatter.format(r.stats.attribute)}</div>
          </li>
          <li>
            <div class="label">${ee(Y.nonsimpleSelectors)}</div>
            <div class="value">${this._formatter.format(r.stats.nonSimple)}</div>
          </li>
        </ul>
      </div>

      <div $="colors" class="results-section horizontally-padded colors">
        <h1>${ee(Y.colors)}</h1>
        <h2>${ee(Y.backgroundColorsS,{PH1:h.length})}</h2>
        <ul>
          ${h.map(this._colorsToFragment.bind(this,"background"))}
        </ul>

        <h2>${ee(Y.textColorsS,{PH1:v.length})}</h2>
        <ul>
          ${v.map(this._colorsToFragment.bind(this,"text"))}
        </ul>

        ${n.size>0?this._contrastIssuesToFragment(n):""}

        <h2>${ee(Y.fillColorsS,{PH1:m.length})}</h2>
        <ul>
          ${m.map(this._colorsToFragment.bind(this,"fill"))}
        </ul>

        <h2>${ee(Y.borderColorsS,{PH1:p.length})}</h2>
        <ul>
          ${p.map(this._colorsToFragment.bind(this,"border"))}
        </ul>
      </div>

      <div $="font-info" class="results-section font-info">
        <h1>${ee(Y.fontInfo)}</h1>
        ${c.size>0?this._fontInfoToFragment(c):u.Fragment.build`<div>${ee(Y.thereAreNoFonts)}</div>`}
      </div>

      <div $="unused-declarations" class="results-section unused-declarations">
        <h1>${ee(Y.unusedDeclarations)}</h1>
        ${d.size>0?this._groupToFragment(d,"unused-declarations","declaration"):u.Fragment.build`<div class="horizontally-padded">${ee(Y.thereAreNoUnusedDeclarations)}</div>`}
      </div>

      <div $="media-queries" class="results-section media-queries">
        <h1>${ee(Y.mediaQueries)}</h1>
        ${l.size>0?this._groupToFragment(l,"media-queries","text"):u.Fragment.build`<div class="horizontally-padded">${ee(Y.thereAreNoMediaQueries)}</div>`}
      </div>
    </div>`,this._resultsContainer.element.appendChild(this._fragment.element())}_createElementsView(e){const{type:t,nodes:s}=e.data;let i="",n="";switch(t){case"contrast":{const{section:t,key:s}=e.data;i=`${t}-${s}`,n=ee(Y.contrastIssues);break}case"color":{const{section:t,color:s}=e.data;i=`${t}-${s}`,n=`${s.toUpperCase()} (${t})`;break}case"unused-declarations":{const{declaration:t}=e.data;i=""+t,n=""+t;break}case"media-queries":{const{text:t}=e.data;i=""+t,n=""+t;break}case"font-info":{const{name:t}=e.data;i=""+t,n=""+t;break}}let o=this._viewMap.get(i);o||(o=new ne(this._controller,this._domModel,this._cssModel,this._linkifier),o.populateNodes(s),this._viewMap.set(i,o)),this._elementContainer.appendTab(i,n,o,!0)}_fontInfoToFragment(e){const t=Array.from(e.entries());return u.Fragment.build`
      ${t.map((([e,t])=>u.Fragment.build`<section class="font-family"><h2>${e}</h2> ${this._fontMetricsToFragment(e,t)}</section>`))}
    `}_fontMetricsToFragment(e,t){const s=Array.from(t.entries());return u.Fragment.build`
      <div class="font-metric">
      ${s.map((([t,s])=>{const i=`${e}/${t}`;return u.Fragment.build`
          <div>
            <h3>${t}</h3>
            ${this._groupToFragment(s,"font-info","value",i)}
          </div>`}))}
      </div>`}_groupToFragment(e,t,s,i=""){const n=Array.from(e.entries()).sort(((e,t)=>{const s=e[1];return t[1].length-s.length})),o=n.reduce(((e,t)=>e+t[1].length),0);return u.Fragment.build`<ul>
    ${n.map((([e,n])=>{const a=100*n.length/o,r=1===n.length?ee(Y.occurrence):ee(Y.occurrences);return u.Fragment.build`<li>
        <div class="title">${e}</div>
        <button data-type="${t}" data-path="${i}" data-${s}="${e}">
          <div class="details">${ee(Y.sS,{PH1:n.length,PH2:r})}</div>
          <div class="bar-container">
            <div class="bar" style="width: ${a}%"></div>
          </div>
        </button>
      </li>`}))}
    </ul>`}_contrastIssuesToFragment(e){return u.Fragment.build`
      <h2>${ee(Y.contrastIssuesS,{PH1:e.size})}</h2>
      <ul>
        ${[...e.entries()].map((([e,t])=>this._contrastIssueToFragment(e,t)))}
      </ul>
    `}_contrastIssueToFragment(e,s){console.assert(s.length>0);let i=s[0];for(const e of s)Math.abs(e.contrastRatio)<Math.abs(i.contrastRatio)&&(i=e);const n=i.textColor.asString(t.Format.HEXA),o=i.backgroundColor.asString(t.Format.HEXA),a=d.experiments.isEnabled("APCA"),r=u.Fragment.build`<li>
      <button
        title="${ee(Y.textColorSOverSBackgroundResults,{PH1:n,PH2:o,PH3:s.length})}"
        data-type="contrast" data-key="${e}" data-section="contrast" class="block" $="color">
        Text
      </button>
      <div class="block-title">
        <div class="contrast-warning hidden" $="aa"><span class="threshold-label">${ee(Y.aa)}</span></div>
        <div class="contrast-warning hidden" $="aaa"><span class="threshold-label">${ee(Y.aaa)}</span></div>
        <div class="contrast-warning hidden" $="apca"><span class="threshold-label">${ee(Y.apca)}</span></div>
      </div>
    </li>`;if(a){const e=r.$("apca");i.thresholdsViolated.apca?e.appendChild(_.Icon.create("smallicon-no")):e.appendChild(_.Icon.create("smallicon-checkmark-square")),e.classList.remove("hidden")}else{const e=r.$("aa");i.thresholdsViolated.aa?e.appendChild(_.Icon.create("smallicon-no")):e.appendChild(_.Icon.create("smallicon-checkmark-square"));const t=r.$("aaa");i.thresholdsViolated.aaa?t.appendChild(_.Icon.create("smallicon-no")):t.appendChild(_.Icon.create("smallicon-checkmark-square")),e.classList.remove("hidden"),t.classList.remove("hidden")}const l=r.$("color");return l.style.backgroundColor=o,l.style.color=n,l.style.border=te(i.backgroundColor),r}_colorsToFragment(e,s){const i=u.Fragment.build`<li>
      <button data-type="color" data-color="${s}" data-section="${e}" class="block" $="color"></button>
      <div class="block-title">${s}</div>
    </li>`,n=i.$("color");n.style.backgroundColor=s;const o=t.Color.parse(s);if(o)return n.style.border=te(o),i}_sortColorsByLuminance(e){return Array.from(e.keys()).sort(((e,i)=>{const n=t.Color.parse(e),o=t.Color.parse(i);return n&&o?s.luminance(o.rgba())-s.luminance(n.rgba()):0}))}setOverviewData(e){this._render(e)}}se.pushedNodes=new Set;class ie extends c.VBox{constructor(){super(),this._tabbedPane=new g.TabbedPane,this._tabbedPane.show(this.element),this._tabbedPane.addEventListener(g.Events.TabClosed,(()=>{this.dispatchEventToListeners(g.Events.TabClosed,this._tabbedPane.tabIds().length)}))}appendTab(e,t,s,i){this._tabbedPane.hasTab(e)||this._tabbedPane.appendTab(e,t,s,void 0,void 0,i),this._tabbedPane.selectTab(e)}closeTabs(){this._tabbedPane.closeTabs(this._tabbedPane.tabIds())}}class ne extends c.Widget{constructor(e,t,s,i){super(),this._controller=e,this._domModel=t,this._cssModel=s,this._linkifier=i,this._elementGridColumns=[{id:"nodeId",title:ee(Y.element),sortable:!0,weight:50,titleDOMFragment:void 0,sort:void 0,align:void 0,width:void 0,fixedWidth:void 0,editable:void 0,nonSelectable:void 0,longText:void 0,disclosure:void 0,allowInSortByEvenWhenHidden:void 0,dataType:void 0,defaultWeight:void 0},{id:"declaration",title:ee(Y.declaration),sortable:!0,weight:50,titleDOMFragment:void 0,sort:void 0,align:void 0,width:void 0,fixedWidth:void 0,editable:void 0,nonSelectable:void 0,longText:void 0,disclosure:void 0,allowInSortByEvenWhenHidden:void 0,dataType:void 0,defaultWeight:void 0},{id:"sourceURL",title:ee(Y.source),sortable:!1,weight:100,titleDOMFragment:void 0,sort:void 0,align:void 0,width:void 0,fixedWidth:void 0,editable:void 0,nonSelectable:void 0,longText:void 0,disclosure:void 0,allowInSortByEvenWhenHidden:void 0,dataType:void 0,defaultWeight:void 0},{id:"contrastRatio",title:ee(Y.contrastRatio),sortable:!0,weight:25,titleDOMFragment:void 0,sort:void 0,align:void 0,width:"150px",fixedWidth:!0,editable:void 0,nonSelectable:void 0,longText:void 0,disclosure:void 0,allowInSortByEvenWhenHidden:void 0,dataType:void 0,defaultWeight:void 0}],this._elementGrid=new f.SortableDataGrid({displayName:ee(Y.cssOverviewElements),columns:this._elementGridColumns,editCallback:void 0,deleteCallback:void 0,refreshCallback:void 0}),this._elementGrid.element.classList.add("element-grid"),this._elementGrid.element.addEventListener("mouseover",this._onMouseOver.bind(this)),this._elementGrid.setStriped(!0),this._elementGrid.addEventListener(C.Events.SortingChanged,this._sortMediaQueryDataGrid.bind(this)),this.element.appendChild(this._elementGrid.element)}_sortMediaQueryDataGrid(){const e=this._elementGrid.sortColumnId();if(!e)return;const t=f.SortableDataGrid.StringComparator.bind(null,e);this._elementGrid.sortNodes(t,!this._elementGrid.isSortOrderAscending())}_onMouseOver(e){const t=e.composedPath().find((e=>e.dataset&&e.dataset.backendNodeId));if(!t)return;const s=Number(t.dataset.backendNodeId);this._controller.dispatchEventToListeners(A.RequestNodeHighlight,s)}async populateNodes(e){if(this._elementGrid.rootNode().removeChildren(),!e.length)return;const[t]=e,s=new Set;let i;if(t.nodeId&&s.add("nodeId"),t.declaration&&s.add("declaration"),t.sourceURL&&s.add("sourceURL"),t.contrastRatio&&s.add("contrastRatio"),s.has("nodeId")){const t=e.reduce(((e,t)=>se.pushedNodes.has(t.nodeId)?e:(se.pushedNodes.add(t.nodeId),e.add(t.nodeId))),new Set);i=await this._domModel.pushNodesByBackendIdsToFrontend(t)}for(const t of e){if(s.has("nodeId")){if(!i)continue;const e=i.get(t.nodeId);if(!e)continue;t.node=e}const e=new oe(this._elementGrid,t,this._linkifier,this._cssModel);e.selectable=!1,this._elementGrid.insertChild(e)}this._elementGrid.setColumnsVisiblity(s),this._elementGrid.renderInline(),this._elementGrid.wasShown()}}class oe extends f.SortableDataGridNode{constructor(e,t,s,i){super(e,t.hasChildren),this.data=t,this._linkifier=s,this._cssModel=i}createCell(e){if("nodeId"===e){const t=this.createTD(e);return t.textContent="...",i.Linkifier.linkify(this.data.node).then((e=>{t.textContent="",e.dataset.backendNodeId=this.data.node.backendNodeId(),t.appendChild(e);const s=document.createElement("button");s.classList.add("show-element"),b.Tooltip.install(s,ee(Y.showElement)),s.tabIndex=0,s.onclick=()=>this.data.node.scrollIntoView(),t.appendChild(s)})),t}if("sourceURL"===e){const t=this.createTD(e);if(this.data.range){const e=this._linkifyRuleLocation(this._cssModel,this._linkifier,this.data.styleSheetId,y.TextRange.fromObject(this.data.range));e&&""!==e.textContent?t.appendChild(e):t.textContent="(unable to link)"}else t.textContent="(unable to link to inlined styles)";return t}if("contrastRatio"===e){const t=this.createTD(e),s=d.experiments.isEnabled("APCA"),i=w.floor(this.data.contrastRatio,2),n=s?i+"%":i,o=u.Fragment.build`
        <div class="contrast-container-in-grid" $="container">
          <span class="contrast-preview" style="border: ${te(this.data.backgroundColor)}; color: ${this.data.textColor.asString()}; background-color: ${this.data.backgroundColor.asString()};">Aa</span>
          <span>${n}</span>
        </div>
      `,a=o.$("container");return s?(a.append(u.Fragment.build`<span>${ee(Y.apca)}</span>`.element()),this.data.thresholdsViolated.apca?a.appendChild(_.Icon.create("smallicon-no")):a.appendChild(_.Icon.create("smallicon-checkmark-square"))):(a.append(u.Fragment.build`<span>${ee(Y.aa)}</span>`.element()),this.data.thresholdsViolated.aa?a.appendChild(_.Icon.create("smallicon-no")):a.appendChild(_.Icon.create("smallicon-checkmark-square")),a.append(u.Fragment.build`<span>${ee(Y.aaa)}</span>`.element()),this.data.thresholdsViolated.aaa?a.appendChild(_.Icon.create("smallicon-no")):a.appendChild(_.Icon.create("smallicon-checkmark-square"))),t.appendChild(o.element()),t}return super.createCell(e)}_linkifyRuleLocation(e,t,s,i){const n=e.styleSheetHeaderForId(s);if(!n)return;const a=n.lineNumberInSource(i.startLine),r=n.columnNumberInSource(i.startLine,i.startColumn),l=new o.CSSLocation(n,a,r);return t.linkifyCSSLocation(l)}}var ae=Object.freeze({__proto__:null,UIStrings:Y,NodeStyleStats:undefined,ContrastIssue:undefined,OverviewData:undefined,FontInfo:undefined,CSSOverviewCompletedView:se,DetailsView:ie,ElementDetailsView:ne,ElementNode:oe});let re;class le extends m.Panel{constructor(){super("css_overview"),this.registerRequiredCSS("css_overview/cssOverview.css",{enableLegacyPatching:!1}),this.element.classList.add("css-overview-panel");const[e]=n.TargetManager.instance().models(R);this._model=e,this._controller=new $,this._startView=new D(this._controller),this._processingView=new q(this._controller),this._completedView=new se(this._controller,e.target()),this._controller.addEventListener(A.RequestOverviewStart,(e=>{I.actionTaken(k.Action.CaptureCssOverviewClicked),this._startOverview()}),this),this._controller.addEventListener(A.RequestOverviewCancel,this._cancelOverview,this),this._controller.addEventListener(A.OverviewCompleted,this._overviewCompleted,this),this._controller.addEventListener(A.Reset,this._reset,this),this._controller.addEventListener(A.RequestNodeHighlight,this._requestNodeHighlight,this),this._reset()}static instance(){return re||(re=new le),re}_reset(){this._backgroundColors=new Map,this._textColors=new Map,this._fillColors=new Map,this._borderColors=new Map,this._fontInfo=new Map,this._mediaQueries=new Map,this._unusedDeclarations=new Map,this._elementCount=0,this._cancelled=!1,this._globalStyleStats={styleRules:0,inlineStyles:0,externalSheets:0,stats:{type:0,class:0,id:0,universal:0,attribute:0,nonSimple:0}},this._renderInitialView()}_requestNodeHighlight(e){this._model.highlightNode(e.data)}_renderInitialView(){this._processingView.hideWidget(),this._completedView.hideWidget(),this._startView.show(this.contentElement)}_renderOverviewStartedView(){this._startView.hideWidget(),this._completedView.hideWidget(),this._processingView.show(this.contentElement)}_renderOverviewCompletedView(){this._startView.hideWidget(),this._processingView.hideWidget(),this._completedView.show(this.contentElement),this._completedView.setOverviewData({backgroundColors:this._backgroundColors,textColors:this._textColors,textColorContrastIssues:this._textColorContrastIssues,fillColors:this._fillColors,borderColors:this._borderColors,globalStyleStats:this._globalStyleStats,fontInfo:this._fontInfo,elementCount:this._elementCount,mediaQueries:this._mediaQueries,unusedDeclarations:this._unusedDeclarations})}async _startOverview(){this._renderOverviewStartedView();const[e,{elementCount:t,backgroundColors:s,textColors:i,textColorContrastIssues:n,fillColors:o,borderColors:a,fontInfo:r,unusedDeclarations:l},d]=await Promise.all([this._model.getGlobalStylesheetStats(),this._model.getNodeStyleStats(),this._model.getMediaQueries()]);t&&(this._elementCount=t),e&&(this._globalStyleStats=e),d&&(this._mediaQueries=d),s&&(this._backgroundColors=s),i&&(this._textColors=i),n&&(this._textColorContrastIssues=n),o&&(this._fillColors=o),a&&(this._borderColors=a),r&&(this._fontInfo=r),l&&(this._unusedDeclarations=l),this._controller.dispatchEventToListeners(A.OverviewCompleted)}_getStyleValue(e,t){const s=e.filter((e=>e.name===t));if(s.length)return s[0].value}_cancelOverview(){this._cancelled=!0}_overviewCompleted(){this._renderOverviewCompletedView()}}var de=Object.freeze({__proto__:null,CSSOverviewPanel:le});export{ae as CSSOverviewCompletedView,E as CSSOverviewController,P as CSSOverviewModel,de as CSSOverviewPanel,z as CSSOverviewProcessingView,J as CSSOverviewSidebarPanel,H as CSSOverviewStartView,L as CSSOverviewUnusedDeclarations};
