/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

#include "InspectorBackendDispatcher.h"
#include "InspectorFrontendRouter.h"
#include "InspectorProtocolObjects.h"

namespace Inspector {

class AlternateBackendDispatcher {
public:
    void setBackendDispatcher(RefPtr<BackendDispatcher>&& dispatcher) { m_backendDispatcher = WTFMove(dispatcher); }
    BackendDispatcher* backendDispatcher() const { return m_backendDispatcher.get(); }
private:
    RefPtr<BackendDispatcher> m_backendDispatcher;
};


class AlternateAnimationBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateAnimationBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void requestEffectTarget(long protocol_requestId, const String& animationId) = 0;
    virtual void resolveAnimation(long protocol_requestId, const String& animationId, const String& opt_objectGroup) = 0;
    virtual void startTracking(long protocol_requestId) = 0;
    virtual void stopTracking(long protocol_requestId) = 0;
};

class AlternateApplicationCacheBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateApplicationCacheBackendDispatcher() { }
    virtual void getFramesWithManifests(long protocol_requestId) = 0;
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void getManifestForFrame(long protocol_requestId, const String& frameId) = 0;
    virtual void getApplicationCacheForFrame(long protocol_requestId, const String& frameId) = 0;
};

class AlternateAuditBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateAuditBackendDispatcher() { }
    virtual void setup(long protocol_requestId, std::optional<int>&& opt_contextId) = 0;
    virtual void run(long protocol_requestId, const String& test, std::optional<int>&& opt_contextId) = 0;
    virtual void teardown(long protocol_requestId) = 0;
};

class AlternateBrowserBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateBrowserBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateCPUProfilerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateCPUProfilerBackendDispatcher() { }
    virtual void startTracking(long protocol_requestId) = 0;
    virtual void stopTracking(long protocol_requestId) = 0;
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class AlternateCSSBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateCSSBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void getMatchedStylesForNode(long protocol_requestId, int nodeId, std::optional<bool>&& opt_includePseudo, std::optional<bool>&& opt_includeInherited) = 0;
    virtual void getInlineStylesForNode(long protocol_requestId, int nodeId) = 0;
    virtual void getComputedStyleForNode(long protocol_requestId, int nodeId) = 0;
    virtual void getFontDataForNode(long protocol_requestId, int nodeId) = 0;
    virtual void getAllStyleSheets(long protocol_requestId) = 0;
    virtual void getStyleSheet(long protocol_requestId, const String& styleSheetId) = 0;
    virtual void getStyleSheetText(long protocol_requestId, const String& styleSheetId) = 0;
    virtual void setStyleSheetText(long protocol_requestId, const String& styleSheetId, const String& text) = 0;
    virtual void setStyleText(long protocol_requestId, Ref<JSON::Object>&& styleId, const String& text) = 0;
    virtual void setRuleSelector(long protocol_requestId, Ref<JSON::Object>&& ruleId, const String& selector) = 0;
    virtual void createStyleSheet(long protocol_requestId, const String& frameId) = 0;
    virtual void addRule(long protocol_requestId, const String& styleSheetId, const String& selector) = 0;
    virtual void getSupportedCSSProperties(long protocol_requestId) = 0;
    virtual void getSupportedSystemFontFamilyNames(long protocol_requestId) = 0;
    virtual void forcePseudoState(long protocol_requestId, int nodeId, Ref<JSON::Array>&& forcedPseudoClasses) = 0;
    virtual void setLayoutContextTypeChangedMode(long protocol_requestId, const String& mode) = 0;
};

class AlternateCanvasBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateCanvasBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void requestNode(long protocol_requestId, const String& canvasId) = 0;
    virtual void requestContent(long protocol_requestId, const String& canvasId) = 0;
    virtual void requestClientNodes(long protocol_requestId, const String& canvasId) = 0;
    virtual void resolveContext(long protocol_requestId, const String& canvasId, const String& opt_objectGroup) = 0;
    virtual void setRecordingAutoCaptureFrameCount(long protocol_requestId, int count) = 0;
    virtual void startRecording(long protocol_requestId, const String& canvasId, std::optional<int>&& opt_frameCount, std::optional<int>&& opt_memoryLimit) = 0;
    virtual void stopRecording(long protocol_requestId, const String& canvasId) = 0;
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual void requestShaderSource(long protocol_requestId, const String& programId, const String& shaderType) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual void updateShader(long protocol_requestId, const String& programId, const String& shaderType, const String& source) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual void setShaderProgramDisabled(long protocol_requestId, const String& programId, bool disabled) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual void setShaderProgramHighlighted(long protocol_requestId, const String& programId, bool highlighted) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
};

class AlternateConsoleBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateConsoleBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void clearMessages(long protocol_requestId) = 0;
    virtual void getLoggingChannels(long protocol_requestId) = 0;
    virtual void setLoggingChannelLevel(long protocol_requestId, const String& source, const String& level) = 0;
};

class AlternateDOMBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDOMBackendDispatcher() { }
    virtual void getDocument(long protocol_requestId) = 0;
    virtual void requestChildNodes(long protocol_requestId, int nodeId, std::optional<int>&& opt_depth) = 0;
    virtual void querySelector(long protocol_requestId, int nodeId, const String& selector) = 0;
    virtual void querySelectorAll(long protocol_requestId, int nodeId, const String& selector) = 0;
    virtual void setNodeName(long protocol_requestId, int nodeId, const String& name) = 0;
    virtual void setNodeValue(long protocol_requestId, int nodeId, const String& value) = 0;
    virtual void removeNode(long protocol_requestId, int nodeId) = 0;
    virtual void setAttributeValue(long protocol_requestId, int nodeId, const String& name, const String& value) = 0;
    virtual void setAttributesAsText(long protocol_requestId, int nodeId, const String& text, const String& opt_name) = 0;
    virtual void removeAttribute(long protocol_requestId, int nodeId, const String& name) = 0;
    virtual void getSupportedEventNames(long protocol_requestId) = 0;
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual void getDataBindingsForNode(long protocol_requestId, int nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual void getAssociatedDataForNode(long protocol_requestId, int nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual void getEventListenersForNode(long protocol_requestId, int nodeId) = 0;
    virtual void setEventListenerDisabled(long protocol_requestId, int eventListenerId, bool disabled) = 0;
    virtual void setBreakpointForEventListener(long protocol_requestId, int eventListenerId, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void removeBreakpointForEventListener(long protocol_requestId, int eventListenerId) = 0;
    virtual void getAccessibilityPropertiesForNode(long protocol_requestId, int nodeId) = 0;
    virtual void getOuterHTML(long protocol_requestId, int nodeId) = 0;
    virtual void setOuterHTML(long protocol_requestId, int nodeId, const String& outerHTML) = 0;
    virtual void insertAdjacentHTML(long protocol_requestId, int nodeId, const String& position, const String& html) = 0;
    virtual void performSearch(long protocol_requestId, const String& query, RefPtr<JSON::Array>&& opt_nodeIds, std::optional<bool>&& opt_caseSensitive) = 0;
    virtual void getSearchResults(long protocol_requestId, const String& searchId, int fromIndex, int toIndex) = 0;
    virtual void discardSearchResults(long protocol_requestId, const String& searchId) = 0;
    virtual void requestNode(long protocol_requestId, const String& objectId) = 0;
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual void setInspectModeEnabled(long protocol_requestId, bool enabled, RefPtr<JSON::Object>&& opt_highlightConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void setInspectModeEnabled(long protocol_requestId, bool enabled, RefPtr<JSON::Object>&& opt_highlightConfig, std::optional<bool>&& opt_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void highlightRect(long protocol_requestId, int x, int y, int width, int height, RefPtr<JSON::Object>&& opt_color, RefPtr<JSON::Object>&& opt_outlineColor, std::optional<bool>&& opt_usePageCoordinates) = 0;
    virtual void highlightQuad(long protocol_requestId, Ref<JSON::Array>&& quad, RefPtr<JSON::Object>&& opt_color, RefPtr<JSON::Object>&& opt_outlineColor, std::optional<bool>&& opt_usePageCoordinates) = 0;
    virtual void highlightSelector(long protocol_requestId, Ref<JSON::Object>&& highlightConfig, const String& selectorString, const String& opt_frameId) = 0;
    virtual void highlightNode(long protocol_requestId, Ref<JSON::Object>&& highlightConfig, std::optional<int>&& opt_nodeId, const String& opt_objectId) = 0;
    virtual void highlightNodeList(long protocol_requestId, Ref<JSON::Array>&& nodeIds, Ref<JSON::Object>&& highlightConfig) = 0;
    virtual void hideHighlight(long protocol_requestId) = 0;
    virtual void highlightFrame(long protocol_requestId, const String& frameId, RefPtr<JSON::Object>&& opt_contentColor, RefPtr<JSON::Object>&& opt_contentOutlineColor) = 0;
    virtual void showGridOverlay(long protocol_requestId, int nodeId, Ref<JSON::Object>&& gridColor, std::optional<bool>&& opt_showLineNames, std::optional<bool>&& opt_showLineNumbers, std::optional<bool>&& opt_showExtendedGridLines, std::optional<bool>&& opt_showTrackSizes, std::optional<bool>&& opt_showAreaNames) = 0;
    virtual void hideGridOverlay(long protocol_requestId, std::optional<int>&& opt_nodeId) = 0;
    virtual void showFlexOverlay(long protocol_requestId, int nodeId, Ref<JSON::Object>&& flexColor, std::optional<bool>&& opt_showOrderNumbers) = 0;
    virtual void hideFlexOverlay(long protocol_requestId, std::optional<int>&& opt_nodeId) = 0;
    virtual void pushNodeByPathToFrontend(long protocol_requestId, const String& path) = 0;
    virtual void resolveNode(long protocol_requestId, std::optional<int>&& opt_nodeId, const String& opt_objectId, std::optional<int>&& opt_executionContextId, const String& opt_objectGroup) = 0;
    virtual void getAttributes(long protocol_requestId, int nodeId) = 0;
    virtual void moveTo(long protocol_requestId, int nodeId, int targetNodeId, std::optional<int>&& opt_insertBeforeNodeId) = 0;
    virtual void undo(long protocol_requestId) = 0;
    virtual void redo(long protocol_requestId) = 0;
    virtual void markUndoableState(long protocol_requestId) = 0;
    virtual void focus(long protocol_requestId, int nodeId) = 0;
    virtual void setInspectedNode(long protocol_requestId, int nodeId) = 0;
    virtual void setAllowEditingUserAgentShadowTrees(long protocol_requestId, bool allow) = 0;
    virtual void describeNode(long protocol_requestId, const String& objectId) = 0;
    virtual void scrollIntoViewIfNeeded(long protocol_requestId, const String& objectId, RefPtr<JSON::Object>&& opt_rect) = 0;
    virtual void getContentQuads(long protocol_requestId, const String& objectId) = 0;
    virtual void setInputFiles(long protocol_requestId, const String& objectId, RefPtr<JSON::Array>&& opt_files, RefPtr<JSON::Array>&& opt_paths) = 0;
};

class AlternateDOMDebuggerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDOMDebuggerBackendDispatcher() { }
    virtual void setDOMBreakpoint(long protocol_requestId, int nodeId, const String& type, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void removeDOMBreakpoint(long protocol_requestId, int nodeId, const String& type) = 0;
    virtual void setEventBreakpoint(long protocol_requestId, const String& breakpointType, const String& opt_eventName, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void removeEventBreakpoint(long protocol_requestId, const String& breakpointType, const String& opt_eventName) = 0;
    virtual void setURLBreakpoint(long protocol_requestId, const String& url, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void removeURLBreakpoint(long protocol_requestId, const String& url, std::optional<bool>&& opt_isRegex) = 0;
};

class AlternateDOMStorageBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDOMStorageBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void getDOMStorageItems(long protocol_requestId, Ref<JSON::Object>&& storageId) = 0;
    virtual void setDOMStorageItem(long protocol_requestId, Ref<JSON::Object>&& storageId, const String& key, const String& value) = 0;
    virtual void removeDOMStorageItem(long protocol_requestId, Ref<JSON::Object>&& storageId, const String& key) = 0;
    virtual void clearDOMStorageItems(long protocol_requestId, Ref<JSON::Object>&& storageId) = 0;
};

class AlternateDatabaseBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDatabaseBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void getDatabaseTableNames(long protocol_requestId, const String& databaseId) = 0;
    virtual void executeSQL(long protocol_requestId, const String& databaseId, const String& query) = 0;
};

class AlternateDebuggerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDebuggerBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void setAsyncStackTraceDepth(long protocol_requestId, int depth) = 0;
    virtual void setBreakpointsActive(long protocol_requestId, bool active) = 0;
    virtual void setBreakpointByUrl(long protocol_requestId, int lineNumber, const String& opt_url, const String& opt_urlRegex, std::optional<int>&& opt_columnNumber, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void setBreakpoint(long protocol_requestId, Ref<JSON::Object>&& location, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void removeBreakpoint(long protocol_requestId, const String& breakpointId) = 0;
    virtual void continueUntilNextRunLoop(long protocol_requestId) = 0;
    virtual void continueToLocation(long protocol_requestId, Ref<JSON::Object>&& location) = 0;
    virtual void stepNext(long protocol_requestId) = 0;
    virtual void stepOver(long protocol_requestId) = 0;
    virtual void stepInto(long protocol_requestId) = 0;
    virtual void stepOut(long protocol_requestId) = 0;
    virtual void pause(long protocol_requestId) = 0;
    virtual void resume(long protocol_requestId) = 0;
    virtual void searchInContent(long protocol_requestId, const String& scriptId, const String& query, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual void getScriptSource(long protocol_requestId, const String& scriptId) = 0;
    virtual void getFunctionDetails(long protocol_requestId, const String& functionId) = 0;
    virtual void setPauseOnDebuggerStatements(long protocol_requestId, bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void setPauseOnExceptions(long protocol_requestId, const String& state, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void setPauseOnAssertions(long protocol_requestId, bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void setPauseOnMicrotasks(long protocol_requestId, bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual void setPauseForInternalScripts(long protocol_requestId, bool shouldPause) = 0;
    virtual void evaluateOnCallFrame(long protocol_requestId, const String& callFrameId, const String& expression, const String& opt_objectGroup, std::optional<bool>&& opt_includeCommandLineAPI, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, std::optional<bool>&& opt_emulateUserGesture) = 0;
    virtual void setShouldBlackboxURL(long protocol_requestId, const String& url, bool shouldBlackbox, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual void setBlackboxBreakpointEvaluations(long protocol_requestId, bool blackboxBreakpointEvaluations) = 0;
};

class AlternateDialogBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDialogBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void handleJavaScriptDialog(long protocol_requestId, bool accept, const String& opt_promptText) = 0;
};

class AlternateEmulationBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateEmulationBackendDispatcher() { }
    virtual void setDeviceMetricsOverride(long protocol_requestId, int width, int height, bool fixedLayout, std::optional<double>&& opt_deviceScaleFactor) = 0;
    virtual void setJavaScriptEnabled(long protocol_requestId, bool enabled) = 0;
    virtual void setAuthCredentials(long protocol_requestId, const String& opt_username, const String& opt_password) = 0;
    virtual void setActiveAndFocused(long protocol_requestId, std::optional<bool>&& opt_active) = 0;
    virtual void grantPermissions(long protocol_requestId, const String& origin, Ref<JSON::Array>&& permissions) = 0;
    virtual void resetPermissions(long protocol_requestId) = 0;
};

class AlternateHeapBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateHeapBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void gc(long protocol_requestId) = 0;
    virtual void snapshot(long protocol_requestId) = 0;
    virtual void startTracking(long protocol_requestId) = 0;
    virtual void stopTracking(long protocol_requestId) = 0;
    virtual void getPreview(long protocol_requestId, int heapObjectId) = 0;
    virtual void getRemoteObject(long protocol_requestId, int heapObjectId, const String& opt_objectGroup) = 0;
};

class AlternateIndexedDBBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateIndexedDBBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void requestDatabaseNames(long protocol_requestId, const String& securityOrigin) = 0;
    virtual void requestDatabase(long protocol_requestId, const String& securityOrigin, const String& databaseName) = 0;
    virtual void requestData(long protocol_requestId, const String& securityOrigin, const String& databaseName, const String& objectStoreName, const String& indexName, int skipCount, int pageSize, RefPtr<JSON::Object>&& opt_keyRange) = 0;
    virtual void clearObjectStore(long protocol_requestId, const String& securityOrigin, const String& databaseName, const String& objectStoreName) = 0;
};

class AlternateInputBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateInputBackendDispatcher() { }
    virtual void dispatchKeyEvent(long protocol_requestId, const String& type, std::optional<int>&& opt_modifiers, const String& opt_text, const String& opt_unmodifiedText, const String& opt_code, const String& opt_key, std::optional<int>&& opt_windowsVirtualKeyCode, std::optional<int>&& opt_nativeVirtualKeyCode, std::optional<bool>&& opt_autoRepeat, std::optional<bool>&& opt_isKeypad, std::optional<bool>&& opt_isSystemKey, RefPtr<JSON::Array>&& opt_macCommands) = 0;
    virtual void dispatchMouseEvent(long protocol_requestId, const String& type, int x, int y, std::optional<int>&& opt_modifiers, const String& opt_button, std::optional<int>&& opt_buttons, std::optional<int>&& opt_clickCount, std::optional<int>&& opt_deltaX, std::optional<int>&& opt_deltaY) = 0;
    virtual void dispatchWheelEvent(long protocol_requestId, int x, int y, std::optional<int>&& opt_modifiers, std::optional<int>&& opt_deltaX, std::optional<int>&& opt_deltaY) = 0;
    virtual void dispatchTapEvent(long protocol_requestId, int x, int y, std::optional<int>&& opt_modifiers) = 0;
};

class AlternateInspectorBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateInspectorBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void initialized(long protocol_requestId) = 0;
};

class AlternateLayerTreeBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateLayerTreeBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void layersForNode(long protocol_requestId, int nodeId) = 0;
    virtual void reasonsForCompositingLayer(long protocol_requestId, const String& layerId) = 0;
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateMemoryBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateMemoryBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void startTracking(long protocol_requestId) = 0;
    virtual void stopTracking(long protocol_requestId) = 0;
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class AlternateNetworkBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateNetworkBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void setExtraHTTPHeaders(long protocol_requestId, Ref<JSON::Object>&& headers) = 0;
    virtual void getResponseBody(long protocol_requestId, const String& requestId) = 0;
    virtual void setResourceCachingDisabled(long protocol_requestId, bool disabled) = 0;
    virtual void loadResource(long protocol_requestId, const String& frameId, const String& url) = 0;
    virtual void getSerializedCertificate(long protocol_requestId, const String& requestId) = 0;
    virtual void resolveWebSocket(long protocol_requestId, const String& requestId, const String& opt_objectGroup) = 0;
    virtual void setInterceptionEnabled(long protocol_requestId, bool enabled) = 0;
    virtual void addInterception(long protocol_requestId, const String& url, const String& stage, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual void removeInterception(long protocol_requestId, const String& url, const String& stage, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual void interceptContinue(long protocol_requestId, const String& requestId, const String& stage) = 0;
    virtual void interceptWithRequest(long protocol_requestId, const String& requestId, const String& opt_url, const String& opt_method, RefPtr<JSON::Object>&& opt_headers, const String& opt_postData) = 0;
    virtual void interceptWithResponse(long protocol_requestId, const String& requestId, const String& content, bool base64Encoded, const String& opt_mimeType, std::optional<int>&& opt_status, const String& opt_statusText, RefPtr<JSON::Object>&& opt_headers) = 0;
    virtual void interceptRequestWithResponse(long protocol_requestId, const String& requestId, const String& content, bool base64Encoded, const String& mimeType, int status, const String& statusText, Ref<JSON::Object>&& headers) = 0;
    virtual void interceptRequestWithError(long protocol_requestId, const String& requestId, const String& errorType) = 0;
#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    virtual void setEmulatedConditions(long protocol_requestId, std::optional<int>&& opt_bytesPerSecondLimit) = 0;
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    virtual void setEmulateOfflineState(long protocol_requestId, bool offline) = 0;
};

class AlternatePageBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternatePageBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void reload(long protocol_requestId, std::optional<bool>&& opt_ignoreCache, std::optional<bool>&& opt_revalidateAllResources) = 0;
    virtual void goBack(long protocol_requestId) = 0;
    virtual void goForward(long protocol_requestId) = 0;
    virtual void navigate(long protocol_requestId, const String& url) = 0;
    virtual void overrideUserAgent(long protocol_requestId, const String& opt_value) = 0;
    virtual void overridePlatform(long protocol_requestId, const String& opt_value) = 0;
    virtual void overrideSetting(long protocol_requestId, const String& setting, std::optional<bool>&& opt_value) = 0;
    virtual void getCookies(long protocol_requestId) = 0;
    virtual void setCookie(long protocol_requestId, Ref<JSON::Object>&& cookie) = 0;
    virtual void deleteCookie(long protocol_requestId, const String& cookieName, const String& url) = 0;
    virtual void getResourceTree(long protocol_requestId) = 0;
    virtual void getResourceContent(long protocol_requestId, const String& frameId, const String& url) = 0;
    virtual void setBootstrapScript(long protocol_requestId, const String& opt_source, const String& opt_worldName) = 0;
    virtual void searchInResource(long protocol_requestId, const String& frameId, const String& url, const String& query, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, const String& opt_requestId) = 0;
    virtual void searchInResources(long protocol_requestId, const String& text, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void setShowRulers(long protocol_requestId, bool result) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void setShowPaintRects(long protocol_requestId, bool result) = 0;
    virtual void setEmulatedMedia(long protocol_requestId, const String& media) = 0;
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    virtual void setForcedAppearance(long protocol_requestId, const String& opt_appearance) = 0;
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    virtual void setForcedReducedMotion(long protocol_requestId, const String& opt_reducedMotion) = 0;
    virtual void setTimeZone(long protocol_requestId, const String& opt_timeZone) = 0;
    virtual void setTouchEmulationEnabled(long protocol_requestId, bool enabled) = 0;
    virtual void snapshotNode(long protocol_requestId, int nodeId) = 0;
    virtual void snapshotRect(long protocol_requestId, int x, int y, int width, int height, const String& coordinateSystem, std::optional<bool>&& opt_omitDeviceScaleFactor) = 0;
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual void archive(long protocol_requestId) = 0;
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual void setScreenSizeOverride(long protocol_requestId, std::optional<int>&& opt_width, std::optional<int>&& opt_height) = 0;
    virtual void insertText(long protocol_requestId, const String& text) = 0;
    virtual void setComposition(long protocol_requestId, const String& text, int selectionStart, int selectionLength, std::optional<int>&& opt_replacementStart, std::optional<int>&& opt_replacementLength) = 0;
    virtual void accessibilitySnapshot(long protocol_requestId, const String& opt_objectId) = 0;
    virtual void setInterceptFileChooserDialog(long protocol_requestId, bool enabled) = 0;
    virtual void setDefaultBackgroundColorOverride(long protocol_requestId, RefPtr<JSON::Object>&& opt_color) = 0;
    virtual void createUserWorld(long protocol_requestId, const String& name) = 0;
    virtual void setBypassCSP(long protocol_requestId, bool enabled) = 0;
    virtual void crash(long protocol_requestId) = 0;
    virtual void setOrientationOverride(long protocol_requestId, std::optional<int>&& opt_angle) = 0;
    virtual void setVisibleContentRects(long protocol_requestId, RefPtr<JSON::Object>&& opt_unobscuredContentRect, RefPtr<JSON::Object>&& opt_contentInsets, RefPtr<JSON::Object>&& opt_obscuredInsets, RefPtr<JSON::Object>&& opt_unobscuredInsets) = 0;
    virtual void updateScrollingState(long protocol_requestId) = 0;
};

class AlternatePlaywrightBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternatePlaywrightBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void close(long protocol_requestId) = 0;
    virtual void createContext(long protocol_requestId, const String& opt_proxyServer, const String& opt_proxyBypassList) = 0;
    virtual void deleteContext(long protocol_requestId, const String& browserContextId) = 0;
    virtual void createPage(long protocol_requestId, const String& opt_browserContextId) = 0;
    virtual void navigate(long protocol_requestId, const String& url, const String& pageProxyId, const String& opt_frameId, const String& opt_referrer) = 0;
    virtual void grantFileReadAccess(long protocol_requestId, const String& pageProxyId, Ref<JSON::Array>&& paths) = 0;
    virtual void setIgnoreCertificateErrors(long protocol_requestId, const String& opt_browserContextId, bool ignore) = 0;
    virtual void getAllCookies(long protocol_requestId, const String& opt_browserContextId) = 0;
    virtual void setCookies(long protocol_requestId, const String& opt_browserContextId, Ref<JSON::Array>&& cookies) = 0;
    virtual void deleteAllCookies(long protocol_requestId, const String& opt_browserContextId) = 0;
    virtual void setGeolocationOverride(long protocol_requestId, const String& opt_browserContextId, RefPtr<JSON::Object>&& opt_geolocation) = 0;
    virtual void setLanguages(long protocol_requestId, Ref<JSON::Array>&& languages, const String& opt_browserContextId) = 0;
    virtual void setDownloadBehavior(long protocol_requestId, const String& opt_behavior, const String& opt_downloadPath, const String& opt_browserContextId) = 0;
    virtual void cancelDownload(long protocol_requestId, const String& uuid) = 0;
};

class AlternateRuntimeBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateRuntimeBackendDispatcher() { }
    virtual void parse(long protocol_requestId, const String& source) = 0;
    virtual void evaluate(long protocol_requestId, const String& expression, const String& opt_objectGroup, std::optional<bool>&& opt_includeCommandLineAPI, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<int>&& opt_contextId, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, std::optional<bool>&& opt_emulateUserGesture) = 0;
    virtual void awaitPromise(long protocol_requestId, const String& promiseObjectId, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult) = 0;
    virtual void callFunctionOn(long protocol_requestId, const String& objectId, const String& functionDeclaration, RefPtr<JSON::Array>&& opt_arguments, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_emulateUserGesture, std::optional<bool>&& opt_awaitPromise) = 0;
    virtual void addBinding(long protocol_requestId, const String& name) = 0;
    virtual void getPreview(long protocol_requestId, const String& objectId) = 0;
    virtual void getProperties(long protocol_requestId, const String& objectId, std::optional<bool>&& opt_ownProperties, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount, std::optional<bool>&& opt_generatePreview) = 0;
    virtual void getDisplayableProperties(long protocol_requestId, const String& objectId, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount, std::optional<bool>&& opt_generatePreview) = 0;
    virtual void getCollectionEntries(long protocol_requestId, const String& objectId, const String& opt_objectGroup, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount) = 0;
    virtual void saveResult(long protocol_requestId, Ref<JSON::Object>&& value, std::optional<int>&& opt_contextId) = 0;
    virtual void setSavedResultAlias(long protocol_requestId, const String& opt_alias) = 0;
    virtual void releaseObject(long protocol_requestId, const String& objectId) = 0;
    virtual void releaseObjectGroup(long protocol_requestId, const String& objectGroup) = 0;
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void getRuntimeTypesForVariablesAtOffsets(long protocol_requestId, Ref<JSON::Array>&& locations) = 0;
    virtual void enableTypeProfiler(long protocol_requestId) = 0;
    virtual void disableTypeProfiler(long protocol_requestId) = 0;
    virtual void enableControlFlowProfiler(long protocol_requestId) = 0;
    virtual void disableControlFlowProfiler(long protocol_requestId) = 0;
    virtual void getBasicBlocks(long protocol_requestId, const String& sourceID) = 0;
};

class AlternateScreencastBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateScreencastBackendDispatcher() { }
    virtual void startVideo(long protocol_requestId, const String& file, int width, int height, int toolbarHeight) = 0;
    virtual void stopVideo(long protocol_requestId) = 0;
    virtual void startScreencast(long protocol_requestId, int width, int height, int toolbarHeight, int quality) = 0;
    virtual void stopScreencast(long protocol_requestId) = 0;
    virtual void screencastFrameAck(long protocol_requestId, int generation) = 0;
};

class AlternateScriptProfilerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateScriptProfilerBackendDispatcher() { }
    virtual void startTracking(long protocol_requestId, std::optional<bool>&& opt_includeSamples) = 0;
    virtual void stopTracking(long protocol_requestId) = 0;
};

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
class AlternateServiceWorkerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateServiceWorkerBackendDispatcher() { }
    virtual void getInitializationInfo(long protocol_requestId) = 0;
};
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

class AlternateTargetBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateTargetBackendDispatcher() { }
    virtual void setPauseOnStart(long protocol_requestId, bool pauseOnStart) = 0;
    virtual void resume(long protocol_requestId, const String& targetId) = 0;
    virtual void sendMessageToTarget(long protocol_requestId, const String& targetId, const String& message) = 0;
    virtual void activate(long protocol_requestId, const String& targetId) = 0;
    virtual void close(long protocol_requestId, const String& targetId, std::optional<bool>&& opt_runBeforeUnload) = 0;
};

class AlternateTimelineBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateTimelineBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void start(long protocol_requestId, std::optional<int>&& opt_maxCallStackDepth) = 0;
    virtual void stop(long protocol_requestId) = 0;
    virtual void setAutoCaptureEnabled(long protocol_requestId, bool enabled) = 0;
    virtual void setInstruments(long protocol_requestId, Ref<JSON::Array>&& instruments) = 0;
};

class AlternateWorkerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateWorkerBackendDispatcher() { }
    virtual void enable(long protocol_requestId) = 0;
    virtual void disable(long protocol_requestId) = 0;
    virtual void initialized(long protocol_requestId, const String& workerId) = 0;
    virtual void sendMessageToWorker(long protocol_requestId, const String& workerId, const String& message) = 0;
};

} // namespace Inspector

#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
