import{UIString as t,ls as e,Color as s,Settings as i,Throttler as n,ObjectWrapper as o}from"../common/common.js";import{NumberUtilities as r}from"../platform/platform.js";import{UIUtils as a,Geometry as h,Widget as l,KeyboardShortcut as d,Utils as c,Icon as u,GlassPane as p}from"../ui/ui.js";import{GetStylesheet as _}from"../component_helpers/component_helpers.js";import*as m from"../third_party/lit-html/lit-html.js";import{render as g,html as v,Directives as f}from"../third_party/lit-html/lit-html.js";import{TextUtils as S}from"../text_utils/text_utils.js";class w{constructor(t,e,s,i,n){this.width=t,this.height=e,this.marginTop=s,this.radius=i,this.linearLine=n}static drawVelocityChart(t,e,s){const i=b;let n=["M",0,i];let o=t.evaluateAt(0);for(let e=1/40;e<1.025;e+=1/40){const r=t.evaluateAt(e);let a=(r.y-o.y)/(r.x-o.x);const h=o.x*(1-e)+r.x*e;a=Math.tanh(a/1.5),n=n.concat(["L",(h*s).toFixed(2),(i-a*i).toFixed(2)]),o=r}n=n.concat(["L",s.toFixed(2),i,"Z"]),e.setAttribute("d",n.join(" "))}curveWidth(){return this.width-2*this.radius}curveHeight(){return this.height-2*this.radius-2*this.marginTop}_drawLine(t,e,s,i,n,o){const r=a.createSVGChild(t,"line",e);r.setAttribute("x1",String(s+this.radius)),r.setAttribute("y1",String(i+this.radius+this.marginTop)),r.setAttribute("x2",String(n+this.radius)),r.setAttribute("y2",String(o+this.radius+this.marginTop))}_drawControlPoints(t,e,s,i,n){this._drawLine(t,"bezier-control-line",e,s,i,n);const o=a.createSVGChild(t,"circle","bezier-control-circle");o.setAttribute("cx",String(i+this.radius)),o.setAttribute("cy",String(n+this.radius+this.marginTop)),o.setAttribute("r",String(this.radius))}drawCurve(t,e){if(!t)return;const s=this.curveWidth(),i=this.curveHeight();e.setAttribute("width",String(this.width)),e.setAttribute("height",String(this.height)),e.removeChildren();const n=a.createSVGChild(e,"g");this.linearLine&&this._drawLine(n,"linear-line",0,i,s,0);const o=a.createSVGChild(n,"path","bezier-path"),r=[new h.Point(t.controlPoints[0].x*s+this.radius,(1-t.controlPoints[0].y)*i+this.radius+this.marginTop),new h.Point(t.controlPoints[1].x*s+this.radius,(1-t.controlPoints[1].y)*i+this.radius+this.marginTop),new h.Point(s+this.radius,this.marginTop+this.radius)];o.setAttribute("d","M"+this.radius+","+(i+this.radius+this.marginTop)+" C"+r.join(" ")),this._drawControlPoints(n,0,i,t.controlPoints[0].x*s,(1-t.controlPoints[0].y)*i),this._drawControlPoints(n,s,0,t.controlPoints[1].x*s,(1-t.controlPoints[1].y)*i)}}const b=26;var x=Object.freeze({__proto__:null,BezierUI:w,Height:b});class C extends l.VBox{constructor(t){super(!0),this._bezier=t,this.registerRequiredCSS("inline_editor/bezierEditor.css",{enableLegacyPatching:!0}),this.contentElement.tabIndex=0,this.setDefaultFocusedElement(this.contentElement),this._previewElement=this.contentElement.createChild("div","bezier-preview-container"),this._previewElement.createChild("div","bezier-preview-animation"),this._previewElement.addEventListener("click",this._startPreviewAnimation.bind(this)),this._previewOnion=this.contentElement.createChild("div","bezier-preview-onion"),this._previewOnion.addEventListener("click",this._startPreviewAnimation.bind(this)),this._outerContainer=this.contentElement.createChild("div","bezier-container"),this._selectedCategory=null,this._presetsContainer=this._outerContainer.createChild("div","bezier-presets"),this._presetUI=new w(40,40,0,2,!1),this._presetCategories=[];for(let t=0;t<E.length;t++)this._presetCategories[t]=this._createCategory(E[t]),this._presetsContainer.appendChild(this._presetCategories[t].icon);this._curveUI=new w(150,250,50,7,!0),this._curve=a.createSVGChild(this._outerContainer,"svg","bezier-curve"),a.installDragHandle(this._curve,this._dragStart.bind(this),this._dragMove.bind(this),this._dragEnd.bind(this),"default"),this._header=this.contentElement.createChild("div","bezier-header");const e=this._createPresetModifyIcon(this._header,"bezier-preset-minus","M 12 6 L 8 10 L 12 14"),s=this._createPresetModifyIcon(this._header,"bezier-preset-plus","M 8 6 L 12 10 L 8 14");e.addEventListener("click",this._presetModifyClicked.bind(this,!1)),s.addEventListener("click",this._presetModifyClicked.bind(this,!0)),this._label=this._header.createChild("span","source-code bezier-display-value")}setBezier(t){t&&(this._bezier=t,this._updateUI())}bezier(){return this._bezier}wasShown(){this._unselectPresets();for(const t of this._presetCategories)for(let e=0;e<t.presets.length;e++)this._bezier.asCSSText()===t.presets[e].value&&(t.presetIndex=e,this._presetCategorySelected(t));this._updateUI(),this._startPreviewAnimation()}_onchange(){this._updateUI(),this.dispatchEventToListeners(y.BezierChanged,this._bezier.asCSSText())}_updateUI(){const e=this._selectedCategory?this._selectedCategory.presets[this._selectedCategory.presetIndex].name:this._bezier.asCSSText().replace(/\s(-\d\.\d)/g,"$1");this._label.textContent=t.UIString(e),this._curveUI.drawCurve(this._bezier,this._curve),this._previewOnion.removeChildren()}_dragStart(t){this._mouseDownPosition=new h.Point(t.x,t.y);const e=this._curveUI;this._controlPosition=new h.Point(r.clamp((t.offsetX-e.radius)/e.curveWidth(),0,1),(e.curveHeight()+e.marginTop+e.radius-t.offsetY)/e.curveHeight());const s=this._controlPosition.distanceTo(this._bezier.controlPoints[0])<this._controlPosition.distanceTo(this._bezier.controlPoints[1]);return this._selectedPoint=s?0:1,this._bezier.controlPoints[this._selectedPoint]=this._controlPosition,this._unselectPresets(),this._onchange(),t.consume(!0),!0}_updateControlPosition(t,e){if(void 0===this._mouseDownPosition||void 0===this._controlPosition||void 0===this._selectedPoint)return;const s=(t-this._mouseDownPosition.x)/this._curveUI.curveWidth(),i=(e-this._mouseDownPosition.y)/this._curveUI.curveHeight(),n=new h.Point(r.clamp(this._controlPosition.x+s,0,1),this._controlPosition.y-i);this._bezier.controlPoints[this._selectedPoint]=n}_dragMove(t){this._updateControlPosition(t.x,t.y),this._onchange()}_dragEnd(t){this._updateControlPosition(t.x,t.y),this._onchange(),this._startPreviewAnimation()}_createCategory(t){const e=document.createElement("div");e.classList.add("bezier-preset-category");const s=a.createSVGChild(e,"svg","bezier-preset monospace"),i={presets:t,presetIndex:0,icon:e};return this._presetUI.drawCurve(h.CubicBezier.parse(i.presets[0].value),s),s.addEventListener("click",this._presetCategorySelected.bind(this,i)),i}_createPresetModifyIcon(t,e,s){const i=a.createSVGChild(t,"svg","bezier-preset-modify "+e);i.setAttribute("width","20"),i.setAttribute("height","20");return a.createSVGChild(i,"path").setAttribute("d",s),i}_unselectPresets(){for(const t of this._presetCategories)t.icon.classList.remove("bezier-preset-selected");this._selectedCategory=null,this._header.classList.remove("bezier-header-active")}_presetCategorySelected(t,e){if(this._selectedCategory===t)return;this._unselectPresets(),this._header.classList.add("bezier-header-active"),this._selectedCategory=t,this._selectedCategory.icon.classList.add("bezier-preset-selected");const s=h.CubicBezier.parse(t.presets[t.presetIndex].value);s&&(this.setBezier(s),this._onchange(),this._startPreviewAnimation()),e&&e.consume(!0)}_presetModifyClicked(t,e){if(null===this._selectedCategory)return;const s=this._selectedCategory.presets.length;this._selectedCategory.presetIndex=(this._selectedCategory.presetIndex+(t?1:-1)+s)%s;const i=h.CubicBezier.parse(this._selectedCategory.presets[this._selectedCategory.presetIndex].value);i&&(this.setBezier(i),this._onchange(),this._startPreviewAnimation())}_startPreviewAnimation(){this._previewAnimation&&this._previewAnimation.cancel();const t=[{offset:0,transform:"translateX(0px)",easing:this._bezier.asCSSText(),opacity:1},{offset:.9,transform:"translateX(218px)",opacity:1},{offset:1,transform:"translateX(218px)",opacity:0}];this._previewAnimation=this._previewElement.animate(t,1600),this._previewOnion.removeChildren();for(let t=0;t<=20;t++){const e=this._previewOnion.createChild("div","bezier-preview-animation").animate([{transform:"translateX(0px)",easing:this._bezier.asCSSText()},{transform:"translateX(218px)"}],{duration:1600,fill:"forwards"});e.pause(),e.currentTime=1600*t/20}}}const y={BezierChanged:Symbol("BezierChanged")},E=[[{name:"ease-in-out",value:"ease-in-out"},{name:"In Out · Sine",value:"cubic-bezier(0.45, 0.05, 0.55, 0.95)"},{name:"In Out · Quadratic",value:"cubic-bezier(0.46, 0.03, 0.52, 0.96)"},{name:"In Out · Cubic",value:"cubic-bezier(0.65, 0.05, 0.36, 1)"},{name:"Fast Out, Slow In",value:"cubic-bezier(0.4, 0, 0.2, 1)"},{name:"In Out · Back",value:"cubic-bezier(0.68, -0.55, 0.27, 1.55)"}],[{name:"Fast Out, Linear In",value:"cubic-bezier(0.4, 0, 1, 1)"},{name:"ease-in",value:"ease-in"},{name:"In · Sine",value:"cubic-bezier(0.47, 0, 0.75, 0.72)"},{name:"In · Quadratic",value:"cubic-bezier(0.55, 0.09, 0.68, 0.53)"},{name:"In · Cubic",value:"cubic-bezier(0.55, 0.06, 0.68, 0.19)"},{name:"In · Back",value:"cubic-bezier(0.6, -0.28, 0.74, 0.05)"}],[{name:"ease-out",value:"ease-out"},{name:"Out · Sine",value:"cubic-bezier(0.39, 0.58, 0.57, 1)"},{name:"Out · Quadratic",value:"cubic-bezier(0.25, 0.46, 0.45, 0.94)"},{name:"Out · Cubic",value:"cubic-bezier(0.22, 0.61, 0.36, 1)"},{name:"Linear Out, Slow In",value:"cubic-bezier(0, 0, 0.2, 1)"},{name:"Out · Back",value:"cubic-bezier(0.18, 0.89, 0.32, 1.28)"}]];var I=Object.freeze({__proto__:null,BezierEditor:C,Events:y,Presets:E,PresetCategory:void 0});const P=e,T=_.getStyleSheets;class z extends Event{constructor(t,e){super("format-changed",{}),this.data={format:t,text:e}}}class k extends HTMLElement{constructor(){super(),this.shadow=this.attachShadow({mode:"open"}),this.tooltip=P`Shift-click to change color format`,this.text=null,this._color=null,this._format=null,this.shadow.adoptedStyleSheets=[...T("inline_editor/colorSwatch.css",{patchThemeSupport:!1})]}get color(){return this._color}get format(){return this._format}renderColor(t,e,n){if("string"==typeof t){if(this._color=s.Color.parse(t),this.text=t,!this._color)return void this.renderTextOnly()}else this._color=t;this._format="boolean"==typeof e&&e?i.detectColorFormat(this._color):"string"==typeof e?e:this._color.format(),this.text=this._color.asString(this._format),n&&(this.tooltip=n),this.render()}renderTextOnly(){g(this.text,this.shadow,{eventContext:this})}render(){g(v`<span class="color-swatch" title="${this.tooltip}"><span class="color-swatch-inner"
        style="background-color:${this.text};"
        @click=${this.onClick}
        @mousedown=${this.consume}
        @dblclick=${this.consume}></span></span><slot><span>${this.text}</span></slot>`,this.shadow,{eventContext:this})}onClick(t){t.stopPropagation(),t.shiftKey?this.toggleNextFormat():this.dispatchEvent(new Event("swatch-click"))}consume(t){t.stopPropagation()}toggleNextFormat(){if(!this._color||!this._format)return;let t;do{this._format=L(this._color,this._format),t=this._color.asString(this._format)}while(t===this.text);t&&(this.text=t,this.render(),this.dispatchEvent(new z(this._format,this.text)))}}function L(t,e){const i=s.Format;switch(e){case i.Original:return t.hasAlpha()?i.RGBA:i.RGB;case i.RGB:case i.RGBA:return t.hasAlpha()?i.HSLA:i.HSL;case i.HSL:case i.HSLA:return t.nickname()?i.Nickname:t.detectHEXFormat();case i.ShortHEX:return i.HEX;case i.ShortHEXA:return i.HEXA;case i.HEXA:case i.HEX:return i.Original;case i.Nickname:return t.detectHEXFormat();default:return i.RGBA}}customElements.get("devtools-color-swatch")||customElements.define("devtools-color-swatch",k);var O=Object.freeze({__proto__:null,FormatChangedEvent:z,ColorSwatch:k});class A extends HTMLElement{renderColor(t,e,s){}get color(){throw new Error("Not implemented in _bridge.js")}get format(){throw new Error("Not implemented in _bridge.js")}}function R(){return document.createElement("devtools-color-swatch")}var M=Object.freeze({__proto__:null,ColorSwatchClosureInterface:A,createColorSwatch:R});const B=/(?<value>[+-]?\d*\.?\d+)(?<unit>deg|grad|rad|turn)/;var X=Object.freeze({__proto__:null,CSSAngleRegex:B});const $=(t,e)=>{let s=t;switch(e){case"grad":s=h.radiansToGradians(t);break;case"deg":s=h.radiansToDegrees(t);break;case"turn":s=h.radiansToTurns(t)}return{value:s,unit:e}},F=t=>{switch(t.unit){case"deg":return h.degreesToRadians(t.value);case"grad":return h.gradiansToRadians(t.value);case"turn":return h.turnsToRadians(t.value)}return t.value},U=(t,e)=>{const s=F(t);return{translateX:Math.sin(s)*e,translateY:-Math.cos(s)*e}},H=t=>{let e=t.value;switch(t.unit){case"deg":case"grad":e=Math.round(t.value);break;case"rad":e=Math.round(1e4*t.value)/1e4;break;case"turn":e=Math.round(100*t.value)/100}return{value:e,unit:t.unit}},V=(t,e)=>{if(t.unit===e)return t;const s=F(t);return $(s,e)},Y=(t,e)=>{const s=a.getValueModificationDirection(e);if(null===s)return;let i="Up"===s?Math.PI/180:-Math.PI/180;e.shiftKey&&(i*=10);const n=F(t);return $(n+i,t.unit)},{render:D,html:j}=m,N=f.styleMap;class K extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.angle={value:0,unit:"rad"},this.background="",this.clockRadius=38.5,this.mousemoveThrottler=new n.Throttler(16.67)}set data(t){this.angle=t.angle,this.onAngleUpdate=t.onAngleUpdate,this.background=t.background,this.render()}updateAngleFromMousePosition(t,e,s){const i=this.shadow.querySelector(".clock");if(!i||!this.onAngleUpdate)return;const{top:n,right:o,bottom:r,left:a}=i.getBoundingClientRect();this.clockRadius=(o-a)/2;const h=(a+o)/2,l=(r+n)/2,d=-Math.atan2(t-h,e-l)+Math.PI;if(s){const t=F({value:15,unit:"deg"}),e=Math.round(d/t)*t;this.onAngleUpdate($(e,this.angle.unit))}else this.onAngleUpdate($(d,this.angle.unit))}onEditorMousedown(t){t.stopPropagation(),this.updateAngleFromMousePosition(t.pageX,t.pageY,t.shiftKey)}onEditorMousemove(t){1===t.buttons&&this.mousemoveThrottler.schedule(()=>(this.updateAngleFromMousePosition(t.pageX,t.pageY,t.shiftKey),Promise.resolve()))}onEditorWheel(t){if(!this.onAngleUpdate)return;const e=Y(this.angle,t);e&&this.onAngleUpdate(e),t.preventDefault()}render(){const t={background:this.background},{translateX:e,translateY:s}=U(this.angle,this.clockRadius/2),i={transform:`translate(${e}px, ${s}px) rotate(${this.angle.value}${this.angle.unit})`};D(j`
      <style>
        .clock, .pointer, .center, .hand, .dial {
          position: absolute;
        }

        .clock {
          top: 6px;
          width: 6em;
          height: 6em;
          background-color: white;
          border: 0.5em solid var(--border-color);
          border-radius: 9em;
          box-shadow: var(--drop-shadow), inset 0 0 15px hsl(0 0% 0% / 25%);
          transform: translateX(-3em);
        }

        :host-context(.-theme-with-dark-background) .clock {
          background-color: hsl(225 5% 27%);
        }

        .pointer {
          margin: auto;
          top: 0;
          left: -0.4em;
          right: 0;
          width: 0;
          height: 0;
          border-style: solid;
          border-width: 0 0.9em 0.9em 0.9em;
          border-color: transparent transparent var(--border-color) transparent;
        }

        .center, .hand, .dial {
          margin: auto;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
        }

        .center, .hand {
          box-shadow: 0 0 2px hsl(0 0% 0% / 20%);
        }

        :host-context(.-theme-with-dark-background) .center,
        :host-context(.-theme-with-dark-background) .hand {
          box-shadow: 0 0 2px hsl(0 0% 0% / 60%);
        }

        .center {
          width: 0.7em;
          height: 0.7em;
          border-radius: 10px;
        }

        .dial {
          width: 2px;
          height: ${6}px;
          background-color: var(--dial-color);
          border-radius: 1px;
        }

        .hand {
          height: 50%;
          width: 0.3em;
          background: var(--accent-fg-color);
        }

        .hand::before {
          content: '';
          display: inline-block;
          position: absolute;
          top: -0.6em;
          left: -0.35em;
          width: 1em;
          height: 1em;
          border-radius: 1em;
          cursor: pointer;
          box-shadow: 0 0 5px hsl(0 0% 0% / 30%);
        }

        :host-context(.-theme-with-dark-background) .hand::before {
          box-shadow: 0 0 5px hsl(0 0% 0% / 80%);
        }

        .hand::before,
        .center {
          background-color: var(--accent-fg-color);
        }
      </style>

      <div class="editor">
        <span class="pointer"></span>
        <div
          class="clock"
          style=${N(t)}
          @mousedown=${this.onEditorMousedown}
          @mousemove=${this.onEditorMousemove}
          @wheel=${this.onEditorWheel}>
          ${this.renderDials()}
          <div class="hand" style=${N(i)}></div>
          <span class="center"></span>
        </div>
      </div>
    `,this.shadow,{eventContext:this})}renderDials(){return this.dialTemplates||(this.dialTemplates=[0,45,90,135,180,225,270,315].map(t=>{const e=this.clockRadius-6-3,{translateX:s,translateY:i}=U({value:t,unit:"deg"},e);return j`<span class="dial" style=${N({transform:`translate(${s}px, ${i}px) rotate(${t}deg)`})}></span>`})),this.dialTemplates}}customElements.get("devtools-css-angle-editor")||customElements.define("devtools-css-angle-editor",K);const{render:G,html:W}=m,q=f.styleMap;class Q extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.angle={value:0,unit:"rad"}}set data(t){this.angle=t.angle,this.render()}render(){const{translateX:t,translateY:e}=U(this.angle,2.75),s={transform:`translate(${t}px, ${e}px) rotate(${this.angle.value}${this.angle.unit})`};G(W`
      <style>
        .swatch {
          position: relative;
          display: inline-block;
          margin-bottom: -2px;
          width: 1em;
          height: 1em;
          border: 1px solid var(--selection-inactive-fg-color);
          border-radius: 1em;
          overflow: hidden;
          cursor: pointer;
          background-color: var(--toolbar-bg-color);
        }

        .mini-hand {
          position: absolute;
          margin: auto;
          top: 0;
          left: 0;
          right: 0;
          bottom: 0;
          height: 55%;
          width: 2px;
          background-color: var(--accent-fg-color);
          border-radius: 5px;
        }
      </style>

      <div class="swatch">
        <span class="mini-hand" style=${q(s)}></span>
      </div>
    `,this.shadow,{eventContext:this})}}customElements.get("devtools-css-angle-swatch")||customElements.define("devtools-css-angle-swatch",Q);const{render:J,html:Z}=m,tt=f.styleMap,et=new Set(["color","background","background-color"]);class st extends Event{constructor(t){super("popover-toggled",{}),this.data={open:t}}}class it extends Event{constructor(t){super("value-changed",{}),this.data={value:t}}}class nt extends Event{constructor(t){super("unit-changed",{}),this.data={value:t}}}const ot={value:0,unit:"rad"};class rt extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.angle=ot,this.displayedAngle=ot,this.propertyName="",this.propertyValue="",this.angleElement=null,this.swatchElement=null,this.popoverOpen=!1,this.popoverStyleTop="",this.onMinifyingAction=this.minify.bind(this),this.onAngleUpdate=this.updateAngle.bind(this)}set data(t){const e=(t=>{const e=t.match(B);return e&&e.groups?{value:Number(e.groups.value),unit:e.groups.unit}:null})(t.angleText);e&&(this.angle=e,this.displayedAngle={...e},this.propertyName=t.propertyName,this.propertyValue=t.propertyValue,this.containingPane=t.containingPane,this.render())}disconnectedCallback(){this.unbindMinifyingAction()}popover(){if(!this.containingPane)return;if(this.angleElement||(this.angleElement=this.shadow.querySelector(".css-angle")),this.swatchElement||(this.swatchElement=this.shadow.querySelector("devtools-css-angle-swatch")),!this.angleElement||!this.swatchElement)return;this.dispatchEvent(new st(!0)),this.bindMinifyingAction();const t=this.swatchElement.getBoundingClientRect().bottom;if(t){const e=this.containingPane.getBoundingClientRect().top;this.popoverStyleTop=t-e+"px"}this.popoverOpen=!0,this.render(),this.angleElement.focus()}minify(){!1!==this.popoverOpen&&(this.popoverOpen=!1,this.dispatchEvent(new st(!1)),this.unbindMinifyingAction(),this.render())}updateProperty(t,e){this.propertyName=t,this.propertyValue=e,this.render()}updateAngle(t){this.displayedAngle=H(V(t,this.displayedAngle.unit)),this.angle=this.displayedAngle,this.dispatchEvent(new it(`${this.angle.value}${this.angle.unit}`))}displayNextUnit(){const t=(t=>{switch(t){case"deg":return"grad";case"grad":return"rad";case"rad":return"turn";default:return"deg"}})(this.displayedAngle.unit);this.displayedAngle=H(V(this.angle,t)),this.dispatchEvent(new nt(`${this.displayedAngle.value}${this.displayedAngle.unit}`))}bindMinifyingAction(){document.addEventListener("mousedown",this.onMinifyingAction),this.containingPane&&this.containingPane.addEventListener("scroll",this.onMinifyingAction)}unbindMinifyingAction(){document.removeEventListener("mousedown",this.onMinifyingAction),this.containingPane&&this.containingPane.removeEventListener("scroll",this.onMinifyingAction)}onMiniIconClick(t){t.stopPropagation(),t.shiftKey?this.displayNextUnit():this.popoverOpen?this.minify():this.popover()}consume(t){t.stopPropagation(),t.preventDefault()}onKeydown(t){if(this.popoverOpen)switch(t.key){case"Escape":t.stopPropagation(),this.minify(),this.blur();break;case"ArrowUp":case"ArrowDown":{const e=Y(this.angle,t);e&&this.updateAngle(e),t.preventDefault();break}}}render(){J(Z`
      <style>
        .css-angle {
          display: inline-block;
          position: relative;
          outline: none;
        }

        devtools-css-angle-swatch {
          display: inline-block;
          margin-right: 2px;
        }

        devtools-css-angle-editor {
          --dial-color: #a3a3a3;
          --border-color: var(--toolbar-bg-color);
          position: fixed;
          z-index: 2;
        }
      </style>

      <div class="css-angle" @keydown=${this.onKeydown} tabindex="-1">
        <div class="preview">
          <devtools-css-angle-swatch
            @click=${this.onMiniIconClick}
            @mousedown=${this.consume}
            @dblclick=${this.consume}
            .data=${{angle:this.angle}}>
          </devtools-css-angle-swatch><slot></slot>
        </div>
        ${this.popoverOpen?this.renderPopover():null}
      </div>
    `,this.shadow,{eventContext:this})}renderPopover(){let t="";return et.has(this.propertyName)&&!this.propertyValue.match(/url\(.*\)/i)&&(t=this.propertyValue),Z`
    <devtools-css-angle-editor
      class="popover popover-css-angle"
      style=${tt({top:this.popoverStyleTop})}
      .data=${{angle:this.angle,onAngleUpdate:this.onAngleUpdate,background:t}}
    ></devtools-css-angle-editor>
    `}}customElements.get("devtools-css-angle")||customElements.define("devtools-css-angle",rt);var at=Object.freeze({__proto__:null,PopoverToggledEvent:st,ValueChangedEvent:it,UnitChangedEvent:nt,CSSAngle:rt});class ht extends HTMLElement{popover(){}minify(){}updateProperty(t,e){}set data(t){}}var lt=Object.freeze({__proto__:null,CSSAngleData:void 0,CSSAngleClosureInterface:ht,createCSSAngle:function(){return document.createElement("devtools-css-angle")}});class dt{constructor(t){this._isBoxShadow=t,this._inset=!1,this._offsetX=ut.zero(),this._offsetY=ut.zero(),this._blurRadius=ut.zero(),this._spreadRadius=ut.zero(),this._color=s.Color.parse("black"),this._format=[ct.OffsetX,ct.OffsetY]}static parseTextShadow(t){return dt._parseShadow(t,!1)}static parseBoxShadow(t){return dt._parseShadow(t,!0)}static _parseShadow(t,e){const i=[],n=S.Utils.splitStringByRegexes(t,[s.Regex,/,/g]);let o=0;for(let e=0;e<n.length;e++)if(1===n[e].regexIndex){const s=n[e];i.push(t.substring(o,s.position)),o=s.position+1}i.push(t.substring(o,t.length));const r=[];for(let t=0;t<i.length;t++){const n=new dt(e);n._format=[];let o=!0;const h=[/inset/gi,s.Regex,ut.Regex],l=S.Utils.splitStringByRegexes(i[t],h);for(let t=0;t<l.length;t++){const e=l[t];if(-1===e.regexIndex){if(/\S/.test(e.value))return[];o=!0}else{if(!o)return[];if(o=!1,0===e.regexIndex)n._inset=!0,n._format.push(ct.Inset);else if(1===e.regexIndex){const t=s.Color.parse(e.value);if(!t)return[];n._color=t,n._format.push(ct.Color)}else if(2===e.regexIndex){const t=ut.parse(e.value);if(!t)return[];const s=n._format.length>0?n._format[n._format.length-1]:"";s===ct.OffsetX?(n._offsetY=t,n._format.push(ct.OffsetY)):s===ct.OffsetY?(n._blurRadius=t,n._format.push(ct.BlurRadius)):s===ct.BlurRadius?(n._spreadRadius=t,n._format.push(ct.SpreadRadius)):(n._offsetX=t,n._format.push(ct.OffsetX))}}}if(a(n,ct.OffsetX,1,1)||a(n,ct.OffsetY,1,1)||a(n,ct.Color,0,1)||a(n,ct.BlurRadius,0,1)||a(n,ct.Inset,0,e?1:0)||a(n,ct.SpreadRadius,0,e?1:0))return[];r.push(n)}return r;function a(t,e,s,i){let n=0;for(let s=0;s<t._format.length;s++)t._format[s]===e&&n++;return n<s||n>i}}setInset(t){this._inset=t,-1===this._format.indexOf(ct.Inset)&&this._format.unshift(ct.Inset)}setOffsetX(t){this._offsetX=t}setOffsetY(t){this._offsetY=t}setBlurRadius(t){if(this._blurRadius=t,-1===this._format.indexOf(ct.BlurRadius)){const t=this._format.indexOf(ct.OffsetY);this._format.splice(t+1,0,ct.BlurRadius)}}setSpreadRadius(t){if(this._spreadRadius=t,-1===this._format.indexOf(ct.SpreadRadius)){this.setBlurRadius(this._blurRadius);const t=this._format.indexOf(ct.BlurRadius);this._format.splice(t+1,0,ct.SpreadRadius)}}setColor(t){this._color=t,-1===this._format.indexOf(ct.Color)&&this._format.push(ct.Color)}isBoxShadow(){return this._isBoxShadow}inset(){return this._inset}offsetX(){return this._offsetX}offsetY(){return this._offsetY}blurRadius(){return this._blurRadius}spreadRadius(){return this._spreadRadius}color(){return this._color}asCSSText(){const t=[];for(let e=0;e<this._format.length;e++){const s=this._format[e];s===ct.Inset&&this._inset?t.push("inset"):s===ct.OffsetX?t.push(this._offsetX.asCSSText()):s===ct.OffsetY?t.push(this._offsetY.asCSSText()):s===ct.BlurRadius?t.push(this._blurRadius.asCSSText()):s===ct.SpreadRadius?t.push(this._spreadRadius.asCSSText()):s===ct.Color&&t.push(this._color.asString(this._color.format()))}return t.join(" ")}}const ct={Inset:"I",OffsetX:"X",OffsetY:"Y",BlurRadius:"B",SpreadRadius:"S",Color:"C"};class ut{constructor(t,e){this.amount=t,this.unit=e}static parse(t){const e=new RegExp("^(?:"+ut.Regex.source+")$","i"),s=t.match(e);return s?s.length>2&&s[2]?new ut(parseFloat(s[1]),s[2]):ut.zero():null}static zero(){return new ut(0,"")}asCSSText(){return this.amount+this.unit}}ut.Regex=new RegExp("([+-]?(?:[0-9]*[.])?[0-9]+(?:[eE][+-]?[0-9]+)?)(ch|cm|em|ex|in|mm|pc|pt|px|rem|vh|vmax|vmin|vw)|[+-]?(?:0*[.])?0+(?:[eE][+-]?[0-9]+)?","gi");var pt=Object.freeze({__proto__:null,CSSShadowModel:dt,_Part:ct,CSSLength:ut});class _t extends l.VBox{constructor(){super(!0),this.registerRequiredCSS("inline_editor/cssShadowEditor.css",{enableLegacyPatching:!0}),this.contentElement.tabIndex=0,this.setDefaultFocusedElement(this.contentElement),this._typeField=this.contentElement.createChild("div","shadow-editor-field shadow-editor-flex-field"),this._typeField.createChild("label","shadow-editor-label").textContent=t.UIString("Type"),this._outsetButton=this._typeField.createChild("button","shadow-editor-button-left"),this._outsetButton.textContent=t.UIString("Outset"),this._outsetButton.addEventListener("click",this._onButtonClick.bind(this),!1),this._insetButton=this._typeField.createChild("button","shadow-editor-button-right"),this._insetButton.textContent=t.UIString("Inset"),this._insetButton.addEventListener("click",this._onButtonClick.bind(this),!1);const e=this.contentElement.createChild("div","shadow-editor-field");this._xInput=this._createTextInput(e,t.UIString("X offset"));const s=this.contentElement.createChild("div","shadow-editor-field");this._yInput=this._createTextInput(s,t.UIString("Y offset")),this._xySlider=e.createChild("canvas","shadow-editor-2D-slider"),this._xySlider.width=88,this._xySlider.height=88,this._xySlider.tabIndex=-1,this._halfCanvasSize=44,this._innerCanvasSize=this._halfCanvasSize-6,a.installDragHandle(this._xySlider,this._dragStart.bind(this),this._dragMove.bind(this),null,"default"),this._xySlider.addEventListener("keydown",this._onCanvasArrowKey.bind(this),!1),this._xySlider.addEventListener("blur",this._onCanvasBlur.bind(this),!1);const i=this.contentElement.createChild("div","shadow-editor-field shadow-editor-flex-field shadow-editor-blur-field");this._blurInput=this._createTextInput(i,t.UIString("Blur")),this._blurSlider=this._createSlider(i),this._spreadField=this.contentElement.createChild("div","shadow-editor-field shadow-editor-flex-field"),this._spreadInput=this._createTextInput(this._spreadField,t.UIString("Spread")),this._spreadSlider=this._createSlider(this._spreadField),this._model,this._canvasOrigin}_createTextInput(t,e){const s=t.createChild("label","shadow-editor-label");s.textContent=e,s.setAttribute("for",e);const i=a.createInput("shadow-editor-text-input","text");return t.appendChild(i),i.id=e,i.addEventListener("keydown",this._handleValueModification.bind(this),!1),i.addEventListener("mousewheel",this._handleValueModification.bind(this),!1),i.addEventListener("input",this._onTextInput.bind(this),!1),i.addEventListener("blur",this._onTextBlur.bind(this),!1),i}_createSlider(t){const e=a.createSlider(0,20,-1);return e.addEventListener("input",this._onSliderInput.bind(this),!1),t.appendChild(e),e}wasShown(){this._updateUI()}setModel(t){this._model=t,this._typeField.classList.toggle("hidden",!t.isBoxShadow()),this._spreadField.classList.toggle("hidden",!t.isBoxShadow()),this._updateUI()}_updateUI(){this._updateButtons(),this._xInput.value=this._model.offsetX().asCSSText(),this._yInput.value=this._model.offsetY().asCSSText(),this._blurInput.value=this._model.blurRadius().asCSSText(),this._spreadInput.value=this._model.spreadRadius().asCSSText(),this._blurSlider.value=this._model.blurRadius().amount.toString(),this._spreadSlider.value=this._model.spreadRadius().amount.toString(),this._updateCanvas(!1)}_updateButtons(){this._insetButton.classList.toggle("enabled",this._model.inset()),this._outsetButton.classList.toggle("enabled",!this._model.inset())}_updateCanvas(t){const e=this._xySlider.getContext("2d");if(!e)throw new Error("Unable to obtain canvas context");e.clearRect(0,0,this._xySlider.width,this._xySlider.height),e.save(),e.setLineDash([1,1]),e.strokeStyle="rgba(210, 210, 210, 0.8)",e.beginPath(),e.moveTo(this._halfCanvasSize,0),e.lineTo(this._halfCanvasSize,88),e.moveTo(0,this._halfCanvasSize),e.lineTo(88,this._halfCanvasSize),e.stroke(),e.restore();const s=this._sliderThumbPosition();e.save(),e.translate(this._halfCanvasSize,this._halfCanvasSize),e.lineWidth=2,e.strokeStyle="rgba(130, 130, 130, 0.75)",e.beginPath(),e.moveTo(0,0),e.lineTo(s.x,s.y),e.stroke(),t&&(e.beginPath(),e.fillStyle="rgba(66, 133, 244, 0.4)",e.arc(s.x,s.y,8,0,2*Math.PI),e.fill()),e.beginPath(),e.fillStyle="#4285F4",e.arc(s.x,s.y,6,0,2*Math.PI),e.fill(),e.restore()}_onButtonClick(t){const e=t.currentTarget===this._insetButton;e&&this._model.inset()||!e&&!this._model.inset()||(this._model.setInset(e),this._updateButtons(),this.dispatchEventToListeners(mt.ShadowChanged,this._model))}_handleValueModification(t){const e=t.currentTarget,s=a.createReplacementString(e.value,t,(function(t,e,s){s.length||(s="px");return t+e+s}));if(!s)return;const i=ut.parse(s);i&&(t.currentTarget===this._blurInput&&i.amount<0&&(i.amount=0),e.value=i.asCSSText(),e.selectionStart=0,e.selectionEnd=e.value.length,this._onTextInput(t),t.consume(!0))}_onTextInput(t){const e=t.currentTarget;this._changedElement=e,this._changedElement.classList.remove("invalid");const s=ut.parse(e.value);!s||e===this._blurInput&&s.amount<0||(e===this._xInput?(this._model.setOffsetX(s),this._updateCanvas(!1)):e===this._yInput?(this._model.setOffsetY(s),this._updateCanvas(!1)):e===this._blurInput?(this._model.setBlurRadius(s),this._blurSlider.value=s.amount.toString()):e===this._spreadInput&&(this._model.setSpreadRadius(s),this._spreadSlider.value=s.amount.toString()),this.dispatchEventToListeners(mt.ShadowChanged,this._model))}_onTextBlur(){if(!this._changedElement)return;let t=this._changedElement.value.trim()?ut.parse(this._changedElement.value):ut.zero();if(t||(t=ut.parse(this._changedElement.value+"px")),!t)return this._changedElement.classList.add("invalid"),void(this._changedElement=null);this._changedElement===this._xInput?(this._model.setOffsetX(t),this._xInput.value=t.asCSSText(),this._updateCanvas(!1)):this._changedElement===this._yInput?(this._model.setOffsetY(t),this._yInput.value=t.asCSSText(),this._updateCanvas(!1)):this._changedElement===this._blurInput?(t.amount<0&&(t=ut.zero()),this._model.setBlurRadius(t),this._blurInput.value=t.asCSSText(),this._blurSlider.value=t.amount.toString()):this._changedElement===this._spreadInput&&(this._model.setSpreadRadius(t),this._spreadInput.value=t.asCSSText(),this._spreadSlider.value=t.amount.toString()),this._changedElement=null,this.dispatchEventToListeners(mt.ShadowChanged,this._model)}_onSliderInput(t){t.currentTarget===this._blurSlider?(this._model.setBlurRadius(new ut(Number(this._blurSlider.value),this._model.blurRadius().unit||"px")),this._blurInput.value=this._model.blurRadius().asCSSText(),this._blurInput.classList.remove("invalid")):t.currentTarget===this._spreadSlider&&(this._model.setSpreadRadius(new ut(Number(this._spreadSlider.value),this._model.spreadRadius().unit||"px")),this._spreadInput.value=this._model.spreadRadius().asCSSText(),this._spreadInput.classList.remove("invalid")),this.dispatchEventToListeners(mt.ShadowChanged,this._model)}_dragStart(t){this._xySlider.focus(),this._updateCanvas(!0),this._canvasOrigin=new h.Point(this._xySlider.totalOffsetLeft()+this._halfCanvasSize,this._xySlider.totalOffsetTop()+this._halfCanvasSize);const e=new h.Point(t.x-this._canvasOrigin.x,t.y-this._canvasOrigin.y),s=this._sliderThumbPosition();return e.distanceTo(s)>=6&&this._dragMove(t),!0}_dragMove(t){let e=new h.Point(t.x-this._canvasOrigin.x,t.y-this._canvasOrigin.y);t.shiftKey&&(e=this._snapToClosestDirection(e));const s=this._constrainPoint(e,this._innerCanvasSize),i=Math.round(s.x/this._innerCanvasSize*20),n=Math.round(s.y/this._innerCanvasSize*20);t.shiftKey?(this._model.setOffsetX(new ut(i,this._model.offsetX().unit||"px")),this._model.setOffsetY(new ut(n,this._model.offsetY().unit||"px"))):(t.altKey||this._model.setOffsetX(new ut(i,this._model.offsetX().unit||"px")),d.KeyboardShortcut.eventHasCtrlOrMeta(t)||this._model.setOffsetY(new ut(n,this._model.offsetY().unit||"px"))),this._xInput.value=this._model.offsetX().asCSSText(),this._yInput.value=this._model.offsetY().asCSSText(),this._xInput.classList.remove("invalid"),this._yInput.classList.remove("invalid"),this._updateCanvas(!0),this.dispatchEventToListeners(mt.ShadowChanged,this._model)}_onCanvasBlur(){this._updateCanvas(!1)}_onCanvasArrowKey(t){const e=t;let s=0,i=0;if("ArrowRight"===e.key?s=1:"ArrowLeft"===e.key?s=-1:"ArrowUp"===e.key?i=-1:"ArrowDown"===e.key&&(i=1),s||i){if(t.consume(!0),s){const t=this._model.offsetX(),e=r.clamp(t.amount+s,-20,20);if(e===t.amount)return;this._model.setOffsetX(new ut(e,t.unit||"px")),this._xInput.value=this._model.offsetX().asCSSText(),this._xInput.classList.remove("invalid")}if(i){const t=this._model.offsetY(),e=r.clamp(t.amount+i,-20,20);if(e===t.amount)return;this._model.setOffsetY(new ut(e,t.unit||"px")),this._yInput.value=this._model.offsetY().asCSSText(),this._yInput.classList.remove("invalid")}this._updateCanvas(!0),this.dispatchEventToListeners(mt.ShadowChanged,this._model)}}_constrainPoint(t,e){return Math.abs(t.x)<=e&&Math.abs(t.y)<=e?new h.Point(t.x,t.y):t.scale(e/Math.max(Math.abs(t.x),Math.abs(t.y)))}_snapToClosestDirection(t){let e=Number.MAX_VALUE,s=t;const i=[new h.Point(0,-1),new h.Point(1,-1),new h.Point(1,0),new h.Point(1,1)];for(const n of i){const i=t.projectOn(n),o=t.distanceTo(i);o<e&&(e=o,s=i)}return s}_sliderThumbPosition(){const t=this._model.offsetX().amount/20*this._innerCanvasSize,e=this._model.offsetY().amount/20*this._innerCanvasSize;return this._constrainPoint(new h.Point(t,e),this._innerCanvasSize)}}const mt={ShadowChanged:Symbol("ShadowChanged")};var gt=Object.freeze({__proto__:null,CSSShadowEditor:_t,Events:mt});const{render:vt,html:ft,Directives:St}=m,wt=e,bt=/(var\()(--[^,)]+)(.*)/;class xt extends HTMLElement{constructor(){super(...arguments),this.shadow=this.attachShadow({mode:"open"}),this.text="",this.computedValue=null,this.fromFallback=!1,this.onLinkClick=()=>{}}set data(t){this.text=t.text,this.computedValue=t.computedValue,this.fromFallback=t.fromFallback,this.onLinkClick=t.onLinkClick,this.render()}parseVariableFunctionParts(){const t=this.text.match(bt);return t?{pre:t[1],name:t[2],post:t[3]}:null}get variableName(){const t=this.text.match(/--[^,)]+/);return t?t[0]:""}renderLink(t){const e=this.computedValue&&!this.fromFallback,s=St.classMap({"css-var-link":!0,undefined:!e}),i=e?wt`Jump to definition`:wt`${t} is not defined`,n=e?this.onLinkClick.bind(this,this.variableName):null;return ft`<span class="${s}" title="${i}" @mousedown=${n} role="link" tabindex="-1">${t}</span>`}render(){const t=this.parseVariableFunctionParts();if(!t)return void vt("",this.shadow,{eventContext:this});const e=this.renderLink(t.name);vt(ft`<style>
      .css-var-link:not(.undefined) {
        cursor: pointer;
        text-decoration: underline;
        text-underline-position: under;
      }
      </style><span title="${this.computedValue||""}">${t.pre}${e}${t.post}</span>`,this.shadow,{eventContext:this})}}customElements.get("devtools-css-var-swatch")||customElements.define("devtools-css-var-swatch",xt);var Ct=Object.freeze({__proto__:null,CSSVarSwatch:xt});class yt extends HTMLElement{set data(t){}}var Et=Object.freeze({__proto__:null,SwatchRenderData:void 0,CSSVarSwatchClosureInterface:yt,createCSSVarSwatch:function(){return document.createElement("devtools-css-var-swatch")}});class It extends HTMLSpanElement{constructor(){super();const t=c.createShadowRootWithCoreStyles(this,{cssFile:"inline_editor/bezierSwatch.css",enableLegacyPatching:!0,delegatesFocus:void 0});this._iconElement=u.Icon.create("smallicon-bezier","bezier-swatch-icon"),t.appendChild(this._iconElement),this._textElement=this.createChild("span"),t.createChild("slot")}static create(){return It._constructor||(It._constructor=c.registerCustomElement("span","bezier-swatch",It)),It._constructor()}bezierText(){return this._textElement.textContent}setBezierText(t){this._textElement.textContent=t}hideText(t){this._textElement.hidden=t}iconElement(){return this._iconElement}}class Pt extends HTMLSpanElement{constructor(){super();const t=c.createShadowRootWithCoreStyles(this,{cssFile:"inline_editor/cssShadowSwatch.css",enableLegacyPatching:!0,delegatesFocus:void 0});this._iconElement=u.Icon.create("smallicon-shadow","shadow-swatch-icon"),t.appendChild(this._iconElement),t.createChild("slot"),this._contentElement=this.createChild("span")}static create(){return Pt._constructor||(Pt._constructor=c.registerCustomElement("span","css-shadow-swatch",Pt)),Pt._constructor()}model(){return this._model}setCSSShadow(t){this._model=t,this._contentElement.removeChildren();const e=S.Utils.splitStringByRegexes(t.asCSSText(),[/inset/g,s.Regex]);for(let s=0;s<e.length;s++){const i=e[s];if(1===i.regexIndex){if(!this._colorSwatch){this._colorSwatch=R();const t=this._colorSwatch.createChild("span");this._colorSwatch.addEventListener("format-changed",e=>{t.textContent=e.data.text})}this._colorSwatch.renderColor(t.color());const e=this._colorSwatch.querySelector("span");e&&(e.textContent=t.color().asString()),this._contentElement.appendChild(this._colorSwatch)}else this._contentElement.appendChild(createTextNode(i.value))}}hideText(t){this._contentElement.hidden=t}iconElement(){return this._iconElement}colorSwatch(){return this._colorSwatch}}var Tt=Object.freeze({__proto__:null,BezierSwatch:It,CSSShadowSwatch:Pt});class zt extends o.ObjectWrapper{constructor(){super(),this._popover=new p.GlassPane,this._popover.registerRequiredCSS("inline_editor/swatchPopover.css",{enableLegacyPatching:!0}),this._popover.setSizeBehavior(p.SizeBehavior.MeasureContent),this._popover.setMarginBehavior(p.MarginBehavior.Arrow),this._popover.element.addEventListener("mousedown",t=>t.consume(),!1),this._hideProxy=this.hide.bind(this,!0),this._boundOnKeyDown=this._onKeyDown.bind(this),this._boundFocusOut=this._onFocusOut.bind(this),this._isHidden=!0,this._anchorElement=null}_onFocusOut(t){const e=t.relatedTarget;!this._isHidden&&e&&this._view&&!e.isSelfOrDescendant(this._view.contentElement)&&this._hideProxy()}isShowing(){return this._popover.isShowing()}show(t,e,s){if(this._popover.isShowing()){if(this._anchorElement===e)return;this.hide(!0)}this.dispatchEventToListeners(kt.WillShowPopover),this._isHidden=!1,this._anchorElement=e,this._view=t,this._hiddenCallback=s,this.reposition(),t.focus();const i=this._popover.element.ownerDocument;i.addEventListener("mousedown",this._hideProxy,!1),i.defaultView&&i.defaultView.addEventListener("resize",this._hideProxy,!1),this._view.contentElement.addEventListener("keydown",this._boundOnKeyDown,!1)}reposition(){!this._isHidden&&this._view&&(this._view.contentElement.removeEventListener("focusout",this._boundFocusOut,!1),this._view.show(this._popover.contentElement),this._anchorElement&&(this._popover.setContentAnchorBox(this._anchorElement.boxInWindow()),this._popover.show(this._anchorElement.ownerDocument)),this._view.contentElement.addEventListener("focusout",this._boundFocusOut,!1),this._focusRestorer||(this._focusRestorer=new l.WidgetFocusRestorer(this._view)))}hide(t){if(this._isHidden)return;const e=this._popover.element.ownerDocument;this._isHidden=!0,this._popover.hide(),e.removeEventListener("mousedown",this._hideProxy,!1),e.defaultView&&e.defaultView.removeEventListener("resize",this._hideProxy,!1),this._hiddenCallback&&this._hiddenCallback.call(null,!!t),this._focusRestorer&&this._focusRestorer.restore(),this._anchorElement=null,this._view&&(this._view.detach(),this._view.contentElement.removeEventListener("keydown",this._boundOnKeyDown,!1),this._view.contentElement.removeEventListener("focusout",this._boundFocusOut,!1),delete this._view)}_onKeyDown(t){const e=t;if("Enter"===e.key)return this.hide(!0),void e.consume(!0);"Escape"===e.key&&(this.hide(!1),e.consume(!0))}}const kt={WillShowPopover:Symbol("WillShowPopover")};var Lt=Object.freeze({__proto__:null,SwatchPopoverHelper:zt,Events:kt});export{I as BezierEditor,x as BezierUI,lt as CSSAngle,at as CSSAngleImpl,X as CSSAngleRegex,gt as CSSShadowEditor,pt as CSSShadowModel,Et as CSSVarSwatch,Ct as CSSVarSwatchImpl,M as ColorSwatch,O as ColorSwatchImpl,Lt as SwatchPopoverHelper,Tt as Swatches};
