import QtQuick 2.10
import QtQuick.Templates 2.1 as T
import highendivisystem 1.0

T.Switch {
    id: stateswitch

    implicitWidth: graphic.width
    implicitHeight: graphic.height

    property alias graphicMirror: graphic.mirror
    property alias graphicpressedMirror: graphicpressed.mirror
    property alias graphicpressedSource: graphicpressed.source
    property alias graphicSource: graphic.source

    background: buttonBackground
    Rectangle {
        id: buttonBackground
        color: "transparent"
        implicitWidth: graphic.width
        implicitHeight: graphic.height
        opacity: enabled ? 1 : 0.3
        Image {
            visible: true
            mirror: false
            id: graphic1
            source: "img/plus.png"
        }
        Image {
            visible: false
            mirror: false
            id: graphic2
            source: "img/plus.png"
        }
        Image {
            visible: false
            mirror: false
            id: graphic3
            source: "img/plus.png"
        }
    }

    states: [
        State {
            name: "off"
            when: !toggleswitch.checked && !toggleswitch.down
        },
        State {
            name: "on"
            when: toggleswitch.checked && !toggleswitch.down

            PropertyChanges {
                target: graphic1
                visible: false
            }

            PropertyChanges {
                target: graphic2
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/

