/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.text.method.MetaKeyKeyListener;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.qtproject.qt5.android.QtEditText;
import org.qtproject.qt5.android.QtLayout;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.QtNativeInputConnection;
import org.qtproject.qt5.android.QtNativeLibrariesDir;
import org.qtproject.qt5.android.QtSurface;

public class QtActivityDelegate {
    private Activity m_activity = null;
    private Method m_super_dispatchKeyEvent = null;
    private Method m_super_onRestoreInstanceState = null;
    private Method m_super_onRetainNonConfigurationInstance = null;
    private Method m_super_onSaveInstanceState = null;
    private Method m_super_onKeyDown = null;
    private Method m_super_onKeyUp = null;
    private Method m_super_onConfigurationChanged = null;
    private Method m_super_onActivityResult = null;
    private static final String NATIVE_LIBRARIES_KEY = "native.libraries";
    private static final String BUNDLED_LIBRARIES_KEY = "bundled.libraries";
    private static final String MAIN_LIBRARY_KEY = "main.library";
    private static final String ENVIRONMENT_VARIABLES_KEY = "environment.variables";
    private static final String APPLICATION_PARAMETERS_KEY = "application.parameters";
    private static final String STATIC_INIT_CLASSES_KEY = "static.init.classes";
    private static final String NECESSITAS_API_LEVEL_KEY = "necessitas.api.level";
    private static String m_environmentVariables = null;
    private static String m_applicationParameters = null;
    private int m_currentRotation = -1;
    private int m_nativeOrientation = 0;
    private String m_mainLib;
    private long m_metaState;
    private int m_lastChar = 0;
    private boolean m_fullScreen = false;
    private boolean m_started = false;
    private HashMap<Integer, QtSurface> m_surfaces = null;
    private HashMap<Integer, View> m_nativeViews = null;
    private QtLayout m_layout = null;
    private QtEditText m_editText = null;
    private InputMethodManager m_imm = null;
    private boolean m_quitApp = true;
    private Process m_debuggerProcess = null;
    private View m_dummyView = null;
    private boolean m_keyboardIsVisible = false;
    public boolean m_backKeyPressedSent = false;
    private long m_showHideTimeStamp = System.nanoTime();
    private final int ImhHiddenText = 1;
    private final int ImhSensitiveData = 2;
    private final int ImhNoAutoUppercase = 4;
    private final int ImhPreferNumbers = 8;
    private final int ImhPreferUppercase = 16;
    private final int ImhPreferLowercase = 32;
    private final int ImhNoPredictiveText = 64;
    private final int ImhDate = 128;
    private final int ImhTime = 256;
    private final int ImhPreferLatin = 512;
    private final int ImhMultiLine = 1024;
    private final int ImhDigitsOnly = 65536;
    private final int ImhFormattedNumbersOnly = 131072;
    private final int ImhUppercaseOnly = 262144;
    private final int ImhLowercaseOnly = 524288;
    private final int ImhDialableCharactersOnly = 0x100000;
    private final int ImhEmailCharactersOnly = 0x200000;
    private final int ImhUrlCharactersOnly = 0x400000;
    private final int ImhLatinOnly = 0x800000;
    private final int ApplicationSuspended = 0;
    private final int ApplicationHidden = 1;
    private final int ApplicationInactive = 2;
    private final int ApplicationActive = 4;
    private boolean m_opionsMenuIsVisible = false;
    private boolean m_contextMenuVisible = false;

    public void setFullScreen(boolean bl) {
        if (this.m_fullScreen == bl) {
            return;
        }
        this.m_fullScreen = bl;
        if (this.m_fullScreen) {
            this.m_activity.getWindow().addFlags(1024);
            this.m_activity.getWindow().clearFlags(2048);
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    int n = View.class.getDeclaredField("SYSTEM_UI_FLAG_IMMERSIVE_STICKY").getInt(null);
                    int n2 = View.class.getDeclaredField("SYSTEM_UI_FLAG_LAYOUT_STABLE").getInt(null);
                    int n3 = View.class.getDeclaredField("SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION").getInt(null);
                    int n4 = View.class.getDeclaredField("SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN").getInt(null);
                    int n5 = View.class.getDeclaredField("SYSTEM_UI_FLAG_HIDE_NAVIGATION").getInt(null);
                    int n6 = View.class.getDeclaredField("SYSTEM_UI_FLAG_FULLSCREEN").getInt(null);
                    Method method = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
                    method.invoke((Object)this.m_activity.getWindow().getDecorView(), n2 | n3 | n4 | n5 | n6 | n | 4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            this.m_activity.getWindow().addFlags(2048);
            this.m_activity.getWindow().clearFlags(1024);
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    int n = View.class.getDeclaredField("SYSTEM_UI_FLAG_VISIBLE").getInt(null);
                    Method method = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
                    method.invoke((Object)this.m_activity.getWindow().getDecorView(), n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.m_layout.requestLayout();
    }

    public void updateFullScreen() {
        if (this.m_fullScreen) {
            this.m_fullScreen = false;
            this.setFullScreen(true);
        }
    }

    public boolean setKeyboardVisibility(boolean bl, long l) {
        if (this.m_showHideTimeStamp > l) {
            return false;
        }
        this.m_showHideTimeStamp = l;
        if (this.m_keyboardIsVisible == bl) {
            return false;
        }
        this.m_keyboardIsVisible = bl;
        QtNative.keyboardVisibilityChanged(this.m_keyboardIsVisible);
        if (!bl) {
            this.updateFullScreen();
        }
        return true;
    }

    public void resetSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                ((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged = false;
            }
        }, 5L);
    }

    public void showSoftwareKeyboard(int n, int n2, int n3, int n4, int n5) {
        if (this.m_imm == null) {
            return;
        }
        if (n4 > this.m_layout.getHeight() * 2 / 3) {
            this.m_activity.getWindow().setSoftInputMode(17);
        } else {
            this.m_activity.getWindow().setSoftInputMode(33);
        }
        int n6 = 0;
        int n7 = 6;
        int n8 = 1;
        if ((n5 & 0x30008) != 0) {
            n8 = 2;
            if ((n5 & 0x20000) != 0) {
                n8 |= 0x3000;
            }
            if (Build.VERSION.SDK_INT > 10 && (n5 & 1) != 0) {
                n8 |= 0x10;
            }
        } else if ((n5 & 0x100000) != 0) {
            n8 = 3;
        } else if ((n5 & 0x180) != 0) {
            n8 = 4;
            if ((n5 & 0x80) != 0) {
                n8 |= 0x10;
            }
            if ((n5 & 0x100) != 0) {
                n8 |= 0x20;
            }
        } else {
            if ((n5 & 1) != 0) {
                n8 |= 0x80;
            } else if ((n5 & 0x46) != 0) {
                n8 |= 0x90;
            }
            if ((n5 & 0x200000) != 0) {
                n8 |= 0x20;
            }
            if ((n5 & 0x400000) != 0) {
                n8 |= 0x10;
                n7 = 2;
            }
            if ((n5 & 0x400) != 0) {
                n8 |= 0x20000;
            }
            if ((n5 & 0x40000) != 0) {
                n6 |= 0x1000;
                n8 |= 0x1000;
            } else if ((n5 & 0x80000) == 0 && (n5 & 4) == 0) {
                n6 |= 0x4000;
                n8 |= 0x4000;
            }
            if ((n5 & 0x40) != 0 || (n5 & 2) != 0) {
                n8 |= 0x80000;
            }
        }
        if ((n5 & 0x400) != 0) {
            n7 = 0x40000000;
        }
        this.m_editText.setInitialCapsMode(n6);
        this.m_editText.setImeOptions(n7);
        this.m_editText.setInputType(n8);
        this.m_layout.removeView(this.m_editText);
        this.m_layout.addView(this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2));
        this.m_editText.bringToFront();
        this.m_editText.requestFocus();
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.showSoftInput((View)QtActivityDelegate.this.m_editText, 0, new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int n, Bundle bundle) {
                        switch (n) {
                            case 2: {
                                QtNativeInputConnection.updateCursorPosition();
                            }
                            case 0: {
                                QtActivityDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                                break;
                            }
                            case 1: 
                            case 3: {
                                QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                            }
                        }
                    }
                });
                if (((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged) {
                    QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                    ((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged = false;
                }
            }
        }, 15L);
    }

    public void hideSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.hideSoftInputFromWindow(this.m_editText.getWindowToken(), 0, new ResultReceiver(new Handler()){

            protected void onReceiveResult(int n, Bundle bundle) {
                switch (n) {
                    case 0: 
                    case 2: {
                        QtActivityDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                        break;
                    }
                    case 1: 
                    case 3: {
                        QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                    }
                }
            }
        });
    }

    public boolean isSoftwareKeyboardVisible() {
        return this.m_keyboardIsVisible;
    }

    String getAppIconSize(Activity activity) {
        int n = activity.getResources().getDimensionPixelSize(0x1050000);
        if (n < 36 || n > 512) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.densityDpi / 10 * 3;
            if (n < 36) {
                n = 36;
            }
            if (n > 512) {
                n = 512;
            }
        }
        return "\tQT_ANDROID_APP_ICON_SIZE=" + n;
    }

    public void updateSelection(int n, int n2, int n3, int n4) {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.updateSelection((View)this.m_editText, n, n2, n3, n4);
    }

    public boolean loadApplication(Activity activity, ClassLoader classLoader, Bundle bundle) {
        if (!(bundle.containsKey(NATIVE_LIBRARIES_KEY) && bundle.containsKey(BUNDLED_LIBRARIES_KEY) && bundle.containsKey(ENVIRONMENT_VARIABLES_KEY))) {
            return false;
        }
        this.m_activity = activity;
        this.setActionBarVisibility(false);
        QtNative.setActivity(this.m_activity, this);
        QtNative.setClassLoader(classLoader);
        if (bundle.containsKey(STATIC_INIT_CLASSES_KEY)) {
            for (String string : bundle.getStringArray(STATIC_INIT_CLASSES_KEY)) {
                if (string.length() == 0) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Object obj = clazz.newInstance();
                    Method method = clazz.getMethod("setActivity", Activity.class, Object.class);
                    method.invoke(obj, this.m_activity, this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        QtNative.loadQtLibraries(bundle.getStringArrayList(NATIVE_LIBRARIES_KEY));
        ArrayList arrayList = bundle.getStringArrayList(BUNDLED_LIBRARIES_KEY);
        QtNative.loadBundledLibraries(arrayList, QtNativeLibrariesDir.nativeLibrariesDir(this.m_activity));
        this.m_mainLib = bundle.getString(MAIN_LIBRARY_KEY);
        if (null == this.m_mainLib && arrayList.size() > 0) {
            this.m_mainLib = (String)arrayList.get(arrayList.size() - 1);
        }
        try {
            this.m_super_dispatchKeyEvent = this.m_activity.getClass().getMethod("super_dispatchKeyEvent", KeyEvent.class);
            this.m_super_onRestoreInstanceState = this.m_activity.getClass().getMethod("super_onRestoreInstanceState", Bundle.class);
            this.m_super_onRetainNonConfigurationInstance = this.m_activity.getClass().getMethod("super_onRetainNonConfigurationInstance", new Class[0]);
            this.m_super_onSaveInstanceState = this.m_activity.getClass().getMethod("super_onSaveInstanceState", Bundle.class);
            this.m_super_onKeyDown = this.m_activity.getClass().getMethod("super_onKeyDown", Integer.TYPE, KeyEvent.class);
            this.m_super_onKeyUp = this.m_activity.getClass().getMethod("super_onKeyUp", Integer.TYPE, KeyEvent.class);
            this.m_super_onConfigurationChanged = this.m_activity.getClass().getMethod("super_onConfigurationChanged", Configuration.class);
            this.m_super_onActivityResult = this.m_activity.getClass().getMethod("super_onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        int n = 1;
        if (bundle.containsKey(NECESSITAS_API_LEVEL_KEY)) {
            n = bundle.getInt(NECESSITAS_API_LEVEL_KEY);
        }
        m_environmentVariables = bundle.getString(ENVIRONMENT_VARIABLES_KEY);
        String string = "QT_ANDROID_FONTS_MONOSPACE=Droid Sans Mono;Droid Sans;Droid Sans Fallback\tQT_ANDROID_FONTS_SERIF=Droid Serif\tNECESSITAS_API_LEVEL=" + n + "\tHOME=" + this.m_activity.getFilesDir().getAbsolutePath() + "\tTMPDIR=" + this.m_activity.getFilesDir().getAbsolutePath();
        string = Build.VERSION.SDK_INT < 14 ? string + "\tQT_ANDROID_FONTS=Droid Sans;Droid Sans Fallback" : string + "\tQT_ANDROID_FONTS=Roboto;Droid Sans;Droid Sans Fallback";
        string = string + this.getAppIconSize(activity);
        m_environmentVariables = m_environmentVariables != null && m_environmentVariables.length() > 0 ? string + "\t" + m_environmentVariables : string;
        m_applicationParameters = bundle.containsKey(APPLICATION_PARAMETERS_KEY) ? bundle.getString(APPLICATION_PARAMETERS_KEY) : "";
        return true;
    }

    public void debugLog(String string) {
        Log.i((String)"Qt JAVA", (String)("DEBUGGER: " + string));
    }

    public boolean startApplication() {
        try {
            String string;
            String string2;
            String string3;
            Bundle bundle = this.m_activity.getIntent().getExtras();
            if (bundle != null && bundle.containsKey("native_debug") && bundle.getString("native_debug").equals("true")) {
                try {
                    string3 = this.m_activity.getPackageManager().getApplicationInfo((String)this.m_activity.getPackageName(), (int)16384).dataDir + "/";
                    string2 = bundle.containsKey("gdbserver_path") ? bundle.getString("gdbserver_path") : string3 + "lib/gdbserver ";
                    string = bundle.containsKey("gdbserver_socket") ? bundle.getString("gdbserver_socket") : "+debug-socket";
                    this.m_debuggerProcess = Runtime.getRuntime().exec(string2 + string + " --attach " + android.os.Process.myPid(), null, new File(string3));
                }
                catch (IOException iOException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
                }
                catch (SecurityException securityException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + securityException.getMessage()));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + nameNotFoundException.getMessage()));
                }
            }
            if (bundle != null && bundle.containsKey("debug_ping") && bundle.getString("debug_ping").equals("true")) {
                try {
                    File file;
                    File file2;
                    this.debugLog("extra parameters: " + bundle);
                    string3 = this.m_activity.getPackageName();
                    string2 = bundle.getString("ping_file");
                    string = bundle.getString("pong_file");
                    String string4 = bundle.getString("gdbserver_socket");
                    String string5 = bundle.getString("gdbserver_command");
                    boolean bl = string2 != null;
                    boolean bl2 = string != null;
                    boolean bl3 = string4 != null;
                    int n = 200;
                    int n2 = 30000;
                    int n3 = n2 / n;
                    if (bl) {
                        this.debugLog("removing ping file " + string2);
                        file2 = new File(string2);
                        if (file2.exists() && !file2.delete()) {
                            this.debugLog("ping file cannot be deleted");
                        }
                    }
                    if (bl2) {
                        this.debugLog("removing pong file " + string);
                        file2 = new File(string);
                        if (file2.exists() && !file2.delete()) {
                            this.debugLog("pong file cannot be deleted");
                        }
                    }
                    this.debugLog("starting " + string5);
                    this.m_debuggerProcess = Runtime.getRuntime().exec(string5);
                    this.debugLog("gdbserver started");
                    if (bl3) {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            this.debugLog("waiting for socket at " + string4 + ", attempt " + n4);
                            file = new File(string4);
                            if (file.exists()) {
                                file.setReadable(true, false);
                                file.setWritable(true, false);
                                file.setExecutable(true, false);
                                break;
                            }
                            Thread.sleep(n);
                        }
                        if (n4 == n3) {
                            this.debugLog("time out when waiting for socket");
                            return false;
                        }
                        this.debugLog("socket ok");
                    } else {
                        this.debugLog("socket not used");
                    }
                    if (bl) {
                        this.debugLog("writing ping at " + string2);
                        FileWriter fileWriter = new FileWriter(string2);
                        fileWriter.write("" + android.os.Process.myPid());
                        fileWriter.close();
                        file = new File(string2);
                        file.setReadable(true, false);
                        file.setWritable(true, false);
                        file.setExecutable(true, false);
                        this.debugLog("wrote ping");
                    } else {
                        this.debugLog("ping not requested");
                    }
                    if (bl2) {
                        int n5;
                        for (n5 = 0; n5 < n3; ++n5) {
                            this.debugLog("waiting for pong at " + string + ", attempt " + n5);
                            file = new File(string);
                            if (file.exists()) {
                                file.delete();
                                break;
                            }
                            this.debugLog("go to sleep");
                            Thread.sleep(n);
                        }
                        if (n5 == n3) {
                            this.debugLog("time out when waiting for pong file");
                            return false;
                        }
                        this.debugLog("got pong " + string);
                    } else {
                        this.debugLog("pong not requested");
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
                }
                catch (SecurityException securityException) {
                    Log.e((String)"Qt JAVA", (String)("Can't start debugger" + securityException.getMessage()));
                }
            }
            if (bundle != null && bundle.containsKey("qml_debug") && bundle.getString("qml_debug").equals("true")) {
                if (bundle.containsKey("qmljsdebugger")) {
                    string3 = bundle.getString("qmljsdebugger");
                    string3.replaceAll("\\s", "");
                } else {
                    string3 = "port:3768";
                }
                m_applicationParameters = m_applicationParameters + "\t-qmljsdebugger=" + string3;
            }
            if (null == this.m_surfaces) {
                this.onCreate(null);
            }
            string3 = QtNativeLibrariesDir.nativeLibrariesDir(this.m_activity);
            QtNative.startApplication(m_applicationParameters, m_environmentVariables, this.m_mainLib, string3);
            this.m_started = true;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onTerminate() {
        QtNative.terminateQt();
    }

    public void onCreate(Bundle bundle) {
        this.m_quitApp = true;
        if (null == bundle) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, 0, 0, displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity);
        }
        this.m_layout = new QtLayout((Context)this.m_activity);
        this.m_editText = new QtEditText((Context)this.m_activity, this);
        this.m_imm = (InputMethodManager)this.m_activity.getSystemService("input_method");
        this.m_surfaces = new HashMap();
        this.m_nativeViews = new HashMap();
        this.m_activity.registerForContextMenu((View)this.m_layout);
        this.m_activity.setContentView((View)this.m_layout, new ViewGroup.LayoutParams(-1, -1));
        int n = this.m_activity.getResources().getConfiguration().orientation;
        int n2 = this.m_activity.getWindowManager().getDefaultDisplay().getRotation();
        boolean bl = n2 == 1 || n2 == 3;
        boolean bl2 = n == 2;
        this.m_nativeOrientation = bl2 && !bl || !bl2 && bl ? 2 : 1;
        QtNative.handleOrientationChanged(n2, this.m_nativeOrientation);
        this.m_currentRotation = n2;
    }

    public void onConfigurationChanged(Configuration configuration) {
        try {
            this.m_super_onConfigurationChanged.invoke((Object)this.m_activity, configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = this.m_activity.getWindowManager().getDefaultDisplay().getRotation();
        if (n != this.m_currentRotation) {
            QtNative.handleOrientationChanged(n, this.m_nativeOrientation);
        }
        this.m_currentRotation = n;
    }

    public void onDestroy() {
        if (this.m_quitApp) {
            if (this.m_debuggerProcess != null) {
                this.m_debuggerProcess.destroy();
            }
            System.exit(0);
        }
    }

    public void onPause() {
        QtNative.updateApplicationState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        Object object = QtNative.m_mainActivityMutex;
        synchronized (object) {
            Iterator<Runnable> iterator = QtNative.getLostActions().iterator();
            while (iterator.hasNext()) {
                this.m_activity.runOnUiThread(iterator.next());
            }
            if (this.m_started) {
                QtNative.updateApplicationState(4);
                QtNative.clearLostActions();
                QtNative.updateWindow();
                this.updateFullScreen();
            }
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        try {
            this.m_super_onActivityResult.invoke((Object)this.m_activity, n, n2, intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        QtNative.onActivityResult(n, n2, intent);
    }

    public void onStop() {
        QtNative.updateApplicationState(0);
    }

    public Object onRetainNonConfigurationInstance() {
        try {
            this.m_super_onRetainNonConfigurationInstance.invoke((Object)this.m_activity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_quitApp = false;
        return true;
    }

    public void onSaveInstanceState(Bundle bundle) {
        try {
            this.m_super_onSaveInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bundle.putBoolean("FullScreen", this.m_fullScreen);
        bundle.putBoolean("Started", this.m_started);
    }

    public void onRestoreInstanceState(Bundle bundle) {
        try {
            this.m_super_onRestoreInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_started = bundle.getBoolean("Started");
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        int n2;
        if (!this.m_started) {
            return false;
        }
        if (n == 82) {
            try {
                return (Boolean)this.m_super_onKeyDown.invoke((Object)this.m_activity, n, keyEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyDown((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        int n3 = n2 = keyEvent.getUnicodeChar(MetaKeyKeyListener.getMetaState((long)this.m_metaState));
        this.m_metaState = MetaKeyKeyListener.adjustMetaAfterKeypress((long)this.m_metaState);
        if ((n2 & Integer.MIN_VALUE) != 0) {
            int n4;
            n2 &= Integer.MAX_VALUE;
            n2 = n4 = KeyEvent.getDeadChar((int)this.m_lastChar, (int)n2);
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        this.m_lastChar = n3;
        if (n == 4) {
            boolean bl = this.m_backKeyPressedSent = !this.m_keyboardIsVisible;
            if (!this.m_backKeyPressedSent) {
                return true;
            }
        }
        QtNative.keyDown(n, n2, keyEvent.getMetaState());
        return true;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.m_started) {
            return false;
        }
        if (n == 82) {
            try {
                return (Boolean)this.m_super_onKeyUp.invoke((Object)this.m_activity, n, keyEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        if (n == 4 && !this.m_backKeyPressedSent) {
            this.hideSoftwareKeyboard();
            this.setKeyboardVisibility(false, System.nanoTime());
            return true;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyUp((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        QtNative.keyUp(n, keyEvent.getUnicodeChar(), keyEvent.getMetaState());
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.m_started && keyEvent.getAction() == 2 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() == 1 && keyEvent.getKeyCode() == 0) {
            QtNative.keyDown(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState());
            QtNative.keyUp(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState());
        }
        try {
            return (Boolean)this.m_super_dispatchKeyEvent.invoke((Object)this.m_activity, keyEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.clear();
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.m_opionsMenuIsVisible = true;
        boolean bl = QtNative.onPrepareOptionsMenu(menu);
        this.setActionBarVisibility(bl && menu.size() > 0);
        return bl;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return QtNative.onOptionsItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void onOptionsMenuClosed(Menu menu) {
        this.m_opionsMenuIsVisible = false;
        QtNative.onOptionsMenuClosed(menu);
    }

    public void resetOptionsMenu() {
        if (Build.VERSION.SDK_INT > 10) {
            try {
                Activity.class.getMethod("invalidateOptionsMenu", new Class[0]).invoke((Object)this.m_activity, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.m_opionsMenuIsVisible) {
            this.m_activity.closeOptionsMenu();
        }
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        contextMenu.clearHeader();
        QtNative.onCreateContextMenu(contextMenu);
        this.m_contextMenuVisible = true;
    }

    public void onContextMenuClosed(Menu menu) {
        if (!this.m_contextMenuVisible) {
            return;
        }
        this.m_contextMenuVisible = false;
        QtNative.onContextMenuClosed(menu);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        return QtNative.onContextItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void openContextMenu() {
        this.m_layout.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_activity.openContextMenu((View)QtActivityDelegate.this.m_layout);
            }
        }, 10L);
    }

    public void closeContextMenu() {
        this.m_activity.closeContextMenu();
    }

    private boolean hasPermanentMenuKey() {
        try {
            return Build.VERSION.SDK_INT < 11 || Build.VERSION.SDK_INT >= 14 && (Boolean)ViewConfiguration.class.getMethod("hasPermanentMenuKey", new Class[0]).invoke((Object)ViewConfiguration.get((Context)this.m_activity), new Object[0]) != false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private Object getActionBar() {
        try {
            return Activity.class.getMethod("getActionBar", new Class[0]).invoke((Object)this.m_activity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setActionBarVisibility(boolean bl) {
        if (this.hasPermanentMenuKey() || !bl) {
            if (Build.VERSION.SDK_INT > 10 && this.getActionBar() != null) {
                try {
                    Class.forName("android.app.ActionBar").getMethod("hide", new Class[0]).invoke(this.getActionBar(), new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (Build.VERSION.SDK_INT > 10 && this.getActionBar() != null) {
            try {
                Class.forName("android.app.ActionBar").getMethod("show", new Class[0]).invoke(this.getActionBar(), new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void insertNativeView(int n, View view, int n2, int n3, int n4, int n5) {
        if (this.m_dummyView != null) {
            this.m_layout.removeView(this.m_dummyView);
            this.m_dummyView = null;
        }
        if (this.m_nativeViews.containsKey(n)) {
            this.m_layout.removeView(this.m_nativeViews.remove(n));
        }
        if (n4 < 0 || n5 < 0) {
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        }
        this.m_layout.addView(view);
        this.m_layout.bringChildToFront(view);
        this.m_nativeViews.put(n, view);
    }

    public void createSurface(int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (this.m_surfaces.size() == 0) {
            object = new TypedValue();
            this.m_activity.getTheme().resolveAttribute(16842836, object, true);
            if (object.type >= 28 && object.type <= 31) {
                this.m_activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(object.data));
            } else {
                this.m_activity.getWindow().setBackgroundDrawable(this.m_activity.getResources().getDrawable(object.resourceId));
            }
            if (this.m_dummyView != null) {
                this.m_layout.removeView(this.m_dummyView);
                this.m_dummyView = null;
            }
        }
        if (this.m_surfaces.containsKey(n)) {
            this.m_layout.removeView((View)this.m_surfaces.remove(n));
        }
        object = new QtSurface((Context)this.m_activity, n, bl, n6);
        if (n4 < 0 || n5 < 0) {
            object.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            object.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        }
        this.m_layout.addView((View)object);
        if (bl) {
            this.m_layout.bringChildToFront((View)object);
        }
        this.m_surfaces.put(n, (QtSurface)((Object)object));
    }

    public void setSurfaceGeometry(int n, int n2, int n3, int n4, int n5) {
        if (this.m_surfaces.containsKey(n)) {
            QtSurface qtSurface = this.m_surfaces.get(n);
            qtSurface.setLayoutParams(new QtLayout.LayoutParams(n4, n5, n2, n3));
        } else if (this.m_nativeViews.containsKey(n)) {
            View view = this.m_nativeViews.get(n);
            view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
            this.m_layout.bringChildToFront(view);
        } else {
            Log.e((String)"Qt JAVA", (String)("Surface " + n + " not found!"));
            return;
        }
        this.m_layout.requestLayout();
    }

    public void destroySurface(int n) {
        View view = null;
        if (this.m_surfaces.containsKey(n)) {
            view = (View)this.m_surfaces.remove(n);
        } else if (this.m_nativeViews.containsKey(n)) {
            view = this.m_nativeViews.remove(n);
        } else {
            Log.e((String)"Qt JAVA", (String)("Surface " + n + " not found!"));
        }
        if (this.m_surfaces.size() == 0 && this.m_nativeViews.size() == 0) {
            this.m_dummyView = view;
        } else if (view != null) {
            this.m_layout.removeView(view);
        }
    }
}

