/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.text.method.MetaKeyKeyListener;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.qtproject.qt5.android.ExtractStyle;
import org.qtproject.qt5.android.QtEditText;
import org.qtproject.qt5.android.QtLayout;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.QtNativeInputConnection;
import org.qtproject.qt5.android.QtNativeLibrariesDir;
import org.qtproject.qt5.android.QtPopupMenu;
import org.qtproject.qt5.android.QtPopupMenu14;
import org.qtproject.qt5.android.QtSurface;

public class QtActivityDelegate {
    private Activity m_activity = null;
    private Method m_super_dispatchKeyEvent = null;
    private Method m_super_onRestoreInstanceState = null;
    private Method m_super_onRetainNonConfigurationInstance = null;
    private Method m_super_onSaveInstanceState = null;
    private Method m_super_onKeyDown = null;
    private Method m_super_onKeyUp = null;
    private Method m_super_onConfigurationChanged = null;
    private Method m_super_onActivityResult = null;
    private static final String NATIVE_LIBRARIES_KEY = "native.libraries";
    private static final String BUNDLED_LIBRARIES_KEY = "bundled.libraries";
    private static final String MAIN_LIBRARY_KEY = "main.library";
    private static final String ENVIRONMENT_VARIABLES_KEY = "environment.variables";
    private static final String APPLICATION_PARAMETERS_KEY = "application.parameters";
    private static final String STATIC_INIT_CLASSES_KEY = "static.init.classes";
    private static final String NECESSITAS_API_LEVEL_KEY = "necessitas.api.level";
    private static final String EXTRACT_STYLE_KEY = "extract.android.style";
    private static String m_environmentVariables = null;
    private static String m_applicationParameters = null;
    private int m_currentRotation = -1;
    private int m_nativeOrientation = 0;
    private String m_mainLib;
    private long m_metaState;
    private int m_lastChar = 0;
    private int m_softInputMode = 0;
    private boolean m_fullScreen = false;
    private boolean m_started = false;
    private HashMap<Integer, QtSurface> m_surfaces = null;
    private HashMap<Integer, View> m_nativeViews = null;
    private QtLayout m_layout = null;
    private QtEditText m_editText = null;
    private InputMethodManager m_imm = null;
    private boolean m_quitApp = true;
    private Process m_debuggerProcess = null;
    private View m_dummyView = null;
    private boolean m_keyboardIsVisible = false;
    public boolean m_backKeyPressedSent = false;
    private long m_showHideTimeStamp = System.nanoTime();
    private final int ImhHiddenText = 1;
    private final int ImhSensitiveData = 2;
    private final int ImhNoAutoUppercase = 4;
    private final int ImhPreferNumbers = 8;
    private final int ImhPreferUppercase = 16;
    private final int ImhPreferLowercase = 32;
    private final int ImhNoPredictiveText = 64;
    private final int ImhDate = 128;
    private final int ImhTime = 256;
    private final int ImhPreferLatin = 512;
    private final int ImhMultiLine = 1024;
    private final int ImhDigitsOnly = 65536;
    private final int ImhFormattedNumbersOnly = 131072;
    private final int ImhUppercaseOnly = 262144;
    private final int ImhLowercaseOnly = 524288;
    private final int ImhDialableCharactersOnly = 0x100000;
    private final int ImhEmailCharactersOnly = 0x200000;
    private final int ImhUrlCharactersOnly = 0x400000;
    private final int ImhLatinOnly = 0x800000;
    private final int ApplicationSuspended = 0;
    private final int ApplicationHidden = 1;
    private final int ApplicationInactive = 2;
    private final int ApplicationActive = 4;
    private boolean m_optionsMenuIsVisible = false;
    private boolean m_contextMenuVisible = false;

    public void setFullScreen(boolean bl) {
        if (this.m_fullScreen == bl) {
            return;
        }
        this.m_fullScreen = bl;
        if (this.m_fullScreen) {
            this.m_activity.getWindow().addFlags(1024);
            this.m_activity.getWindow().clearFlags(2048);
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    int n = View.class.getDeclaredField("SYSTEM_UI_FLAG_IMMERSIVE_STICKY").getInt(null);
                    int n2 = View.class.getDeclaredField("SYSTEM_UI_FLAG_LAYOUT_STABLE").getInt(null);
                    int n3 = View.class.getDeclaredField("SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION").getInt(null);
                    int n4 = View.class.getDeclaredField("SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN").getInt(null);
                    int n5 = View.class.getDeclaredField("SYSTEM_UI_FLAG_HIDE_NAVIGATION").getInt(null);
                    int n6 = View.class.getDeclaredField("SYSTEM_UI_FLAG_FULLSCREEN").getInt(null);
                    Method method = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
                    method.invoke((Object)this.m_activity.getWindow().getDecorView(), n2 | n3 | n4 | n5 | n6 | n | 4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            this.m_activity.getWindow().addFlags(2048);
            this.m_activity.getWindow().clearFlags(1024);
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    int n = View.class.getDeclaredField("SYSTEM_UI_FLAG_VISIBLE").getInt(null);
                    Method method = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
                    method.invoke((Object)this.m_activity.getWindow().getDecorView(), n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.m_layout.requestLayout();
    }

    public void updateFullScreen() {
        if (this.m_fullScreen) {
            this.m_fullScreen = false;
            this.setFullScreen(true);
        }
    }

    public boolean setKeyboardVisibility(boolean bl, long l) {
        if (this.m_showHideTimeStamp > l) {
            return false;
        }
        this.m_showHideTimeStamp = l;
        if (this.m_keyboardIsVisible == bl) {
            return false;
        }
        this.m_keyboardIsVisible = bl;
        QtNative.keyboardVisibilityChanged(this.m_keyboardIsVisible);
        if (!bl) {
            this.updateFullScreen();
        }
        return true;
    }

    public void resetSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                ((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged = false;
            }
        }, 5L);
    }

    public void showSoftwareKeyboard(int n, int n2, int n3, int n4, int n5) {
        if (this.m_imm == null) {
            return;
        }
        if (this.m_softInputMode == 0 && n4 > this.m_layout.getHeight() * 2 / 3) {
            this.m_activity.getWindow().setSoftInputMode(17);
        } else if (this.m_softInputMode == 0) {
            this.m_activity.getWindow().setSoftInputMode(33);
        } else {
            this.m_activity.getWindow().setSoftInputMode(this.m_softInputMode);
        }
        int n6 = 0;
        int n7 = 6;
        int n8 = 1;
        if ((n5 & 0x30008) != 0) {
            n8 = 2;
            if ((n5 & 0x20000) != 0) {
                n8 |= 0x3000;
            }
            if (Build.VERSION.SDK_INT > 10 && (n5 & 1) != 0) {
                n8 |= 0x10;
            }
        } else if ((n5 & 0x100000) != 0) {
            n8 = 3;
        } else if ((n5 & 0x180) != 0) {
            n8 = 4;
            if ((n5 & 0x180) != 384) {
                if ((n5 & 0x80) != 0) {
                    n8 |= 0x10;
                }
                if ((n5 & 0x100) != 0) {
                    n8 |= 0x20;
                }
            }
        } else {
            if ((n5 & 0x600000) != 0) {
                if ((n5 & 0x400000) != 0) {
                    n8 |= 0x10;
                    n7 = 2;
                } else if ((n5 & 0x200000) != 0) {
                    n8 |= 0x20;
                }
            } else if ((n5 & 1) != 0) {
                n8 |= 0x80;
            } else if ((n5 & 2) != 0 || (n5 & 0x40) != 0) {
                n8 |= 0x90;
            }
            if ((n5 & 0x400) != 0) {
                n8 |= 0x20000;
            }
            if ((n5 & 0x40000) != 0) {
                n6 |= 0x1000;
                n8 |= 0x1000;
            } else if ((n5 & 0x80000) == 0 && (n5 & 4) == 0) {
                n6 |= 0x4000;
                n8 |= 0x4000;
            }
            if ((n5 & 0x40) != 0 || (n5 & 2) != 0 || (n5 & 1) != 0) {
                n8 |= 0x80000;
            }
        }
        if ((n5 & 0x400) != 0) {
            n7 = 0x40000000;
        }
        this.m_editText.setInitialCapsMode(n6);
        this.m_editText.setImeOptions(n7);
        this.m_editText.setInputType(n8);
        this.m_layout.removeView(this.m_editText);
        this.m_layout.addView(this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2));
        this.m_editText.requestFocus();
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.showSoftInput((View)QtActivityDelegate.this.m_editText, 0, new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int n, Bundle bundle) {
                        switch (n) {
                            case 2: {
                                QtNativeInputConnection.updateCursorPosition();
                            }
                            case 0: {
                                QtActivityDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                                break;
                            }
                            case 1: 
                            case 3: {
                                QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                            }
                        }
                    }
                });
                if (((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged) {
                    QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                    ((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged = false;
                }
            }
        }, 15L);
    }

    public void hideSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.hideSoftInputFromWindow(this.m_editText.getWindowToken(), 0, new ResultReceiver(new Handler()){

            protected void onReceiveResult(int n, Bundle bundle) {
                switch (n) {
                    case 0: 
                    case 2: {
                        QtActivityDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                        break;
                    }
                    case 1: 
                    case 3: {
                        QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                    }
                }
            }
        });
    }

    String getAppIconSize(Activity activity) {
        int n = activity.getResources().getDimensionPixelSize(0x1050000);
        if (n < 36 || n > 512) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.densityDpi / 10 * 3;
            if (n < 36) {
                n = 36;
            }
            if (n > 512) {
                n = 512;
            }
        }
        return "\tQT_ANDROID_APP_ICON_SIZE=" + n;
    }

    public void updateSelection(int n, int n2, int n3, int n4) {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.updateSelection((View)this.m_editText, n, n2, n3, n4);
    }

    public boolean loadApplication(Activity activity, ClassLoader classLoader, Bundle bundle) {
        if (!(bundle.containsKey(NATIVE_LIBRARIES_KEY) && bundle.containsKey(BUNDLED_LIBRARIES_KEY) && bundle.containsKey(ENVIRONMENT_VARIABLES_KEY))) {
            return false;
        }
        this.m_activity = activity;
        this.setActionBarVisibility(false);
        QtNative.setActivity(this.m_activity, this);
        QtNative.setClassLoader(classLoader);
        if (bundle.containsKey(STATIC_INIT_CLASSES_KEY)) {
            for (String string : bundle.getStringArray(STATIC_INIT_CLASSES_KEY)) {
                if (string.length() == 0) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(string);
                    Object obj = clazz.newInstance();
                    Method method = clazz.getMethod("setActivity", Activity.class, Object.class);
                    method.invoke(obj, this.m_activity, this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        QtNative.loadQtLibraries(bundle.getStringArrayList(NATIVE_LIBRARIES_KEY));
        ArrayList arrayList = bundle.getStringArrayList(BUNDLED_LIBRARIES_KEY);
        QtNative.loadBundledLibraries(arrayList, QtNativeLibrariesDir.nativeLibrariesDir(this.m_activity));
        this.m_mainLib = bundle.getString(MAIN_LIBRARY_KEY);
        if (null == this.m_mainLib && arrayList.size() > 0) {
            this.m_mainLib = (String)arrayList.get(arrayList.size() - 1);
        }
        if (bundle.containsKey(EXTRACT_STYLE_KEY)) {
            String string = bundle.getString(EXTRACT_STYLE_KEY);
            new ExtractStyle((Context)this.m_activity, string);
        }
        try {
            this.m_super_dispatchKeyEvent = this.m_activity.getClass().getMethod("super_dispatchKeyEvent", KeyEvent.class);
            this.m_super_onRestoreInstanceState = this.m_activity.getClass().getMethod("super_onRestoreInstanceState", Bundle.class);
            this.m_super_onRetainNonConfigurationInstance = this.m_activity.getClass().getMethod("super_onRetainNonConfigurationInstance", new Class[0]);
            this.m_super_onSaveInstanceState = this.m_activity.getClass().getMethod("super_onSaveInstanceState", Bundle.class);
            this.m_super_onKeyDown = this.m_activity.getClass().getMethod("super_onKeyDown", Integer.TYPE, KeyEvent.class);
            this.m_super_onKeyUp = this.m_activity.getClass().getMethod("super_onKeyUp", Integer.TYPE, KeyEvent.class);
            this.m_super_onConfigurationChanged = this.m_activity.getClass().getMethod("super_onConfigurationChanged", Configuration.class);
            this.m_super_onActivityResult = this.m_activity.getClass().getMethod("super_onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        int n = 1;
        if (bundle.containsKey(NECESSITAS_API_LEVEL_KEY)) {
            n = bundle.getInt(NECESSITAS_API_LEVEL_KEY);
        }
        m_environmentVariables = bundle.getString(ENVIRONMENT_VARIABLES_KEY);
        String string = "QT_ANDROID_FONTS_MONOSPACE=Droid Sans Mono;Droid Sans;Droid Sans Fallback\tQT_ANDROID_FONTS_SERIF=Droid Serif\tNECESSITAS_API_LEVEL=" + n + "\tHOME=" + this.m_activity.getFilesDir().getAbsolutePath() + "\tTMPDIR=" + this.m_activity.getFilesDir().getAbsolutePath();
        string = Build.VERSION.SDK_INT < 14 ? string + "\tQT_ANDROID_FONTS=Droid Sans;Droid Sans Fallback" : string + "\tQT_ANDROID_FONTS=Roboto;Droid Sans;Droid Sans Fallback";
        string = string + this.getAppIconSize(activity);
        m_environmentVariables = m_environmentVariables != null && m_environmentVariables.length() > 0 ? string + "\t" + m_environmentVariables : string;
        m_applicationParameters = bundle.containsKey(APPLICATION_PARAMETERS_KEY) ? bundle.getString(APPLICATION_PARAMETERS_KEY) : "";
        try {
            this.m_softInputMode = this.m_activity.getPackageManager().getActivityInfo((ComponentName)this.m_activity.getComponentName(), (int)0).softInputMode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static void debugLog(String string) {
        Log.i((String)"Qt JAVA", (String)("DEBUGGER: " + string));
    }

    public boolean startApplication() {
        try {
            String string;
            Bundle bundle = this.m_activity.getIntent().getExtras();
            if (bundle != null) {
                String string2;
                String string3;
                if (bundle.containsKey("native_debug") && bundle.getString("native_debug").equals("true")) {
                    try {
                        string = this.m_activity.getPackageManager().getApplicationInfo((String)this.m_activity.getPackageName(), (int)16384).dataDir + "/";
                        string3 = bundle.containsKey("gdbserver_path") ? bundle.getString("gdbserver_path") : string + "lib/gdbserver ";
                        String string4 = string2 = bundle.containsKey("gdbserver_socket") ? bundle.getString("gdbserver_socket") : "+debug-socket";
                        if (!new File(string3).exists()) {
                            string3 = string3 + ".so";
                        }
                        this.m_debuggerProcess = Runtime.getRuntime().exec(string3 + string2 + " --attach " + android.os.Process.myPid(), null, new File(string));
                    }
                    catch (IOException iOException) {
                        Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
                    }
                    catch (SecurityException securityException) {
                        Log.e((String)"Qt JAVA", (String)("Can't start debugger" + securityException.getMessage()));
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"Qt JAVA", (String)("Can't start debugger" + nameNotFoundException.getMessage()));
                    }
                }
                if (bundle.containsKey("debug_ping") && bundle.getString("debug_ping").equals("true")) {
                    try {
                        Object object;
                        File file;
                        QtActivityDelegate.debugLog("extra parameters: " + bundle);
                        string = this.m_activity.getPackageName();
                        string3 = bundle.getString("ping_file");
                        string2 = bundle.getString("pong_file");
                        String string5 = bundle.getString("gdbserver_socket");
                        String string6 = bundle.getString("gdbserver_command");
                        String string7 = bundle.getString("ping_socket");
                        boolean bl = string3 != null;
                        boolean bl2 = string2 != null;
                        boolean bl3 = string5 != null;
                        boolean bl4 = string7 != null;
                        int n = 200;
                        int n2 = 30000;
                        int n3 = n2 / n;
                        if (string5 != null) {
                            QtActivityDelegate.debugLog("removing gdb socket " + string5);
                            new File(string5).delete();
                        }
                        if (bl) {
                            QtActivityDelegate.debugLog("removing ping file " + string3);
                            file = new File(string3);
                            if (file.exists() && !file.delete()) {
                                QtActivityDelegate.debugLog("ping file cannot be deleted");
                            }
                        }
                        if (bl2) {
                            QtActivityDelegate.debugLog("removing pong file " + string2);
                            file = new File(string2);
                            if (file.exists() && !file.delete()) {
                                QtActivityDelegate.debugLog("pong file cannot be deleted");
                            }
                        }
                        QtActivityDelegate.debugLog("starting " + string6);
                        this.m_debuggerProcess = Runtime.getRuntime().exec(string6);
                        QtActivityDelegate.debugLog("gdbserver started");
                        if (bl3) {
                            int n4;
                            for (n4 = 0; n4 < n3; ++n4) {
                                QtActivityDelegate.debugLog("waiting for socket at " + string5 + ", attempt " + n4);
                                object = new File(string5);
                                if (((File)object).exists()) {
                                    ((File)object).setReadable(true, false);
                                    ((File)object).setWritable(true, false);
                                    ((File)object).setExecutable(true, false);
                                    break;
                                }
                                Thread.sleep(n);
                            }
                            if (n4 == n3) {
                                QtActivityDelegate.debugLog("time out when waiting for debug socket");
                                return false;
                            }
                            QtActivityDelegate.debugLog("socket ok");
                        } else {
                            QtActivityDelegate.debugLog("socket not used");
                        }
                        if (bl4) {
                            int n5;
                            DebugWaitRunnable debugWaitRunnable = new DebugWaitRunnable(string7);
                            object = new Thread(debugWaitRunnable);
                            ((Thread)object).start();
                            for (n5 = 0; n5 < n3 && ((Thread)object).isAlive(); ++n5) {
                                QtActivityDelegate.debugLog("Waiting for debug socket connect");
                                QtActivityDelegate.debugLog("go to sleep");
                                Thread.sleep(n);
                            }
                            if (n5 == n3) {
                                QtActivityDelegate.debugLog("time out when waiting for ping socket");
                                debugWaitRunnable.shutdown();
                                return false;
                            }
                            if (debugWaitRunnable.wasFailure) {
                                QtActivityDelegate.debugLog("Could not connect to debug client");
                                return false;
                            }
                            QtActivityDelegate.debugLog("Got pid acknowledgment");
                        }
                        if (bl) {
                            QtActivityDelegate.debugLog("writing ping at " + string3);
                            FileWriter fileWriter = new FileWriter(string3);
                            fileWriter.write("" + android.os.Process.myPid());
                            fileWriter.close();
                            object = new File(string3);
                            ((File)object).setReadable(true, false);
                            ((File)object).setWritable(true, false);
                            ((File)object).setExecutable(true, false);
                            QtActivityDelegate.debugLog("wrote ping");
                        } else {
                            QtActivityDelegate.debugLog("ping not requested");
                        }
                        if (bl2) {
                            int n6;
                            for (n6 = 0; n6 < n3; ++n6) {
                                QtActivityDelegate.debugLog("waiting for pong at " + string2 + ", attempt " + n6);
                                object = new File(string2);
                                if (((File)object).exists()) {
                                    ((File)object).delete();
                                    break;
                                }
                                QtActivityDelegate.debugLog("go to sleep");
                                Thread.sleep(n);
                            }
                            QtActivityDelegate.debugLog("Removing pingFile " + string3);
                            new File(string3).delete();
                            if (n6 == n3) {
                                QtActivityDelegate.debugLog("time out when waiting for pong file");
                                return false;
                            }
                            QtActivityDelegate.debugLog("got pong " + string2);
                        } else {
                            QtActivityDelegate.debugLog("pong not requested");
                        }
                    }
                    catch (IOException iOException) {
                        Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
                    }
                    catch (SecurityException securityException) {
                        Log.e((String)"Qt JAVA", (String)("Can't start debugger" + securityException.getMessage()));
                    }
                }
                if (bundle.containsKey("qml_debug") && bundle.getString("qml_debug").equals("true")) {
                    if (bundle.containsKey("qmljsdebugger")) {
                        string = bundle.getString("qmljsdebugger");
                        string.replaceAll("\\s", "");
                    } else {
                        string = "port:3768";
                    }
                    m_applicationParameters = m_applicationParameters + "\t-qmljsdebugger=" + string;
                }
                if (bundle.containsKey("extraenvvars")) {
                    try {
                        m_environmentVariables = m_environmentVariables + "\t" + new String(Base64.decode((String)bundle.getString("extraenvvars"), (int)0), "UTF-8");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (bundle.containsKey("extraappparams")) {
                    try {
                        m_applicationParameters = m_applicationParameters + "\t" + new String(Base64.decode((String)bundle.getString("extraappparams"), (int)0), "UTF-8");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (null == this.m_surfaces) {
                this.onCreate(null);
            }
            string = QtNativeLibrariesDir.nativeLibrariesDir(this.m_activity);
            QtNative.startApplication(m_applicationParameters, m_environmentVariables, this.m_mainLib, string);
            this.m_started = true;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onTerminate() {
        QtNative.terminateQt();
    }

    public void onCreate(Bundle bundle) {
        this.m_quitApp = true;
        if (null == bundle) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            QtNative.setApplicationDisplayMetrics(displayMetrics.widthPixels, displayMetrics.heightPixels, 0, 0, displayMetrics.xdpi, displayMetrics.ydpi, displayMetrics.scaledDensity);
        }
        this.m_layout = new QtLayout((Context)this.m_activity);
        this.m_editText = new QtEditText((Context)this.m_activity, this);
        this.m_imm = (InputMethodManager)this.m_activity.getSystemService("input_method");
        this.m_surfaces = new HashMap();
        this.m_nativeViews = new HashMap();
        this.m_activity.registerForContextMenu((View)this.m_layout);
        this.m_activity.setContentView((View)this.m_layout, new ViewGroup.LayoutParams(-1, -1));
        int n = this.m_activity.getResources().getConfiguration().orientation;
        int n2 = this.m_activity.getWindowManager().getDefaultDisplay().getRotation();
        boolean bl = n2 == 1 || n2 == 3;
        boolean bl2 = n == 2;
        this.m_nativeOrientation = bl2 && !bl || !bl2 && bl ? 2 : 1;
        QtNative.handleOrientationChanged(n2, this.m_nativeOrientation);
        this.m_currentRotation = n2;
    }

    public void initializeAccessibility() {
        try {
            Class<?> clazz = Class.forName("org.qtproject.qt5.android.accessibility.QtAccessibilityDelegate");
            Constructor<?> constructor = clazz.getConstructor(Activity.class, ViewGroup.class, this.getClass());
            Object obj = constructor.newInstance(new Object[]{this.m_activity, this.m_layout, this});
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            Log.w((String)"Qt A11y", (String)("Unknown exception: " + exception.toString()));
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        try {
            this.m_super_onConfigurationChanged.invoke((Object)this.m_activity, configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = this.m_activity.getWindowManager().getDefaultDisplay().getRotation();
        if (n != this.m_currentRotation) {
            QtNative.handleOrientationChanged(n, this.m_nativeOrientation);
        }
        this.m_currentRotation = n;
    }

    public void onDestroy() {
        if (this.m_quitApp) {
            if (this.m_debuggerProcess != null) {
                this.m_debuggerProcess.destroy();
            }
            System.exit(0);
        }
    }

    public void onPause() {
        QtNative.updateApplicationState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        Object object = QtNative.m_mainActivityMutex;
        synchronized (object) {
            Iterator<Runnable> iterator = QtNative.getLostActions().iterator();
            while (iterator.hasNext()) {
                this.m_activity.runOnUiThread(iterator.next());
            }
            QtNative.updateApplicationState(4);
            if (this.m_started) {
                QtNative.clearLostActions();
                QtNative.updateWindow();
                this.updateFullScreen();
            }
        }
    }

    public void onNewIntent(Intent intent) {
        QtNative.onNewIntent(intent);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        try {
            this.m_super_onActivityResult.invoke((Object)this.m_activity, n, n2, intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        QtNative.onActivityResult(n, n2, intent);
    }

    public void onStop() {
        QtNative.updateApplicationState(0);
    }

    public Object onRetainNonConfigurationInstance() {
        try {
            this.m_super_onRetainNonConfigurationInstance.invoke((Object)this.m_activity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_quitApp = false;
        return true;
    }

    public void onSaveInstanceState(Bundle bundle) {
        try {
            this.m_super_onSaveInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bundle.putBoolean("FullScreen", this.m_fullScreen);
        bundle.putBoolean("Started", this.m_started);
    }

    public void onRestoreInstanceState(Bundle bundle) {
        try {
            this.m_super_onRestoreInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_started = bundle.getBoolean("Started");
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        int n2;
        if (!this.m_started) {
            return false;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyDown((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        int n3 = n2 = keyEvent.getUnicodeChar(MetaKeyKeyListener.getMetaState((long)this.m_metaState));
        this.m_metaState = MetaKeyKeyListener.adjustMetaAfterKeypress((long)this.m_metaState);
        if ((n2 & Integer.MIN_VALUE) != 0) {
            int n4;
            n2 &= Integer.MAX_VALUE;
            n2 = n4 = KeyEvent.getDeadChar((int)this.m_lastChar, (int)n2);
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        this.m_lastChar = n3;
        if (n == 4) {
            boolean bl = this.m_backKeyPressedSent = !this.m_keyboardIsVisible;
            if (!this.m_backKeyPressedSent) {
                return true;
            }
        }
        QtNative.keyDown(n, n2, keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        return true;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.m_started) {
            return false;
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        if (n == 4 && !this.m_backKeyPressedSent) {
            this.hideSoftwareKeyboard();
            this.setKeyboardVisibility(false, System.nanoTime());
            return true;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyUp((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        QtNative.keyUp(n, keyEvent.getUnicodeChar(), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.m_started && keyEvent.getAction() == 2 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() == 1 && keyEvent.getKeyCode() == 0) {
            QtNative.keyDown(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
            QtNative.keyUp(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        }
        try {
            return (Boolean)this.m_super_dispatchKeyEvent.invoke((Object)this.m_activity, keyEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.clear();
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.m_optionsMenuIsVisible = true;
        boolean bl = QtNative.onPrepareOptionsMenu(menu);
        this.setActionBarVisibility(bl && menu.size() > 0);
        return bl;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return QtNative.onOptionsItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void onOptionsMenuClosed(Menu menu) {
        this.m_optionsMenuIsVisible = false;
        QtNative.onOptionsMenuClosed(menu);
    }

    public void resetOptionsMenu() {
        if (Build.VERSION.SDK_INT > 10) {
            try {
                Activity.class.getMethod("invalidateOptionsMenu", new Class[0]).invoke((Object)this.m_activity, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.m_optionsMenuIsVisible) {
            this.m_activity.closeOptionsMenu();
        }
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        contextMenu.clearHeader();
        QtNative.onCreateContextMenu(contextMenu);
        this.m_contextMenuVisible = true;
    }

    public void onCreatePopupMenu(Menu menu) {
        QtNative.fillContextMenu(menu);
        this.m_contextMenuVisible = true;
    }

    public void onContextMenuClosed(Menu menu) {
        if (!this.m_contextMenuVisible) {
            return;
        }
        this.m_contextMenuVisible = false;
        QtNative.onContextMenuClosed(menu);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        this.m_contextMenuVisible = false;
        return QtNative.onContextItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void openContextMenu(final int n, final int n2, final int n3, final int n4) {
        this.m_layout.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT < 11 || n3 <= 0 || n4 <= 0) {
                    QtActivityDelegate.this.m_activity.openContextMenu((View)QtActivityDelegate.this.m_layout);
                } else if (Build.VERSION.SDK_INT < 14) {
                    QtActivityDelegate.this.m_layout.removeView(QtActivityDelegate.this.m_editText);
                    QtActivityDelegate.this.m_layout.addView(QtActivityDelegate.this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2));
                    QtPopupMenu.getInstance().showMenu(QtActivityDelegate.this.m_editText);
                } else {
                    QtActivityDelegate.this.m_layout.removeView(QtActivityDelegate.this.m_editText);
                    QtActivityDelegate.this.m_layout.addView(QtActivityDelegate.this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2));
                    QtPopupMenu14.getInstance().showMenu(QtActivityDelegate.this.m_editText);
                }
            }
        }, 100L);
    }

    public void closeContextMenu() {
        this.m_activity.closeContextMenu();
    }

    private boolean hasPermanentMenuKey() {
        try {
            return Build.VERSION.SDK_INT < 11 || Build.VERSION.SDK_INT >= 14 && (Boolean)ViewConfiguration.class.getMethod("hasPermanentMenuKey", new Class[0]).invoke((Object)ViewConfiguration.get((Context)this.m_activity), new Object[0]) != false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private Object getActionBar() {
        try {
            return Activity.class.getMethod("getActionBar", new Class[0]).invoke((Object)this.m_activity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void setActionBarVisibility(boolean bl) {
        if (this.hasPermanentMenuKey() || !bl) {
            if (Build.VERSION.SDK_INT > 10 && this.getActionBar() != null) {
                try {
                    Class.forName("android.app.ActionBar").getMethod("hide", new Class[0]).invoke(this.getActionBar(), new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (Build.VERSION.SDK_INT > 10 && this.getActionBar() != null) {
            try {
                Class.forName("android.app.ActionBar").getMethod("show", new Class[0]).invoke(this.getActionBar(), new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void insertNativeView(int n, View view, int n2, int n3, int n4, int n5) {
        if (this.m_dummyView != null) {
            this.m_layout.removeView(this.m_dummyView);
            this.m_dummyView = null;
        }
        if (this.m_nativeViews.containsKey(n)) {
            this.m_layout.removeView(this.m_nativeViews.remove(n));
        }
        if (n4 < 0 || n5 < 0) {
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        }
        view.setId(n);
        this.m_layout.addView(view);
        this.m_nativeViews.put(n, view);
    }

    public void createSurface(int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (this.m_surfaces.size() == 0) {
            object = new TypedValue();
            this.m_activity.getTheme().resolveAttribute(16842836, object, true);
            if (object.type >= 28 && object.type <= 31) {
                this.m_activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(object.data));
            } else {
                this.m_activity.getWindow().setBackgroundDrawable(this.m_activity.getResources().getDrawable(object.resourceId));
            }
            if (this.m_dummyView != null) {
                this.m_layout.removeView(this.m_dummyView);
                this.m_dummyView = null;
            }
        }
        if (this.m_surfaces.containsKey(n)) {
            this.m_layout.removeView((View)this.m_surfaces.remove(n));
        }
        object = new QtSurface((Context)this.m_activity, n, bl, n6);
        if (n4 < 0 || n5 < 0) {
            object.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            object.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        }
        int n7 = this.getSurfaceCount();
        this.m_layout.addView((View)object, n7);
        this.m_surfaces.put(n, (QtSurface)((Object)object));
    }

    public void setSurfaceGeometry(int n, int n2, int n3, int n4, int n5) {
        if (this.m_surfaces.containsKey(n)) {
            QtSurface qtSurface = this.m_surfaces.get(n);
            qtSurface.setLayoutParams(new QtLayout.LayoutParams(n4, n5, n2, n3));
        } else if (this.m_nativeViews.containsKey(n)) {
            View view = this.m_nativeViews.get(n);
            view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        } else {
            Log.e((String)"Qt JAVA", (String)("Surface " + n + " not found!"));
            return;
        }
    }

    public void destroySurface(int n) {
        View view = null;
        if (this.m_surfaces.containsKey(n)) {
            view = (View)this.m_surfaces.remove(n);
        } else if (this.m_nativeViews.containsKey(n)) {
            view = this.m_nativeViews.remove(n);
        } else {
            Log.e((String)"Qt JAVA", (String)("Surface " + n + " not found!"));
        }
        if (view == null) {
            return;
        }
        if (this.m_surfaces.size() == 0 && this.m_nativeViews.size() == 0) {
            this.m_dummyView = view;
        } else {
            this.m_layout.removeView(view);
        }
    }

    public int getSurfaceCount() {
        return this.m_surfaces.size();
    }

    public void bringChildToFront(int n) {
        View view = (View)this.m_surfaces.get(n);
        if (view != null) {
            int n2 = this.getSurfaceCount();
            if (n2 > 0) {
                this.m_layout.moveChild(view, n2 - 1);
            }
            return;
        }
        view = this.m_nativeViews.get(n);
        if (view != null) {
            this.m_layout.moveChild(view, -1);
        }
    }

    public void bringChildToBack(int n) {
        View view = (View)this.m_surfaces.get(n);
        if (view != null) {
            this.m_layout.moveChild(view, 0);
            return;
        }
        view = this.m_nativeViews.get(n);
        if (view != null) {
            int n2 = this.getSurfaceCount();
            this.m_layout.moveChild(view, n2);
        }
    }

    private class DebugWaitRunnable
    implements Runnable {
        public boolean wasFailure;
        private LocalServerSocket socket;

        public DebugWaitRunnable(String string) throws IOException {
            this.socket = new LocalServerSocket(string);
        }

        @Override
        public void run() {
            try {
                LocalSocket localSocket = this.socket.accept();
                QtActivityDelegate.debugLog("Debug socket accepted");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(localSocket.getInputStream()));
                DataOutputStream dataOutputStream = new DataOutputStream(localSocket.getOutputStream());
                dataOutputStream.writeBytes("" + android.os.Process.myPid());
                for (int i = 0; i < 150; ++i) {
                    String string = bufferedReader.readLine();
                    QtActivityDelegate.debugLog("Incoming socket " + string);
                    if (!string.isEmpty()) break;
                    if (localSocket.isClosed()) {
                        this.wasFailure = true;
                        break;
                    }
                    Thread.sleep(200L);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.wasFailure = true;
                Log.e((String)"Qt JAVA", (String)("Can't start debugger" + iOException.getMessage()));
            }
            catch (InterruptedException interruptedException) {
                this.wasFailure = true;
                Log.e((String)"Qt JAVA", (String)("Can't start debugger" + interruptedException.getMessage()));
            }
        }

        public void shutdown() throws IOException {
            this.wasFailure = true;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

