# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from init_paths import init_test_paths
init_test_paths(False)

from PySide6.QtCore import QObject
from PySide6.QtGui import QPen, QBrush


class TestBug991 (unittest.TestCase):
    def testReprFunction(self):
        reprPen = repr(QPen())
        self.assertTrue(reprPen.startswith("<PySide6.QtGui.QPen"))
        reprBrush = repr(QBrush())
        self.assertTrue(reprBrush.startswith("<PySide6.QtGui.QBrush"))
        reprObject = repr(QObject())
        self.assertTrue(reprObject.startswith("<PySide6.QtCore.QObject"))


if __name__ == '__main__':
    unittest.main()
