/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.videolan.Logger;

class BDJClassFileTransformer {
    private static final Logger logger = Logger.getLogger(BDJClassFileTransformer.class.getName());

    BDJClassFileTransformer() {
    }

    public byte[] transform(byte[] b, int off, int len) throws ClassFormatError {
        logger.info("Trying to transform broken class file (" + len + " bytes)");
        byte[] r = new byte[len];
        for (int i = 0; i < len; ++i) {
            r[i] = b[i + off];
        }
        try {
            ClassReader cr = new ClassReader(r);
            ClassWriter cw = new ClassWriter(cr, 0);
            MyClassVisitor cv = new MyClassVisitor(cw);
            cr.accept(cv, 2);
            return cw.toByteArray();
        }
        catch (Exception e) {
            logger.error("Failed transforming class: " + e);
            return r;
        }
    }

    private static class MyMethodVisitor
    extends MethodVisitor {
        public MyMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitAttribute(Attribute attr) {
            super.visitAttribute(attr);
        }
    }

    private static class MyClassVisitor
    extends ClassVisitor {
        public MyClassVisitor(ClassVisitor cv) {
            super(262144, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            return new MyMethodVisitor(mv);
        }
    }
}

