/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.BDFileSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.tv.xlet.Xlet;
import org.videolan.BDJClassFileTransformer;
import org.videolan.BDJClassLoaderAdapter;
import org.videolan.BDJLoader;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.StrUtil;
import org.videolan.bdjo.AppCache;

public class BDJClassLoader
extends URLClassLoader {
    private String xletClass;
    private Map hideClasses;
    private Map bootClasses;
    private Map xletClasses;
    private static final Logger logger = Logger.getLogger(BDJClassLoader.class.getName());

    public static BDJClassLoader newInstance(AppCache[] appCaches, String basePath, String classPathExt, final String xletClass) {
        ArrayList<URL> classPath = new ArrayList<URL>();
        URL url = BDJClassLoader.translateClassPath(appCaches, basePath, null);
        if (url != null) {
            classPath.add(url);
        }
        String[] classPaths = StrUtil.split(classPathExt, ';');
        for (int i = 0; i < classPaths.length; ++i) {
            url = BDJClassLoader.translateClassPath(appCaches, basePath, classPaths[i]);
            if (url == null || classPath.indexOf(url) >= 0) continue;
            classPath.add(url);
        }
        final URL[] urls = classPath.toArray(new URL[classPath.size()]);
        return (BDJClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new BDJClassLoader(urls, xletClass);
            }
        });
    }

    private static URL translateClassPath(AppCache[] appCaches, String basePath, String classPath) {
        String protocol;
        int i;
        String path = classPath == null || classPath.length() <= 0 ? basePath : (classPath.charAt(0) == '/' ? classPath.substring(1) : basePath + "/" + classPath);
        if (path.length() < 5) {
            return null;
        }
        String name = path.substring(0, 5);
        String dir = path.substring(5);
        for (i = 0; i < appCaches.length && !appCaches[i].getRefToName().equals(name); ++i) {
        }
        if (i >= appCaches.length) {
            return null;
        }
        if (appCaches[i].getType() == 1) {
            protocol = "file:";
            name = name + ".jar";
        } else if (appCaches[i].getType() == 2) {
            protocol = "file:/";
        } else {
            return null;
        }
        String fullPath = System.getProperty("bluray.vfs.root") + File.separator + "BDMV" + File.separator + "JAR" + File.separator + name;
        String cachePath = BDJLoader.getCachedFile(fullPath);
        String url = protocol + cachePath + dir;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            System.err.println("" + e + "\n" + Logger.dumpStack(e));
            return null;
        }
    }

    private BDJClassLoader(URL[] urls, String xletClass) {
        super(urls);
        this.xletClass = xletClass;
        BDJClassLoaderAdapter a = Libbluray.getClassLoaderAdapter();
        if (a != null) {
            this.hideClasses = a.getHideClasses();
            this.bootClasses = a.getBootClasses();
            this.xletClasses = a.getXletClasses();
        }
    }

    protected Xlet loadXlet() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (Xlet)this.loadClass(this.xletClass).newInstance();
    }

    protected void update(AppCache[] appCaches, String basePath, String classPathExt, String xletClass) {
        int i;
        ArrayList<URL> classPath = new ArrayList<URL>();
        URL[] urls = this.getURLs();
        for (int i2 = 0; i2 < urls.length; ++i2) {
            classPath.add(urls[i2]);
        }
        URL url = BDJClassLoader.translateClassPath(appCaches, basePath, null);
        if (url != null) {
            classPath.add(url);
        }
        String[] classPaths = StrUtil.split(classPathExt, ';');
        for (i = 0; i < classPaths.length; ++i) {
            url = BDJClassLoader.translateClassPath(appCaches, basePath, classPaths[i]);
            if (url == null || classPath.indexOf(url) >= 0) continue;
            classPath.add(url);
        }
        for (i = 0; i < classPath.size(); ++i) {
            this.addURL((URL)classPath.get(i));
        }
        this.xletClass = xletClass;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.hideClasses != null && this.hideClasses.get(name) != null) {
            logger.error("Hiding class " + name);
            throw new ClassNotFoundException(name);
        }
        if (name.equals("java.io.File")) {
            Class<?> c = super.loadClass(name);
            if (c != null) {
                BDFileSystem.init(c);
            }
            return c;
        }
        Class bootclass = this.tryLoad(name, this.bootClasses);
        if (bootclass != null) {
            return bootclass;
        }
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e0) {
            logger.error("ClassNotFoundException: " + name);
            Class xletclass = this.tryLoad(name, this.xletClasses);
            if (xletclass != null) {
                return xletclass;
            }
            throw e0;
        }
        catch (Error err) {
            logger.error("FATAL: " + err);
            throw err;
        }
    }

    private Class tryLoad(String name, Map classes) {
        if (classes != null) {
            try {
                byte[] code = (byte[])classes.get(name);
                if (code != null) {
                    logger.info("Overriding class " + name);
                    return this.defineClass(code, 0, code.length);
                }
            }
            catch (Exception e) {
                logger.error("tryLoad(" + name + ") failed: " + e);
            }
        }
        return null;
    }

    private byte[] loadClassCode(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        URL res = super.findResource(path);
        if (res == null) {
            logger.error("loadClassCode(): resource for class " + name + " not found");
            throw new ClassNotFoundException(name);
        }
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            int r;
            is = res.openStream();
            os = new ByteArrayOutputStream();
            byte[] buffer = new byte[65535];
            while ((r = is.read(buffer)) != -1) {
                os.write(buffer, 0, r);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("loadClassCode(" + name + ") failed: " + e);
            throw new ClassNotFoundException(name);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError ce) {
            byte[] b = this.loadClassCode(name);
            if (b == null) {
                logger.error("loadClassCode(" + name + ") failed");
                throw ce;
            }
            try {
                b = new BDJClassFileTransformer().strip(b, 0, b.length);
                return this.defineClass(b, 0, b.length);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                logger.error("Class rewriting failed: " + t);
                throw new ClassNotFoundException(name);
            }
        }
        catch (Error er) {
            logger.error("Unexpected error: " + er + " " + Logger.dumpStack(er));
            throw er;
        }
    }

    @Override
    public URL getResource(String name) {
        name = name.replace('\\', '/');
        URL url = super.getResource(name);
        logger.info("getResource(" + name + ") --> " + url);
        return url;
    }

    @Override
    public URL findResource(String name) {
        name = name.replace('\\', '/');
        URL url = super.findResource(name);
        logger.info("findResource(" + name + ") --> " + url);
        return url;
    }

    public Enumeration findResources(String name) throws IOException {
        name = name.replace('\\', '/');
        return super.findResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name = name.replace('\\', '/'));
        if (is == null) {
            logger.info("getResourceAsStream(" + name + ") failed");
        }
        return is;
    }
}

