{
    This file is the source for a series of routines to set the shape of the
    text cursor.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit cursor;

interface

uses dos;

const
  NO_CURSOR = $2000;

function getcursor : word;
procedure setcursor (cursor : word);

implementation

function getcursor : word;
var
  regs : registers;
begin
  with regs do begin
    ah := $03;
    bh := $00;
  end;
  intr ($10, regs);
  getcursor := regs.cx;
end;

procedure setcursor (cursor : word);
var
  regs : registers;
begin
  regs.ah := $01;
  regs.bh := $00;
  regs.cx := cursor;
  intr ($10, regs);
end;

begin
  writeln ('CURSOR.TPU initializing...Done');
end.

