{
    This file is the source for a series of routines to ease the detection
    of certain operating environments.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit os;

interface

function is_winnt : boolean;
function is_win95 : boolean;
function is_dosemu : boolean;

implementation

uses dos, strings;

function is_winnt : boolean;
var
  regs : registers;
begin
  is_winnt := false;
  regs.ax := $3306;
  intr ($21, regs);
  if regs.al = $ff then
    exit;
  if regs.bx = $3205 then begin
    is_winnt := true;
    exit;
  end;
end;

function is_win95 : boolean; assembler;
asm
  mov ax, $1600
  int $2f
  mov bl, al
  cmp bl, 0
  jne @win95
  mov ax, 0
  jmp @done
@win95:
  mov ax, 1
@done:
  ret
end;

function is_dosemu : boolean;
var
  e6vector : pointer;
  date_string : pchar;
  dosemu_inst : word;
  major, minor : byte;
  patchlevel : word;
begin
  getintvec ($e6, e6vector);
  date_string := ptr ($f000, $fff5);
  if (strlcomp (date_string, '02/25/93', 8) = 0) and (seg (e6vector^) = $f000) then begin
    asm
      mov ah, $00
      int $e6
      mov dosemu_inst, ax
      mov major, bh
      mov minor, bl
      mov patchlevel, cx
    end;
    if dosemu_inst = $aa55 then
      is_dosemu := true;
  end else
    is_dosemu := false;
end;

begin
  writeln ('OS.TPU initializing...Done');
end.
