/*    
   Hlpread.c - help file reader.

   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "hlpread.h"

void MakeHelpFileName(int index, char* result)
{
    int   i;
    char* p;

    strcpy(result, HELP_DIR HELP_BASE);

    p = result+strlen(HELP_DIR HELP_BASE);
    itoa(index, p, 10);
    strrev(p);
    for (i = strlen(p); i < 3; i++) p[i] = '0';
    strrev(p);
}

int ReadHelpFile(int index)
{
    FILE* fptr;
    char filename[22];
    long filesize;
    int c, result;

    char *HelpData, *pos;

    /* Get the appropriate file name. */
    MakeHelpFileName(index, filename);

    /* Read the file. */
    if ((fptr = fopen(filename, "rt")) != NULL)
    {
       fseek(fptr, 0, SEEK_END);
       filesize = ftell(fptr);
       fseek(fptr, 0, SEEK_SET);
    
       if (filesize > 32767)
       {
          fclose(fptr);
          return HELPMEMINSUFFICIENT;
       }
       
       if ((HelpData = malloc((size_t) filesize)) == NULL)
       {
          fclose(fptr);
          return HELPMEMINSUFFICIENT;
       }

       pos = HelpData;
       while ((c = fgetc(fptr)) != EOF) *pos++ = (char) c;
       fclose(fptr);
    }
    else
       return HELPREADERROR;

    result = ParseHelpFile(HelpData, (size_t) filesize);
    free(HelpData);

    return result;
}


