/*

POPD v.1.0 Pops a directory from the stack.
Copyright (C) 1998 Robert Lake

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Robert Lake can be contacted at
email: rlake@cs.mun.ca
Snail Mail: 29 Carlton Drive, Mt. Pearl, NF, A1N 2X4

*/

#include "popd.h"
#include "../misc.h"
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{
	Directories *Dirs;
	if(argc == 2) {
		print_header(argv[0], USAGE, VERSION, NAME, AUTHOR);
		return 0;
	}
	Dirs = (Directories *)malloc(sizeof(Directories));
	if(Dirs == NULL) {
		printf("Cannot malloc mem\n\r");
		return 0;
	}
	if(!read_dirs(Dirs))
		return 0;
	change_dir(Dirs);
	write_dirs(Dirs);
	check_fsize();
	return 1;
}

int read_dirs(Dirs)
Directories *Dirs;
{
	Directories *Top;
	FILE *fhandle;
	Top = Dirs;
	fhandle = fopen(FN, "r");
	if(!fhandle) {
		printf("directory stack empty\n");
		return 0;
	}
	while(!feof(fhandle)) {
		fscanf(fhandle, "%s", Dirs->dir);
		Dirs->next = (Directories *)malloc(sizeof(Directories));
		Dirs = Dirs->next;
		Dirs->next = NULL;
	}
	Dirs = Top;
	fclose(fhandle);
	return 1;
}

int change_dir(Dir)
Directories *Dir;
{
	Directories *Top;
	char dir_to[MAXPATH];
	Top = Dir;
	while(Dir->next != NULL) {
		strcpy(dir_to, Dir->dir);
		Dir = Dir->next;
	}
	setdisk(dir_to[0] - 'A');
	chdir(dir_to);
	Dir = Top;
	return 1;
}

int write_dirs(Dir)
Directories *Dir;
{
	FILE *fhandle;
	Directories *Temp;
	unlink(FN);
	fhandle = fopen(FN, "w");
	if(!fhandle) {
		printf("Unable to open %s\n", FN);
		return 0;
	}
	while(Dir->next->next != NULL) {
		fprintf(fhandle, "%s", Dir->dir);
		Temp = Dir;
		Dir = Dir->next;
		free(Temp);
		if(Dir->next->next != NULL)
			fprintf(fhandle, "\n\r");
	}
	fclose(fhandle);
	return 1;
}

int check_fsize(void)
{
	long length;
	FILE *file;
	file = fopen(FN, "r");
	fseek(file, 0L, SEEK_END);
	length = ftell(file);
	fclose(file);
	if(length == 0)
		unlink(FN);
	return 1;
}
