/*
  pg.h
  
  Header file for pg program
  
  (c) BearHeart
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Revision Notes
                  bh 95.02.27  Initial Coding
*/

#define true (1)
#define false (0)

#define byte unsigned char
#define word unsigned int

/* video attributes */
#define BLACK   (0x00)
#define BLUE    (0x01)
#define GREEN   (0x02)
#define CYAN    (0x03)
#define RED     (0x04)
#define MAGENTA (0x05)
#define BROWN   (0x06)
#define WHITE   (0x07)
#define BRIGHT  (0x08)
#define BLINK   (0x80)
#define YELLOW  (BROWN | BRIGHT)
#define UNDERLINE (0x01)  /* for MONO only */

#define ATTR(fg,bg)  (((bg) << 4) | (fg))

/* for use with asm */
#define BIOS_DATA_SEG 40h
#define DISP_MODE     49h      
#define DISP_COLS     4ah
#define DISP_ROWS     84h
#define CURSOR        50h

/* for use with c */
#define MONO          (7)

#define PG_UP      (0x4900)
#define PG_DN      (0x5100)
#define KEY_HOME   (0x4700)
#define KEY_END    (0x4F00)
#define KEY_UP     (0x4800)
#define KEY_DN     (0x5000)
#define KEY_LT     (0x4B00)
#define KEY_RT     (0x4D00)
#define RETURN     (0x0D)
#define ESC        (0x1B)
#define SPACE      (0x20)
#define BK_SPACE   (0x08)

