{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$G+ enable 286 opcodes}
{$M $2000,0,0}
Program Keyb;
{
ͻ
 Keyboard device driver for FreeDOS. (AT only, no XT)      
 Largely free configurable.                                
͹
 Version 1.13.   08. July   2002. Turbo/Borland Pascal 7.0 
                                                           
 (P) + (C) 1991,1992,1994 Dietmar Hhmann.                 
 (C) 2000-2002 Aitor Santamara. (aitor.sm@wanadoo.es)     
ͼ

Possible defines:
        DEBUG   Enables the debugging options
        KBDRES  Compiles the XKEYBRES, the LITE version


History:
         x.x.'xx: Einbau des PI                                   -> V1.1
        17.2.'92: Fehler bei INT15-Aufruf behoben.
        18.2.'92: Implementation von Kombinationszeichen.         -> V1.2
         8.4.'92: Bug-Fix: ALT-1 - ALT-0,ALT- & ALT-'
        26.6.'92: ^Break gendert in INT 1B und ^C.               -> V1.22
                  Funktion 248 :=> Taste bewirkt nichts.
         9.9.'92: Funktion 247: => OS/2: DOS-Box schlieen.       -> V1.24

        14.2.'94: Fehler bei Alt+Ctrl+F2 behoben                  -> V1.3
                  Problem mit Backslash im MS-DOS-Editor behoben.
                  Angepat an AMI-BIOS: Kein Speichertest beim Warmstart.
                  Fehler mit nicht funktionierender automatischer Einrichtung
                       des XString-Speichers behoben.
                  Erweiterter Tastaturstaus wird gepflegt und kann ber die
                       entsprechenden BIOS-Funktionen abgefragt werden.
----- Aitor Santamara Merino new maintainer
        VER 1.5.1  xKEYB 1.5 was packed WITHOUT .key files
      (24.9.2000)  1.5.1 is just 1.5 with all the .key files packed

        VER 1.6    * Search on PATH capability (Ralf Quint)
      (27.1.2001)  * Changes to .KEY files (Aitor):
                     - DVORAK.KEY (Eugene Wong)
                     - SU.KEY to RU.KEY
                     - Bug 126 fixed (small patch to IT.KEY)

        VER 1.7    *  LED support removed (Aitor, Axel)
      (12.9.2001)  *  Improved search of .key files (also in curdir)
                      (Aitor, Ralf)
                   * Added XKEYB.FHL, the fast help, and it is
                     shown with /? (Aitor)
                   * New Copyright notice (Aitor)
                   * XKEYBRES is now included within this file using DEFINEs
                     this way, changes are reflected in both codes (Aitor)
                   * Switched the reported values in BX/CX for int2Fh/AX=AD80h
                     for MS compatibility (Aitor)
			 * New Makefile (Axel, Ralf, Aitor)
			 * Most of the messages are now displayed in English (Ralf)
			 * Added br850.key (for Brazil, codepage 850) (Alain)
        VER 1.8    * Scancodes now up to 127 (Aitor)
      (31.12.2001) * Solved the problem with the two keys having same Scancode:
                     the (/ ? key) and the (Gray /) key, that causes troubles in
                     non-US keyboards) (Aitor)
                     (thanks to Eric Auer for his hints!)
                   * The Extended E0-keys (Ins, Supr, arrows...) do NOT behave
                     as their normal-AT conunterparts with SHIFT (Aitor)
                   * Translation of source comments into English
                     (Michael Kallas, MANY, MANY thanks!)
                   * Fixes in SCANKBD to patch it during MAKE process (Aitor)
                   * SCANKBD is now more friendly on parameters (Aitor)
                   * CONTRIBUTED LAYOUTS:
                       PC860   Jos A. Senna
                     MODIFIED/UPDATED LAYOUTS:
                       ALL     Added support for extended53 key (gray /)
                       BR850   Alain (modifies COMBI)
                       PC850   Alain, Aitor (Adds COMBI)
                       SP(850) Luis Ignacio Estrada Hoyos, Jose Antonio (jafras)
                       LA(850) Luis Ignacio Estrada Hoyos
                          (in SP and LA: added COMBIs and some useful stuff:
                           tilde in AltGr+)
                     REMOVED LAYOUTS:
                       PC8 (Standard US-437, incomplete and normally unnccessary)
                       RU  (it was equal to SU, whence incorrect)
                       ECMA94  (combis only, does NOT work!)
        VER 1.9    * Alt+9 bug fixed!
      (04.04.2002)  Problem was: Alt+9 produces virtualscancode 128, which was
                     interpretated by StoreKey as a request for XString
                     Solved using the dirty trick of a new variable Alt+9
                   * Allowed immediate comments in lines which very first
                     character is ';' (I hope there are no combis with this character!)
                   * Now returns control to next in chain for non-defined functions:
                     83..8F, 92, 93 and 9D..FF
                   * All layouts include now support for [INS 0] key
                     (thanks to Imre Leber)
                   * MODIFIED/UPDATED LAYOUTS:
                     - PC860   Jose A. Senna
                     - BE      Pierre (now contains COMBIs!)
                     CONTRIBUTED LAYOUTS
                     - US-LV   Kristaps Kaupe
                     - RU      Kristaps Kaupe
                     - HU      Nagy Zsolt
                     - PL      Michal H. Tyc
                     - TR      <sz_chake@hotmail.com>
        VER 1.10   * E0 keys support completed.
      (14.4.2002)    ScanKbd and .KEY files patched accordingly
                     Advantages:
                     - Ctrl+Alt+Del bug fixed
                     - Support for Win keys and multimedia keys (read the docs)
                     Disadvantage:
                     - Over 800b more resident memory! :-(
                   * Before going resident, environment memory is freed
                   * Before resetting, disk caches are flushed
                     (Thanks to: Matthias Paul, Axel for the code for this,
                                 imported from his FreeKEYB)
        VER 1.11   * New hardcoded XFunctions. Default XFunction table:
       (8.5.2002)    247: INT 19h (closes OS/2 DOS Box)
                     250: Disables XKEYB
                     251: Suspends PC (required APM 1.1 or later) (new!)
                     252: Turns the PC Off (required APM 1.1 or later) (new!)
                     253: Performs a cold reboot (new!)
                     254: INT 5h (Print Screen)
                     255: Performs a warm reboot
                   * User defined xfunctions now up to 34 (was up to 39)
                   * New way of defining COMBIs: no longer based in ASCII,
                     but use !C1, !C2,... to assign key combination to
                     the first, second, ... row in [COMBI] section
                     (fixes the problem with ' character in some layouts)
                   * TRUE support of E0-extended keys, fixing all problems
                     that appeared with numeric keys in various editors
                   * New switch /E, to ignore the E0-prefix, and preassign
                     extended keys to their non-extended counterpart
                     (warning, switch not to be used with multimedia keys,
                     winkeys, etc)
        VER 1.12   * Ctrl^CursorUp Ctrl^Cursor down generate correct scancode
       (8.6.2002)    (thanks Axel for noticing)
                   * Fixed scancode for AltGr+number key
                   * Fixed scancode with COMBIs (should be 0!)
                   * Fixed potential problem with Ctrl+Alt+F2 and XKEYBRES if
                     file was not loaded (now with FileLoaded variable)
                   * Fixed problem with character ASCII $E0
                   * 286 and AT is now checked at the begining
                   * All the KEY files have now the "Ctrl+Alt+F1 disable"
                     behaviour by default (modification on the KEY files)
                   * Updated keyboard layout: PC850
                   * Added keyboard layout:   ECMA23 (probably buggy), BR275
        VER 1.13   * In case of Error, DOSExitCode is set to an error code
      (27.7.2002)  * New layout: PC437.KEY
                   * PC437.KEY is ALWAYS read before any other, so KEY files
                     just need to have the differences
                   * Corrected: if Ctrl+^vInsDel is not assigned anything,
                     then it behaves like BIOS (does NOTHING)
                   * Fixed possibly weird behaviour of Alt+ keys affected by
                     NumLock different from keypad
                   * Completely new debugged header for int9handler
                     (includes input buffer checking and timeout)
                     Also the proto-int15h has been almost completely rewritten
                     Fixes a potential bug with GetKey and XFunctions
                     Finally, has a workaround for the byte at offset 03h
                     when using APL software (note however that changes in that
                     bit would produce no effects)
                   * StoreKey now forks into EfStoreKey, the procedure that
                     really gets key into buffer; StoreKey simply parses any
                     possible ASCII,Scancode to its corresponding action.
                   * Xfunction 249: Break interrupt (for ctrl+break)
                   * Changes of virtual ScanCode moved into StoreKey
                   * API function 94h: AH=BH=ScanCode, no longer separation
                     between real and virtual scancode
                   * Removed /E option to map E0-extended into non-extended
                     (for commandline compatibility reasons)
                   * When overloading install, if config file is not found,
                     action is aborted
                   * E0-prefix is now tracked through BIOS variable
                     0040h:0096h (KeysDown2)
                   * Alt+NumberPad and Pause behave now the same as BIOS Keyb
                   * F11 and F12 scancodes are now patched
                   * New policy for testing keyStatus bits: now better
                     behaviour with pressing multiple shifting keys
                   * PrtScrt recovered in the KEY files
                   * Added:  JP106 (Japanese, Takeshi Hamasaki)
                     Reworked: PC850 and BR275 (Henrique Peron),
                               FR (Patrice LEMONNIER)
                     Patched:  all, so that there's response to PrtScr
}

Uses Dos,Inter2;

Const   VerS        = '1.13';
        Version     = $1D0;

        E0Prefixed  = 2;

        { keyboard commands }
        DisableKeyboard = $AD;
        EnableKeyboard  = $AE;

        { keyboard signals }
        AckSignal    = $FA;
        NakSignal    = $FE;


Procedure Data; Forward;

Type   BuffEntTyp  = Record                 { Type of the entries in key buffer. }
                     Case Byte of
                        0:(Ascii,Scan : Byte);
                        1:(Entire : Word);
                     End;
       XBufferTyp  = Array[0..63] of BuffEntTyp;
       ActionTyp   = (Install,Uninstall,OverLoad,GetInfo,WrongVers,OtherDrv,FastHlp);
       PtrTyp      = Record Ofs,Seg:Word End;
       TransTabTyp = Array[1..256,0..5] of Byte;  {127 scancodes, E0+127 scancodes}
       XFuncTyp    = Record
                        Stat : Byte;
                        Case Byte of
                           0 : (Adr : Pointer);
                           1 : (Proc : Procedure(W : Word));
                     End;

{ ========== Following constants are building the fast access DS ========== }
Const  ScanCode    : Byte = 0;
       BreakCode   : Boolean = False;
       XShift      : Boolean = False;       { Extended Shift key. }
       ShiftNum    : Byte = 0;
       ShiftBit    : Byte = 0;
       NCS         : Boolean = False;
       WaitLoop    : Word = 0;
       Loop        : Byte = 0;
{ The 5 following variables are eventually be read from the 2nd copy of XKeyb and modified. }
       ShiftKeys   : Array[0..7] of Byte = (0,0,0,0,0,0,0,0);   { ScanCodes of Shift keys. }
       LastXStr    : Byte = 0;              { Number of the last defined XString. }
       TransTable  : ^TransTabTyp = Nil;    { Pointer to translation table. }
{$IFNDEF KBDRES}
       Inactive    : Boolean = False;       { Tells whether keyboard input is processed by XKeyb or by the BIOS. }
{$ELSE}
       Inactive    : Boolean = True;        { See above. }
{$ENDIF}
       FileLoaded  : Boolean = False;       { File was loaded? }
       XBuffer     : ^XBufferTyp = Nil;     { Pointer to second level buffer. }
       NextMulti   : Pointer = Nil;         { Chain for multiplexer interrupt. }
       NextInt16   : Pointer = Nil;         { Chain for Int 16. }

       XString     : ^String = Nil;         { Actual XString. }
       XStrPos     : Byte = 0;              { Position in XString. }
       PutXStr     : Boolean = False;       { Is XString currently being processed ? }
       Row         : Byte = 0;              { Pointer in translation table. }
       LoopRunning : Boolean = False;       { End of pause mode is already waited for. }
       XBufferHead : Word = 0;              { Pointer to next char and next }
       XBufferTail : Word = 0;              { free entry in second level key buffer. }
       AltInput    : Byte = 0;              { Char entered by Alt and numberkeys. }
       SnapKey     : Boolean = False;       { MultiplexHandler waits for key. }
       SnapedKey   : Byte = 0;              { Ascii-Value of key. }
       FuncPtr     : Byte = 0;              { Number of waiting fuction calls. }
       CombStat    : Word = 0;              { Status of char combination. 0=No combination signs in work. }
                                            { Else pointer to combination table. }
       DownKeys    : Byte = 0;              { Mask for currently pressed keys. }
       KStat       : Byte = 0;              { Status of modifier keys. Alt Gr dissolved to Control+Alt. }
       EoDS        : Byte = 0;

Procedure FastDS;                           { Memory for fast access DS. }
Begin
   ASM
   DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
   End;
End;

Var    KeyStat     : Byte absolute 0:$417;  { Status of modifying keys. }
                                            { 0 : Right SHIFT }
                                            { 1 : Left SHIFT }
                                            { 2 : CTRL }
                                            { 3 : ALT }
                                            { 4 : SCROLL LOCK }
                                            { 5 : NUM LOCK }
                                            { 6 : CAPS LOCK }
                                            { 7 : INSERT }
       KeysDown    : Byte absolute 0:$418;  { Currently pressed modifier keys. }
       KeysDown2   : Byte absolute 0:$496;  { Status of right ALT and Control. }
       LEDs        : Byte absolute 0:$497;  { Status of LEDS. }
       BufferStart : Word absolute 0:$480;  { Start address of key buffer. }
       BufferEnd   : Word absolute 0:$482;  { End address of key buffer. }
       BufferHead  : Word absolute 0:$41C;  { Next free char in buffer. }
       BufferTail  : Word absolute 0:$41A;  { Next char to read. }
       NoMemCheck  : Word absolute 0:$472;

{ -----------------------------------------------------------------------
  Definition of a record which contains data staying resident.
  This builds the slow access DS.
  -----------------------------------------------------------------------}
Type
DR = Record                                 { All data needed after installation. }
       TransTable  : TransTabTyp;           { Maximally 128 keys + 128 extended keys }
                                            { 5 key levels (0-4): normal, shift, ctrl, alt, ctrl+alt (alt gr). }
                                            { Level 5 contains administration information for every key: }
                                            { Bits 0-2 tell, whether the key is influenced by Num, Caps or Scroll. }
                                            { Bits 3-7 tell for every level whether it's mapped to an XStr. }
       Int9Hand    : IntHandObj;
       ConfigFile  : String[64];            { Name of Config file. }
       DoFuncs     : Array[1..10] of        { Functions having to be done at next INT 16. }
                     Record
                        FuncNum : Byte;
                        Case Byte of
                           0:(Stat,Scan:Byte);
                           1:(Entire:Word);
                     End;
       XStrBufSize : Word;                  { Size of buffer for xstrings. }
       XFunc       : Array[201..235] of XFuncTyp;
       CombTab     : Array[0..191] of Byte; { Table for combinated chars. }
       XStrings    : Array[0..$C8C8] of Byte;{ Up to 50K of Kbdextensions.
                                               Aitor's note: reduced from 63Kb}
End;

{ ++++++++++ Macros ++++++++++ }
Procedure Push(W : Word); Inline($90);      { Push parameters to stack. }

Function GetAx : Word; Inline($90);         { Read reg AX. }

Function GetAl : Byte; Inline($90);         { Read reg AL. }


Procedure WaitKBDReady;
Inline($64E4/                               { IN AL,64. }
       $0224/                               { AND AL,2. }
       $FA75);                              { JNZ $-6. }



{ ==========================================================
  Routines for key buffer:
     Procedure StoreKey(Ascii,Scan : Byte);
     Function  BufferSpace : Word;

     + Processing of BIOS calls.
  ==========================================================}


Procedure FindXStr(XStrNum : Byte);         { Search XString and "open" for reading. }
                                            { Will be called by GetKey, }
Label Ende;                                 { if the Scancode read from the 2nd buffer was 128. }
Begin
   If XStrNum<=LastXStr Then                { Number of searched XStr may not be greater than last XStr. }
   Begin
      ASM                                   { base address of XString Table to ES:DI. }
         Mov DI,Offset Data+Offset DR.XStrings
         Push CS
         Pop ES
      End;
      While XStrNum>1 Do                    { Skip n-1 XStrs. }
      Begin
         ASM                      { Address of next XStr. }
            Mov Al,ES:[DI]
            Xor Ah,Ah
            Inc AX
            Add DI,Ax
         End;
         Dec(XStrNum);
      End;
      ASM                         { Store address in XString. }
         Mov Word Ptr XString,DI
         Mov Word Ptr XString+2,ES
         CMP Byte Ptr ES:[DI],0   { length of string = 0 ? }
         JZ  Ende                 { Then end. }
      End;
      XStrPos:=1;                           { Set actual position in XStr to 1. }
      PutXStr:=True;                        { Set flag for processing of XStr. }
                                            { All chars read from now on are from this XStr. }
   End;                                     { If number of XStr is greater than the last one, ignore it. }
Ende:
End;

Function GetKey : Word;                     { Get key from XBuffer. Lo = Ascii, Hi = Scancode. }
Label Skp1,Skp2,Skp3,Skp4;
Begin
   GetKey:=0;

   If not PutXStr Then                      { If no XStr in work, }
   ASM                            { get key from XBuffer. }
      Mov AX,XBufferTail
      Shl Ax,1
      Les DI,XBuffer
      Add Di,Ax                   { Address of next key. }
      Mov Ax,ES:[DI]              { Read key. }
      Cmp Ah,$FF
      Jne Skp1
      Push Ax
      Call FindXStr               { Scancode 128 -> Key mapped to XString -> Search and "open" XStr. }
      Jmp Skp2
Skp1: pop dx
      Mov [BP-2],Ax
Skp2:
      Mov AX,XBufferTail
      Inc Ax
      And Ax,63
      Mov XBufferTail,Ax          { Pointer to next entry. }
   End;

   If PutXStr Then                          { XStr in process. !No ELSE to the IF above, }
   Begin                                    { as PutXStr possibly was set only above! }
      ASM
         Mov Al,XStrPos
         Xor Ah,AH
         Mov Di,Ax
         Add Di,Word Ptr XString
         Mov Ax,[DI]              { Next 2 Bytes from XString. }
         Inc XStrPos
         Cmp AL,0
         JZ  Skp3                 { 1st char >0 ? }
         Xor AH,AH                { -> ASCII only, no Scancode. }
         Jmp Skp4

Skp3:    Inc XStrPos              { Else return Scancode, increase pointer by 2. }
Skp4:    Mov [BP-2],AX
      End;
      PutXStr:=XStrPos<=Length(XString^);   { End of XString ? -> PutXStr = False. }
   End;
End;


(* Last edit: 2001-06-18 MPAUL
;
; - Taken from Axel C. Frinkes & Matthias Pauls FreeKEYB sources
;   with some modifications to possibly work as a drop-in replacement
;   in 4DOS.
; - While the implied actions are different for SMARTDRV 4.0+
;   and NWCACHE 1.00+, the result is the same for both of
;   them - the cache will be flushed unconditionally.
; - Works around a problem with DBLSPACE loaded, where DBLSPACE
;   may terminate the current process with an error message, that
;   it would not be compatible with SMARTDRV before 4.10+.
; - Works around a problem, where the cache would not be flushed
;   with NWCACHE 1.00+, if the CX register accidently happened
;   to be 0EDCh.
; - Is enabled to continue to work with future issues of NWCACHE,
;   which might no longer flush the cache just on calling
;   SMARTDRV's install check...
; - Supports NetWare Lite's NLCACHE and Personal NetWare's
;   NWCACHE sideband API to asynchronously flush the cache.
;   This ensures system integrity even when the NetWare Lite or
;   Personal NetWare SERVER is loaded on the machine.
; - Furthermore, under some conditions on pre-386 machines
;   NWCACHE cannot intercept a reboot broadcast by itself, and
;   hence it must be called explicitely before a possible reboot.  *)

procedure FlushCache; assembler;
label FlushNLCACHE, NLCACHE_callf, NLCACHE_farentry, NLCACHE_reentry,
      FlushSMARTDRV, FlushCacheForce, FlushCacheExit;
asm
FlushNLCACHE:
        mov     ax,0D8C0h       { NLCACHE/NWCACHE install check  }
        mov     cl,ah           { (sanity check: preset CL >= 10h) }
        push    cs              { (preset to ourselves for safety) }
        pop     es              
        mov     di,offset NLCACHE_farentry
        int     2Fh             { (NLCACHE/NWCACHE modify AL,CL,DX,DI,ES)}

        cmp     ax,0D8FFh       { cache installed? (AL = FFh)             }
         jne    FlushSMARTDRV   

        cmp     cl,al           { CL=FFh? (workaround for NWCACHE before  }
         je     NLCACHE_callf   { BETA 17 1993-09-28, CL=FFh,00h,01h)     }
        cmp     cl,10h          { (sanity check: CL < 10h on return,      }
         jae    FlushSMARTDRV   { only CL=01h,02h,03h are defined so far) }

NLCACHE_callf:
        xor     bx,bx           { BX=0: asynch. flush request from server }
        push    cs              { push return address on stack            }
        mov     ax,offset NLCACHE_reentry
        push    ax              
        push    es              { push ES:DI -> entry point into far API  }
        push    di              
        clc                     { assume pure cache                       }
NLCACHE_farentry:               { (dummy entry point)                     }
        retf                    { simulate a CALLF into sideband function }

NLCACHE_reentry:                { return from sideband (AX/flags modified)}
         jc     FlushNLCACHE    { if error retry because still dirty cache}
        test    ax,ax           { CF clear and AX=0000h?                  }
         jnz    FlushNLCACHE    { if not, retry until everything is OK    }

(*NLCACHE/NWCACHE is pure now, so it would be safe to exit here.
; However, it doesn't harm to play it extra safe and
; just fall through into the normal SMARTDRV flush sequence...
; Who knows, multiple caches might be loaded at the same time...  *)

FlushSMARTDRV:
        mov     ax,4A10h        { SMARTDRV 4.00+ API                      }
        xor     bx,bx           { install check (BX=0)                    }
        mov     cx,0EBABh       { mimic SMARTDRV 4.10+ (CX=EBABh)         }
                                { to workaround DBLSPACE problem.         }
                                { CX<>0EDCh to avoid NWCACHE's /FLUSH:OFF }
                                { special case! Flush regardless          }
                                { of NWCACHE's configuration setting.     }
        int     2Fh             { (modifies AX,BX,CX,DX,DI,SI,BP,DS;ES?)  }
                                { NWCACHE 1.xx has flushed its buffers    }
                                { now, but we should not rely on this.    }
        cmp     ax,6756h        { NWCACHE 1.00+ magic return?             }
         je     FlushCacheForce {  (extra-safe for future NWCACHE 2.00+)  }
        cmp     ax,0BABEh       { SMARTDRV 4.0+ magic return?             }
         jne    FlushCacheExit  {  nothing we can do                      }
         jcxz   FlushCacheExit  { any dirty cache elements?               }
FlushCacheForce:
        mov     cx,ax           { CX<>0EDCh to avoid NWCACHE special case,}
                                { hence we preset with magic return for   }
                                { possible future broadcast expansion.    }
        mov     ax,4A10h        { SMARTDRV 4.00+ API                      }
        mov     bx,0001h        { force synchronous cache flush           }
        push    cx              
        int     2Fh             { (modifies BP???)                        }
        pop     cx              { (safety only, not necessary)            }
        cmp     cx,6756h        { retry for any cache but NWCACHE         }
        jne    FlushSMARTDRV    { probably obsolete, but safer            }
                                { at the risk of a possible deadlock in   }
                                { case some hyphothetical SMARTDRV        }
                                { clone would not support the CX return   }
FlushCacheExit:
end;


procedure ForceAPM1_1; assembler;
label ende;
asm
     MOV AX, $5301      {Real Mode interface connect}
     XOR BX, BX
     INT $15

     MOV AX, $530F      {Engage power management}
     MOV BX, 1
     MOV CX, BX
     INT $15

     MOV AX, $5308      {Enable APM for all devices}
     MOV BX, 1
     MOV CX, BX
     INT $15

     MOV AX, $530E      {force version 1.1}
     XOR BX, BX
     MOV CX, $0101
     INT $15
end;



procedure SwitchOff; assembler;
asm
     CALL ForceAPM1_1

     MOV AX, $5307              {First attempt: switch all off}
     MOV BX, 1
     MOV CX, 3
     INT $15

     MOV AX, $5307              {Second attempt: system bios}
     XOR BX, BX
     MOV CX, 3
     INT $15
end;



procedure suspend; assembler;
asm
     CALL ForceAPM1_1

     MOV AX, $5307
     MOV BX, 1
     MOV CX, 2
     INT 15
end;


Procedure EfStoreKey(A,S : Byte); assembler;  { effectively store key in XBuffer. }
label
     Skp1;
asm
            Mov Ax,XBufferHead
            Shl Ax,1
            LES DI,XBuffer
            Add DI,Ax             { Address of next free space in buffer. }
            Mov Ah,S              { Scancode. }
            Mov Al,A              { ASCII-Value. }
            Mov ES:[DI],Ax        { Enter in buffer. }

            Mov Ax,XBufferHead    { Move pointer to buffer end. }
            Inc Ax
            And Ax,63

            Cmp Ax,XBufferTail    { Buffer overflow ? }
            JE  Skp1              { Then discard key and do not change XBufferHead. }
            Mov XBufferHead,Ax
Skp1:
end;


procedure XFunction (XFN: byte);
begin
Case XFN of
201..235: {*** USER DEFINED XFunctions ****}
   With DR(@Data^) Do                       { Function call. }
   Begin
      Case XFunc[XFN].Stat of
         $80 : If FuncPtr<10 Then
               Begin
                  Inc(FuncPtr);
                  Asm
                     Xor Ax,Ax
                     Mov Es,Ax
                     Mov BL,ES:KeyStat      { Get key status. }
                     Push CS
                     Pop ES
                     Mov DI,Offset Data+Offset DR.DoFuncs
                     Mov Al,FuncPtr
                     Dec Al
                     Mov Ah,3
                     Mul Ah
                     Add DI,Ax              { Address of entry in DoFuncs. }
                     Mov Al,XFN
                     Mov ES:[DI],Al         { Function number. }
                     Mov ES:[DI+1],Bl       { key status. }
                     Mov Al,Scancode
                     Mov ES:[DI+2],Al       { ScanCode. }
                  End;
               End;
         $81 : XFunc[XFN].Proc(ScanCode*256+KeyStat);
         $82 : Word(XFunc[XFN].Adr^):=ScanCode*256+KeyStat;
      End;
   End;
{246: RESERVED}
247 : Inline($CD/$19);          { OS/2: Close DOS Box. (int 19h) }
{248: RESERVED}
249 : begin
           XBufferTail := XBufferHead;
           BufferTail  := BufferHead;
           Inline($CD/$1B);          { Break.  (int 1Bh)}
      end;
250 : Inactive:=True;           { XKeyb off. BIOS takes over. }
251 : Begin                     { Suspend}
           FlushCache;
           Suspend
      end;
252 : Begin                     { Switch the PC off }
           FlushCache;
           SwitchOff
      end;
253 : Begin                     { Cold Reboot }
           FlushCache;
           NoMemCheck := 0;
           Inline($ea/0/0/$FF/$FF);  { JMP FFFF:0000 -> Reset. }
      end;
254 : Inline($CD/5);            { Print Screen (INT 5h) }
255 : Begin                     { XF255: Warm Reboot }
           FlushCache;                
           NoMemCheck:=$1234;
           Inline($ea/0/0/$FF/$FF);  { JMP FFFF:0000 -> Reset. }
      End;
end; {case}
end;


Procedure StoreKey(A,S : Byte);             { General processing of ASCII,Scancode }
Begin

{============== REPLACE SCANCODES ============= }

{ ********** Test for control+cursors ********** }
{   if (S=87) or (S=88) then exit; }     { F11 and F12 OFF! }


{ ********** Test for control+cursors ********** }
{ Here we create the virtual scancodes for keys mentioned above, if needed. }

   If ((KStat and $C) = 4) and            { These keys create a special scancode ONLY with Control. }
      ((S=55) or ((S>70) and (S<84)))
   Then
         Case S of
            55 : S:=114;         { ^Print. }
            71 : S:=119;         { ^Home. }
            73 : S:=132;         { ^Pg Up. }
            75 : S:=115;         { ^Cursor left. }
            77 : S:=116;         { ^Cursor right. }
            79 : S:=117;         { ^End. }
            81 : S:=118;         { ^Pg Down. }
            72,76,80,82,83:  If A=0 then exit
         End;

{ ********** Test for function keys F1-F12 ********** }
{ Here we create virtual scancodes for the function keys, if needed. }
{ These only create a different scancode with SHIFT, CONTROL und ALT, }
{ but not with ALT GR. }

   { piece for F1-F10 }
   If (S>58) and (S<69) Then
    Begin
      if (KStat and 8)>0 then S:=s+45           {Lalt or Ralt}
      else if (KStat and 4)>0 then S:=s+35      {ctrl}
      else if (KStat and 3)>0 then S:=s+25      {Lshift and RShift}
    end;

   { piece for F11-F12 }
   If (S=87) or (S=88) Then
    Begin
      if (KStat and 8)>0 then S:=s+52           {Lalt or Ralt}
      else if (KStat and 4)>0 then S:=s+50      {ctrl}
      else if (KStat and 3)>0 then S:=s+48      {Lshift and RShift}
      else s:=s+46
    end;


{ ********** Test for [2] - [13] ********** }
{ The keys [2] - [13] (= 1234567890') [on german keyboard] are increased by 118 with ALT. }

   If (((KStat and $F)=8) or ((KStat and $F)=12)) and
       ((S>1) and (S<14))
     then S:=S+118;

{ ********** E0-prefixed keys ********** }
   if (KeysDown2 AND E0Prefixed)>0 then begin
       if A=0 then A := $E0
              else S := $E0
   end;

{============== Continue with Scancode/ASCII processing ============= }

   If SnapKey Then                          { Does Program interface wait for a key? }
   Begin
      SnapKey:=False;                       { Key goes to PI. }
      SnapedKey:=A;
   End
   Else
   If (KeysDown and 8)=8 Then               { Pause ? }
   ASM                                      { Then end Pause. }
      Mov AL,ES:[Offset KeysDown]           { ES still remains from the check for 0000! }
      And AL,$F7
      Mov ES:[Offset KeysDown],AL
   End
   Else                                     { Else store pressed key. }
       EfStoreKey (A,S);
End;


Function BufferSpace : Byte;                { Calculate free space in buffer. (first level) }
Label Skp1;
Begin
   ASM
      Xor Ax,Ax
      Mov Es,Ax
      Mov AX,ES:BufferEnd
      Sub AX,ES:BufferStart                 { Buffer size in Byte. }
      Mov BX,ES:BufferHead
      Sub Bx,ES:BufferTail                  { Number of Bytes in buffer. }
      JNC Skp1                              { If BX negative, -BX is the free space! }
      Xor Ax,Ax
Skp1: Sub Ax,Bx                             { AX = Free Bytes. }
      Shr Ax,1                              { AX = Free Entrys. }
      Dec AX                                { One entry stays emptys for administration. }
      Mov [BP-1],AL
   End;
End;

Procedure MoveKeys;
{ This routine fills the BIOS key buffer }
{ from the second level buffer. Other ones are fetching them. }
Label Lop1,EoL1,Skp1;
Begin
   ASM
      CLI
      Call BufferSpace
Lop1:    Or Al,Al
         JZ EoL1                  { Loop maximally until AL=0. }
         Mov Bx,XBufferHead
         Cmp Bx,XBufferTail       { If XBuffer empty }
         JNE Skp1
         CMP PutXStr,0            { and no XStr in process }
         JZ  EoL1                 { then end of loop. }
Skp1:
         Push Ax                  { Store counter in AL. }
         Call GetKey              { Get key. }
         Xor Si,Si
         Mov Es,Si
         Mov DI,ES:BufferHead     { Pointer to end of buffer. }
         Mov ES:[DI+$400],AX      { Key in [40:BufferHead]. }
         Pop Ax
         Dec Al                   { Free Space -1. }

         Add Di,2                 { Pointer to next entry. }
         Cmp DI,ES:BufferEnd      { Reached end of buffer ? }
         Mov ES:BufferHead,DI
         Jne Lop1                 { No -> Proceed in Text. }

         Mov DI,ES:BufferStart    { Pointer back to start. }
         Mov ES:BufferHead,DI
         Jmp Lop1                 { Next loop iteration. }

EoL1:
   End;
End;

Procedure Int16Handler;
Label Skp1,Lop1,EoL1;
Begin
   ASM
      PushA
      Push DS
      Push CS
      Pop  DS
      Push ES
      STI
   End;
   For Loop:=1 To FuncPtr Do
      With DR(@Data^),DoFuncs[Loop] Do
         XFunc[FuncNum].Proc(Entire);
   FuncPtr:=0;
   MoveKeys;
   ASM
      Pop  ES
      Pop  DS
      PopA
      Leave
      JMP CS:NextInt16
   End;
End;

Procedure MultiplexHandler;
{ Handler for multiplexer interrupt. Hereby we get the state of installation. }

Label InsCheck,SetKeyTrans,GetKeyTrans,WaitForKeyHit,PutKey,
      SetX,GetX,SetFunc,ClearFunc,SetMap,SetTable,GetTable,
      GetCombTab,GetShiftTab,
      Distr,Ende,Next,Skp1,Skp2,Skp3,Skp4,Skp5,Skp6,Skp7,Skp8,
      Lop1,Lop2,Lop3,Lop4,Lop5,EoL1,EoL2,EoL3,EoL4;
Begin
   ASM
      Push DS                     { Store DS and set to CS. }
      Push CS
      Pop  DS

      CMP AX,$AD80                { Is XKeyb called? }
      JB  Next                    { (XKeyb occupies the function region AD80 - AD9C.) }
      CMP AX,$AD9B
      JA  Next                    { No -> Proceed in chain. }
      CMP AX,$AD92                { functions 92 and 93 not implemented! }
      JE  Next
      CMP AX,$AD93
      JE  Next
      CMP AX,$AD83                { functions 83..8F not implemented! }
      JB  Distr
      CMP AX,$AD90
      JB  Next

{ XKEYB Distributor }
Distr:
      CMP AL,$80                  { AD80 -> Installation Check. }
      JE InsCheck
      CMP AL,$81                  { AD81 -> Set Code Page (Dummy). }
      JNE Skp1
      Mov Ax,0
      CLC
      Jmp Ende
Skp1: CMP AL,$82                  { AD82 -> Set keyboard mapping. }
      JE  SetMap
      CMP AL,$90
      JE  SetKeyTrans             { AD90 -> Set key translation. }
      CMP AL,$91
      JE  GetKeyTrans             { AD91 -> Read key translation. }
      CMP AL,$94
      JE  WaitForKeyHit           { AD94 -> Wait for key hit and return key data. }
      CMP AL,$95
      JE  PutKey                  { AD95 -> Store key into second level buffer. }
      CMP AL,$96
      JE  SetX                    { AD96 -> Set expansion string. }
      CMP AL,$97
      JE  GetX                    { AD97 -> Read expansion string. }
      CMP AL,$98
      JE  SetFunc                 { AD98 -> Assign function. }
      CMP AL,$99
      JE  ClearFunc               { AD99 -> Cancel function assignment. }
      CMP AL,$9A
      JE  SetTable                { AD9A -> Set address of keyboard translation table. }
      CMP AL,$9B
      JE  GetTable                { AD9B -> Read address of keyboard translation table. }
      CMP AL,$9C
      JNE Skp2
      Mov Ax,0                    { AD9C -> Get number of last defined expansion string. }
      Mov BL,LastXStr
      JMP Ende
Skp2: CMP AL,9Dh
      JE  GetCombTab              { Read address of the combination table. }
      CMP Al,9Eh
      JE  GetShiftTab             { Read address of the Shift-List. }
      Mov Ax,10                   { Error 10 -> unknown function. }
      JMP Ende

InsCheck:
       Mov AL,$FF                  { -> Keyboard driver installed. }
      Mov CX,$584B                { Mark for Xkeyb. }
      Mov BX,Version              { Version number. }
      Mov DX,Seg Data             { Address of the data block. }
      Mov ES,DX
      Mov DI,Offset Data
      Mov DX,$4448                { Mark for Xkeyb. }
      Mov SI,$5053                { Mark for Xkeyb. }
      Jmp Ende

SetMap:                           { BL=0 -> BIOS.  BL=FF -> XKeyb. }
      Mov Ax,9
      STC
      INC BL                      { Result has to be 0 or 1! }
      CMP BL,1
      JA  Ende                    { Else error 9 -> Illegal mapping code. }
      Mov Inactive,BL             { 0 (False) -> XKeyb, 1 (True) -> BIOS. }
      Mov Ax,0
      CLC
      JMP Ende

SetKeyTrans:
      Mov Ax,4
      Dec DI                      { Result needs to be smaller than 255}
      CMP DI,255
      JA  Ende                    { Else error 4 -> Illegal key number}
      Shl DI,1
      Mov Ax,Di
      Shl Di,1
      Add Ax,Di                   { (Key number-1)*6 -> Offset for translation table! }
      LES DI,TransTable           { Base of translation table. }
      Add DI,Ax                   { Address of the entry to modify. }
      Mov ES:[DI],BL              { Normal mapping. }
      Inc DI
      Mov ES:[DI],CH              { With Shift. }
      Inc DI
      Mov ES:[DI],CL              { With Control. }
      Inc DI
      Mov ES:[DI],DH              { With Alt. }
      Inc DI
      Mov ES:[DI],DL              { With Alt Gr. }
      Inc DI
      Mov ES:[DI],BH              { Status byte. }
      Mov Ax,0
      Jmp Ende

GetKeyTrans:
      Mov Ax,4
      Dec DI
      CMP DI,255
      JA  Ende                    { Error if key number 0 or >255. }
      Shl DI,1
      Mov Ax,Di
      Shl Di,1
      Add Ax,Di
      LES DI,TransTable
      Add DI,Ax                   { Address of entry in the table. }     
      Mov BL,ES:[DI]              { Read all entries. }
      Inc DI
      Mov CH,ES:[DI]
      Inc DI
      Mov CL,ES:[DI]
      Inc DI
      Mov DH,ES:[DI]
      Inc DI
      Mov DL,ES:[DI]
      Inc DI
      Mov BH,ES:[DI]
      Mov Ax,0
      Jmp Ende

WaitForKeyHit:
      Mov SnapKey,True            { -> Program interface is waiting for a key. }
      STI                         { Enable interrupts. }
Lop1: CMP SnapKey,True            { Wait until key press.}
      JE  Lop1
      CLI                         { Please do not disturb.}
      Mov Ah,ScanCode             { Read virtual scancode. }
      Mov Al,SnapedKey            { ASCII Value of key. }
      Mov Bh,ScanCode             { Physical Scancode. }
      Xor Cx,Cx
      Mov Es,CX
      Mov Bl,ES:[Offset KeyStat]  { Keyboard status. }
      Mov Dh,Row                  { Key level -> 0=Normal, 1=Shift, 2=Control, 3=Alt, 4=Alt Gr. }
      Mov Cx,Version              { Version number. }
      Jmp Ende

PutKey:
      Mov CX,XBufferHead          { Remember BufferHead. }
      Push CX
      Push BX                     { BL=ASCII Value. }
      Mov BL,BH                   { BH=Scancode (virtual). }
      Push BX
      Call StoreKey               { store it. }
      Xor Ax,Ax
      Pop CX
      Cmp Cx,XBufferHead          { Did BufferHead change? }
      Jne Ende                    { Yes -> ok. }
      Mov Ax,5                    { No -> Error 5: Buffer full. }
      Jmp Ende

SetX:
      Mov Ax,1
      Dec Bl
      Cmp Bl,199
      JA  Ende                    { XStr number has to be between 1 and 200! }

      Inc Bl                      { Restore XStr Number. }
      Mov Bp,Offset Data
      Xor Si,Si
      Cmp Bl,LastXStr             { Is XStr Number greater than that of last one? }
      JBE Skp3

         Mov BH,1                 { Yes -> We need to create some empty strings. }
Lop2:       Cmp BH,LastXStr       { Calculate pointer BEHIND last XStr. }
            JA  EoL3
            Mov Al,Byte Ptr CS:[SI+BP+Offset DR.XStrings] { Length of XStr. }
            Xor AH,AH
            Add Si,Ax             { Add length to SI. }
            Inc SI                { SI+1 -> because of length byte! }
            Inc BH
            Jmp Lop2
EoL3:
         Xor Ch,Ch
         Mov CL,BL
         Sub Cl,LastXStr          { CX = Number of empty strings to create. }
         Mov Ax,2
         Push Cx                  { Save. }
         Add Cx,Si                { SI = Pointer behind LastXStr. }
         Cmp Cx,Word Ptr CS:[BP+ Offset DR.XStrBufSize]  { Do the empty strings still fit into the buffer? }
         Pop CX
         JA  Ende                 { No -> Error 2: Buffer full. }

         Xor Ax,Ax
         CLD                      { Direction: forward (inc). }
         Push Di                  { Store ES:DI. }
         Push ES
         Push CX                  { Store CX. }
         Push CS
         Pop ES                   { ES = Segment address of buffer. }
         Mov Di,Si                { DI = Address behind LastXStr relatively to start of buffer. }
         Add Di,BP                { + Offset address of  Data region. }
         Add Di,Offset DR.XStrings{ + Offset address of buffer in the record. }
         Rep Stosb                { Create CX empty strings. }
         Pop CX                   { Restore CX and ES:DI. }
         Pop ES
         Pop DI

         Push Cx
         Add CL,LastXStr
         Mov LastXStr,CL          { Correct LastXStr. }
         Pop Cx

         Add Si,Cx                { SI contains Address of XString to define. }
         Mov Cx,Si                { CX points behind LastXStr. Both relates to the start of the buffer! }
         Dec Si
         Jmp Skp4

{ The ELSE-branch, if XStr number <= LastXStr. }
Skp3:
         Mov BH,1
         Mov AX,SI                { SI points to first XStr. (contains 0.) }
Lop3:       CMP BH,LastXStr       { Calculate pointer behind last XStr and pointer to the searched XStr. }
            JA  EoL4
            CMP BL,BH
            DB  $75,2             { If BL<>BH skip next command. }
            Mov Ax,SI             { Else store address of searched XStr. }
            Mov Dl,CS:[SI+BP+Offset DR.XStrings]
            Xor Dh,Dh
            Add Si,Dx
            Inc SI
            Inc BH
            Jmp Lop3

EoL4:    Mov CX,SI                { As above! CX points behind everything, Si to the searched string.}
         Mov Si,AX

Skp4:                             { We continue with the values calculated by one of the IF branches. }
      Mov DL,ES:[DI]              { Length of XStr to enter. }
      Xor Dh,Dh
      Mov Al,CS:[SI+BP+Offset DR.XStrings] { Length of present XStr. }
      Xor Ah,Ah
      Sub Dx,Ax                   { DX: needed shifting BACKWARDS in Bytes. May be negative. }
      JZ Skp5                     { Same string length? Then skip shifting. }

         Push CX
         Add Cx,Dx                { Is the shifting possible? }
         Mov Ax,2
         Dec Cx
         Cmp CX,CS:[BP+Offset DR.XStrBufSize]
         Pop CX
         JA  Ende                 { Sorry. Not enough buffer space. }

         Mov AX,SI
         Add Al,CS:[BP+SI+Offset DR.XStrings]
         Adc AH,0
         Inc Ax                   { Pointer behind the string to insert. }
         Mov Bx,Cx
         Sub Bx,Ax                { Number of Bytes to copy. }
         Jz  Skp5                 { None? Bye... }

         Push Dx
         SHL DX,1                 { Test upper bit -> is DX positive or negative? }
         Pop DX
         CLD
         JC Skp6                  { If negative copy from front to back. }

         STD                      { Else from back to front. }
         Add Ax,Bx                { Correct pointer: From first byte to copy to the last. }
         Dec Ax                   { UPON the last, not behind! }

Skp6:    Push Es                  { Save ES:DI, will still be needed! }
         Push Di
         Push Si                  { As well as the start address of the string to set. }
         Push CS
         Pop Es                   { ES to segment address of buffer. }
         Mov DI,Ax                { ES:DI = target. }
         Add DI,DX                { target = source + shifting }
         Mov Si,Ax                { DS:SI = source }
         Mov Cx,Bx                { Number of Bytes. }
         Mov AX,Offset DR.XStrings{ Offset address of Buffer relatively to start of record }
         Add Ax,BP                { + Base address of data region }
         Add SI,AX                { add to source and target. }
         Add DI,AX
         Rep Movsb                { Just put it! }
         Pop Si                   { Restore Si,Di,Es. }
         Pop Di
         Pop Es

Skp5: Mov Cl,ES:[DI]              { Length of string to enter. }
      Xor Ch,Ch
      Mov BX,DI
      Mov DI,SI                   { DI = target offset. }
      Mov SI,BX                   { SI = source offset. }
      Add DI,BP                   { target offset + base of buffer. }
      Add DI,Offset DR.XStrings
      Mov Bx,Es
      Mov DS,Bx                   { DS = source segment. }
      Push CS
      Pop ES                      { ES = target segment. }
      CLD                         { Go ahead! }
      Inc CX                      { And don't forget the length byte! }
      Rep Movsb                   { There it goes ... }

      Xor Ax,Ax                   { Ahh. Did it :-) }
      Mov BL,LastXStr
      JMP Ende

GetX:
      Mov AX,1
      Dec Bl
      Cmp Bl,199
      JA  Ende                    { Invalid number. }

      Mov Ax,3
      Inc Bl
      Cmp Bl,LastXStr
      Ja  Ende                    { XStr is not defined. }

      Mov Si,Offset Data+Offset DR.XStrings { Offset address of buffer relatively to Segment start. }
Lop4:    Cmp BL,1                 { Search desired XStr. }
         JE  EoL1
         Mov Al,CS:[SI]
         Xor Ah,Ah
         Add Si,Ax
         Inc Si
         Dec Bl
         Jmp Lop4
EoL1:
      CLD
      Mov CL,CS:[SI]              { String length to CX. }
      Xor Ch,Ch
      Inc CX                      { + length byte. }
      Rep Movsb                   { and shovel ... }

      Xor Ax,Ax
      Mov Bl,LastXStr
      Jmp Ende

SetFunc:
      Mov BP,Offset Data+Offset DR.XFunc { Offset address of XFunction table. }
      Cmp Bl,0                    { BL=0 -> Search empty XStr. }
      JNE Skp7                    { Else use given number. }

         Mov SI,0
         Mov Ax,6
Lop5:    Cmp DS:[BP+SI+Offset XFuncTyp.Stat],Ah { Unused ? }
         JE  EoL2                 { Then end. }
         Add SI,5                 { Else next one. }
         Inc BL
         Cmp BL,40                { No more left? }
         Je  Ende                 { Oh oh. Error 4: No free XStr for functions. }
         JMP Lop5                 { Don't be tired! Go on searching! }

EoL2:    Add BL,201               { Adapt BL for caller. }
         JMP Skp8                 { SI cointains pointer into the table. }

{ Else-branch. Test if desired XStr is legal. }
Skp7:
         Mov Ax,1
         Sub BL,201
         JC  Ende                 { XStr number < 201? No way. }
         Cmp BL,34
         JA  Ende                 { After subtraction still > 34? Not possible either. }
                                  { If the XFunc is already in use, that's the user's own problem! }
         Mov Al,Bl
         Mov Ah,5
         Mul Ah                   { Every entry contains 5 Bytes. }
         Add BL,201               { Correct value. }
         Mov Si,Ax                { SI contains pointer into the table. }

Skp8:
      Mov Ax,7
      CMP BH,2                    { BH>2? That's an error. }
      JA  Ende                    { Error 2 -> Illegal calling convention. }

      Add BH,$80
      Mov DS:[BP+SI+Offset XFuncTyp.Stat],BH   { Insert all the stuff into the table. }
      Mov DS:[BP+SI+Offset XFuncTyp.Adr],Di
      Mov DS:[BP+SI+Offset XFuncTyp.Adr+2],ES
      Xor Ax,AX
      Jmp Ende

ClearFunc:
      Mov BP,Offset Data+Offset DR.XFunc
      Mov Ax,1
      Sub Bl,201
      Jc  Ende
      Cmp Bl,34
      Ja  Ende                    { Error if illegal XFunc number. }

      Mov Al,Bl
      Mov Ah,5
      Mul Ah
      Mov Si,Ax
      Mov AX,8
      Cmp DS:[BP+SI+Offset XFuncTyp.Stat],AH
      Je  Ende                    { Error if XFunc not mapped. }

      Mov DS:[BP+Si+Offset XFuncTyp.Stat],AH { Status = 0. }

      Xor Ax,AX
      Jmp Ende

SetTable:
      Mov Word Ptr TransTable,DI  { Set address of translation table. }
      Mov Word Ptr TransTable+2,ES

GetTable:
      LES DI,TransTable           { Read address of translation table. }
      Xor Ax,Ax
      Jmp Ende

GetCombTab:
      Push Cs
      Pop  Es
      Mov  Di,Offset Data+Offset DR.CombTab
      Xor  Ax,Ax
      Jmp  Ende

GetShiftTab:
      Push Cs
      Pop  Es
      Mov  Di,Offset ShiftKeys
      Xor  Ax,Ax

Ende:
      Pop DS                      { Restore DS and end of interrupt. }
      Pop BP
      IRET

Next:
      Pop DS                      { Restore DS and go to next interrupt handler. }
      Pop BP
      JMP CS:[NextMulti]
   End;
End;

Procedure KBDOut(B:Byte);
Label Lop1,Lop2,Ok,Err;
Begin
   ASM
Lop1: IN  AL,$64                  { Wait for readiness. }
      And AL,2
      JNZ Lop1

      Mov AL,B                    { Output byte. }
      Out $60,AL

      Xor Ax,Ax
      Mov Es,Ax
      Mov CX,$2000

Lop2: Mov Al,ES:LEDs              { Wait for answer. }
      Test Al,$10
      Jnz Ok
      Test Al,$20
      Jnz Err
      Loop Lop2

Err:  Or ES:LEDs,$80              { Error flag. }

Ok:   And ES:LEDs,$CF             { Clear Ack & Nak. }
   End;
End;

{***********************************************************
 Translation routines.
 ***********************************************************}


{$F+}
Procedure Int9Handler(Var Regs : Registers);{ Handler for keyboard interrupt. }
Label  Start,Ende,BIOS,Combine,NoCombine,Skp0,
       Skp1,Skp1_2,Skp1_3,Skp1_4,Skp2,Skp3,Skp5,Store,Skp7,Err,Lop1,Lop2,Lop3,
       WaitReady1, WaitReady2, X, DoXFunc, Skp8, Skp9,
       Jmp1, Jmp2, Jmp3, Jmp4, JmpXX;
Begin


{------------------------------------------------------------------------
---- BEGIN FreeDOS KEYB 2.0 CODE (by Aitor Santamaria_Merino)       -----
------------------------------------------------------------------------}

   ASM
        {**** Workaround for the byte 03h problem with APL }
        JMP Start
        DB 0                 { reserved for IsActive, modified by APL software}
Start:

        {**** check if the driver should be active }

        TEST Inactive, $FF   { If Inactive GOTO BIOS}
        JNZ  BIOS
        CLI                  { we process it, we disable hardware ints }


        {**** Disable the keyboard }

        XOR    CX, CX       { counter to 65535! }
WaitReady1:
        IN     AL, $64      { read status register }
        TEST   AL, 2        { bit 1 set: input buffer full? }
        LOOPNZ WaitReady1   { loop until timeout or bit 1 clear }

        MOV AL, DisableKeyboard 
        OUT $64, AL         { send the disable command }

        {**** Get Scancode }

        IN AL, $60          { get scancode to AL }

        {**** Authenticate scancode}

        Mov Ah,$4F
        STC
        INT 15h             { -> Possibly external scancode translation by INT 15! }
        JNC Ende            { No further processing of pressed keys if CARRY cleared! }


        {**** Test for Ack, Nak, XKey }

        CMP AL, $E0          { E0? then jump to Ende, and there E0prefixed will be updated }
        JE  Ende
        CMP AL, AckSignal    { Acknowledge signal? }
        JNE Jmp1             
        MOV CL, $10
        JMP Jmp2
Jmp1:   CMP AL, NakSignal    { No-acknowledge signal? }
        JNE Jmp3
        MOV CL, $20
Jmp2:   XOR AX, AX           { Ack or Nak signals }
        MOV ES, AX
        OR  ES:LEDs, CL      { update extended keyboard state }
        JMP Ende

        {**** Determine if it's break or make code }

Jmp3:   XOR CL, CL           { this will store BreakCode }
        TEST AL, $80         { break or make? }
        JZ   Jmp4            { if zero -> make }
        MOV  CL,1            { breakcode}
        AND  AL, $7F         { disable the break bit}
Jmp4:   MOV  BreakCode, CL   { fill breakcode }
        MOV  ScanCode,  AL   { correct scancode }

    End;

{------------------------------------------------------------------------
---- END FreeDOS KEYB 2.0 CODE (by Aitor Santamaria_Merino)         -----
------------------------------------------------------------------------}


{ ********** Test for Break ********** }
   If ((KeysDown2 AND E0Prefixed)>0) and not BreakCode Then
      If ScanCode=70 Then    { Extended key 70 is the Break key. Only at extended keyboards!!! }
      begin
           XBufferTail := XBufferHead;
           BufferTail  := BufferHead;
           Inline($CD/$1B);  { Break. }
           Goto Ende;
      End;


   KStat:=KeyStat;
   If (KeysDown2 and 8)=8 Then KStat:=KStat or 12;


{ ********** Test for Shift ********** }

   ShiftNum:=0;                             { Test whether actual scancode is in the list of keys to shift. }
   While (ShiftNum<=7) and                  { Search until scancode found or end of list. }
      (ScanCode<>ShiftKeys[ShiftNum]) Do begin
      Inc(ShiftNum);
   end;

   ASM                            { Set the bit in ShiftBit that corresponds with the pressed shift key. }
      Mov Cl,ShiftNum
      Mov Al,1
      Shl Al,Cl
      Mov ShiftBit,Al
   End;
           
   If (ShiftNum<2) Then                     { Extended Shift key was pressed. }
   Begin
      If (KeysDown2 AND E0Prefixed)>0 Then
      Begin
         XShift:=Not BreakCode;             { Remember this seperately. }
         Goto Ende;
      End
      Else
      If BreakCode Then XShift:=False;
   End;

   If ShiftNum>1 Then                       { Set extended keyboard state. }
   Begin
      If ShiftNum<4 Then DownKeys:=1 shl (ShiftNum-2)
                    Else DownKeys:=1 shl ShiftNum;
      DownKeys:=DownKeys and $7F;           { Prevent INS from being interpret as SYS-REQ }
      If (ShiftNum=3) and ((KeysDown2 AND E0Prefixed)>0) Then         { Right ALT-key has got no influence here! }
         KeysDown:=0;
      If BreakCode Then KeysDown:=KeysDown and (not DownKeys)
                   Else KeysDown:=KeysDown or DownKeys;
   end;

   If ShiftNum<4 Then                       { One of LSHift, RShift, Control, Alt was pressed. }
   Begin
      If ShiftNum>1 Then
         DownKeys:=1 shl(ShiftNum-2);       { For extended keyboard status. }
      If (ShiftNum=3) and ((KeysDown2 AND E0Prefixed)>0) Then
      Begin
{         ShiftBit:=$C; }                   { Extended ALT-key = Alt Gr = Control+Alt! } 
         If BreakCode Then KeysDown2:=KeysDown2 and $F7   { Actualize status for right ALT-key. }
                      Else KeysDown2:=KeysDown2 or 8;
      End;
      If BreakCode Then                     { If key released, }
      Begin
         KeyStat:=KeyStat and               { clear corresponding bit in status. }
                  (not ShiftBit);
         If ShiftBit=8 Then                 { ALT released ! }
            If AltInput<>0 Then             { ALT + keypad numbers ? }
            Begin
               ScanCode:=0;
               StoreKey(AltInput,0);       { Store entered key in keyboard buffer. }
               CombStat:=0;                 { No combinations with Alt-signs! }
               AltInput:=0;
            End;
      End
      Else KeyStat:=KeyStat or ShiftBit;    { If key pressed, set corresponding bit in status. }
      Goto Ende;                            { end of processing. }
   End;

   If BreakCode Then Goto Ende;             { Releasing of keys isn't any more relevant from here on! }

   If ShiftNum<7 Then                       { Scancode is one of Lock keys. }
   Begin
      If (ShiftNum=5) and ((KeyStat and 4)>0) Then
      ASM                                   { Ctrl-Num = Pause ! }
         Xor AX,AX
         Mov ES,AX
         OR  ES:KeysDown,8                  { Set pause bit. }
         JMP Ende                           { Goto final waiting loop. }
      End;
      ASM
         Xor Ax,Ax
         Mov Es,Ax
         Mov Al,ShiftBit
         Xor ES:KeyStat,Al                  { Shift status of pressed key. }
         JMP Ende                           { Output to KBD takes place at the end. }
      End;
   End;



{ *********** Check for Insert *********** }

   If (ShiftNum=7) and                      { Shift-7 = Insert (INS). }
      ((KeyStat and $F) =0) Then            { !Only if pressed WITHOUT Shift, Control and Alt! }
   ASM
      Xor Ax,Ax
      Mov Es,Ax
      Xor Es:KeyStat,$80                    { Toggle INS Bit. }
   End;

{ ********** Check for ALT + number key ********** }

   If ((KStat and $F) = 8 ) and ((KeysDown2 AND E0Prefixed)=0) and           { ALT pressed? }
      (ScanCode>=$47) and (ScanCode<=$52) and
      (Scancode<>$4A) and (scancode<>$4A)   { Is key influenced by NUM? }
      Then
      Begin
        If (KeysDown and 8)=8 Then               { Pause ? }
           ASM                                      { Then end Pause. }
             Mov AL,ES:[Offset KeysDown]           { ES still remains from the check for 0000! }
             And AL,$F7
             Mov ES:[Offset KeysDown],AL
           End
        else begin
          {translate scancode->number}
         case Scancode of $47..$49 : Scancode := Scancode - $40;
                          $4B..$4D : Scancode := Scancode - $47;
                          $4F..$51 : Scancode := Scancode - $4E;
                          Else       Scancode := 0;
         end;
         AltInput:=AltInput*10 + ScanCode; { -> append pressed number to the existing value. }
        end;
        goto ende;
      End;

{ ********** Processing of further keys ********** }

   scancode := scancode + ((keysDown2 AND E0Prefixed) SHL 6);
        { if E0-prefixed, then scancode adds 128}

   NCS:=(( TransTable^[ScanCode,5] and      { Check, whether Num, Caps or Scroll are on }
          (KeyStat shr 4) and               { and whether the pressed key is influenced by them. }
          $7
        ) > 0){ Xor XShift};                { Extended Shift key clears NCS! }

   if scancode<128 then                     { in NON-extended keys only!}
        NCS := NCS xor XShift;


   if (KStat and 12)=4 then Row := 2                             {CTRL}
   else if (Kstat and 3)>0 then Row := byte(NCS) xor 1           {Shift}
   else if (KStat and 8)>0 then Row := 3 + ord((KStat and $4)>0) {LAlt,RAlt}
   else if (Kstat and $f)=0 then row := byte (NCS);              {normal}

(*
   Case (KStat and $F) of
      0    : Row:=Byte(NCS);                { No Shifts, depends on NCS. }
      1..3 : Row:=Byte(NCS) xor 1;          { SHIFT, depends on NCS. }
      4    : Row:=2;                        { CTRL, not influenced by NCS. }
      8    : Row:=3;                        { ALT, not influenced by NCS. }
      12   : Row:=4;                        { CTRL & ALT, not influenced by NCS. }
   End;
*)
(*   If (KeysDown2 and 8)=8 Then Row:=4;      { Right ALT key is down! =>> ALT GR! } *)

   
   ASM
      Mov Al,ScanCode             { ScanCode. }
      Dec Al                      { Array starts at 1. Correcting that. }
      Xor AH,AH
      SHL AX,1
      Mov BX,Ax
      Shl Ax,1
      Add Ax,Bx                   { 6 times value -> pointer in TransTable. }
      LES Di,TransTable           { Start address of table. }
      Add Di,Ax                   { Address of table entry. }
      Mov Al,ES:[DI+5]            { Read status byte. }
      Mov Bl,ScanCode

      Mov Cl,Row                  { Line. }
      Inc Cl
      Shl Al,Cl                   { The XStr-Bit corresponding to row gets shifted to Carry. }
      JNC Skp1                    { Jump if not occupied by XStr. }
      Mov BL,$FF                  { Replace scancode by signature FFh }

Skp1: Mov Cl,Row
      Xor Ch,Ch
      Add Di,CX
      Mov Al,ES:[DI]              { ASCII value or XStr number from Transtable. }

{------------------------------------------------------------------------
---- BEGIN FreeDOS KEYB 2.0 CODE (by Aitor Santamaria_Merino)       -----
------------------------------------------------------------------------}

{====================== WE HAVE Scan, ASCII ===========}

Skp1_2:
      CMP BL,$FF      { XOperation: XFunction, XString, COMBI or predefined}
      JE  X

{====================== PART 1: non-XOperation ========}

      AND BL,$7F          { disable the effect of +128 for E0-prefixed ones}
      CMP AL,$E0          { if ASCII=$E0, then ScanCode=0 }
      JNE Skp1_4
      XOR BL,BL

Skp1_4:
      CMP CombStat, 0     { pending COMBI operation? }
      JZ  Store           { NO, store the ASCII,SCANCODE }

    {===== PART 1-1: COMBINE ==} 

      Mov Di,CombStat
      Mov CombStat,0

      Mov Si,Di
      Mov CL,DS:[DI]              { Number of chars to check. }
      Xor Ch,Ch
      Inc Di
Lop2: Cmp Al,DS:[DI]              { Found 2nd char of combination? }
      JNZ Skp5                    { No. }

      Inc Di
      Mov Al,DS:[Di]              { Replacement char. }
      XOR BX,BX                   { ScanCode should be 0 with COMBI!}
      Jmp Store

Skp5: Inc Di                      { Next entry. }
      Inc Di
      Dec Cx                      { Another candidate? }
      JNZ Lop2                    { Then go on. }

NoCombine:
      Push Ax                     { All that was a failure. }
      Push BX                     { Now throw both chars into the key buffer seperately. }
      Mov Al,DS:[Si-1]            { First char. }
      Xor Bl,Bl                   { Scancode forgotten. So we put 0. }
      Push Ax
      Push Bx
      Call StoreKey               { Store first char. }
      Call StoreKey               { Store 2nd char. }
      Jmp Ende

{====================== PART 2: XOperation ========}

X:    CMP AL,200             { is AL<=200 ? }
      JA Skp8                { yes, so it is a XString }
      MOV BL, $FF            { we put the signature $FF as scancode }
      JMP Store              {yes: it is XString, so we store it}

Skp8: CMP Al,236             {is 236<=AL<=245 ?}
      JB  DoXFunc
      CMP Al,245
      JA  DoXFunc               {if not, we go to}

    {===== PART 2-1: START COMBI ==}

      Mov DI,Offset Data+Offset DR.CombTab  { Test, whether char is first char of a combination. }
Lop3: Cmp Byte Ptr DS:[Di],0      { End of list? }
      Jz  Store                   { Yes. }
      Cmp Al,236                  { Is this the char? }
      JE  Skp7                    { Yes. }
      Inc Di
      Mov Cl,DS:[Di]
      Xor Ch,Ch
      Shl Cx,1
      Add Di,Cx
      Inc Di                      { Next char. }
      Dec Al
      Jmp Lop3

Skp7: Inc Di
      Mov CombStat,Di
      Jmp Ende

    {===== PART 2-2: Call XFunction ==} 

DoXFunc:
      PUSH AX
      Call XFunction
      Jmp Ende

{==================== FINAL: Store the key in AX, BX ========}

Store:
      PUSH Ax
      Push Bx
      Call StoreKey


{==================== ENDE: Interrupt ENDS here =============}

Ende:

        {===== A) update the E0 flag in KeysDown2 (0040h:0096h) ==}

        XOR CX,CX
        MOV ES,CX
        MOV CL, ES:[Offset KeysDown2]      { CL := KeysDown2 }
        AND CL, $FD          { Clear E0Prefixed flag }
        CMP AL, $E0          { AL=Scancode = E0h ? }
        JNE JmpXX
        OR  CL, E0Prefixed   { Put E0Prefixed flag }
JmpXX:  MOV ES:[Offset KeysDown2], CL


        {===== B) update the BIOS buffer and run Xfunctions ==}

        Call MoveKeys;

        {===== C) totally reenable interrupts ==}

        MOV AL, $20            { report End of Interrupt to interrupt controller }
        OUT $20, AL
        STI                    { restore interrupts }


        {===== D) Enable the keyboard ==}

        XOR    CX, CX       { counter to 65535! }
WaitReady2:
        IN     AL, $64      { read status register }
        TEST   AL, 2        { bit 1 set: input buffer full? }
        LOOPNZ WaitReady2   { loop until timeout or bit 1 clear }

        MOV AL, EnableKeyboard
        OUT $64, AL         { send the enable command }

    END;

{------------------------------------------------------------------------
---- END FreeDOS KEYB 2.0 CODE (by Aitor Santamaria_Merino)         -----
------------------------------------------------------------------------}


   If LoopRunning Then Goto Skp3;           { If waiting loop is already running, leave interrupt routine. }

   LoopRunning:=True;
   ASM
      Xor  Ax,Ax
      Mov  Es,Ax
Lop1: Test Es:KeysDown,8                    { Wait while in pause mode. }
      JNZ  Lop1
   End;
   LoopRunning:=False;
Skp3:
   ExitChain;                               { Leave interrupt routine. }


BIOS:                                       { XKeyb is inactive. Key translation is done by BIOS. }
   If ((KeyStat and 12) = 12) and           { Ctrl+Alt and }
      (Port[$60]=60) and                    { F2 pressed? }
      FileLoaded Then                       { already file loaded? }
   Begin                                    { XKeyb takes over again. }
      Inactive:=False;
      EOI;
      Goto Skp3
   End;


End;
{$F-}

{***********************************************************
 The following procedure is a dummy.
 Here we store the data section during runtime.
 ( For slow access DS.)
 The final size depends on size of XStr buffer.
 ***********************************************************}

Procedure Data;                               {  about 2'75K free memory. }
Begin ASM
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
End; End;

Var    DatSeg      : ^DR;                   { Variables only needed during installation. }
       Regs        : Registers;

Procedure Keep(Ende : Pointer; Code : Byte);     { Terminate program but stay resident in memory. }
Var    Laenge      : Word;                       { !The program will stay in memory only until the given address! }
       PSPPtr      : ^Word;
Type   PtrTyp      = Record Ofs,Seg : Word; End;
Begin
   {free the environment block}
   PSPPtr := Ptr( PrefixSeg, $2C );
   with regs do begin
      ax := $4900;
      es := PSPPtr^
   end;
   Intr( $21, Regs);

   {callculate size and exit}
   Laenge:=PtrTyp(Ende).Seg-PrefixSeg +     { Calculate program length. }
           (PtrTyp(Ende).Ofs+15) Div 16;
   With Regs Do
   Begin
      AH:=49;                               { Terminate, stay resident. }
      AL:=Code;                             { End-code. }
      DX:=Laenge;                           { Length in paragraphs. }
      Intr($21,Regs);
   End;
End;


{$IFNDEF KBDRES}   {Piece of code which is not neccessary for KBDRES}


Procedure Error(B : Byte);
Begin
   Case B of
      1 : Writeln('Different Version of XKeyb installed.');
      2 : Writeln('Incompatible keyboard driver installed.');
      3 : Writeln('Resident part of xkeyb was NOT installed.');
      4 : Writeln('Specified file could not be opened.');
      5 : Writeln('The resident part of XKeyb could not be removed.');
      6 : Writeln('Internal failure: Memory for fast access DS too small.');
      7 : Writeln('XKeyb requires an AT/286 or better');
      8 : Writeln('Required configuration file PC437.KEY not found');
   End;
   Halt(b);
End;


{***********************************************************
 Load translation table.
 ***********************************************************}

{ +++++++++++ Special keys for XStrings +++++++++++ }

Const  KeyNames    : Array[1..18] of String[5] =
                     ('HOME','END','PU','PD','CL','CR','CU','CD','DEL','INS',
                      'CHOME' ,'CEND','CPU','CPD','CCL','CCR','F11','F12');
       KeyCodes    : Array[1..18] of Byte =
                     (71,79,73,81,75,77,72,80,83,82,119,117,132,118,115,116,87,88);

{$S+,I+,R+}

Var    XStrEnd     : Word;
       XStrs       : Array[1..200] of String; { The XStrs will first be deposited here and only later }
                                              { be copied to their data region. So we don't have to move }
                                              { all the following XStrs if we insert one. If XStrs exist already, }
                                              { they will be copied here first! }

Function ProgramName:String;                { Finds out name and path of the current program. }
Var    EnvSeg,                              { Replaces ParamStr(0) as that won't work if environment is empty. }
       EnvOfs      : Word;
       S           : String;
Begin
   EnvSeg:=MemW[PrefixSeg:$2C];             { Environment Adress. }
   EnvOfs:=0;
   While MemW[EnvSeg:EnvOfs]>0 Do           { Seek end of environment. }
      Inc(EnvOfs);
   Inc(EnvOfs,4);
   S:='';
   While Mem[EnvSeg:EnvOfs]>0 Do            { Program name. Terminated by zero. }
   Begin
      S:=S+Char(Mem[EnvSeg:EnvOfs]);
      Inc(EnvOfs);
   End;
   ProgramName:=S;                          { Let's give it back ... }
End;



{Aitor, 1.7}
Function ProgramPath: string;
var
   s: string;
begin
     s := ProgramName;
     while s[length(s)]<>'\' do
        delete (s,length(s),1);
     delete (s,length(s),1);
     ProgramPath := s
End; {ProgramPath}



Function GetNumber(Var Line:String; Var LinePtr:Byte):Byte; { Read byte from line. }
Var    S           : String[8];
       Num         : Byte;
       err         : Integer;
Begin
   S:='0';
   err := 0;

   While Line[LinePtr]=' ' Do               { Skip eventual spaces. }
      Inc(LinePtr);

   {regular case}
   While (Line[LinePtr]>='0') and           { until no more numbers follow or end of line reached. }
         (Line[LinePtr]<='9') and
         (LinePtr<=Length(Line)) Do
   Begin
      S:=S+Line[LinePtr];
      Inc(LinePtr);
   End;
   Val(S,Num,err);                          { Calculate value. }

   {Send result}
   if err=0 then GetNumber:=Num
            else GetNumber:=0
End;


Procedure SetKey(Var Line:String);          { Read sections with the name KEYS. }
Var    KeyNum      : Byte;
       LinePtr     : Byte;
       C           : Char;
       B           : Byte;
       flag       : boolean;
Begin
   LinePtr:=1;

   While Line[LinePtr]=' ' Do               { Skip eventual spaces. }
      Inc(LinePtr);

   {Add Aitor 1.10: Exx to read the extended scancodes}
   flag := upcase(line[lineptr])='E';
   if flag then inc(LinePtr);

   KeyNum:=GetNumber(Line,LinePtr)+128*ord(flag);      { Read keynumber. }

   If (KeyNum=0) or (KeyNum>256) Then    { Keynumber legal? }
   Begin
      Writeln('Illegal key number:');
      Writeln(Line);
   End;

   TransTable^[KeyNum,5]:=0;             { Key attribute = 0. }

   C:=Line[LinePtr];
   While C<>' ' Do                       { After key number, NCS follows optionally, then space. }
   Begin
      Case UpCase(C) Of
         'N' : Inc(TransTable^[KeyNum,5],2);   { Set Num Lock Bit. }
         'C' : Inc(TransTable^[KeyNum,5],4);   { Caps. }
         'S' : Inc(TransTable^[KeyNum,5],1);   { Scroll. }
      End;
      Inc(LinePtr);                      { Next char. }
      C:=Line[LinePtr];
   End;

   For B:=0 To 4 Do                      { Mappings for 5 levels. }
   Begin
      While Line[LinePtr]=' ' Do
         Inc(LinePtr);                   { Skip space. }
      Case Line[LinePtr] of
         '#' : Begin                     { #+ASCII-Value of char. }
                  Inc(LinePtr);
                  TransTable^[KeyNum,B]:=GetNumber(Line,LinePtr);
               End;
         '!' : Begin                     { Key mapped to XStr. }
                  Inc(LinePtr);
                    flag := upcase(line[lineptr])='C';  {!C means 235+ (for COMBI)}
                    if flag then inc(LinePtr);
                  TransTable^[KeyNum,B]:=GetNumber(Line,LinePtr)+235*ord(flag);
                  Inc(TransTable^[KeyNum,5],$80 shr B);  { Set XStr Bit for actual level. }
               End;
         Else  Begin                     { Normal mapping with chars. }
                  TransTable^[KeyNum,B]:=Byte(Line[LinePtr]);
                  Inc(LinePtr);
               End;
      End;
   End;
End;

Procedure SetShifts(Var Line:String);       { Read scancodes of shift keys from config file. }
Var    B           : Byte;
       LinePtr     : Byte;
Begin
   LinePtr:=1;
   B:=0;
   While (LinePtr<=Length(Line)) and (B<=7) Do     { All scancodes need to be in one row! }
   Begin
      ShiftKeys[B]:=GetNumber(Line,LinePtr);       { And it needs to contain at least 8 scancodes! }
      Inc(B);
   End;

   If B<=7 Then                          { Less than 8 scancodes found? }
   Begin
      Writeln('Warning:');
      Writeln('Some shift keys remain undefined!');
      Writeln(Line);
   End;
End;


Function GetKeyByName(Var Line:String; Var LinePtr:Byte):String;
Var    KeyName     : String[10];            { For processing XStr definitions. }
       ShiftOffset : Byte;                  { Gets the scancode of a key by its name. }
       B           : Byte;                  { Names of keys are in KeyNames. }
       I           : Integer;               { The corresponding scancodes are in KeyCodes. }
Begin
   GetKeyByName:='';
   KeyName:='';

   While (LinePtr<Length(Line)) and         { Read name of key. }
         (Line[LinePtr]<>']') and
         (Length(KeyName)<7) Do
   Begin                                    { Copy char until ']', end of line or 7 chars read. }
      KeyName:=KeyName+UpCase(Line[LinePtr]);
      Inc(LinePtr);
   End;

   If Line[LinePtr]<>']' Then               { Key not terminated by ']' ? }
   Begin
      Writeln;
      Writeln('"]" missing in xstring definition:');
      Writeln(Line);
      Exit;
   End
   Else Inc(LinePtr);

   B:=0;
   Repeat                                   { Search key in list specified at the top of this program section. }
      Inc(B);
   Until (B=17) or (KeyName=KeyNames[B]);
   If B<17 Then                             { Key found => return its scancode. }
   Begin
      GetKeyByName:=#0+Char(KeyCodes[B]);   { We return a zero-Byte + the scancode. }
                                            { Returning string may be appended directly to the XStr. }
   End
   Else
   Begin                                    { Key not found. May be function key. }
      ShiftOffset:=0;
      Case KeyName[1] of                    { Scancodes of function keys (F) are number + an offset. }
         'S' : ShiftOffset:=83;             { Offset for Shift. }
         'C' : ShiftOffset:=93;             { Control. }
         'A' : ShiftOffset:=103;            { Alt. }
         'F' : ShiftOffset:=58;             { No modifying key. }
      End;
      If (ShiftOffset=0) or
         (
            (ShiftOffset>58) and
            (KeyName[2]<>'F')
         ) Then
      Begin                                 { Name of key is invalid. }
         Writeln;
         Writeln('Invalid keyname ',KeyName,' in xstring definition:');
         Writeln(Line);
         Exit;
      End;

      If ShiftOffset>58 Then Delete(KeyName,1,2) { Isolate function key number. }
                        Else Delete(KeyName,1,1);

      Val(KeyName,B,I);                     { and turn into value. }
      If (B<1) or (B>10) Then               { Only values 1-10 are allowed. }
      Begin
         Writeln;
         Writeln('Invalid function key F',B,' in xstring definition:');
         Writeln(Line);
         Exit;
      End;

      GetKeyByName:=#0+Char(B+ShiftOffset); { The scancode is key number + the level independent offset. }
   End;
End;

Function GetSpecKey(Var Line:String; Var LinePtr : Byte):String;
Var    Len         : Byte;                  { This function manages if a '\' appears in the XStr definition. }
       Number      : Byte;                  { If needed it calls the function GetKeyByName. }
       Select      : Char;
Begin
   Len:=Length(Line);
   GetSpecKey:='';

   If LinePtr>Len Then                      { Was '\' the last char in the XStr? }
   Begin
      Writeln;                              { Yes -> Error. }
      Writeln('Unexpected end of xstring definition:');
      Writeln(Line);
      Exit;
   End;

   Select:=UpCase(Line[LinePtr]);           { Evaluate char after \ . }
   Case Select of
      'N' : Begin
               GetSpecKey:=#13;             { \n = CR. }
               Inc(LinePtr);
            End;
      '\' : Begin
               GetSpecKey:='\';             { \\ = \. }
               Inc(LinePtr);
            End;
      'A',
      'S' : Begin                           { \Axxx = Chr(xxx) ; \Sxxx = Key(xxx). }
               If Lineptr+3<Len Then        { The number has got max. 3 digits. }
                  Byte(Line[0]):=           { Shorten length of line }
                  LinePtr+3;                { to ignore digits following eventually upon the number! }
               Inc(LinePtr);
               Number:=GetNumber(Line,LinePtr);
               Byte(Line[0]):=Len;          { Restore original line length. }

               If Select='A'
                  Then GetSpecKey:=Char(Number)
                  Else GetSpecKey:=#0+Char(Number);
            End;
      '[' : Begin                           { In [] we have the name of a key. }
               Inc(LinePtr);                { GetKeyByName calculates the corresponding code. }
               GetSpecKey:=GetKeyByName(Line,LinePtr);
            End;
      Else Begin                            { Illegal char after \ -> Error. }
              Writeln;
              Writeln('Syntax error in xstring definition:');
              Writeln(Line);
           End;
   End;
End;

Procedure ParseXStr(Var Line:String; Var LinePtr:Byte; Var Dest:String);
Begin                                       { This routine translates an XStr. }
   Dest:='';
   While LinePtr<=Length(Line) Do           { Process all chars until end of line. }
   Begin
      If Line[LinePtr]='\' Then             { Is char a backslash ? }
      Begin
         Inc(LinePtr);                      { Yes -> special char. }
         Dest:=Dest+GetSpecKey(Line,LinePtr);    { Meaning will be calculated by GetSpecKey. }
      End
      Else
      Begin                                 { No -> Take char unmodified. }
         Dest:=Dest+Line[LinePtr];
         Inc(LinePtr);
      End;
   End;
End;


Procedure SetXStr(Var Line : String);       { Process sections with label [XSTRINGS] }
Var    LinePtr     : Byte;
       XStrNum     : Byte;
Begin
   LinePtr:=1;
   XStrNum:=GetNumber(Line,LinePtr);     { Line starts with number of the XStr. }

   If (XStrNum=0) or (XStrNum>200) Then  { Number valid ? }
   Begin
      Writeln;
      Writeln('illegal xstring number:');
      Writeln(Line);
      Writeln('legal xstring numbers: 1-200.')
   End
   Else
   Begin
      If XStrNum>LastXStr Then LastXStr:=XStrNum;  { Number greater than LastXStr? -> Set new LastXStr. }
      Inc(LinePtr);                      { Exactly ONE space follows. Skip that. }

      XStrs[XStrNum]:='';
      ParseXStr(Line,LinePtr,XStrs[XStrNum]); { Let XStr translate by ParseXStr. }
   End;
End;

Procedure ReadCombis(Var S : String);
{ S[1]=First char of combinations of this list. }
{ S[2]=Number of combinations in this list. Needs to be 0 at the calling of this routine. }
Var    Loop        : Byte;
Begin
   With DatSeg^ Do
   Begin
      Loop:=0;
      While (CombTab[Loop]<>0) and (CombTab[Loop]<>Byte(S[1])) Do
      Begin                                 { Search combination char. }
         Loop:=Loop+2*CombTab[Loop+1]+2;
      End;

      If CombTab[Loop]>0 Then               { Found combinations with this char. }
      Begin
         Byte(S[0]):=CombTab[Loop+1]*2+2;
         Move(CombTab[Loop],S[1],Byte(S[0])); { Copy existing combinations. }

         Move(CombTab[Loop+Byte(S[0])],CombTab[Loop],192-Loop);
                                            { The read combinations will be erased! }
                                            { Eventually reentered later in other form. }
      End;
   End;
End;

Procedure WriteCombis(Var S : String);
Var    Loop        : Byte;
Begin
   Loop:=0;
   With DatSeg^ Do
   Begin
      While CombTab[Loop]>0 Do
         Loop:=Loop+2*CombTab[Loop+1]+2;

      If Loop+Length(S)>191 Then
      Begin
         Writeln(#10'Warning: Overflow of combination char table. ');
         Writeln('combinations with char ',S[1],' inactive.');
      End
      Else
      Begin
         Move(S[1],CombTab[Loop],Length(S)); { Insert the crap. }
         CombTab[Loop+Length(S)]:=0;
      End;
   End;
End;


Procedure SetCombi(Var Line : String);
Var    CombiChars  : String;
       LinePtr     : Byte;
Begin
   LinePtr:=1;
   While (Line[LinePtr]=' ') and (LinePtr<=Length(Line)) Do
      Inc(LinePtr);                         { Skip blanks. }
   If LinePtr>Length(Line) Then Exit;       { Nothing in the row? }

   CombiChars:=Line[LinePtr]+#0;            { First char of the combination after CombiChars. }
   ReadCombis(CombiChars);                  { Read eventually existing combinations with this char. }

   Inc(LinePtr);
   While LinePtr<=Length(Line) Do           { Process line. }
   Begin
      If Line[LinePtr]<>' ' Then            { Blank ? *shiver* }
      Begin
         If Line[LinePtr]='#' Then          { ASCII-Value for char after #. }
         Begin
            Inc(LinePtr);                   { Get ASCII-Value and translate into char. }
            CombiChars:=CombiChars+Char(GetNumber(Line,LinePtr));
         End
         Else
         If Line[LinePtr]='!' Then          { ! erases an existing definition. }
         Begin
            CombiChars[0]:=#2;
            CombiChars[2]:=#0;
         End
         Else
         Begin
            CombiChars:=CombiChars+Line[LinePtr];
            Inc(LinePtr);                   { Else copy chars directly. }
         End;
      End
      Else
         Inc(LinePtr);                      { Skip blanks. }
   End;

   If Odd(Length(CombiChars)) Then
   Begin                                    { Here we have just a halve pair of chars -> nonsense. }
      Writeln(#10'Warning: Halve pair of chars at combination char:');
      Writeln(#10,Line);
      Writeln(#10'Line was shortened to full pairs of chars!');
      Dec(CombiChars[0]);
   End;

   CombiChars[2]:=
      Char(Length(CombiChars) Shr 1 -1);    { Half length of list minus 1 is number of combinations. }
   If CombiChars[2]>#0 Then
      WriteCombis(CombiChars);              { Save combinations. }
End;



Procedure CopyXStrs(BufSize:Word);           { Shorten XStrings and save to buffer. }
Var    B           : Byte;
       BufferFull  : Boolean;
Begin
   XStrEnd:=0;
   BufferFull:=False;

   With DatSeg^ Do
   Begin
      B:=1;
      While (B<=LastXStr) and not BufferFull Do  { Until all XStrs are inserted or buffer is full. }
      Begin
         If XStrEnd+Length(XStrs[B])>=BufSize Then    { Will the string still fit into the buffer ? }
         Begin
            Writeln;                                  { No. }
            Writeln('Not enough buffer space for xstring declaration:');
            Writeln(XStrs[B]);
            XStrs[B]:='';                             { Erase XString. }
            BufferFull:=(BufSize-XStrEnd)=0;          { Buffer completely full ? => Exit loop. }
         End
         Else
         Begin
            Move(XStrs[B],XStrings[XStrEnd],Byte(XStrs[B][0])+1); { Copy XStr into the buffer and }
            XStrEnd:=XStrEnd+Byte(XStrs[B][0])+1;     { recalculate end of occupied memory. }
            Inc(B);
         End;
      End;
      LastXStr:=B-1;                        { If not all strings could be inserted. }

      If XStrBufSize=0 Then
         XStrBufSize:=XStrEnd;              { Buffer size not declared => minimize. }
   End;
End;

Procedure GetOldXStrs;                      { Read XStrings from resident copy of XKeyb. }
Var    B           : Byte;
       W           : Word;
Begin
   With DatSeg^ Do                          { The data region of the resident copy will be used! }
   Begin
      W:=0;
      For B:=1 To LastXStr Do               { Go through all XStrs. }
      Begin
         Move(XStrings[W],XStrs[B],XStrings[W]+1);    { Copy XStr to other data region. }
         W:=W+XStrings[W]+1;                { Calculate address of next XStr. }
      End;
   End;
End;




Procedure ExpandFileName(Var Name : String);{ If needed, extend name of config file. }
Begin
  { first, we are loading a .KEY file }
   If Pos('.',Name)=0 Then    { filename has no extension -> add .KEY }
      Name:=Name+'.Key';

   If (Pos('\',Name)=0) and
      (Pos(':',Name)=0) Then  { filename contains no path -> add program path }
   Begin
      Name := FSearch (Name, ProgramPath+';'+GetEnv('PATH'));  {RQ 1.6-1.7}
      Name := FExpand (Name);            
   End;
End;


Type   SectionTyp  = (Keys,Shifts,XStrings,Comment,List,Continue,Combi);

Function GetSection(Var Line : String):SectionTyp;    { Evaluate section name. }
Var    B           : Byte;
Begin
   B:=2;
   While (B<Length(Line)) and               { Make line uppercase. }
         (Line[B]<>']') Do                  { Ignore all chars after ']'. }
   Begin
      Line[B]:=UpCase(Line[B]);
      Inc(B);
   End;
   Line[0]:=Char(B);                        { Ignore chars after ] . }

   If Line='[KEYS]' Then GetSection:=Keys
   Else If Line='[SHIFTS]' Then GetSection:=Shifts
   Else If Line='[XSTRINGS]' Then GetSection:=XStrings
   Else If Line='[COMMENT]' Then GetSection:=Comment
   Else If Line='[LIST]' Then GetSection:=List
   Else If Line='[CONTINUE]' Then GetSection:=Continue
   Else If Line='[COMBI]' Then GetSection:=Combi
   Else
   Begin
      Writeln('Warning:');
      Writeln('Unknown section ',Line,' found.');
      Writeln('Skipping section.');
      GetSection:=Comment;
   End;
End;

Procedure ReadConfigFile(Name:String; BufSize : Word);   { Read config file. }
Var    B           : Byte;
       S           : String;
       Section     : SectionTyp;
       Line        : String;
       ConfigFile  : Text;
       FileN       : byte;    {number of file being parsed}
       SingleName  : string;
       TrueFile    : boolean;
Label  Cont;
Begin
   For B:=1 To 200 Do                       { Clear XString workspace. }
      XStrs[B]:='';

   If BufSize=$FFFF Then GetOldXStrs;       { Read old xstrings. BufSize=FFFFh -> XKeyb resident installiert. }

   TrueFile := FALSE;
   SingleName := 'PC437';

Cont:
   ExpandFileName(SingleName);
   Assign(ConfigFile,SingleName);
{$I-}
   Reset(ConfigFile);
{$I+}
   If IOResult<>0 Then Error(8-4*ord(TrueFile)); { Opening of file failed. }

   If TrueFile then DatSeg^.ConfigFile:=SingleName;
   Section:=Comment;

   While not Eof(ConfigFile) Do             { Read whole file. }
   Begin
      Readln(ConfigFile,Line);

      If (Length(Line)>0) and (Line[1]<>';') Then                { Ignore empty lines. }
         If Line[1]='[' Then Section:=GetSection(Line)
         Else
            Case Section of
               Keys     : SetKey(Line);
               Shifts   : SetShifts(Line);
               XStrings : SetXStr(Line);
               List     : Writeln(Line);
               Combi    : SetCombi(Line);   { Define combination chars. }
               Continue : Begin             { Proceed with next file. }
                             Close(ConfigFile);
                             SingleName:=Line;
                             Goto Cont;
                          End;   {en FIleN>1}
            End
      Else If Section=List Then Writeln;
   End;
   Close(ConfigFile);
   if trueFile then begin
       FileLoaded := TRUE;
       WriteLn ('Installed ',SingleName);
   end else begin
       truefile   := TRUE;
       SingleName := Name;
       goto cont
   end;

   With DatSeg^ Do
      If BufSize<$FFFF Then                 { No resident installation yet. }
      Begin
         XStrBufSize:=BufSize;
         If BufSize>1024 Then BufSize:=1024;{ For installation max. 1K buffer, else we overwrite our code! }
         If BufSize=0 Then BufSize:=1024;   { No size given? -> minimal, up to 1K. }
      End
      Else BufSize:=XStrBufSize;            { If installed already, resident copy declares buffer size. }

   CopyXStrs(BufSize);                      { Put XStrs to their data region. }

End;


{***********************************************************
 Main program & Check for already installed driver.
 ***********************************************************}

Type   BCDString   = String[2];

Function BCD(B : Byte) : BCDString;         { Translate BCD number into string. }
Begin
   If B>15 Then BCD:=Char(B shr 4 + 48)+Char(B and 15 + 48)
           Else BCD:=Char(B+48);
End;

Function VS(W : Word) : String;             { Returns version number as string. }
Var    S           : String;
Begin
   S:=BCD(LO(W));                           { Turn second value into string. }
   If Length(S)<2 Then S:='0'+S;            { Eventually add leading zero. }
   VS:=BCD(Hi(W))+'.'+S;                    { Add first value and point. }
End;

Function TestInstallation : Byte;
{ Check whether a copy of XKeyb is already installed. }
{ Result:   0 -> No keyboard driver installed. }
{           1 -> Identical version of XKeyb installed. }
{                >> DatSeg will be set to data region of resident copy. }
{           2 -> Different version of XKeyb installed. }
{           3 -> Different keyboard driver installed. }
Begin
   TestInstallation:=0;
   With Regs Do                             { Already installed ? }
   Begin
      AX:=$AD80;                            { Check state of installation. }
      BX:=0;                                { AL=0 -> No keyboard driver installed. }
      ES:=0;                                { AL=FFh -> Already a keyboard driver installed. }
      DI:=0;
      Intr($2F,Regs);

      If AL=$FF Then                        { Already installed? }
      Begin                                 { YES! }

         If (SI=$5053) and                  { Is it XKeyb ? }
            (DX=$4448) and
            (CX=$584B) Then
         Begin                              { YES! }
            If BX=Version Then              { Same version? }
            Begin                           { YES! -> Tables can be overloaded [taken over?]. }
               DatSeg:=Ptr(ES,DI);          { Set pointer to data segment of resident driver copy. }
               TestInstallation:=1;
            End
            Else TestInstallation:=2;       { Different version of XKeyb. }
         End
         Else TestInstallation:=3;          { Other keyboard driver (KEYB.COM ?) installed. }
      End;
   End;
End;

Procedure Remove;                           { Remove XKeyb from memory. }
Var    Removeable  : Boolean;
       IntVec      : Array[Byte] of Pointer absolute 0:0;
       Regs        : Registers;
       MultiHand   : Pointer;
       Int16Hand   : Pointer;
Begin
{ Check whether removing is possible. }

   MultiHand:=DatSeg;
   PtrTyp(MultiHand).Ofs:=Ofs(MultiplexHandler);
   Int16Hand:=DatSeg;
   PtrTyp(Int16Hand).Ofs:=Ofs(Int16Handler);
   With DatSeg^ Do
   Begin
      Removeable:=
         (IntVec[$09]=@Int9Hand) and
         (IntVec[$16]=Int16Hand) and
         (IntVec[$2F]=MultiHand);

      If not Removeable Then Error(5);      { Removing impossible. Interrupt vectors were changed by another program. }

{ Uninstall it. }
      Int9Hand.Dequeue;
      DisableInts;
      IntVec[$16]:=NextInt16;
      IntVec[$2F]:=NextMulti;
      EnableInts;
      With Regs Do
      Begin
         AH:=$49;                           { Free memory. }
         ES:=MemW[Seg(XBuffer^):$2C];       { Environment segment. }
         Intr($21,Regs);
         AH:=$49;
         ES:=Seg(XBuffer^);                 { Program segment. }
         Intr($21,Regs);
      End;
   End;

   Writeln('Resident part of XKeyb removed.');
End;

Procedure ShowInfo;
Begin
   With DatSeg^ Do
   Begin
      Writeln('Active definition file     : ',ConfigFile);
      Writeln('Number of XStrings defined : ',Byte( Ptr(Seg(DatSeg^) , Ofs(LastXStr))^ ));
      Writeln('XString buffer size        : ',XStrBufSize,' Bytes');
   End;
End;

Function PerformParam:ActionTyp;            { Evaluate parameters. }
Var    B           : Byte;
       I           : Integer;
       S           : String;
       Regs        : Registers;
       ConFileName : String;
       Action      : ActionTyp;
       Installed   : Byte;
       XStrBufSize : Word;
       FastDatSeg  : Word;
       T           : text;
Begin
   FastDatSeg:=CSeg;
   ConFileName:='';
   XStrBufSize:=0;
   Action:=GetInfo;
   Installed:=TestInstallation;

   If Installed=1 Then                      { If already installed get certain values from resident FastDS. }
      Move(Ptr(PtrTyp(DatSeg).Seg , Ofs(ShiftKeys))^,
           ShiftKeys,27);

   With Regs Do
   Begin
      AX:=$3700;                            { Evaluate SwitchChar. (Normally '/') }
      Intr($21,Regs);
   End;

   For B:=1 To ParamCount Do                { Process all parameters. }
   Begin
      S:=ParamStr(B);
      If Byte(S[1])=Regs.DL Then            { parameter starts with switch char. }
      Begin
         Case Upcase(S[2]) of
            'X' : Begin                     { Set buffersize for xstring buffer. }
                     Delete(S,1,2);
                     Val(S,XStrBufSize,I);
                  End;
            'U' : Begin                     { Uninstall.}
                     Action:=Uninstall;
                  End;
            'Q' : Begin                     { Quit. Ignore LIST sections. }
                     Close(OutPut);
                     Assign(OutPut,'Nul');
                     Rewrite(OutPut);
                  End;
            'I' : Begin                     { Install. Ignore other driver. }
                     Installed:=0;
                     Action:=Install;
                  End;
            '?' : begin
                        Action := FastHlp;        { Show the fast help }
                  end;
            Else
            Begin                           { Unknown option required -> Error. }
               Writeln;
               Writeln('Invalid modifier -  ',S);  {Aitor 1.7}
            End;
         End;
      End
      Else
      Begin
         ConFileName:=S;      { a parameter without / is the .KEY file name }
         Case Installed of
            0:Action:=Install;
            1:Action:=OverLoad;
         End;
      End;
   End;

   if action<>FastHlp then
   Case Installed of
      2:Action:=WrongVers;
      3:Action:=OtherDrv;
   End;

   if action=OverLoad then begin   {when file not found, abort! }
       ExpandFileName(S);
       Assign(t,S);
       {$I-}
       Reset(t);
       {$I+}
       If IOResult<>0
          then error(4)
          else close (t);
   end;


{ Geforderte Aktion ausfhren. }

   Case Action of
      Install          : ReadConfigFile(ConFileName,XStrBufSize);
      OverLoad         : ReadConfigFile(ConFileName,$FFFF);
      GetInfo          : If Installed=1 Then ShowInfo Else Error(3);
      Uninstall        : If Installed=1 Then Remove Else Error(3);
      WrongVers        : Error(1);
      OtherDrv         : Error(2);
{      FastHlp          : if fSearch (ProgramPath+'\XKEYB.FHL', '') = '' then
                           begin
                              WriteLn ('xkeyb error: fast help file ',ProgramPath+'\XKEYB.HLP',' was not found.');
                           end
                         else
                           Begin
                              Assign (T, ProgramPath+'\XKEYB.FHL');
                              Reset(T);
                              while not eof(T) do begin
                                    readLn (T,S);
                                    WriteLn (S)
                              end;
                              close(T)
                           end;}
   End;

   If Installed=1 Then                      { If already installed, write certain values into resident FastDS. }
   Begin
      If Action=OverLoad Then Inactive:=False;   { Activate driver if table was loaded. }
      Move(ShiftKeys,                            { (also includes ReadConfigFile, updated to TRUE }
           Ptr(PtrTyp(DatSeg).Seg , Ofs(ShiftKeys))^,15);
   End;

   PerformParam:=Action;
End;

(* No longer neccessary
Procedure CopyRight; External;

We replace it for the fast help:*)

Procedure Fasthelp; External;

Procedure ShowFastHelp;
Var
       B           : Byte;
       CopyPtr     : ^Byte;
       CopyLen     : ^Word;
Begin
   Writeln(#10);
   CopyPtr:=Ptr(CSeg,Ofs(FastHelp)+2);
   CopyLen:=@FastHelp;
   B:=CopyPtr^;
{$R-}
   While CopyLen^>0 Do
   Begin
      Inc(PtrTyp(CopyPtr).Ofs);
      Dec(CopyLen^);
      If B>207 Then
      Begin
         Loop:=B-208;
         B:=CopyPtr^-B;
         While Loop>0 Do
         Begin
            Write(Char(B));
            Dec(Loop);
         End;
         Inc(PtrTyp(CopyPtr).Ofs);
         Dec(CopyLen^);
      End
      Else
      If B=126 Then Write(VS(Version))
      Else Write(Char(B));
      B:=CopyPtr^-B;
   End;
{$R+}
   Writeln(#10);
End; {ShowFastHelp}


{$ENDIF}{KBDRES}

function Is286p: boolean;
var
   vax: word;
begin
     asm
        xor  ax,ax              
        push ax                 
        popf                    
        pushf                   
        pop  ax                 
        mov  vax, ax
     end;
     Is286p := (vax AND $F000)<>$F000
end;


Var    B           : Byte;
       Action      : ActionTyp;
{       CopyPtr     : ^Byte;
       CopyLen     : ^Word;     NO LONGER neccessary}

Begin

   If Ofs(EoDS)>Ofs(FindXStr) Then begin
      Writeln('Internal failure: Memory for fast access DS too small.');
      halt (6)
   end;       {This is Error(6), but needs to do this with KBDRES}


   if (mem[$F000:$FFFE]=$FF) or (mem[$F000:$FFFE]=$FE) or (not Is286p) then begin
       Writeln('XKeyb requires an AT/286 or better');
       halt (7)
   end;       {This is Error(7), but needs to do this with KBDRES}

   WriteLn ('XKEYB ',VerS,': keyboard driver for FreeDOS AT machines (more info: XKEYB /?)');


(*      OLD COPYRIGHT METHOD: now used for fasthelp
   Writeln(#10);                            { Output Copyright note. }
   CopyPtr:=Ptr(CSeg,Ofs(CopyRight)+2);
   CopyLen:=@CopyRight;
   B:=CopyPtr^;
{$R-}
   While CopyLen^>0 Do
   Begin
      Inc(PtrTyp(CopyPtr).Ofs);
      Dec(CopyLen^);
      If B>207 Then
      Begin
         Loop:=B-208;
         B:=CopyPtr^-B;
         While Loop>0 Do
         Begin
            Write(Char(B));
            Dec(Loop);
         End;
         Inc(PtrTyp(CopyPtr).Ofs);
         Dec(CopyLen^);
      End
      Else
      If B=126 Then Write(VS(Version))
      Else Write(Char(B));
      B:=CopyPtr^-B;
   End;
{$R+}
   Writeln(#10);

*)

                                            { Initialize resident data segment. }
                                            { These values are only valid if the driver is made
                                              resident newly [the first time?]. }
   XBuffer:=Ptr(PrefixSeg,128);
   TransTable:=@DR(@Data^).TransTable;
   DatSeg:=@Data;                           { Initialize pointer to resident data segment to the procedure data. }
                                            { If necessary, this setting will be changed by TestInstallation. }

{$IFNDEF KBDRES}
   Action:=PerformParam;                    { Evaluate command line parameters. }

   If Action=FastHlp Then
      ShowFastHelp
   Else
   If Action=Install Then
{$ENDIF}
   With DatSeg^ Do
   Begin
{$IFNDEF KBDRES}
      XStrBufSize:=                         { Round up end of buffer to segment border. }
         XStrBufSize
           +(
               16
              -Ofs(XStrings[XStrBufSize]) and $F
            )
            and $F;
{$ELSE}
      XStrBufSize:=Ofs(Keep)-Ofs(XStrings);                         { Round up end of buffer to segment border. }
{$ENDIF}

      GetIntVec($2F,NextMulti);
      GetIntVec($16,NextInt16);

      Move(Ptr(DSeg,0)^,Ptr(CSeg,0)^,Ofs(EoDS)); { Copy data into resident FastDS. }

      For Loop:=201 To 235 Do
         XFunc[Loop].Stat:=0;

      Int9Hand.Enqueue(9,Int9Handler,CSeg);
      SetIntVec($2F,@MultiPlexHandler);
      SetIntVec($16,@Int16Handler);

      SwapVectors;
 {$IFNDEF KBDRES}
      Keep(@XStrings[XStrBufSize],0);
 {$ELSE}
      Keep(@Keep,0);
 {$ENDIF}
 
      FastDS;                              { Avoids removal of FastDS by the linker. }
   End;
(* NO LONGER NECCESSARY, replace by fasthelp
End{$L Copy.OBJ}.  *)
END{$L xkeybhlp.obj}.

