/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.HunkTypedElement;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.UnmatchedHunkTypedElement;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.resources.IResource;

public class HunkDiffNode
extends PatchDiffNode {
    private final HunkResult result;

    public static HunkDiffNode createDiffNode(PatchFileDiffNode parent, HunkResult result, boolean fullContext) {
        return HunkDiffNode.createDiffNode(parent, result, fullContext, fullContext, fullContext);
    }

    public static HunkDiffNode createDiffNode(PatchFileDiffNode parent, HunkResult result, boolean ancestorFullContext, boolean leftFullContext, boolean rightFullContext) {
        return new HunkDiffNode(result, parent, 3, HunkDiffNode.getAncestorElement(result, ancestorFullContext), HunkDiffNode.getLeftElement(result, leftFullContext), HunkDiffNode.getRightElement(result, rightFullContext));
    }

    public static ITypedElement getRightElement(HunkResult result, boolean fullContext) {
        return new HunkTypedElement(result, true, fullContext);
    }

    private static ITypedElement getLeftElement(HunkResult result, boolean fullContext) {
        if (fullContext && !result.isOK()) {
            return new UnmatchedHunkTypedElement(result);
        }
        return new HunkTypedElement(result, false, fullContext);
    }

    public static ITypedElement getAncestorElement(HunkResult result, boolean fullContext) {
        if (!fullContext && result.isOK()) {
            return new HunkTypedElement(result, false, fullContext);
        }
        if (!fullContext) {
            return null;
        }
        return new HunkTypedElement(result, false, result.isOK());
    }

    public HunkDiffNode(HunkResult result, PatchFileDiffNode parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        super(result.getHunk(), parent, kind, ancestor, left, right);
        this.result = result;
    }

    public HunkResult getHunkResult() {
        return this.result;
    }

    protected PatchConfiguration getConfiguration() {
        return this.result.getDiffResult().getConfiguration();
    }

    public boolean isManuallyMerged() {
        ITypedElement left = this.getLeft();
        if (left instanceof UnmatchedHunkTypedElement) {
            UnmatchedHunkTypedElement element = (UnmatchedHunkTypedElement)left;
            return element.isManuallyMerged();
        }
        return false;
    }

    public boolean isFuzzUsed() {
        return this.result.getFuzz() > 0;
    }

    public boolean isAllContextIgnored() {
        int fuzz = this.result.getFuzz();
        if (fuzz > 0) {
            String[] lines = this.result.getHunk().getLines();
            int contextLines = 0;
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                char c = line.charAt(0);
                if (c == ' ') {
                    ++contextLines;
                } else {
                    if (contextLines > 0 && fuzz >= contextLines) {
                        return true;
                    }
                    contextLines = 0;
                }
                ++i;
            }
            if (contextLines > 0 && fuzz >= contextLines) {
                return true;
            }
        }
        return false;
    }

    public IResource getResource() {
        return ((PatchFileDiffNode)this.getParent()).getResource();
    }
}

