/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.utils;

import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.ocsp.ResponderID;
import java.util.Hashtable;

public class TrustedResponders {
    private Hashtable a = new Hashtable();

    public boolean removeTrustedResponderEntry(ResponderID responderID, X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.a.get(responderID);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            int n2 = x509CertificateArray.length;
            if (n2 == 1) {
                if (x509CertificateArray[0].equals(x509Certificate)) {
                    return this.removeTrustedResponder(responderID);
                }
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (x509CertificateArray[n3].equals(x509Certificate)) {
                    x509CertificateArray[n3] = null;
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[n2 - 1];
                    int n4 = 0;
                    while (n4 < n2 - 1) {
                        x509CertificateArray2[n4] = x509CertificateArray[n4] == null ? x509CertificateArray[n4 + 1] : x509CertificateArray[n4];
                        ++n4;
                    }
                    this.a.put(responderID, x509CertificateArray2);
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public boolean removeTrustedResponder(ResponderID responderID) {
        return this.a.remove(responderID) != null;
    }

    public boolean isTrustedResponder(ResponderID responderID, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.a.get(responderID);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            int n2 = 0;
            while (n2 < x509CertificateArray.length) {
                if (x509CertificateArray[n2].equals(x509Certificate2) && x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void clearAllEntries() {
        this.a.clear();
    }

    public boolean addTrustedResponderEntry(ResponderID responderID, X509Certificate x509Certificate) {
        int n2;
        Object[] objectArray = (X509Certificate[])this.a.get(responderID);
        if (objectArray != null && objectArray.length > 0) {
            n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2].equals(x509Certificate)) {
                    return false;
                }
                ++n2;
            }
            objectArray = (X509Certificate[])Util.resizeArray(objectArray, objectArray.length + 1);
            objectArray[objectArray.length - 1] = x509Certificate;
        } else {
            objectArray = new X509Certificate[]{x509Certificate};
        }
        int n3 = n2 = this.a.put(responderID, objectArray) != null ? 1 : 0;
        return n2 != 0 || objectArray.length == 1;
    }
}

